Ext.define('EgViewRoles.view.UserRolesGroupedSummaryGrid', {
	extend: 'Ext.grid.Panel',
	alias:'widget.userrolesgroupedsummarygrid',
	id:'userrolesgroupedsummarygrid',
	cls:'gridSkin',
	requires: [
		'Ext.ux.RowExpander',
		'Ext.grid.*'
	],

	scroll : true,
	autoScroll : true,
	flex : 1,
	store: new Ext.data.Store({
		fields: ['users', 'userRoleCategory','hasUsers'],
		data: []
	}),

	emptyText : '<div class = "iconInformation" style="margin:10% auto auto auto"></div><div  id=\"userDeferMessage1\" class="commonErrorMsgText">'+validationMsg10+'</div>',
	viewConfig: {
		deferEmptyText: false
	},

	plugins: [{
		
		ptype : 'rowexpander',
		getHeaderConfig: function() {
			var me = this,
				toggleRow = Ext.Function.bind(me.toggleRow, me),
				selectRowOnExpand = me.selectRowOnExpand;

			return {
				id: this.getHeaderId(),
				width: 24,
				sortable: false,
				resizable: false,
				draggable: false,
				hideable: false,
				menuDisabled: true,
				cls: Ext.baseCSSPrefix + 'grid-header-special',
				renderer: function(value, metadata,record, rowIdx, colIdx) {
					if (record.get('hasUsers') == true)
					{
						metadata.tdCls = Ext.baseCSSPrefix + 'grid-cell-special';
						return '<div class="' + Ext.baseCSSPrefix + 'grid-row-expander">&#160;</div>';
					}
					else
					{
						metadata.tdCls = Ext.baseCSSPrefix + 'grid-cell-special';
						return '<div>&#160;</div>';
					}
				},
				processEvent: function(type, view, cell, recordIndex, cellIndex, e) {
					if (type == "mousedown" && e.getTarget('.x-grid-row-expander')) {
						var row = e.getTarget('.x-grid-row');
						toggleRow(row);
						return selectRowOnExpand;
					}
				}
			};
		},
		//expandOnDblClick : false,
		//expandOnEnter : false,
		rowBodyTpl: [
			'<div>{users}</div>'
		]
		
	}],
	tbar:[
		{
			xtype:'tbfill',
		},
		{
			xtype: 'trigger',
			trigger1Cls: 'x-form-clear-trigger',
			trigger2Cls: 'x-form-search-trigger',
			cls: 'whitedropdown_search',
			emptyText: 'Search',
			id : 'strSearch',
			getTriggerMarkup: function() {
				var me = this,
					i = 0,
					hideTrigger = (me.readOnly || me.hideTrigger),
					triggerCls,
					triggerBaseCls = me.triggerBaseCls,
					triggerConfigs = [],
					unselectableCls = Ext.dom.Element.unselectableCls,
					style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
					cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;

				// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
				// single triggerCls config. Should rethink this, perhaps something more structured like a list of
				// trigger config objects that hold cls, handler, etc.
				// triggerCls is a synonym for trigger1Cls, so copy it.
				if (!me.trigger1Cls) {
					me.trigger1Cls = me.triggerCls;
				}

				// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
				for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
					if (i == 0)
					{
						triggerConfigs.push({
							tag: 'td',
							role: 'presentation',
							valign: 'top',
							cls: cls,
							id : 'strSearch_'+i,
							style: style + "display:none;",
							cn: {
								cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
								role: 'presentation'
							}
						});
					}
					else
					{
						triggerConfigs.push({
							tag: 'td',
							role: 'presentation',
							valign: 'top',
							cls: cls,
							id : 'strSearch_'+i,
							style: style,
							cn: {
								cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
								role: 'presentation'
							}
						});
					}
				}
				triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
				return Ext.DomHelper.markup(triggerConfigs);
			},
			onTrigger1Click: function() {
				this.reset();
			},
			onTrigger2Click: function() {
				appCtn.searchUserRole(this.getValue(),"search1",this);
			},
			listeners :
			{
				specialkey: function(field, e){
					// e.HOME, e.END, e.PAGE_UP, e.PAGE_DOWN,
					// e.TAB, e.ESC, arrow keys: e.LEFT, e.RIGHT, e.UP, e.DOWN
					if (e.getKey() == e.ENTER) {
						appCtn.searchUserRole(field.getValue(),'search1',field);
					}
				}
			}
		},
		{
			xtype:'toolbar',
			ui:'footer',
			items:[
				{
					xtype: 'button',
					text: intnlLabel11,
					isChanged : 'false',
					align:'right',
					id: 'showAllUsers',
					cls:'button20'
				}
			]
		}
	],

	columns : [
		{
			header: intnlLabel13,
			sortable: true,
			hideable: false,
			menuDisabled: true,
			dataIndex: 'userRoleCategory',
			flex : 1
		},
		{
			xtype: 'actioncolumn',
			//cls: 'tasks-icon-column-header tasks-edit-column-header',
			width: 36,
			iconCls: 'iconDashboardView',
			sortable: false,
			hideable: false,
			menuDisabled: true,
			handler : function(grid, rowIndex, colIndex)
			{
				var rec = grid.getStore().getAt(rowIndex);
				var usertype = rec.get('userRoleCategory');
				appCtn.modifyUserRole(usertype);
			},
			renderer: function(value, metaData, record, row, col, store, gridView)
			{
				metaData.tdAttr = "data-qtip='View' data-qclass='yellowTip'";
			}
		},
		{
			header: '',
			xtype: 'actioncolumn',
			width: 36,
			sortable: false,
			hideable: false,
			menuDisabled: true,
			renderer: function(value, metaData, record, row, col, store, gridView)
			{
				metaData.tdAttr = "data-qtip='Add User' data-qclass='yellowTip'";
			},
			items: [{
			iconCls: 'iconAddUser',
			//iconCls: 'x-hidden',
			style: {
				background: 'none',
				border: '0px'
			},
			handler: function(grid, rowIndex, colIndex) {
					var rec = grid.getStore().getAt(rowIndex);
					var usertype = rec.get('userRoleCategory');
					window.location.href='EgAddUser.jsp?qctr=1&reqfrom=EgViewRoles&usertype='+usertype;
				}
			}]
		}
	],
	hideHeaders : false,
	listeners : {
		'viewready' : function()
		{
			this.view.addListener('expandbody',this.expandRowExpbody);
		},
		
	},
	expandRowExpbody : function(rowNode, record, expandRow, eOpts)
	{
		appCtn.isUserAvailable(rowNode, record, expandRow, eOpts);
	}
});



