Ext.define('EgViewUser.controller.Main',{
	extend:'Ext.app.Controller',
	requires : [
		'EgViewUser.view.Main'
	],
	views:['Main'],
	refs:[
		{selector:'main', ref:'main'}
	],

	init:function(){
		appCnt = this;
		this.buildMainData();
		this.control({
			'main':
			{
				'boxready':this.afterMainRender
			},
			'main button[id="backButton"]':
			{
				'click':this.goBack
			}
		});
	},

	buildMainData : function()
	{
		Ext.Ajax.request({
			url : 'EgViewUser/data/EgViewUserJson.jsp',
			async: false,
			method : 'POST',
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
			}
		});
	},
	
	afterMainRender : function()
	{
		var isUsersCreated = publicJSON['isUsersCreated'];
		if (isUsersCreated != false)
		{
			var rootData = {
				text: 'Choose Organization / Organizational Unit / User',
				id: '-1',
				name: '-1',
				expanded: true,
				children:publicJSON['exportDataArr']
			};
			Ext.getCmp('unameTree').setRootNode(rootData);
			Ext.getCmp('unameTree').show();
			Ext.getCmp('emptyCont').hide();
		}
		else
		{
			Ext.getCmp('unameTree').hide();
			Ext.getCmp('emptyCont').show();
		}
	},

	goBack : function()
	{
		window.location.href = backHref;
	}
});



