Ext.define('EgViewUser.view.Main', {
	extend: 'Ext.form.Panel',
	alias: 'widget.main',
	ui:'simplePanel simplePanelHeaderBorder',
	title: homeTitle,
	margin: '8 8 0 8',
	id: 'main',
	tools:[
		{
			xtype:'button',
			id : 'backButton',
			cls:'backbutton',
			iconCls:'iconBack',
			text: backText,
			hidden:true
		}
	],
	scroll : false,
	autoScroll : false,

	layout: {
		type: 'vbox',
		align: 'stretch'
	},
	items: [
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center',
				align: 'stretch'
			},
			margin: 10,
			flex: 1,
			items: [
				{
					xtype: 'treepanel',
					id: 'unameTree',
					name: 'unameTree',
					width: 700,
					frame: false,
					border:false,
					autoShow: true,
					autoScroll: true,
					store: Ext.create('Ext.data.TreeStore', {
						fields: [{name: 'text', sortType:Ext.data.SortTypes.asUCString},
								{name: 'role', sortType:Ext.data.SortTypes.asUCString}],
						sorters: [{
							property: 'text',
							direction: 'ASC'
						}]
					}),
					rootVisible: false,
					columns: [
						{
							xtype: 'treecolumn',
							dataIndex: 'text',
							flex: 1,
							header: 'User Name',
							renderer: function (e, b, a, g, d, c, f)
							{
								var nodeId = a.data["text"];
								b.tdAttr = "data-qtip='"+nodeId+"' data-qclass='yellowTip'";
								return nodeId;
							}
						},
						{
							dataIndex: 'role',
							flex: 1,
							header: 'Role'
						}
					],
					tools: [
						{ 
							xtype: 'tbfill' 
						},
						{
							xtype: 'trigger',
							name:'searchbox',
							id:'searchbox',
							trigger1Cls: 'x-form-clear-trigger',
							trigger2Cls: 'x-form-search-trigger', 
							cls: 'whitedropdown_search',
							emptyText: searchLbl,
							onTrigger1Click: function() {
								this.reset();
							},
							onTrigger2Click: function() {
								egTitleSearch();
							},
							listeners :
							{
								change : function(field, newVal)
								{
									egTitleSearch();
								},
								specialkey: function(field, e){
									// e.HOME, e.END, e.PAGE_UP, e.PAGE_DOWN,
									// e.TAB, e.ESC, arrow keys: e.LEFT, e.RIGHT, e.UP, e.DOWN
									if (e.getKey() == e.ENTER) {
										egTitleSearch();
									}
								}
							},
							getTriggerMarkup: function() {
								var me = this,
								i = 0,
								hideTrigger = (me.readOnly || me.hideTrigger),
								triggerCls,
								triggerBaseCls = me.triggerBaseCls,
								triggerConfigs = [],
								unselectableCls = Ext.dom.Element.unselectableCls,
								style = 'width:' + me.triggerWidth-20 + 'px;' + (hideTrigger ? 'display:none;' : ''),
								cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;
								// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
								// single triggerCls config. Should rethink this, perhaps something more structured like a list of
								// trigger config objects that hold cls, handler, etc.
								// triggerCls is a synonym for trigger1Cls, so copy it.
								if (!me.trigger1Cls) {
									me.trigger1Cls = me.triggerCls;
								}
								// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
								for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
									if (i == 0)
									{
										triggerConfigs.push({
											tag: 'td',
											role: 'presentation',
											valign: 'top',
											cls: cls,
											id : 'MyTrigger_'+me.id+'_'+i,
											style: style + "display:none;",
											cn: {
												cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
												role: 'presentation'
											}
										});
									}
									else
									{
										triggerConfigs.push({
											tag: 'td',
											role: 'presentation',
											valign: 'top',
											cls: cls,
											id : 'MyTrigger_'+me.id+'_'+i,
											style: style,
											cn: {
												cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
												role: 'presentation'
											}
										});
									}
								}
								triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
								return Ext.DomHelper.markup(triggerConfigs);
							},
							disabled: false
						},
						{ 
							xtype: 'tbseparator' 
						},
						{
							xtype: 'button',
							id : 'nodeExpand',
							iconCls: 'iconExpandAll',
							hidden:true,
							tooltip: 'Expand all',
							style: {
								background: 'none',
								border: '0px'
							},
							listeners: {
								'click':function(obj){
									this.hide();
									Ext.getCmp('nodeCollapse').show();
									Ext.getCmp('unameTree').expandAll();
								}
							}
						},
						{
							xtype:'button',
							id :'nodeCollapse',
							iconCls: 'iconCollapseAll',
							hidden:false,
							tooltip: 'Collapse all',
							style: {
								background: 'none',
								border: '0px'
							},
							listeners:{
								'click':function(obj){
									this.hide();
									Ext.getCmp('nodeExpand').show();
									Ext.getCmp('unameTree').collapseAll();
								}
							}
						}
					],
					listeners: {
						afterrender : function()
						{
							Ext.getCmp('unameTree').addCls("gridSkin");
						}
					},
					clearFilter: function() {
						var view = this.getView();
						if (this.getRootNode())
						{
							this.getRootNode().cascadeBy(function(tree, view){
								var uiNode = view.getNodeByRecord(this);

								if(uiNode) {
									Ext.get(uiNode).setDisplayed('table-row');
								}
							}, null, [this, view]);

							//No data found message removal
							var elemNoData = Ext.getElementById('noDataFound');
							if (elemNoData)
							{
								elemNoData.style.display = "none";
							}
						}
					},
					filterBy: function(text, by) {
						this.clearFilter();

						var view = this.getView(),
							me = this,
							nodesAndParents = [];

						// Find the nodes which match the search term, expand them.
						// Then add them and their parents to nodesAndParents.
						if (this.getRootNode())
						{
							this.getRootNode().cascadeBy(function(tree, view){
								var currNode = this;
								if(currNode && currNode.data[by] && currNode.data[by].toString().toLowerCase().indexOf(text.toLowerCase()) > -1) {
									me.expandPath(currNode.getPath());

									while(currNode.parentNode) {
										nodesAndParents.push(currNode.id);
										currNode = currNode.parentNode;
									}
								}
							}, null, [me, view]);

							// Hide all of the nodes which aren't in nodesAndParents
							this.getRootNode().cascadeBy(function(tree, view){
								var uiNode = view.getNodeByRecord(this);
								if(uiNode && !Ext.Array.contains(nodesAndParents, this.id) && this.data.id != -1) {
									Ext.get(uiNode).setDisplayed('none');
								}
								
							}, null, [me, view]);

							//No data found message show
							if(Ext.isEmpty(nodesAndParents))
							{
								var elemNoData = Ext.getElementById('noDataFound');
								if (elemNoData == null || elemNoData === undefined)
								{
									Ext.DomHelper.append(Ext.get(view.id), {
										tag: 'div',
										style:{'height':'100%','width':'100%','textAlign':'center','display': 'table'}, 
										cls: 'new-div-cls', 
										id: 'noDataFound',
										html:LoadSearchAlert
									});
								}
								else
								{
									elemNoData.style.display = "table";
								}
							}
						}
					}
				},
				{
					xtype:"container",
					id: 'emptyCont',
					html:'<div class="emptyText"><div class = "iconInformation"></div><div align="center" class="commonErrorMsgText">'+intnlLabel1+".</div></div>"
				}
			]
		}
	],

	listeners: {
		close: function() 
		{
			window.location.href = '/final/admin/EgAdminOperations.jsp?fromAction='+fromWizard;
		},
		boxready: function() 
		{
			new Ext.ToolTip({
				target: document.getElementById('homeTitle'),
				anchor: 'top',
				anchorOffset:42,
				mouseOffset: [-55, 0],
				html: pageDiscription,
				cls: "adminInfoTooltip"
			});
		}
	}
});

function egTitleSearch()
{
	var obj = Ext.getCmp("unameTree");
	var egTitleSearchStr = Ext.getCmp('searchbox').getValue();
	var firstId = 'MyTrigger_searchbox_0';
	var secondId = 'MyTrigger_searchbox_1';

	if (egTitleSearchStr == "" || egTitleSearchStr .length == 0)
	{
		Ext.get(firstId).setStyle('display','none');
		Ext.get(secondId).setStyle('display','block');
	}
	else
	{
		Ext.get(secondId).setStyle('display','none');
		Ext.get(firstId).setStyle('display','block');
	}
	if(egTitleSearchStr==null || egTitleSearchStr=="")
	{
		Ext.getCmp('unameTree').filterBy(egTitleSearchStr, 'text');
		//No data found message removal
		var elemNoData = Ext.getElementById('noDataFound');
		if (elemNoData)
		{
			elemNoData.style.display = "none";
		}
	}
	else
	{
		Ext.getCmp('unameTree').filterBy(egTitleSearchStr, 'text');
	}
}



