<%
/*******************************************************************************
 *      File name               :   Egassignagentsp.jsp
 *      Purpose                 :   Process page for assigning external agents
 *      Version                 :   1.0
 *      Creation Date           :   08-05-2004
 *      Last Modified Date      :
 *				:
 *      Author                  :   Saravanan.K
 ******************************************************************************/
%>

<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import = "java.util.*"%>
<%@ page import = "com.eg.EgDiscInfo"%>
<%@ page import = "com.eg.EgManagersIniForManager"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%
	/* code for auditlog starts */
	AuditLogThread auditLogThread = new AuditLogThread();	
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Redundant Manager");
	auditLogThread.setValue("Activity","Assign Agents");		
	/* code for auditlog ends */

	/*
	ASSUMPTIONS....
	1. Agents reporting to the Primary manager cannot be Unmanaged.
	    But they can be associated to some other manager.
	2. Agents Disassociated from any of the secondary manager will automatically
	    be associated to Primary manager.

	*/


	EgDiscInfo 	discInfo = new EgDiscInfo("manager");
	Hashtable 	ipNickMap = discInfo.getIpNickMap();
	Hashtable 	nickIpMap = discInfo.getNickIpMap();

	String agentsToUnassociate[]   = request.getParameterValues("agentsForSelectedManagers");
	String agentsToAssociate[] = request.getParameterValues("agentsForOtherManagers");
	String selectedManagerIP = request.getParameter("managerIP");
	String primaryManagerIP = request.getParameter("primaryManagerIP");

	//out.println("selectedManagerIP  "+selectedManagerIP);



	// No agents have been managed or unmanaged...so no work here...go back
	if(agentsToUnassociate == null && agentsToAssociate == null)
	{
		String url = "EgAssignAgents.jsp?manager_IP=" + selectedManagerIP;
		/* code for auditlog starts */
		auditLogThread.setValue("Description","No agents have been managed or unmanaged");
		auditLogThread.sendItToDB();
		/* code for auditlog ends */
%>
		<jsp:forward page="<%=url%>" />
<%
	}

	// To associate this agent to a manager...
	// Disassociate this agent from the manager its currently reporting to..
	// Associate this agent to the manager selected..
	if(agentsToAssociate != null && agentsToAssociate.length > 0)
	{
		//String [] ipNicks = new String[associate.size()];
		EgManagersIniForManager mgrIni = EgManagersIniForManager.getInstance();
		mgrIni.manageTheseAgents(agentsToAssociate, selectedManagerIP);
		/* code for auditlog starts */
		auditLogThread.setCurrentValue("Manager IP",selectedManagerIP);
		if(agentsToAssociate != null && agentsToAssociate.length>0)
		{
			for(int i=0;i<agentsToAssociate.length;i++)
				auditLogThread.setCurrentValue("Associated Agent(s)",agentsToAssociate[i]);
		}
		auditLogThread.setValue("Description","Agents have been associated to manager");
		auditLogThread.sendItToDB();
		/* code for auditlog ends */
	}

	// To Disassociate this agent from a manager...
	// Disassociate this agent from the manager its currently reporting to..
	// Associate this agent to the primary manager..
	if(agentsToUnassociate != null)
	{
		EgManagersIniForManager mgrIni = EgManagersIniForManager.getInstance();
		mgrIni.manageTheseAgents(agentsToUnassociate, primaryManagerIP);
		/* code for auditlog starts */
		auditLogThread.setCurrentValue("Primary Manager IP",primaryManagerIP);
		if(agentsToUnassociate != null && agentsToUnassociate.length>0)
		{
			for(int i=0;i<agentsToUnassociate.length;i++)
				auditLogThread.setCurrentValue("Associated Agent(s)",agentsToUnassociate[i]);
		}
		auditLogThread.setValue("Description","Agent(s) have been associated to primay manager");
		auditLogThread.sendItToDB();
		/* code for auditlog ends */
	}

	String url = "EgAssignAgents.jsp?manager_IP=" + selectedManagerIP;
%>

		 <jsp:forward page="<%=url%>" />








