<%
/***********************************************************************************************************
*
*	Name			:	Egchangeipp.jsp
*	Purpose			:	Process page for the EgChangeIP.jsp.
*	CreationDate	:	06/06/08
*
***********************************************************************************************************/
%>
<%@ include file="EgTrackerA.jsp"%>
<%@ page errorPage="EgProbs.jsp"%>

<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page import = "com.eg.EgServicesInfo" %>
<%@ page import = "com.eg.UpdateIP"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.eg.UnmanagedAgentsInfo" %>

<%@ page import = "java.util.ArrayList"%>
<%@ page import = "java.util.List"%>

<%@ page import = "java.util.StringTokenizer"%>
<%@ page import = "java.util.Collections"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>

<%@ page import="com.eg.AgentConfig"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%
	String hostIP = request.getParameter("hostip");
	String hostName = request.getParameter("hostname");
	String port = request.getParameter("port");
	String treeViewSrc = request.getParameter("treeViewSrc");
	String newHostIP = request.getParameter("newhostip");
	String serverType = request.getParameter("servertype");
	String hostList = request.getParameter("hostlist");
	hostIP = (hostIP != null)?hostIP:"";
	hostName = (hostName != null)?hostName:"";
	newHostIP = (newHostIP != null)?newHostIP:"";
	serverType = (serverType != null)?serverType:"";
	hostList = (hostList != null)?hostList:"";
	AgentConfig agentConfig = AgentConfig.getAgentConfig();

	EgServicesInfo servicesInfo = new EgServicesInfo("manager");
	boolean isAllowHostName = servicesInfo.isAllowHostNames();

	/********Audit Log*******/
	AuditLogThread auditLogThread = new AuditLogThread();	
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Add/Modify Servers");
	auditLogThread.setValue("Activity","Modify Component");
	if(isAllowHostName)
	{
		auditLogThread.setCurrentValue("01~~Old host IP/Name", hostIP);
		auditLogThread.setCurrentValue("02~~New host IP/Name", newHostIP);
		auditLogThread.setValue("Description","Host IP/Name has been modified");
	}
	else
	{
		auditLogThread.setCurrentValue("01~~Old host IP", hostIP);
		auditLogThread.setCurrentValue("02~~New host IP", newHostIP);
		auditLogThread.setValue("Description","Host IP has been modified");
	}
	
	boolean statusFlag = true;
	String hostNames = hostName;
	String modexternalHosts = "";
	String modremoteHosts = "";
	if (hostList.length() > 0)
	{
		hostNames += ":"+hostList;
	}
	UpdateIP updateIP = new UpdateIP();
	
	// eg_discover.ini and eg_agents.ini are to be modified for IP changes
	statusFlag = updateIP.changeHostIP(hostNames,hostIP,newHostIP);
	
	hostNames = updateIP.getModifiedComponents(hostName,serverType);
	modexternalHosts = updateIP.getModifiedExternalHosts();
	modremoteHosts = updateIP.getModifiedRemoteHosts();
	Vector sess_vec = new Vector();
	String url = "";
	List resultList = new ArrayList();
	StringTokenizer stt = new StringTokenizer(hostNames,":");
	while(stt.hasMoreTokens())
	{
		String tmpHost = stt.nextToken();
		int idx = tmpHost.indexOf("|");
		if (idx > 0)
		{
			String modCompTypes = tmpHost.substring(idx+1);
			if(modCompTypes.indexOf(",") > 0)
			{
				StringTokenizer strToken = new StringTokenizer(modCompTypes,",");
				while(strToken.hasMoreTokens())
				{
					resultList.add(tmpHost.substring(0,idx)+" ("+_mapping.getComponentTypeDescription(strToken.nextToken())+")");
				}
			}
			else
			{
				resultList.add(tmpHost.substring(0,idx)+" ("+_mapping.getComponentTypeDescription(modCompTypes)+")");
			}
		}
		else
		{
			resultList.add(tmpHost+" ("+_mapping.getComponentTypeDescription(serverType)+")");
		}
	}
	Collections.sort(resultList);
	/*****Audit Log*********/
	if (resultList.size()>0)
	{		
		for(int i=0;i<resultList.size();i++)
		{
			auditLogThread.setCurrentValue("03~~Modified host(s)", (String)resultList.get(i));
		}
	
	}
	/*********************/

	String sessResult = resultList.toString();
	sessResult = sessResult.substring(1,sessResult.length() -1);

	boolean allExternalTests = true;
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	String[] testsForServer = specsInfo.getTestsForServer(serverType);
	if (testsForServer != null)
	{
		for (int a=0; a<testsForServer.length; a++)
		{
			if (!specsInfo.isTestExternal(testsForServer[a]))
			{
				allExternalTests = false;
				break;
			}
		}
	}

	String urlForParentPage  = "EgNewServer.jsp?server="+hostName+":"+port+"&serverType="+serverType+"&modifyserver=true&allExternalTests="+allExternalTests;

	if (statusFlag)
	{
		agentConfig.removeAgentElement(hostName);
		sess_vec.add(_mapping.getTextDescription("admin.server.Modify components"));
		if(!StringUtils.isNull(treeViewSrc))
		{
			sess_vec.add(urlForParentPage+"&treeViewSrc="+treeViewSrc);
		}
		else
		{
			sess_vec.add(urlForParentPage);
		}
		sess_vec.add(_mapping.getTextDescription("admin.server.Modify components"));
		sess_vec.add(_mapping.getTextDescription("admin.server.The following component(s) is/are updated with the new host IP")+" "+newHostIP+"<br><br>"+sessResult);
		//sess_vec.add(sessResult);
		if(modexternalHosts!=null && modexternalHosts.length() > 0)
		{
			sess_vec.add(_mapping.getTextDescription("admin.server.The following external host(s) is/are updated with the new host IP")+" "+newHostIP+"<br><br>"+modexternalHosts);
			//sess_vec.add(modexternalHosts);
			auditLogThread.setCurrentValue("04~~Modified External agent(s)", modexternalHosts);
		}
		if(modremoteHosts!=null && modremoteHosts.length() > 0)
		{
			sess_vec.add(_mapping.getTextDescription("admin.server.The following remote host(s) is/are updated with the new host IP")+" "+newHostIP+"<br><br>"+modremoteHosts);
			//sess_vec.add(modremoteHosts);
			auditLogThread.setCurrentValue("05~~Modified Remote agent(s)", modremoteHosts);
		}
		auditLogThread.sendItToDB();
		session.setAttribute("vec_Results",sess_vec);
		url="EgResults.jsp";
		if(!StringUtils.isNull(treeViewSrc))
		{
			url="EgResults.jsp?from=ManUnMan";
		}
		UnmanagedAgentsInfo uai = new UnmanagedAgentsInfo();
		uai.updateAgentDetail(newHostIP);
	}
	else
	{
		sess_vec.add(_mapping.getTextDescription("admin.server.Modify components"));
		if(!StringUtils.isNull(treeViewSrc))
		{
			sess_vec.add(urlForParentPage+"&treeViewSrc="+treeViewSrc);
		}
		else
		{
			sess_vec.add(urlForParentPage);
		}
		sess_vec.add(urlForParentPage);
		sess_vec.add(_mapping.getTextDescription("admin.server.Modify components"));
		sess_vec.add(_mapping.getTextDescription("admin.server.Not properly updated with the new host IP")+", "+newHostIP);
		session.setAttribute("vec_Errors",sess_vec);
		url = "EgErrors.jsp";
	}
%>
<jsp:forward page="<%=url%>" />


