<%
/**
 *	Process page for EgDiagnosisFormat.jsp
 *
 *	@author		Arun Jayaprakash
 *	@created	20/03/2004
 *	@version	3.1
 *
 *	@modified	24/05/2004	Arun	Included checks to see if eg_format.ini is defined for DD 
 *									before generating the classes.
 *				07/01/2004	Arun	Uses StringUtils.removeISOControlChar() to remove Ctrl-M
 *									from text.
 */
%>
<%@ include file="EgTrackerA.jsp" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import = "egurkha.TestBean" %>
<%@ page import = "com.egurkha.*" %>
<%@ page import = "com.egurkha.util.*" %>
<%@ page import = "java.util.*" %>

<jsp:useBean id="serviceBean" scope="page" class="egurkha.ServiceBean"/>

<%
	String testName = request.getParameter("test");
	String serverType = request.getParameter("server");
	
	String action = request.getParameter("action");
	
	if (action == null)
	{
	
		action = EgConstants.BLANK_STRING;
	}

	if (action.equalsIgnoreCase("generate"))
	{
		
		String loadLib = request.getParameter("loadLib");
		String lib = request.getParameter("lib");
		String path = request.getParameter("path");

		TestBean testBean = new TestBean(true);
//System.out.println("DD enabled for "+testName+"? "+testBean.isDdEnabled(testName));
		if(!testBean.loadDdFile(path, testName)) 
		{	
			Vector errors = new Vector();
			errors.add(_mapping.getTextDescription("admin.error.Generate Detailed Diagnosis"));
			errors.add("EgConfigTestMeasure.jsp?test=" + testName); 
			errors.add(_mapping.getTextDescription("admin.error.Possible Reason"));
			errors.add(_mapping.getTextDescription("admin.error.Unable to load the class file from")+" " + path);
			errors.add(_mapping.getTextDescription("admin.error.Please check if the class file is available in the specified path"));
			session.setAttribute("vec_Errors", errors);

%>
	<jsp:forward page="EgErrors.jsp" />
<%
		}
		else if(loadLib != null && loadLib.equalsIgnoreCase("yes") && !testBean.loadDdFile(lib, testName))
		{
			Vector errors = new Vector();
			errors.add(_mapping.getTextDescription("admin.error.Generate Detailed Diagnosis"));
			errors.add("EgConfigTestMeasure.jsp?test=" + testName); 
			errors.add(_mapping.getTextDescription("admin.error.Possible Reason"));
			errors.add(_mapping.getTextDescription("admin.error.Unable to load the library file")+" " + lib );
			errors.add(_mapping.getTextDescription("admin.error.Please check if the file is available in the specified path"));
			errors.add(_mapping.getTextDescription("admin.error.Please note files of size more than 0*5 MB may not be loaded")+". "+_mapping.getTextDescription("admin.error.These files have to be added manually")+". "+_mapping.getTextDescription("admin.error.Please refer User Manual on where to add these library files"));
			session.setAttribute("vec_Errors", errors);
%>
	<jsp:forward page="EgErrors.jsp" />
<%
		}
		else if (!testBean.isDdEnabled(testName))
		{
			Vector errors = new Vector();
			errors.add(_mapping.getTextDescription("admin.error.Generate Detailed Diagnosis"));
			errors.add("EgDiagnosisFormat.jsp?page=true&measure=&test="+testName);
			errors.add(_mapping.getTextDescription("admin.error.Possible Reason"));
			errors.add(_mapping.getTextDescription("admin.error.No measure(s) have been selected for Detailed Diagnosis")+". ");
			errors.add(_mapping.getTextDescription("admin.error.Please select the measure(s) and specify the description and column headings for enabling Detailed Diagnosis")+".");
			session.setAttribute("vec_Errors", errors);
%>
	<jsp:forward page="EgErrors.jsp" />
<%
		}

		String url = "EgDefault.jsp?qctr=0&t_name="+testName;
		if (!StringUtils.isNull(serverType) && !serverType.equalsIgnoreCase("null"))
		{
			url += "&server="+serverType;
		}
		else
		{
			url += "&page=true";
		}

//System.out.println("Egdiagnosisformatp.jsp : Url - "+url);
%>
<script language="JavaScript">
		window.location.href = "<%=url%>";
</script><%
	}
	else if (action.equalsIgnoreCase("add"))
	{
		
		String colTitles = request.getParameter("ddColTitles");
		String desc = request.getParameter("ddDesc");
		String measureName = request.getParameter("measure");

		if (!StringUtils.isNull(colTitles)
		|| !StringUtils.isNull(desc)
		|| !StringUtils.isNull(testName)
		|| !StringUtils.isNull(measureName))
		{
			serviceBean.stopDiscovery();

			StringBuffer key = new StringBuffer(32);
			key.append(testName);
			key.append(EgConstants.COLON);
			key.append(measureName);

			desc = StringUtils.removeISOControlChar(desc);
			colTitles = StringUtils.removeISOControlChar(colTitles);

			
			StringBuffer value = new StringBuffer(32);
			value.append("Format");
			value.append(EgConstants.COLON);
			/*
			 * Replacing commas in the string to blank spaces
			 */
			value.append(colTitles.replace(',', ' '));
			value.append(EgConstants.COMMA);
			value.append("Desc:");
			value.append(desc);

			/*
			 * Open eg_format.ini and create an entry in the format
			 * TestName:MeasureName=Format:<column names>,Desc:<desc>
			 */
			IniFile iniFile = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_format.ini", true);
			//System.out.println("Setting "+value.toString()+" in ini file");
			iniFile.setValue("FORMAT", key.toString(), value.toString());
			iniFile.saveFile();
			EgConfigFilesSync.releaseInstance(iniFile);
			serviceBean.startDiscovery("1");

		/*
		 * Go to EgDiagnosisFormat.jsp to add detailed diagnosis for any other measure
		 *
		 */
		 String s_url = "EgDiagnosisFormat.jsp?test=" + testName + "&server=" +  serverType+ "&measure=";
%>
		<jsp:forward page="<%=s_url%>" />
<%
		}
		else
		{
			Vector errors = new Vector();
			errors.addElement(_mapping.getTextDescription("admin.error.Format Entries For Detailed Diagnosis"));
			errors.addElement("EgDiagnosisFormat.jsp?test="+testName+"&server="+serverType);
			errors.addElement(_mapping.getTextDescription("admin.error.Possible Reasons"));
			errors.addElement(_mapping.getTextDescription("admin.error.One of the following was not available")+".<br>");
			errors.addElement("1) "+_mapping.getTextDescription("admin.error.Column titles for the table")+". <br>");
			errors.addElement("2) "+_mapping.getTextDescription("admin.error.Description for the detailed diagnosis test")+".<br>");
			errors.addElement("3) "+_mapping.getTextDescription("admin.error.Name of the test and/or measure for which the detailed diagnosis is enabled"));
			session.setAttribute("vec_Errors", errors);
%>
		<jsp:forward page="EgErrors.jsp" />
<%
		}
	}
	else if (action.equalsIgnoreCase("del"))
		{
			
			String add = request.getParameter("add");
			String test = request.getParameter("test");
			String measure = request.getParameter("ddmeasure");
			IniFile iniFile = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_format.ini", true);
			StringBuffer key = new StringBuffer(32);
			key.append(test);
			key.append(EgConstants.COLON);
			key.append(measure);
			
			iniFile.deleteValue("FORMAT",key.toString());
			iniFile.saveFile();
			EgConfigFilesSync.releaseInstance(iniFile);
			String s_url1 = "EgDiagnosisFormat.jsp?test=" + testName ;
%>
		<jsp:forward page="<%=s_url1%>" />
<%
	}
	else
	{
		Vector errors = new Vector();
		errors.addElement(_mapping.getTextDescription("admin.error.Format Entries For Detailed Diagnosis"));
		errors.addElement("EgDiagnosisFormat.jsp?test="+testName+"&server="+serverType);
		errors.addElement(_mapping.getTextDescription("admin.error.Possible Reasons"));
		errors.addElement(_mapping.getTextDescription("admin.error.Data insufficient to enable detailed diagnosis")+".");
		errors.addElement(_mapping.getTextDescription("admin.error.Please try again")+".");
		errors.addElement("");
		errors.addElement("");
		session.setAttribute("vec_Errors", errors);
	}	
%>