Ext.define('EnableDisableDD.controller.Main',{
	extend:'Ext.app.Controller',

	views: ['FormItems'],

	refs: [
		{
			selector:'formitems',
			ref:'formitems'
		},
	],

	init: function(){
		this.buildFieldData()

		this.control({
			'formitems': {
				'afterrender': this.afterMainRender
			},
			'formitems combo[id="compType"]': {
				'select': this.comboLoad
			},
			'formitems button[id="UpdateBTN"]': {
				'click': this.updation
			}
		});
	},

	buildFieldData: function(){
		Ext.Ajax.request({
			url: 'EnableDisableDD/data/EgEnableDisableDDJson.jsp',
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},

	comboLoad: function() {
		var testItemSelectorObj = Ext.getCmp('itemselectDD');
		var fromTriggerObj =  testItemSelectorObj.fromField.down('trigger');
		var toTriggerObj =  testItemSelectorObj.toField.down('trigger');
		if (!Ext.isEmpty(fromTriggerObj.getValue()))
		{
			fromTriggerObj.reset();
		}

		if (!Ext.isEmpty(toTriggerObj.getValue()))
		{
			toTriggerObj.reset();
		}

		var componentType = Ext.getCmp('compType').getValue();
		Ext.Ajax.request({
			url: 'EnableDisableDD/data/EgEnableDisableDDJson.jsp?componentType='+encodeURIComponent(componentType),
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
				Ext.getCmp('itemselectDD').getStore().loadRawData(publicJSON['itemSelectorValue']);
				Ext.getCmp('itemselectDD').setValue(publicJSON['disableTests']);
			}
		});
	},

	updation: function(btn){
		var compType = Ext.getCmp('compType').getValue();
		if (compType == '-1')
		{
			Ext.Msg.show(
			{
				title :pageTitle,
				msg : publicJSON['screenLabels']['admin.test.Please choose a component type']+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
			});
		}
		else
		{
			var myDDMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
			myDDMask.show(); 

			var prevEnabledDDTests = publicJSON['enableTests'];
			var prevDisabledDDTests = publicJSON['disableTests'];

			var DDdisabledTestList = Ext.getCmp('itemselectDD').getValue();

			var Arr = new Array();
			for (var i=0;i<Ext.getCmp('itemselectDD').getStore().getCount();i++)
			{
				var allValue = Ext.getCmp('itemselectDD').getStore().getAt(i).get('valueField');
				var isData = false;
				for (var j=0;j<DDdisabledTestList.length ;j++ )
				{
					if (allValue == DDdisabledTestList[j])
					{
						isData = true;
						break;
					}
				}
				if (!isData)
				{
					Arr[Arr.length]=allValue;
				}
			}
			var DDenabledTestList = Arr;
			var qrString = "prevEnabledDDTests="+prevEnabledDDTests+"&prevDisabledDDTests="+prevDisabledDDTests+"&DDdisabledTestList="+DDdisabledTestList+"&DDenabledTestList="+DDenabledTestList+"&componentType="+encodeURIComponent(compType);

			Ext.Ajax.request({
			url: 'EnableDisableDD/data/EgEnableDisableDDpJson.jsp?'+qrString,
			method: 'POST',
			success: function( response )
			{
				myDDMask.hide(); 
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
				if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
				{
					var resultStatus = publicJSON['requestStatus'];
					if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
					{
						var resultStatus = publicJSON['result'];
						Ext.MessageBox.show(
						{
							title : resultStatus['title'],
							msg : resultStatus['message1'],
							icon : 'iconInformation',
							buttons : Ext.Msg.OK,
							fn : function(btn){
									Ext.Ajax.request({
									url: 'EnableDisableDD/data/EgEnableDisableDDJson.jsp?componentType='+encodeURIComponent(compType),
									method: 'POST',
									success: function( response )
									{
										if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
										{
											var jsonText = response.responseText;
											publicJSON = Ext.decode( jsonText );
										}
										Ext.getCmp('itemselectDD').getStore().loadRawData(publicJSON['itemSelectorValue']);
										Ext.getCmp('itemselectDD').setValue(publicJSON['disableTests']);
									}
								});
							}
						});
					}
				}
			}
		});
		}
	},

	initializeFields : function(){
		var me=this;
		var executiveForm = this.getFormitems().getForm();
		var screenLabels = publicJSON['screenLabels'];
		if (componType == "null")
		{
			me.setValueWithOptionInList(executiveForm, 'compType', publicJSON['compType'],'');
		}
		else
		{
			me.setValueWithOptionInList(executiveForm, 'compType', publicJSON['compType'],componType);
		}
	},

	setValueWithOptionInList : function(form, fieldName, list, value){
		form.findField(fieldName).getStore().clearFilter(true);
		form.findField(fieldName).getStore().loadRawData(list);
		form.findField(fieldName).suspendEvents(false);
		var valueAssigned = false;
		for(var listCounter = 0 ; listCounter < list.length ; listCounter++){
			if(list[listCounter].valueField == value && !Ext.isEmpty(value) && value != null){
				form.findField(fieldName).setValue(value);
				valueAssigned = true;
			}
		}
		
		if(!valueAssigned){
			form.findField(fieldName).setValue(list[0].valueField);
		}
		form.findField(fieldName).resumeEvents();
	},

	afterMainRender : function() {
		this.initializeFields();
		Ext.getCmp('itemselectDD').fromField.getComponent(0).setTitle(publicJSON['screenLabels']['admin.test.DD ENABLED TESTS']);
		Ext.getCmp('itemselectDD').toField.getComponent(0).setTitle(publicJSON['screenLabels']['admin.test.DD DISABLED TESTS']);
		Ext.getCmp('compType').setFieldLabel(publicJSON['screenLabels']['admin.server.Component type']);
		Ext.getCmp('UpdateBTN').setText(publicJSON['screenLabels']['admin.common.Update']);

		if (componType != null && !Ext.isEmpty(componType))
		{
			Ext.Ajax.request({
			url: 'EnableDisableDD/data/EgEnableDisableDDJson.jsp?componentType='+encodeURIComponent(componType),
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
				Ext.getCmp('itemselectDD').getStore().loadRawData(publicJSON['itemSelectorValue']);
				Ext.getCmp('itemselectDD').setValue(publicJSON['disableTests']);
			}
		});
		}
	}

});



