Ext.define('EnableDisableTests.controller.Main',{
	extend:'Ext.app.Controller',

	views: ['FormItems'],

	refs: [
		{
			selector:'formitems',
			ref:'formitems'
		},
	],

	init: function(){
		this.buildFieldData()

		this.control({
			'formitems': {
				'afterrender': this.afterMainRender
			},
			'formitems combo[id="compType"]': {
				'select': this.comboLoad
			},
			'formitems combo[id="testType"]': {
				'select': this.comboLoad
			},
			'formitems multiselect[id="itemselectTests"]': {
				'change': this.getDataLoad
			},
			'formitems button[id="UpdateBTN"]': {
				'click': this.updation
			},
			'formitems button[id="backbutton"]': {
				'click': this.backbutton
			}
		});
	},

	buildFieldData: function(){
		Ext.Ajax.request({
			url: 'EnableDisableTests/data/EgEnableDisableTestsJson.jsp',
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},

	comboLoad: function(){
		var testItemSelectorObj = Ext.getCmp('itemselectTests');
		var fromTriggerObj =  testItemSelectorObj.fromField.down('trigger');
		var toTriggerObj =  testItemSelectorObj.toField.down('trigger');
		if (!Ext.isEmpty(fromTriggerObj.getValue()))
		{
			fromTriggerObj.reset();
		}

		if (!Ext.isEmpty(toTriggerObj.getValue()))
		{
			toTriggerObj.reset();
		}

		var componentType = Ext.getCmp('compType').getValue();
		var testType = Ext.getCmp('testType').getValue();
		var qrString = '';
		var isConfigSupported = publicJSON['isConfigSupported'];
		if (isConfigSupported == false)
		{
			qrString = "componentType="+encodeURIComponent(componentType);
		}
		else
		{
			qrString = "componentType="+encodeURIComponent(componentType)+"&testType="+testType;
		}
		Ext.Ajax.request({
			url: 'EnableDisableTests/data/EgEnableDisableTestsJson.jsp?'+qrString,
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
				var noConfigTests = publicJSON['screenLabels']['No Configuration Tests Available'];
				if (componentType != -1 && typeof noConfigTests != 'undefined')
				{
					Ext.getCmp('NoConfigTestAvailable').show();
					Ext.getCmp('itemselectTests').hide();
					Ext.getCmp('UpdateBTN').hide();
				}
				else
				{
					Ext.getCmp('NoConfigTestAvailable').hide();
					Ext.getCmp('itemselectTests').show();
					Ext.getCmp('UpdateBTN').show();
					Ext.getCmp('itemselectTests').getStore().loadRawData(publicJSON['allTests']);
					Ext.getCmp('itemselectTests').setValue(publicJSON['disabledTests']);
				}
			}
		});
	},

	backbutton: function(){
		if (!Ext.isEmpty(btnFrom))
		{
			if (backBtnUrl.indexOf("reqfrom") == -1)
			{
				backBtnUrl = backBtnUrl+"&reqfrom="+btnFrom;
				btnFrom = "";
			}
		}

		if (!Ext.isEmpty(fromWizard))
		{
			backBtnUrl+="&fromWizard="+fromWizard;
		}
		window.location.href = backBtnUrl;
	},

	getDataLoad: function(){
		var disabledTestList = Ext.getCmp('itemselectTests').getValue();
		var userTest = publicJSON['usrBasedTests'];
		var namedUserTest = '';
		var userTestStr = userTest.toString();
		var userTestToken = userTestStr.split(",");

		var isNamedUser = false;
		var isRumParentTest = false;
		var webDispName = '';
		var disableArr = new Array();
		var namedUserValue = '';
		var componentType = Ext.getCmp('compType').getValue();
		
		for (var j=0;j<userTestToken.length ;j++)
		{
			for (var k=0;k<disabledTestList.length ;k++)
			{
				if (disabledTestList[k] == userTestToken[j])
				{
					isNamedUser = true;
					var displayIndex = Ext.getCmp('itemselectTests').getStore().find('valueField',userTestToken[j],0,false,true,true);
					var dispName = Ext.getCmp('itemselectTests').getStore().getAt(displayIndex).get('displayField');
					var dispValue = Ext.getCmp('itemselectTests').getStore().getAt(displayIndex).get('valueField');
					namedUserTest += ","+dispName;
					namedUserValue += ","+dispValue;
				}
			}
		}
		for (var k=0;k<disabledTestList.length ;k++)
		{
			if (!Ext.isEmpty(componentType) && componentType == 'Real_user_monitor')
			{
				if (!Ext.isEmpty(disabledTestList[k]) && disabledTestList[k] == 'RUMAppTest')
				{
					isRumParentTest = true;
					var dispIndex = Ext.getCmp('itemselectTests').getStore().find('valueField',disabledTestList[k],0,false,true,true);
					var dispName = Ext.getCmp('itemselectTests').getStore().getAt(dispIndex).get('displayField');
					var dispValue = Ext.getCmp('itemselectTests').getStore().getAt(dispIndex).get('valueField');
					webDispName = dispName;
				}
				
				if (!Ext.isEmpty(disabledTestList[k]) && disabledTestList[k] != 'RUMAppTest')
				{
					disableArr[disableArr.length] = disabledTestList[k];
				}
				else
				{
					continue;
				}
			}
			else if (namedUserValue.indexOf(disabledTestList[k]) == -1)
			{
				disableArr[disableArr.length] = disabledTestList[k];
			}
			else
			{
				continue;
			}
		}

		if (isRumParentTest)
		{
			Ext.Msg.show(
			{
				title : pageTitle,
				msg : webDispName + ' test cannot be disabled.',
				buttons : Ext.Msg.OK,
				width: 300,
				icon : 'iconExclamation',
			});
			var disableTestListValue = disableArr;
			Ext.getCmp('itemselectTests').show();
			Ext.getCmp('itemselectTests').getStore().loadRawData(publicJSON['allTests']);
			Ext.getCmp('itemselectTests').setValue(disableTestListValue);
		}

		if (isNamedUser)
		{
			Ext.Msg.show(
			{
				title : pageTitle,
				msg : publicJSON['screenLabels']['NamedUserAlert']+publicJSON['screenLabels']['NamedUserAlertName']+" "+namedUserTest.substring(1),
				buttons : Ext.Msg.OK,
				icon : 'iconExclamation',
			});
			var disableTestListValue = disableArr;
			Ext.getCmp('itemselectTests').show();
			Ext.getCmp('itemselectTests').getStore().loadRawData(publicJSON['allTests']);
			Ext.getCmp('itemselectTests').setValue(disableTestListValue);
		}
	},

	updation: function(btn){
		var componentType = Ext.getCmp('compType').getValue();
		if (componentType == -1)
		{
			Ext.Msg.show(
			{
				title : pageTitle,
				msg : publicJSON['screenLabels']['admin.test.Please choose a component type']+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				width : 300
			});
		}
		else
		{
			var testType = Ext.getCmp('testType').getValue();

			var updateUrl = publicJSON['updateUrl'];
			var disabledTestList = Ext.getCmp('itemselectTests').getValue();

			var Arr = new Array();
			for (var i=0;i<Ext.getCmp('itemselectTests').getStore().getCount();i++)
			{
				var allValue = Ext.getCmp('itemselectTests').getStore().getAt(i).get('valueField');
				var isData = false;
				for (var j=0;j<disabledTestList.length ;j++ )
				{
					if (allValue == disabledTestList[j])
					{
						isData = true;
						break;
					}
				}
				if (!isData)
				{
					Arr[Arr.length]=allValue;
				}
			}
			var tempenabledTestList = Arr;
			var enabledTestList = tempenabledTestList.toString();

			var flagEnable = false;
			var enableTests_Only = new Array();
			var EnabledStr = publicJSON['checkEnabledTests'];
			EnabledStr = ","+EnabledStr+",";
			var newlyEnabledTest="";
			var newlyEnabledTestTokens = enabledTestList.split(",");
			var n=0;
			for(i = 0; i < newlyEnabledTestTokens.length; i++)
			{
				newlyEnabledTest = newlyEnabledTestTokens[i];
				if(EnabledStr.indexOf(","+newlyEnabledTest+",") == -1)
				{
					enableTests_Only[n++] = newlyEnabledTest;
					flagEnable = true;
				}
			}

			var flagDisable = false;
			var disableTests_Only = new Array();
			var DisabledStr = publicJSON['checkDisabledTests'];
			var disabledTestListVal = disabledTestList.toString();
			var newlyDisabledTest="";
			var newlyDisabledTestTokens = disabledTestListVal.split(",");
			DisabledStr = ","+DisabledStr+",";
			var d=0;
			for(i = 0; i < newlyDisabledTestTokens.length; i++)
			{
				newlyDisabledTest = newlyDisabledTestTokens[i];
				if(DisabledStr.indexOf(","+newlyDisabledTest+",") == -1)
				{
					disableTests_Only[d++] = newlyDisabledTest;
					flagDisable = true;
				}
			}

			if(flagEnable || flagDisable)
			{
				var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
				myMask.show();

				var isConfigSupported = publicJSON['isConfigSupported'];
				if (isConfigSupported == false)
				{
					var result = updateUrl+"&componentType="+encodeURIComponent(componentType); //+"&enableTests_Only="+enableTests_Only+"&disableTests_Only="+disableTests_Only;
				}
				else
				{
					var result = updateUrl+"&componentType="+encodeURIComponent(componentType)+"&testType="+testType;//+"&enableTests_Only="+enableTests_Only+"&disableTests_Only="+disableTests_Only;
				}
				Ext.Ajax.request({
				url: result,
				params: {
					enabledTestList : enabledTestList,
					disabledTestList : disabledTestList,
					enableTests_Only : enableTests_Only.toString(),
					disableTests_Only : disableTests_Only.toString()
				},
				timeout: 600000,
				method: 'POST',
				success: function( response )
				{
					myMask.hide();
					var jsonText = response.responseText;
					publicJSON = Ext.decode(jsonText);
					if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
					{
						var resultStatus = publicJSON['requestStatus'];
						if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
						{
							var resultStatus = publicJSON['result'];
							Ext.MessageBox.show(
							{
								title : resultStatus['title'],
								msg : resultStatus['message1'],
								icon : 'iconInformation',
								buttons : Ext.Msg.OK,
								width : 300,
								fn : function(btn)
								{
									var qrrString = '';
									if (isConfigSupported == false)
									{
										qrrString = "componentType="+encodeURIComponent(componentType);
									}
									else
									{
										qrrString = "componentType="+encodeURIComponent(componentType)+"&testType="+testType;
									}
									Ext.Ajax.request({
										url: 'EnableDisableTests/data/EgEnableDisableTestsJson.jsp?'+qrrString,
										method: 'POST',
										success: function( response )
										{
											if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
											{
												var jsonText = response.responseText;
												publicJSON = Ext.decode( jsonText );
											}
											Ext.getCmp('itemselectTests').show();
											Ext.getCmp('itemselectTests').getStore().loadRawData(publicJSON['allTests']);
											Ext.getCmp('itemselectTests').setValue(publicJSON['disabledTests']);
										}
									});
								}
							});
						}
					}
				}
				});
			}
			else
			{
				Ext.MessageBox.show(
				{
					title : pageTitle,
					msg : publicJSON['screenLabels']['admin.test.Please choose atleast one test to enable or disable']+'.',
					icon : 'iconInformation',
					buttons : Ext.Msg.OK,
					width : 300
				});
			}
		}
	},

	initializeFields: function(){
		var me=this;
		var executiveForm = this.getFormitems().getForm();
		if (componType == "null")
		{
			me.setValueWithOptionInList(executiveForm, 'compType', publicJSON['ComponentType'],'');
		}
		else
		{
			me.setValueWithOptionInList(executiveForm, 'compType', publicJSON['ComponentType'],componType);
		}
		var isConfigSupported = publicJSON['isConfigSupported'];
		if (isConfigSupported == true)
		{
			if (testType == "null")
			{
				me.setValueWithOptionInList(executiveForm, 'testType', publicJSON['TestType'],'');
			}
			else
			{
				me.setValueWithOptionInList(executiveForm, 'testType', publicJSON['TestType'],testType);
			}
		}
	},

	setValueWithOptionInList: function(form, fieldName, list, value) {
		form.findField(fieldName).getStore().clearFilter(true);
		form.findField(fieldName).getStore().loadRawData(list);
		form.findField(fieldName).suspendEvents(false);
		var valueAssigned = false;
		if (list.length > 0)
		{
		for(var listCounter = 0 ; listCounter < list.length ; listCounter++){
			if(list[listCounter].valueField == value && !Ext.isEmpty(value) && value != null){
				form.findField(fieldName).setValue(value);
				valueAssigned = true;
			}
		}
		}
		if(!valueAssigned){
			form.findField(fieldName).setValue(list[0].valueField);
		}
		form.findField(fieldName).resumeEvents();
	},

	afterMainRender: function(){
		if ((fromNavlink != null && !Ext.isEmpty(fromNavlink) && fromNavlink != "null" ) || (fromResultPage == "true") || hideBtn == 'true')
		{
			Ext.getCmp('backbutton').hide();
		}
		
		this.initializeFields();
		if ((componType == null && Ext.isEmpty(componType)) || (testType == null && Ext.isEmpty(testType)))
		{
			Ext.getCmp('itemselectTests').show();
			Ext.getCmp('UpdateBTN').show();
		}
		Ext.getCmp('compType').setFieldLabel(publicJSON['screenLabels']['admin.server.Component type']);
		Ext.getCmp('testType').setFieldLabel(publicJSON['screenLabels']['admin.test.Test type']);
		Ext.getCmp('UpdateBTN').setText(publicJSON['screenLabels']['admin.common.Update']);
		Ext.getCmp('itemselectTests').fromField.getComponent(0).setTitle(publicJSON['screenLabels']['admin.test.ENABLED TESTS']);
		Ext.getCmp('itemselectTests').toField.getComponent(0).setTitle(publicJSON['screenLabels']['admin.test.DISABLED TESTS']);

		var isConfigSupported = publicJSON['isConfigSupported'];
		if (isConfigSupported == false)
		{
			Ext.getCmp('testType').hide();
		}
		Ext.getCmp('NoConfigTestAvailable').hide();
		if ((componType != null && !Ext.isEmpty(componType)) || (testType != null && !Ext.isEmpty(testType)))
		{
			var qrrString = '';
			if (isConfigSupported == false)
			{
				qrrString = "componentType="+encodeURIComponent(componType);
			}
			else
			{
				qrrString = "componentType="+encodeURIComponent(componType)+"&testType="+testType;
			}
			Ext.Ajax.request({
				url: 'EnableDisableTests/data/EgEnableDisableTestsJson.jsp?'+qrrString,
				method: 'POST',
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						publicJSON = Ext.decode( jsonText );
					}
					var noConfigTests = publicJSON['screenLabels']['No Configuration Tests Available'];
					if (componType != -1 && typeof noConfigTests != 'undefined')
					{
						Ext.getCmp('itemselectTests').hide();
						Ext.getCmp('UpdateBTN').hide();
						Ext.getCmp('NoConfigTestAvailable').show();
					}
					else
					{
						Ext.getCmp('NoConfigTestAvailable').hide();
						Ext.getCmp('itemselectTests').show();
						Ext.getCmp('UpdateBTN').show();
						Ext.getCmp('itemselectTests').getStore().loadRawData(publicJSON['allTests']);
						Ext.getCmp('itemselectTests').setValue(publicJSON['disabledTests']);
					}
				}
			});
		}
	}

});



