Ext.define('EnableDisableTests.view.FormItems', {
	extend: 'utilities.innerScrollContainer',
	alias: 'widget.formitems',
	title: pageTitle,
	cls:'outerpanel',
	header:{cls:'textUpper'},
	margin:'8 8 0 8',
	id: 'formitems',
	requires: [
		'Ext.ux.ItemSelectorSm',
		'utilities.ScrollCombo'
	],

	fieldDefaults: {
		labelAlign: 'top',
		labelSeparator: ' '
	},

	layout: {
		type: 'vbox',
		align:'stretch'
	},

	items: [
		{
			xtype: 'component',
			cls:'adminHeadInfoText',
			html: "<center>"+'<img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp'+pageDesc+"."+"</center>",
			width:'100%',
			height: 25,
			padding: 3
		},
		{
			xtype:'container',
			layout : {
				type : 'vbox',
				align : 'center',
				pack : 'center'
			},
			items:[
				{
					xtype: 'container',
					cls:'formOuter',
					layout: {
						type: 'hbox',
						pack: 'center'
					},
					margin: 10,
					padding:10,
					items: [
						{
							xtype: 'scrollcombo',
							cls:'dropdown',
							id : 'compType',
							name: 'compType',
							fieldLabel: 'ComponentType',
							fieldName : 'compType',
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local',
							//editable: false,
							width: 250,
							parent:this,
							store:new Ext.data.Store({
								fields: ['displayField','valueField'],
								data: []
							})
						},
						{
							xtype: 'scrollcombo',
							cls:'dropdown',
							id : 'testType',
							name: 'testType',
							fieldLabel: 'Test Type',
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local',
							editable: false,
							width: 150,
							margin: '0 0 0 20',
							parent:this,
							store:new Ext.data.Store({
								fields: ['displayField','valueField'],
								data: []
							})
						}
					]
				}
			]
		},
		{
			xtype: 'container',
			id: 'NoConfigTestAvailable',
			layout: {
				type: 'vbox',
				pack: 'center',
				align: 'center'
			},
			items: [
				{
					xtype: 'label',
					html: '<table><tr><td align="center" height="400"><table><tr><td align="center"><img src="/final/admin/eg_images/spacer.gif" class="iconExclamation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+noConfTest+'</td></tr></table></td></tr></table>'
				}
			]
		},
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center',
				align: 'stretch'
			},
			flex: 1,
			margin: 10,
			items: [
				{
					xtype: 'itemselectorsmfield',
					cls:'multiselect',
					name: 'itemselectTests',
					fieldName: 'itemselectTests',
					id: 'itemselectTests',
					//font: 'bold',
					buttons: ['add','remove'],
					buttonsText: {
						add: "Add to Disabled",
						remove: "Remove from Disabled"
					},
					store: new Ext.data.Store({
						fields: ['displayField','valueField'],
						data: []
					}),
					displayField: 'displayField',
					valueField: 'valueField',
					height: 370,
					width: 800,
					fromTitle: 'ENABLED TESTS',
					toTitle: 'DISABLED TESTS',
					hidden: true
				}
			]
		},
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			margin: '10 0 20 0',
			items: [
				{
					xtype: 'button',
					cls:'button20',
					text: 'Update',
					id: 'UpdateBTN',
					width: 80,
					hidden: true
				}
			]
		}
	],

	tools: [
		{
			xtype : 'button',
			cls:'backbutton',
			id : 'backbutton',
			iconCls:'iconBack',
			text : backBtnLabel
		}
	]

});



