Ext.define('ExportImport.controller.Main',{
	extend: 'Ext.app.Controller',
	refs:[
		{selector:'exportimportconfiguration', ref:'exportimportconfiguration'},
		{selector:'downloadutils', ref:'downloadutils'}
	],
	init:function(){
		me = this,
		this.control({
			'exportimportconfiguration':
			{
				'afterrender': this.afterMainRender
			},
			'exportimportconfiguration tabpanel[id="exportimportTab"]':
			{
				'tabchange': this.tabChange
			},
			'exportimportconfiguration treepanel[id="exportTreePanel"]':
			{
				'itemclick': this.exportItemClicked
			},
			'exportimportconfiguration treepanel[id="importTreePanel"]':
			{
				'itemclick': this.importItemClicked
			},
			'exportimportconfiguration button[id="exportBtn"]':
			{
				'click': this.exportData
			},
			'exportimportconfiguration button[id="importBtn"]':
			{
				'click': this.importData
			},
			'exportimportconfiguration button[id="selectAllExportBtn"]':
			{
				'click':this.selectAllExportBtnClick
			},
			'exportimportconfiguration button[id="selectAllImportBtn"]':
			{
				'click':this.selectAllImportBtnClick
			},
			'exportimportconfiguration button[id="cancelBtn"]':
			{
				'click':this.removeUploadData
			},
			'exportimportconfiguration button[id="uploadBtn"]':
			{
				'click':this.uploadSelectedData
			}
		
		});
	},
	tabChange: function(type)
	{
		var selectTab = Ext.getCmp('exportimportTab').getActiveTab().getItemId();
		if(selectTab == 'exportTab')
		{
			this.afterMainRender();
		}
		else if (selectTab == 'importTab')
		{
			this.removeUploadData();
		}
		Ext.Ajax.request({
			url: 'ExportImport/data/exportimporthelpJson.jsp?selectTab='+selectTab,
			method: 'POST',
			async: false
		});
	},
	exportItemClicked: function(view, record, item, index, event)
	{
		//alert('itemclick  view : '+view+'\n record : '+record+'\n item : '+item+'\n index : '+index+'\n event :'+event);
		//the record is the data node that was clicked
		//the item is the html dom element in the tree that was clicked
		//index is the index of the node relative to its parent
		nodeId = record.data.id;
		var btnText = Ext.getCmp('selectAllExportBtn');
		if(record.data.checked)
		{
			if(record.data.text == 'Alarm policies' && record.parentNode.firstChild.data.checked )
			{
				record.parentNode.firstChild.set('checked', false);
			}
			record.set( 'checked', false );
			if(btnText.getText() == 'Deselect all')
			{
				btnText.setText('Select all');
			}
		}
		else
		{
			if(record.data.text == 'Alarm policies' && record.parentNode.firstChild.data.checked )
			{
				record.parentNode.firstChild.set('checked', false);
			}
			record.set( 'checked', true );
			var sel = Ext.getCmp('exportTreePanel').getView().getChecked();
			if (record.data.text == 'Alarm policies' && record.parentNode.childNodes.length > 1)
			{
				if(sel.length >= 9 && (record.parentNode.firstChild.data.checked && record.previousSibling.data.checked))
				{
					btnText.setText(deSelectTxt);
				}
			}
			else
			{
				if(sel.length >= 9 && btnText.getText() != 'Deselect all')
				{
					btnText.setText('Deselect all');
				}
			}
		}
		if(!record.isLeaf())
		{
			if(record.data.checked)
			{
				for( i = 0; i < record.childNodes.length; i++ )
				{
					record.childNodes[i].set('checked',true);
				}
				var sel = Ext.getCmp('exportTreePanel').getView().getChecked();
				if(sel.length >= 9)
				{
					btnText.setText('Deselect all');
				}
			}
			else
			{
				for( i = 0; i < record.childNodes.length; i++ )
				{
					record.childNodes[i].set('checked',false);
				}
				if(btnText.getText() == deSelectTxt)
				{
					btnText.setText(selectTxt);
				}
			}
		}

		if (record.data.text == 'Default thresholds' && record.data.checked)
		{
			if(!record.parentNode.lastChild.data.checked)
			{
				record.parentNode.lastChild.set('checked', true); //Disable
			}
			var sel = Ext.getCmp('exportTreePanel').getView().getChecked();
			if(sel.length >= 9 && btnText.getText() == 'Select all')
			{
				btnText.setText('Deselect all');
			}
		}
		else if (record.data.text == 'Default thresholds' && !record.data.checked)
		{
			if(record.parentNode.lastChild.data.checked)
			{
				record.parentNode.lastChild.set('checked', false); //Disable
			}
			if(btnText.getText() == 'Deselect all' )
			{
				btnText.setText('Select all');
			}
		}
		

		if(record.data.parentId != null && record.data.parentId != 'undefined' && record.data.parentId != 'root')
		{
			if(record.data.checked)
			{
				var isAllChildChecked = true;
				for( i = 0; i < record.parentNode.childNodes; i++ ) 
				{
					if (!record.parentNode.childNodes[i].data.checked)
					{
						isAllChildChecked = false;
					}
				}
				if(isAllChildChecked)
				{
					record.parentNode.set('checked',true);
				}
			}
			else
			{
				var isAllChildUnChecked = true;
				//alert("record.parentNode.childNodes.length  : "+record.parentNode.childNodes.length);
				for( i = 0; i < record.parentNode.childNodes.length; i++ )
				{
					if (record.parentNode.childNodes[i].data.checked)
					{
						isAllChildUnChecked = false;
						
					}
					//record.childNodes[i].set('checked',false);
				}
				//alert("isAllChildUnChecked  : "+isAllChildUnChecked);
				if(isAllChildUnChecked)
				{
					record.parentNode.set('checked',false);
				}
			}
		}
	},
	afterMainRender: function()
	{
		Ext.Ajax.request({
			url:'ExportImport/data/EgExportConfigureFilesJson.jsp?',
			method:'post',	
			scope:this,
			async: false,
			success:function(response)
			{
				if(response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					publicJson = Ext.decode(jsonText);
					var rootData = {
									text:'test',
									expanded: true,
									children:publicJson['exportDataArr']
									};
					Ext.getCmp('exportTreePanel').setRootNode(rootData);
					Ext.getCmp('selectAllExportBtn').setText(deSelectTxt);
					var sel = Ext.getCmp('exportTreePanel').getView().getChecked();
						for ( var i = 0 ; i < sel.length ; i++)
						{ 
							var selectedText = sel[i].get('text');
							if(selectedText != null && selectedText == 'Default thresholds' )
							{
								//alert("selectedText  : "+selectedText);
								// sel[i+2].get('id').disable();
							}
						}
				}
			}
		});
	},
	exportData : function(btn)
	{
		var tree = Ext.getCmp('exportTreePanel');
		var export_data = '';
		var threshChildVal = '';
		var testChildVal = '';
		var discChildVal = '';
		var chkboxAll = true;
		var isChecked = tree.getView().getChecked();
		if(tree.getRootNode() != null && tree.getRootNode() != 'undefined')
		{

			for (var i=0;i<tree.getRootNode().childNodes.length ;i++ )
			{
				var nodeVal = tree.getRootNode().childNodes[i];
				if(nodeVal.data.checked)
				{
					if(nodeVal.data.text == 'Tests')
					{
						for (j=0;j<nodeVal.childNodes.length ;j++ )
						{
							if(nodeVal.childNodes[j].data.checked)
							{
								testChildVal += nodeVal.childNodes[j].data.text+",";
							}
							else
							{
								chkboxAll = false;
							}
						}
						
					}
					if(nodeVal.data.text == 'Thresholds')
					{
						//threshChildVal = 'Default thresholds,Global thresholds,Alarm policies,';
						for (j=0;j<nodeVal.childNodes.length ;j++ )
						{
							if(nodeVal.childNodes[j].data.checked)
							{
								threshChildVal += nodeVal.childNodes[j].data.text+",";
							}
							else
							{
								chkboxAll = false;
							}
						}
					}
					if(nodeVal.data.text == 'Discovery settings')
					{
						for (j=0;j<nodeVal.childNodes.length ;j++ )
						{
							if(nodeVal.childNodes[j].data.checked)
							{
								discChildVal += nodeVal.childNodes[j].data.text+",";
							}
							else
							{
								chkboxAll = false;
							}
						}
						
					}
					export_data += 'export_'+i+'~|~'+nodeVal.data.text+',';
				}
				else
				{
					chkboxAll = false;
				}
			}
		}	
		var mode= '';
		var qString = "selectAll="+encodeURIComponent(chkboxAll)+"&export_data="+encodeURIComponent(export_data)+"&test_child="+encodeURIComponent(testChildVal)+"&thresh_child="+encodeURIComponent(threshChildVal)+"&disc_child="+encodeURIComponent(discChildVal);
		//saveFileTool:function(){
		var flag = false;
		if(isChecked.length > 0)
		{
			flag = true;
		}
		if (flag)
		{
			var s_qryString = "/final/servlet/com.egurkha.admin.EgExportConfigureServlet?"+qString;
			var downloadUtils =  Ext.widget('downloadutils');
			downloadUtils.savePDF(s_qryString);
		}
		else
		{
			Ext.Msg.show({
				title: pageName,
				msg: alert5,
				buttons: Ext.Msg.OK,
				width: alert5.length * 7,
				icon: 'iconExclamation'
			});
			return false;
		}
		//},
	},
	selectAllExportBtnClick: function(view, record, item, index, event)
	{
		var tree = Ext.ComponentQuery.query( 'treepanel[id=exportTreePanel]')[0];
		var button = Ext.getCmp('selectAllExportBtn');
		var btnText = button.getText();
		if(btnText != null && btnText != 'undefined' && btnText == selectTxt)
		{
			tree.getRootNode().cascadeBy(function()
			{
				this.set( 'checked', true );
				button.setText(deSelectTxt);
			});
		}
		else
		{
			tree.getRootNode().cascadeBy(function()
			{
				this.set( 'checked', false );
				button.setText(selectTxt);
			});
		}
	},
	uploadSelectedData: function()
	{
		var fileName = Ext.getCmp('importFileField').getValue();
		var fileExt = ".zip";
		if(fileName.lastIndexOf(".zip") == -1)
		{
			Ext.Msg.show({
				title: pageName,
				msg: alert1+" '"+fileExt+"'",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			Ext.getCmp('importFileField').reset();
			Ext.getCmp('importFileField').focus();
			return;
		}

		var frmMain = this.getExportimportconfiguration().getForm();
		if (frmMain.isValid())
		{
			var myMask = new Ext.LoadMask(Ext.getBody(), {msg:'Loading...'});
			myMask.show();
			this.getExportimportconfiguration().submit({
				url: 'ExportImport/data/EgImportConfigureFilesJson.jsp?fileName='+encodeURIComponent(fileName)+"&com.eg.CSRF_NONCE="+csrfToken,
				method: 'POST',
				success: function(form, action){

					myMask.hide();
					var jsonText = action.response.responseText;
					publicJson = Ext.decode(jsonText);
					if (publicJson['importDataArr'] == null || publicJson['importDataArr'].length == 0 )
					{
						Ext.Msg.show({
							title: pageName,
							msg: alert2+' '+alertZipMsg,
							width: alert2.length * 7,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
						return;
					}

					var rootData = {
									text:'test',
									expanded: true,
									children:publicJson['importDataArr']
									};
					Ext.getCmp('importTreePanel').setRootNode(rootData);
					Ext.getCmp('importTreePanel').show();
					Ext.getCmp('importBtnContainer').show();
					Ext.getCmp('importFileField').hide();
					Ext.getCmp('uploadBtnContainer').hide();
					Ext.getCmp('selectAllImportBtn').setText(deSelectTxt);
				},
				failure: function(form, action) // if result page doest not contain success:true, this method fires
				{
					myMask.hide();
					var jsonText = Ext.decode(action.response.responseText);
					var jsonText = action.response.responseText;
					publicJson = Ext.decode(jsonText);
					var isNoData = publicJson['isNoData'];
					var alertMsg = publicJson['screenLabels']['No_Data_Msg'];
					if(!Ext.isEmpty(isNoData) && isNoData)
					{
						Ext.Msg.show({
							title: pageName,
							msg: alertMsg+'. '+alertZipMsg,
							width: alertMsg.length * 7,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
					}
				}
			});
		}
	},
	importData: function()
	{
		var tree = Ext.getCmp('importTreePanel');
		var fileName = publicJson['folderName'];
		var isChecked = tree.getView().getChecked();
		var export_data = '';
		var threshChildVal = '';
		var testChildVal = '';
		var discChildVal = '';
		var chkboxAll = true;
		var mode = '';
		if(tree.getRootNode() != null && tree.getRootNode() != 'undefined')
		{
			for (var i=0;i<tree.getRootNode().childNodes.length ;i++ )
			{
				var nodeVal = tree.getRootNode().childNodes[i];
				if(nodeVal.data.checked)
				{
					if(nodeVal.data.text == 'Tests')
					{
						//alert('nodeVal.childNodes.lastChild.data.text : '+nodeVal.childNodes.lastChild);
						for (j=0;j<nodeVal.childNodes.length ;j++ )
						{
							if(nodeVal.childNodes[j].data.checked)
							{
								testChildVal += nodeVal.childNodes[j].data.text+",";
							}
							else
							{
								chkboxAll = false;
							}
						}
						
					}
					if(nodeVal.data.text == 'Thresholds')
					{
						//threshChildVal = 'Default thresholds,Global thresholds,Alarm policies,';
						for (j=0;j<nodeVal.childNodes.length ;j++ )
						{
							if(nodeVal.childNodes[j].data.checked)
							{
								threshChildVal += nodeVal.childNodes[j].data.text+",";
							}
							else
							{
								chkboxAll = false;
							}
						}
					}
					if(nodeVal.data.text == 'Discovery settings')
					{
						//alert('nodeVal.childNodes.lastChild.data.text : '+nodeVal.childNodes.lastChild);
						for (j=0;j<nodeVal.childNodes.length ;j++ )
						{
							if(nodeVal.childNodes[j].data.checked)
							{
								discChildVal += nodeVal.childNodes[j].data.text+",";
							}
							else
							{
								chkboxAll = false;
							}
						}
						
					}
					export_data += nodeVal.data.text+',';
				}
				else
				{
					chkboxAll = false;
				}
			}
		}

		var flag = false;
		if(isChecked.length > 0)
		{
			flag = true;
		}
		if(chkboxAll)
		{
			mode='on';
		}
		var qString = "selectAll="+encodeURIComponent(mode)+"&export_data="+encodeURIComponent(export_data)+"&test_child="+encodeURIComponent(testChildVal)+"&thresh_child="+encodeURIComponent(threshChildVal)+"&folderName="+encodeURIComponent(fileName)+"&disc_child="+encodeURIComponent(discChildVal);
		if(flag)
		{
			var isSameMgrVersion = publicJson.isSameMgrVersion;
			if (!isSameMgrVersion)
			{
				Ext.MessageBox.confirm(pageName,alert6,function(btn)
				{
					if(btn == 'yes')
					{
						var myMask = new Ext.LoadMask(Ext.getBody(), {msg:'Loading...'});
						myMask.show();
						Ext.Ajax.request({
							url:'ExportImport/data/Egimportconfigurefilesp.jsp?from=extJs&'+qString,
							method:'POST',
							scope:this,
							//async: false,
							timeout: 600000000,
							success:function(response)
							{
								if(response.status == 200 && !Ext.isEmpty(response.responseText))
								{
									myMask.hide();
									var jsonText = Ext.decode(response.responseText);
									Ext.Msg.show({
										title: pageName,
										msg: alert3,
										width: alert3.length * 7,
										buttons: Ext.Msg.OK,
										icon: 'iconInformation',
										fn: function() {
											me.removeUploadData();
										}
									});
								}
							}
						});
					}
					else
					{
						me.removeUploadData();
					}
				});
			}
			else
			{
				var myMask = new Ext.LoadMask(Ext.getBody(), {msg:'Loading...'});
				myMask.show();
				Ext.Ajax.request({
					url:'ExportImport/data/Egimportconfigurefilesp.jsp?from=extJs&'+qString,
					method:'POST',
					scope:this,
					//async: false,
					timeout: 600000000,
					success:function(response)
					{
						if(response.status == 200 && !Ext.isEmpty(response.responseText))
						{
							myMask.hide();
							var jsonText = Ext.decode(response.responseText);
							Ext.Msg.show({
								title: pageName,
								msg: alert3,
								width: alert3.length * 7,
								buttons: Ext.Msg.OK,
								icon: 'iconInformation',
								fn: function() {
									me.removeUploadData();
								}
							});
						}
					}
				});
			}
		}
		else
		{
			Ext.Msg.show({
				title: pageName,
				msg: alert4,
				width: alert4.length * 7,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}
	},
	selectAllImportBtnClick: function(view, record, item, index, event)
	{
		var tree = Ext.ComponentQuery.query( 'treepanel[id=importTreePanel]')[0];
		var button = Ext.getCmp('selectAllImportBtn');
		var btnText = button.getText();
		if(btnText != null && btnText != 'undefined' && btnText == selectTxt)
		{
			tree.getRootNode().cascadeBy(function()
			{
				this.set( 'checked', true );
				button.setText(deSelectTxt);
			});
		}
		else
		{
			tree.getRootNode().cascadeBy(function()
			{
				this.set( 'checked', false );
				button.setText(selectTxt);
			});
		}
	},
	removeUploadData: function()
	{
		if (Ext.getCmp('importTreePanel').isVisible())
		{
			//Ext.getCmp('importTreePanel').setDisabled(true);
			Ext.getCmp('importTreePanel').hide();
		}
		
		if (Ext.getCmp('importBtnContainer').isVisible())
		{
			//Ext.getCmp('importBtnContainer').setDisabled(true);
			Ext.getCmp('importBtnContainer').hide();
		}

		Ext.getCmp('importFileField').show();
		Ext.getCmp('importFileField').reset();
		Ext.getCmp('uploadBtnContainer').show();
	},
	importItemClicked: function(view, record, item, index, event)
	{
		//alert('itemclick  view : '+view+'\n record : '+record+'\n item : '+item+'\n index : '+index+'\n event :'+event);
		//the record is the data node that was clicked
		//the item is the html dom element in the tree that was clicked
		//index is the index of the node relative to its parent
		nodeId = record.data.id;
		var totalCount = publicJson['totalCount'];
		var btnText = Ext.getCmp('selectAllImportBtn');
		if(record.data.checked)
		{
			if(record.data.text == 'Alarm policies' && (record.parentNode.firstChild.data.text == 'Default thresholds' && record.parentNode.firstChild.data.checked) )
			{
				record.parentNode.firstChild.set('checked', false);
			}
			record.set( 'checked', false );
			if(btnText.getText() == deSelectTxt)
			{
				btnText.setText(selectTxt);
			}
		}
		else
		{
			if(record.data.text == 'Alarm policies' && (record.parentNode.firstChild.data.text == 'Default thresholds' && record.parentNode.firstChild.data.checked) )
			{
				record.parentNode.firstChild.set('checked', false);
			}
			record.set( 'checked', true );
			var selectedChecked = Ext.getCmp('importTreePanel').getView().getChecked();
			if (record.data.text == 'Alarm policies' && record.parentNode.childNodes.length > 1)
			{
				if(selectedChecked.length >= totalCount && (record.parentNode.firstChild.data.checked && record.previousSibling.data.checked))
				{
					btnText.setText(deSelectTxt);
				}
			}
			else
			{
				if(selectedChecked.length >= totalCount && btnText.getText() != deSelectTxt )
				{
					btnText.setText(deSelectTxt);
				}
			}
		}
		if(!record.isLeaf())
		{
			if(record.data.checked)
			{
				for( i = 0; i < record.childNodes.length; i++ )
				{
					record.childNodes[i].set('checked',true);
				}

				var selectedChecked = Ext.getCmp('importTreePanel').getView().getChecked();
				if(selectedChecked.length >= totalCount)
				{
					btnText.setText(deSelectTxt);
				}
			}
			else
			{
				for( i = 0; i < record.childNodes.length; i++ )
				{
					record.childNodes[i].set('checked',false);
				}
				if(btnText.getText() == deSelectTxt)
				{
					btnText.setText(selectTxt);
				}
			}
		}

		if (record.data.text == 'Default thresholds' && record.data.checked)
		{
			//record.parentNode.lastChild.set('cls','visibility:hidden;');
			if(!record.parentNode.lastChild.data.checked)
			{
				record.parentNode.lastChild.set('checked', true); //Disable
			}
			var sel = Ext.getCmp('importTreePanel').getView().getChecked();
			if(sel.length >= totalCount && btnText.getText() == 'Select all')
			{
				btnText.setText('Deselect all');
			}
		}
		else if (record.data.text == 'Default thresholds' && !record.data.checked)
		{
			if(record.parentNode.lastChild.data.checked)
			{
				record.parentNode.lastChild.set('checked', false); //Disable
			}
			if(btnText.getText() == 'Deselect all' )
			{
				btnText.setText('Select all');
			}
		}

		if(record.data.parentId != null && record.data.parentId != 'undefined' && record.data.parentId != 'root')
		{
			if(record.data.checked)
			{
				var isAllChildChecked = true;
				for( i = 0; i < record.parentNode.childNodes; i++ ) 
				{
					if (!record.parentNode.childNodes[i].data.checked)
					{
						isAllChildChecked = false;
					}
					//record.parentNode.childNodes[i].set('checked',true);
				}
				if(isAllChildChecked)
				{
					record.parentNode.set('checked',true);
					//record.parentNode.data.checked = true;
				}
			}
			else
			{
				var isAllChildUnChecked = true;
				for( i = 0; i < record.parentNode.childNodes.length; i++ )
				{
					if (record.parentNode.childNodes[i].data.checked)
					{
						isAllChildUnChecked = false;
						
					}
					//record.childNodes[i].set('checked',false);
				}
				if(isAllChildUnChecked)
				{
					record.parentNode.set('checked',false);
				}
			}
		}
	}
});
