Ext.define('ExternalAgent.controller.AddExtCtrl',{
	extend: 'Ext.app.Controller',

	view: ['ExternalAgent'],

	refs: [
		{
			selector: 'externalagent',
			ref: 'externalagent'
		},
	],

	init: function(){
		this.control({
			'externalagent': {
				'afterrender' : this.afterMainRender
			}
		});
	},

	buildAddFieldData: function(){
		var hostname = Ext.getCmp('Hostname').getValue();
		var hostIp = Ext.getCmp('Hostip').getValue();
		var qstring = '';
		if (btnText == 'Add')
		{
			qstring = "NewAgnt&modify=null&eagent=null";
		}
		else
		{
			qstring = "bmod&modify=true&eagent="+encodeURI(hostname)+"&hostip="+encodeURI(hostIp);
		}
		Ext.Ajax.request({
			url: 'ExternalAgent/data/EgNewExtAgentsJson.jsp?Btype='+qstring,
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},

	afterMainRender : function(){
		Ext.getCmp('Hostip').focus();
		var hostnamecheck = Ext.getCmp('Hostname').getValue();

		if (isClientEmulation == "false")
		{
			Ext.getCmp('client').hide();
		}
		else
		{
			Ext.getCmp('client').show();
		}

		var emuUpdate = publicJSON['emuUpdate'];
		if (emuUpdate == false)
		{
			Ext.getCmp('clientemulno').disable();
		}

		Ext.getCmp('hostIpCt').setFieldLabel(publicJSON['screenLabels']['admin.external.Host IP']);
		Ext.getCmp('Hostname').setFieldLabel(publicJSON['screenLabels']['admin.external.Host name']);
		Ext.getCmp('client').setFieldLabel(publicJSON['screenLabels']['admin.external.Client emulation']);
		Ext.getCmp('remoteagent').setFieldLabel(publicJSON['screenLabels']['admin.external.Add as Remote agent']);
		Ext.getCmp('UpdateBTN').setText(publicJSON['screenLabels']['admin.common.Update']);

		var notrmtAgent = publicJSON['rmtnothaveagent'];
		if (notrmtAgent == 'No')
		{
			Ext.getCmp('remoteagent').disable();
			Ext.getCmp('remoteagent').hide();
		}
		var old_name = publicJSON['hostValue']['hostNameValue'];
		if (old_name != null && old_name != "null" && old_name.length > 0)
		{
			modify = 'true';
			Ext.getCmp('Hostname').setReadOnly(true);
		}

		Ext.getCmp('Hostip').setValue(publicJSON['hostValue']['hostIPValue']);
		Ext.getCmp('Hostname').setValue(publicJSON['hostValue']['hostNameValue']);
		var emulateYes = publicJSON['emulateYes'];
		if (emulateYes == 'Yes')
		{
			Ext.getCmp('clientemulyes').setValue(true);
			Ext.getCmp('remoteagent').disable();
			Ext.getCmp('remoteagent').hide();
		}
		else
		{
			Ext.getCmp('clientemulno').setValue(true);
			Ext.getCmp('remoteagentno').setValue(true);
		}
	}

});



