Ext.define('ExternalAgent.controller.AssignExtCtrl',{
	extend:'Ext.app.Controller',

	views:['AssignExternalAgent'],

	refs:[
		{
			selector:'assignexternalagent',
			ref:'assignexternalagent'
		},
	],

	init:function(){
		this.control({
			'assignexternalagent': {
				'afterrender': this.afterMainRender
			}
		});
	},

	buildFieldData: function(){
		Ext.Ajax.request({
			url: 'ExternalAgent/data/EgConfigExtAgentsJson.jsp',
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},

	buildGivenAgentData: function(assignAgent){
		var me = this;
		var othereagent = "null";
		if (assignAgent == -1)
		{
			assignAgent = "null";
		}
		Ext.Ajax.request({
			url: 'ExternalAgent/data/EgConfigExtAgentsJson.jsp?eagent='+assignAgent+'&othereagent='+encodeURIComponent(othereagent),
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
				if (Ext.getCmp('itemselectextagent').fromField.store.getCount() >= 1)
				{
					Ext.getCmp('itemselectextagent').fromField.store.removeAll();
				}
				if (Ext.getCmp('itemselectextagent').toField.store.getCount() >= 1)
				{
					Ext.getCmp('itemselectextagent').toField.store.removeAll();
				}

				Ext.getCmp('itemselectextagent').fromField.store.add(publicJSON['ManagedHostByThisAgent']);
				me.initializeFields2();
				if (assignAgent == "null")
				{
					Ext.getCmp('otherExtAgent').setDisabled(true);
				}
				else
				{
					Ext.getCmp('otherExtAgent').setDisabled(false);
				}
				Ext.getCmp('itemselectextagent').toField.store.add(publicJSON['ManagedHostByOthrAgnt']);
			}
		});
	},

	initializeFields : function(){
		var me=this;
		var executiveForm = this.getAssignexternalagent().getForm();
		if (assignAgent != null || assignAgent != '')
		{
			me.setValueWithOptionInList(executiveForm, 'extAgent', publicJSON['externalAgentsArray'],assignAgent);
		}
		else
		{
			me.setValueWithOptionInList(executiveForm, 'extAgent', publicJSON['externalAgentsArray'],'');
		}
	},

	initializeFields2 : function(){
		var executiveForm = this.getAssignexternalagent().getForm();
		this.setValueWithOptionInList(executiveForm, 'otherExtAgent', publicJSON['otherExternalAgentsArray'],'');
	},

	setValueWithOptionInList : function(form, fieldName, list, value){
		form.findField(fieldName).getStore().loadRawData(list);
		form.findField(fieldName).suspendEvents(false);
		var valueAssigned = false;
		for(var listCounter = 0 ; listCounter < list.length ; listCounter++){
			if(list[listCounter].valueField == value && !Ext.isEmpty(value) && value != null){
				form.findField(fieldName).setValue(value);
				valueAssigned = true;
			}
		}
		
		if(!valueAssigned){
			form.findField(fieldName).setValue(list[0].valueField);
		}
		form.findField(fieldName).resumeEvents();
	},

	afterMainRender : function(){
		Ext.getCmp('extAgent').setFieldLabel(publicJSON['screenLabels']['admin.test.External agent']);
		Ext.getCmp('UpdateBTN').setText(publicJSON['screenLabels']['admin.remote.Update']);
		this.initializeFields();
		this.initializeFields2();
	}

});



