Ext.define('ExternalAgent.controller.DeleteExtCtrl',{
	extend: 'Ext.app.Controller',

	view: ['DeleteExternalAgents'],

	refs: [
		{
			selector: 'deleteexternalagents',
			ref: 'deleteexternalagents'
		},
	],

	init: function(){
		this.control({
			'deleteexternalagents': {
				'afterrender' : this.afterMainRender
			}
		});
	},

	buildDeleteFieldData: function() {
		Ext.Ajax.request({
			url: 'ExternalAgent/data/DeleteExternalAgentsJson.jsp',
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},

	buildInternalHostsData: function(HostName) {
		Ext.Ajax.request({
			url: 'ExternalAgent/data/deletegroupsexternalpJson.jsp',
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},

	buildAssDissAgnt: function(HostName) {
		Ext.Ajax.request({
			url: 'ExternalAgent/data/DeleteExternalAgentsJson.jsp?eagent='+HostName,
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},

	afterMainRender : function() {
		Ext.getCmp('NoDelSearchFound').hide();
		Ext.getCmp('components').getStore().loadData(publicJSON['externalAgentArray']);
		Ext.getCmp('deleteBtn').setText(publicJSON['screenLabels']['admin.common.Delete']);
	}

});



