Ext.define('ExternalAgent.controller.Main', {
	extend:'Ext.app.Controller',

	views:['ExternalAgents','ExternalAgent','AssignExternalAgent','DeleteExternalAgents'],
	requires : ['ExternalAgent.view.ExternalAgent', 'ExternalAgent.view.FileUploadForm', 'ExternalAgent.view.FileUpload'],

	refs:[
		{selector:'externalagents', ref:'externalagents'},
		{selector:'assignexternalagent', ref:'assignexternalagent'},
		{selector:'deleteexternalagents', ref:'deleteexternalagents'},
		{selector:'externalagent', ref:'externalagent'},
		{selector:'fileuploadform', ref:'fileuploadform'}
	],

	init:function(){
		appCnt = this;
		this.buildMainData()

		this.control({
			'externalagents': {
				'afterrender': this.afterMainRender
			},
			'externalagents trigger[name="gridSearch"]': {
				'change': this.mainGridSearch
			},
			'externalagents button[id="addAgent"]': {
				'click': this.addAgent
			},
			'externalagents button[id="DeleteOver"]': {
				'click': this.deleteOver
			},
			'externalagent radio[id="clientemulyes"]': {
				'change' : this.radChange
			},
			'externalagent button[id="UpdateBTN"]': {
				'click' : this.addUpdate
			},
			'externalagents button[id="associateDissociate"]': {
				'click': this.associateDissociate
			},
			'externalagents button[id="dwnldAgent"]': {
				'click': this.dwnldAgent
			},
			//'externalagents button[id="deleteAgent"]': {
			//	'click': this.deleteAgent
			//},
			'assignexternalagent combo[id="extAgent"]': {
				'select': this.comboFromFieldLoad
			},
			'assignexternalagent combo[id="otherExtAgent"]': {
				'select': this.comboToFieldLoad
			},
			'assignexternalagent button[id="UpdateBTN"]': {
				'click': this.updation
			},
			'assignexternalagent button[id="backbutton"]': {
				'click': this.backbutton
			},
			'deleteexternalagents button[id="deleteBtn"]': {
				'click' : this.deletefun
			},
			'deleteexternalagents trigger[name="compsearch"]': {
				'change': this.mainFormEvent
			},
			'deleteexternalagents button[id="backDelbutton"]': {
				'click': this.backDelButton
			},
			'externalagents button[action="openPopupWin"]': {
				'click': this.openPopupWin
			},
			'fileupload button[action="bulkAgentAction"]': {
				click: this.bulkAgentAction
			}
		});
	},

	buildMainData: function(){
		Ext.Ajax.request({
			url: 'ExternalAgent/data/EgDispExtAgentsJson.jsp',
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
					if (!Ext.isEmpty(publicJSON.exVarList))
					{
						var tmpExistVars = publicJSON.exVarList;
						ex_varStr = tmpExistVars.split(',');
					}
				}
			}
		});
	},

	handleDeleteIconClick: function(gridView, row, col){
		var task = Ext.getCmp('gridDisplay').getStore().getAt(row);
		this.deleteTask(task,row);
	},

	handleEditIconClick: function(gridView, row, col){
		btnText = 'Edit';
		var rec = Ext.getCmp('gridDisplay').getStore().getAt(row);
		var HostName = rec.get('Hostname');
		var HostIP = rec.get('HostIP');
		var ZoneLocation = rec.get('zoneLocation');
		var ClientEmulation = rec.get('Clientemulation');
		this.showEditWindow(HostName,HostIP,ClientEmulation,ZoneLocation);
	},

	showEditWindow: function(HostName,HostIP,ClientEmulation,ZoneLocation){
		Ext.widget('externalagent').show();
		Ext.getCmp('Hostname').setValue(HostName).disable();
		Ext.getCmp('Hostip').setValue(HostIP);
		Ext.getCmp('zoneLocation').setValue(ZoneLocation);
		Ext.getCmp('UpdateBTN').setText('Update');
		Ext.getCmp('AddModView').setTitle(extModPageTitle);

		this.getController('ExternalAgent.controller.AddExtCtrl').buildAddFieldData();
		rmtListStr = publicJSON['rmtAgentsArr'];
		var enableNickNameEdit = publicJSON['enableNickNameEdit'];
		if(enableNickNameEdit)
		{
			Ext.getCmp('Hostname').setValue(HostName).enable();
		}

		Ext.getCmp('hostIpCt').setFieldLabel(publicJSON['screenLabels']['admin.external.Host IP']);
		Ext.getCmp('client').setFieldLabel(publicJSON['screenLabels']['admin.external.Client emulation']);
		if (isClientEmulation == 'false')
		{
			Ext.getCmp('client').hide();
		}
		else
		{
			Ext.getCmp('client').show();
		}
	//	var emuUpdate = publicJSON['emuUpdate'];
	//	if (emuUpdate == false)
	//	{
	//		Ext.getCmp('clientemulno').disable();
	//	}
		var disableEmu = publicJSON["disableEmulation"];
		if(disableEmu == 'yes')
		{
			Ext.getCmp("clientemulno").setValue(true);
			Ext.getCmp("clientemulyes").disable();
		} 
		else if(disableEmu == 'no')
		{
			Ext.getCmp("clientemulyes").setValue(true);
			Ext.getCmp("clientemulno").disable();
		}
		else if(disableEmu == 'none')
		{
			Ext.getCmp("clientemulno").enable();
			Ext.getCmp("clientemulyes").enable();
			Ext.getCmp("clientemulno").setValue(true);
		}

		var notrmtAgent = publicJSON['rmtnothaveagent'];
		if (notrmtAgent == 'No')
		{
			Ext.getCmp('remoteagent').disable();
			Ext.getCmp('remoteagent').hide();
		}

		if (ClientEmulation == 'Yes')
		{
			Ext.getCmp('clientemulyes').setValue(true);
			Ext.getCmp('remoteagent').disable();
			Ext.getCmp('remoteagent').hide();
		}
		else
		{
			Ext.getCmp('clientemulno').setValue(true);
			Ext.getCmp('remoteagentno').setValue(true);
		}

		oldHostIp = publicJSON['hostValue']['hostIPValue'];
		oldNickName = publicJSON['hostValue']['hostNameValue'];
		old_emulate = publicJSON['old_emulate'];

		this.radChange();
	},

	commonDelete: function(HostName,rowIndex){
		var callInitMd = this;
		Ext.Msg.show({
			title: 'DELETE EXTERNAL AGENT',
			msg: deleteSingleAgntMsg+"'"+HostName+"'"+"?",
			icon : 'iconConfirmation',
			buttons: Ext.Msg.YESNO,
			fn: function(response) {
			if(response === 'yes') {
					var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
					tmpMask.show();
					Ext.Ajax.request({
					url: 'ExternalAgent/data/EgnewextagentspJson.jsp?mode=del&eagent='+encodeURIComponent(HostName),
					method: 'POST',
					success: function( response )
					{
						tmpMask.hide();
						var jsonText = response.responseText;
						publicJSON = Ext.decode(jsonText);
						if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
						{
							var resultStatus = publicJSON['requestStatus'];
							if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
							{
								var resultStatus = publicJSON['result'];
								var doubleAlert = publicJSON['doubleAlert'];
								if (doubleAlert != undefined && doubleAlert == 'true')
								{
									Ext.Msg.show({
										title:resultStatus['title'],
										msg: resultStatus['message1'],
										icon : 'iconConfirmation',
										buttons: Ext.Msg.OKCANCEL,
										fn: function(response) {
											if (response == 'ok')
											{
												tmpMask.show();
												Ext.Ajax.request({
												url: 'RemoteAgent/data/EgnewremoteagentspJson.jsp?mode=del&eagent='+encodeURIComponent(HostName),
												method: 'POST',
												success: function( response )
												{
													tmpMask.hide();
													var jsonText = response.responseText;
													publicJSON = Ext.decode(jsonText);
													if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
													{
														var resultStatus = publicJSON['requestStatus'];
														if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
														{
															var result = publicJSON['result'];
															Ext.MessageBox.show(
															{
																title : result['title'],
																msg : result['message1'],
																icon : 'iconInformation',
																buttons : Ext.Msg.OK
															});
														}
														else
														{
															var resultStatus = publicJSON['error'];
															Ext.MessageBox.show(
															{
																title : resultStatus['title'],
																msg : resultStatus['message1'],
																icon : 'iconExclamation',
																buttons : Ext.Msg.OK
															});
														}
													}
												},
												failure: function()
												{
													tmpMask.hide();
												}
												});
											}
										}
									});
								}
								else
								{
									Ext.Msg.show({
									title:resultStatus['title'],
									msg: resultStatus['message1'],
									buttons: Ext.Msg.OK,
									icon : 'iconInformation'
									});
								}
							}
							else
							{
								var resultStatus = publicJSON['error'];
								Ext.MessageBox.show(
								{
									title : resultStatus['title'],
									msg : resultStatus['message1'],
									icon : 'iconExclamation',
									buttons : Ext.Msg.OK
								});
							}
							Ext.getCmp('gridSearch').setRawValue('');
							callInitMd.buildMainData()

							var resultsData = publicJSON['gridExtAgents'];
							if (resultsData == null || resultsData.length == 0)
							{
								Ext.getCmp('gridSearch').disable()
								Ext.getCmp('associateDissociate').disable();
								//Ext.getCmp('deleteAgent').disable();
								Ext.getCmp('gridDisplay').store.loadData('');
								Ext.getCmp('gridDisplay').getView().emptyText = '<table align="center"><tr><td align="center" height="300"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+noExtPrtDesc+'.</td></tr></table></td></tr></table>';
								Ext.getCmp('gridDisplay').getView().refresh();
							}
							else
							{
								Ext.getCmp('gridSearch').enable()
								Ext.getCmp('associateDissociate').enable();
								//Ext.getCmp('deleteAgent').enable();
								Ext.getCmp('gridDisplay').getStore().loadRawData(resultsData);
								var view = Ext.getCmp('gridDisplay').getView();
								var headerCt = view.headerCt;
								var checkHd = headerCt.child('gridcolumn[isCheckerHd]');
								if (checkHd) {
									checkHd.el.removeCls(Ext.baseCSSPrefix +'grid-hd-checker-on');
								}
							}
						}
						appCnt.buildMainData();
						var resultsData = publicJSON['gridExtAgents'];
						Ext.getCmp('gridSearch').enable();
						Ext.getCmp('associateDissociate').enable();
						//Ext.getCmp('deleteAgent').enable();

						Ext.getCmp('gridDisplay').getStore().loadRawData(resultsData);
						Ext.getCmp('gridSearch').setRawValue('');
					},
					failure: function()
					{
						tmpMask.hide();
					}
					});
				}
			}
		});
	},

	deleteTask: function(task,rowIndex){
		var HostName = task.get('Hostname');
		this.commonDelete(HostName,rowIndex);
	},

	mainGridSearch : function(obj){
		var gridsearch = Ext.getCmp('gridSearch').getValue();
		if (gridsearch == "" || gridsearch.length == 0)
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');
		}
		Ext.Ajax.request({
		url: 'ExternalAgent/data/EgDispExtAgentsJson.jsp?egTitleSearchStr='+gridsearch,
		method: 'POST',
		success: function( response )
		{
			if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode( jsonText );
			}
			var value = publicJSON['gridExtAgents'];
			{
				Ext.getCmp('associateDissociate').enable();
				//Ext.getCmp('deleteAgent').enable();
				if (value != null && value.length > 0)
				{
					Ext.getCmp('gridDisplay').store.loadData(publicJSON['gridExtAgents']);
				}
				else
				{
					Ext.getCmp('gridDisplay').store.loadData('');
					Ext.getCmp('gridDisplay').getView().emptyText = '<table align="center"><tr><td align="center" height="300"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+noExtFound+'.</td></tr></table></td></tr></table>';
					Ext.getCmp('gridDisplay').getView().refresh();
				}
			}
		}
		});
	},

	addAgent: function(btn){
		btnText = 'Add';
		Ext.widget('externalagent').show();
		Ext.getCmp('UpdateBTN').setText('Add');
		Ext.getCmp('AddModView').setTitle(extAddPageTitle);

		this.getController('ExternalAgent.controller.AddExtCtrl').buildAddFieldData();
		this.getController('ExternalAgent.controller.AddExtCtrl').afterMainRender();
	},

	openPopupWin: function ()
	{
		Ext.widget('fileupload').show();
	},
	bulkAgentAction: function() {
		var me = this;
		var uploadObj = Ext.getCmp('FILE_0').getValue();
		var actionType = Ext.getCmp('bulkExtAgent').getValue().actionType;
		var alertWinTitle = addOrDeleteExtAgentInBulkTitle;// default title
		if(actionType == 'add') {
			alertWinTitle = addExtAgentInBulkTitle;
		} else if(actionType == 'delete') {
			alertWinTitle = deleteExtAgentInBulkTitle;
		}
		if (uploadObj != null && uploadObj != '' && uploadObj != undefined && uploadObj != 'undefined')
		{
			var getFileName = uploadObj;
			getFileName = getFileName.substring(getFileName.lastIndexOf('.') + 1);
			if ( getFileName == 'csv')
			{
				var URL = "";
				if(actionType == 'add') {
					URL = "/final/servlet/com.egurkha.admin.EgCLIBulkActionController?action=addExtAgent"; //defualt
					me.doAction(URL);
				} else if(actionType == 'delete') {
					URL = "/final/servlet/com.egurkha.admin.EgCLIBulkActionController?action=deleteExtAgent";
					Ext.Msg.show({
					title: alertWinTitle,
					msg: deleteSelected,
					buttons: Ext.Msg.YESNO,
					icon: 'iconConfirmation',
					fn: function(response) {
						if(response == 'yes') {
							me.doAction(URL);
						}
					}
					});
				}
			
			} else {
				Ext.Msg.show({
					title: alertWinTitle,
					msg: selectValidFile,
					buttons: Ext.MessageBox.OK,
					icon: 'iconExclamation'
				});
			}
		} else {
			Ext.Msg.show({
			title: alertWinTitle,
			msg: selectCompsListFile,
			buttons: Ext.MessageBox.OK,
			icon: 'iconInformation'
			});
		}
	},
	doAction: function(URL) {
		var compListForm = this.getFileuploadform().getForm();
		var actionType = Ext.getCmp('bulkExtAgent').getValue().actionType;
		var alertWinTitle = addOrDeleteExtAgentInBulkTitle;// default title
		if(actionType == 'add') {
			alertWinTitle = addExtAgentInBulkTitle;
		} else if(actionType == 'delete') {
			alertWinTitle = deleteExtAgentInBulkTitle;
		}
		if(compListForm.isValid())
		{
			var tmpMask = new Ext.LoadMask('fileUpload', {msg: 'Please wait...'});
			tmpMask.show();

			compListForm.submit({
				url: URL,
				scope: this,
				async: true,
				//waitMsg: 'Please wait upload in progress',
				method: 'POST',
				enctype: 'multipart/form-data',
				success: function (form, action)
				{
					tmpMask.hide();
					var jsonText = action.response.responseText;
						jsonText = Ext.decode(jsonText);
					var errorMsg = jsonText['errorMsg'];
					var errorInfo = jsonText['errorInfo'];

					var resultMsg = jsonText['resultMsg'];
					var tempErrorMsg = jsonText['tempErrorMsg'];
					var ErrMsgsJson = jsonText['ErrMsgsJson'];
					if (!Ext.isEmpty(jsonText))
					{
						if(Ext.isEmpty(tempErrorMsg))
						{
							if(!Ext.isEmpty(resultMsg))
							{
								Ext.Msg.show({
								title: alertWinTitle,
								msg: resultMsg,
								icon: 'iconInformation',
								buttons: Ext.Msg.OK
								});
							} else {
								if(!Ext.isEmpty(ErrMsgsJson)) {
									Ext.Msg.show({
										title: alertWinTitle,
										msg: errorMsg,
										icon: 'iconExclamation',
										buttons: Ext.Msg.OK
									});
								} else if(!Ext.isEmpty(errorInfo)) {
									
									Ext.Msg.show({
										title: alertWinTitle,
										msg: errorInfo,
										icon: 'iconInformation',
										buttons: Ext.Msg.OK
									});
								} else if(!Ext.isEmpty(errorMsg)) {
									Ext.Msg.show({
										title: alertWinTitle,
										msg: errorMsg,
										icon: 'iconExclamation',
										buttons: Ext.Msg.OK
									});
								}
							}
						} else {
							Ext.Msg.show({
								title: alertWinTitle,
								msg: tempErrorMsg,
								icon: 'iconExclamation',
								buttons: Ext.Msg.OK
							});
						}
					} 
				},
				failure: function (form, action)
				{
					tmpMask.hide();
					Ext.Msg.show({
						title: alertWinTitle,
						msg: 'Failure Notice',
						icon: 'iconExclamation',
						buttons: Ext.Msg.OK
					});
				}
			});
		}
	},
	deleteOver: function(){
		var HostNameToDel = Ext.getCmp('DispHostName').getValue();
		window.location.href = "ExternalAgent/data/EgnewextagentspJson.jsp?mode=del&eagent="+encodeURIComponent(HostNameToDel);
	},

	showAssignHosts: function(rowIdx,gridID)
	{
		var  grid = Ext.getCmp(gridID);
		var row = grid.getStore().getAt(rowIdx);
		assignAgent = row.get('Hostname');

		Ext.getCmp('extviewport').removeAll();
		this.getController('ExternalAgent.controller.AssignExtCtrl').buildFieldData();
		Ext.getCmp('extviewport').add({xtype: 'assignexternalagent'});
		this.getController('ExternalAgent.controller.AssignExtCtrl').buildGivenAgentData(assignAgent);
		this.getController('ExternalAgent.controller.AssignExtCtrl').afterMainRender();
	},

	radChange : function(){
		var emulVal = Ext.getCmp('clientemulyes').getValue();
		if (emulVal == true)
		{
			Ext.getCmp('remoteagent').disable();
			Ext.getCmp('remoteagent').hide();
		}
		else
		{
			var mode = publicJSON['mode'];
			var notrmtAgent = publicJSON['rmtnothaveagent'];
			if (notrmtAgent == 'No')
			{
				Ext.getCmp('remoteagent').hide();
			}
			else
			{
				Ext.getCmp('remoteagent').enable();
				Ext.getCmp('remoteagent').show();
			}
			
			var HostNameAgent = Ext.getCmp('Hostname').getValue();

			var rmtListHasAgent = false;
			for (var l=0;l<rmtListStr.length;l++)
			{
				var rmtListStrSa = rmtListStr[l].trim();
				if (rmtListStrSa == HostNameAgent)
				{
					rmtListHasAgent = true;
				}
			}
			if ((HostNameAgent.length > 0) && (ExtIpAgent == HostNameAgent || rmtListHasAgent))
			{
				Ext.getCmp('remoteagent').hide();
			}
			else
			{
				if (notrmtAgent == 'No')
				{
					Ext.getCmp('remoteagent').hide();
				}
				else
				{
					Ext.getCmp('remoteagent').enable();
					Ext.getCmp('remoteagent').show();
				}
			}
		}

		var host_name = Ext.getCmp('Hostname').getValue();
		if(host_name.toLowerCase() == "none")
		{
			Ext.getCmp('client').hide();
			Ext.getCmp('remoteagent').hide();
		}
	},

	addUpdate : function(btn){
		var hostip = Ext.getCmp('Hostip').getValue();
		var hostname = Ext.getCmp('Hostname').getValue();
		var modify = (btnText != 'Add') ? 'true' : 'false';

		var me = this;
		var checkValidation = me.validationForAddModify();
		if(modify == 'true' && hostname.toLowerCase() == "none")
		{
			Ext.Msg.show({
				title : extPageTitle,
				msg : "You are not allowed to modify the existing nickname to eG reserved keyword \'"+hostname+"\'",
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('Hostname').focus(true);
				}
			});
			checkValidation = false;
		}

		var rmtListHasAgent = false;
		if(btnText != 'Add')
		{
			if(oldHostIp != null && oldNickName != null && oldHostIp != hostip && oldNickName != hostname)
			{
				Ext.Msg.show(
				{
					title : extPageTitle,
					msg : checkSingleEdit + '.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('Hostip').focus(true);
					}
				});
				checkValidation = false;
			}
			else
			{
				for (var l=0;l<rmtListStr.length;l++)
				{
					var rmtListStrSa = rmtListStr[l].trim();
					if (rmtListStrSa == oldNickName)
					{
						rmtListHasAgent = true;
					}
				}
			}
		}

		if (checkValidation)
		{
			if(oldNickName != hostname)
			{
				if(rmtListHasAgent)
				{
					var emulation = Ext.getCmp('clientemulyes').getValue();
					if(emulation == true)
					{
						Ext.Msg.show(
						{
							title : extPageTitle,
							msg : clienabled1 + '.',
							icon : 'iconExclamation',
							buttons : Ext.Msg.OK,
							fn : function(btn){
								Ext.getCmp('Hostip').focus(true);
							}
						});
					}
					else
					{
						Ext.Msg.show(
						{
							title : extPageTitle,
							//msg : '' + '.',
							msg : sameNameAlert1+'. '+sameNameAlert2+'. '+sameNameAlert3+'.',
							buttons: Ext.Msg.YESNO,
							icon: 'iconConfirmation',
							fn: function(response) {
								if(response == 'yes') 
								{
									me.addUpdateProcess();
								}
							}
						});
					}
				}
				else
				{
					me.addUpdateProcess();
				}
			}
			else
			{
				me.addUpdateProcess();
			}
		}
	},

	addUpdateProcess : function()
	{
		var getBuildData = this;
		this.getController('ExternalAgent.controller.AddExtCtrl').buildAddFieldData();

		var hostip = Ext.getCmp('Hostip').getValue();
		var hostname = Ext.getCmp('Hostname').getValue();

		var Btype= '';
		var modify= '';

		if (btnText == 'Add')
		{
			Btype = 'NewAgnt';
			modify = 'null';
		}
		else
		{
			Btype = 'bmod';
			modify = 'true';
		}

		var remote = '';
		var remoteAgent = Ext.getCmp('remoteagentyes').getValue();
		if (remoteAgent == true)
		{
			remote = true;
		}
		else
		{
			remote = false;
		}

		var emulate = '';
		var emulation = Ext.getCmp('clientemulyes').getValue();
		if (emulation == true)
		{
			emulate = 'true';
		}
		else
		{
			emulate = 'false';
		}
		var eagent = null;

		var mode = publicJSON['mode'];
		var lat_value='';
		var lng_value='';
		var zonelocation = Ext.getCmp('zoneLocation').getValue();

		
		if (parent.isInternetAvailable && !Ext.isEmpty(zonelocation))
		{
			Ext.Ajax.cors = true;
			Ext.Ajax.useDefaultXhrHeader = false;
			var url = "https://maps.googleapis.com/maps/api/geocode/json?key="+google_map_key+"&address="+encodeURI(zonelocation)+"&sensor=true";
			Ext.Ajax.request({
				url : url,
				async: false,
				success : function(response, opts)
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					if (!Ext.isEmpty(jsonData.results[0]))
					{
						lat_value = jsonData.results[0].geometry.location.lat;
						lng_value = jsonData.results[0].geometry.location.lng;
					}
				},
				failure: function(response)
				{
					console.log('failed---url->',url);
				}
			}); 
		}
		if (!Ext.isEmpty(lat_value) && !Ext.isEmpty(lng_value))
		{
			var qrString = modify+"&remote="+remote+"&mode="+mode+"&hostip="+hostip+"&hostname="+encodeURI(hostname)+"&old_name="+encodeURIComponent(oldNickName)+"&old_ip="+oldHostIp+"&emulate="+emulate+"&old_emulate="+old_emulate+"&eagent="+eagent+"&Btype="+Btype+"&zonelocation="+zonelocation+"&lat_value="+lat_value+"&lng_value="+lng_value;
		}
		else
		{
			var qrString = modify+"&remote="+remote+"&mode="+mode+"&hostip="+hostip+"&hostname="+encodeURI(hostname)+"&old_name="+encodeURIComponent(oldNickName)+"&old_ip="+oldHostIp+"&emulate="+emulate+"&old_emulate="+old_emulate+"&eagent="+eagent+"&Btype="+Btype;
		}
		var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
		tmpMask.show();
		Ext.Ajax.request({
			url: 'ExternalAgent/data/EgnewextagentspJson.jsp?modify='+qrString,
			method: 'POST',
			success: function( response )
			{
				tmpMask.hide();
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
				if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
				{
					var resultStatus = publicJSON['requestStatus'];
					if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
					{
						var resultStatus = publicJSON['result'];
						var addToRemote = publicJSON['addToRemote'];
						var toRmtAgent = publicJSON['toRemoteMod'];
						if (addToRemote == undefined && toRmtAgent == undefined)
						{
							Ext.MessageBox.show(
							{
								title : resultStatus['title'],
								msg : resultStatus['message1'],
								icon : 'iconInformation',
								buttons : Ext.Msg.OK,
								width : 400,
								fn : function(btn){
									Ext.getCmp('AddModView').destroy();
								}
							});
						}
						if (addToRemote != null && addToRemote == 'true')
						{
							var queryStr = "mode=add&externalResultString=eG_CLI_0010&addAsRemote=true&hostip="+hostip+"&hostname="+encodeURIComponent(hostname);
							tmpMask.show();
							Ext.Ajax.request({
								url: 'RemoteAgent/data/EgnewremoteagentspJson.jsp?'+queryStr,
								method: 'POST',
								success: function( response )
								{
									tmpMask.hide();
									var jsonText = response.responseText;
									publicJSON = Ext.decode(jsonText);
									if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
									{
										var resultStatus = publicJSON['requestStatus'];
										if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
										{
											var resultStatus = publicJSON['result'];
											Ext.MessageBox.show(
											{
												title :resultStatus['title'],
												msg : resultStatus['message1'],
												icon : 'iconInformation',
												buttons : Ext.Msg.OK,
												width : 400,
												fn : function(btn){
													Ext.getCmp('AddModView').destroy();
												}
											});
										}
									}
								},
								failure: function()
								{
									tmpMask.hide();
								}
							});
						}
						if (toRmtAgent != null && toRmtAgent == 'true')
						{
							var queryModStr = "mode=add&addAsRemote=true&hostip="+hostip+"&hostname="+encodeURIComponent(hostname);
							tmpMask.show();
							Ext.Ajax.request({
								url: 'RemoteAgent/data/EgnewremoteagentspJson.jsp?'+queryModStr,
								method: 'POST',
								success: function( response )
								{
									tmpMask.hide();
									var jsonText = response.responseText;
									publicJSON = Ext.decode(jsonText);
									if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
									{
										var resultStatus = publicJSON['requestStatus'];
										if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
										{
											var resultStatus = publicJSON['result'];
											Ext.MessageBox.show(
											{
												title : resultStatus['title'],
												msg : resultStatus['message1'],
												icon : 'iconInformation',
												buttons : Ext.Msg.OK,
												fn : function(btn){
													Ext.getCmp('AddModView').destroy();
												}
											});
										}
									}
								},
								failure: function()
								{
									tmpMask.hide();
								}
							});
						}
					}
					else
					{
						var errorStatus = publicJSON['error'];
						var notProperlyUpdated = publicJSON['notProperlyUpdated'];
						var errMsg1 = errorStatus['message1'];
						var errMsg2 = errorStatus['message2'];
						var err2Show = errMsg1;
						if (errMsg2 != null && errMsg2 != 'undefined')
						{
							err2Show += errMsg2;
						}
						var errType = publicJSON.error_type;

						if (errType=='confirmNickSuggestion')
						{
							Ext.Msg.confirm({
								title: errorStatus['title'],
								msg: err2Show,
								buttons: Ext.Msg.YESNO,
								icon: 'iconConfirmation',
								fn: function(response) {
									if(response == 'yes') 
									{
										var forwardURL = errorStatus.forward_URL;
										var IP = errorStatus.IP;
										var Nick = errorStatus.nickName;
										forwardURL ="ExternalAgent/data/"+forwardURL;
										getBuildData.forwardGivenURL(forwardURL,IP,Nick);
									}
									else
									{
										//Ext.getCmp('Hostname').setValue("");
										Ext.getCmp('Hostname').focus();
									}
								}
							});
						}
						else
						{
							if (notProperlyUpdated == undefined)
							{
								Ext.MessageBox.show(
								{
									title : errorStatus['title'],
									msg : err2Show,
									buttons : Ext.Msg.OK,
									icon : 'iconExclamation',
									fn : function(btn){
										if (errType=='alert')
										{
											//Ext.getCmp('Hostname').setValue("");
											Ext.getCmp('Hostname').focus();
										}
										else
										{
											Ext.getCmp('AddModView').destroy();
										}
									}
								});
							}
							var AddSameAsRem = publicJSON['AddSameAsRem'];
							if (AddSameAsRem != undefined && AddSameAsRem == 'true')
							{
								Ext.Msg.show({
									title:errorStatus['title'],
									msg: errorStatus['message1']+errorStatus['message2']+'.',
									icon : 'iconExclamation',
									buttons: Ext.Msg.OKCANCEL,
									fn: function(response) {
										if (response == 'ok')
										{
											tmpMask.show();
											Ext.Ajax.request({
												url: 'RemoteAgent/data/EgnewremoteagentspJson.jsp?mode=add&addAsRemote=true&hostip='+hostip+"&hostname="+encodeURI(hostname),
												method: 'POST',
												success: function( response )
												{
													tmpMask.hide();
													var jsonText = response.responseText;
													publicJSON = Ext.decode(jsonText);
													if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
													{
														var resultStatus = publicJSON['requestStatus'];
														if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
														{
															var result = publicJSON['result'];
															Ext.MessageBox.show(
															{
																title : result['title'],
																msg : result['message1'],
																icon : 'iconInformation',
																buttons: Ext.Msg.OK,
																fn : function(btn){
																	Ext.getCmp('AddModView').destroy();
																}
															});
														}
													}
												},
												failure: function()
												{
													tmpMask.hide();
												}
											});
										}
										else
										{
											Ext.getCmp('AddModView').destroy();
										}
									}
								});
							}

							if (notProperlyUpdated != null && notProperlyUpdated == 'true')
							{
								var qString = "mode=add&addAsRemote=true&hostip="+hostip+"&hostname="+encodeURIComponent(hostname);
								tmpMask.show();
								Ext.Ajax.request({
									url: 'RemoteAgent/data/EgnewremoteagentspJson.jsp?'+qString,
									method: 'POST',
									success: function( response )
									{
										tmpMask.hide();
										var jsonText = response.responseText;
										publicJSON = Ext.decode(jsonText);
										if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
										{
											var resultStatus = publicJSON['requestStatus'];
											if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
											{
												var resultStatus = publicJSON['result'];
												Ext.MessageBox.show(
												{
													title : resultStatus['title'],
													msg : resultStatus['message1'],
													icon : 'iconInformation',
													buttons: Ext.Msg.OK,
													fn : function(btn){
														Ext.getCmp('AddModView').destroy();
													}
												});
											}
										}
									},
									failure: function()
									{
										tmpMask.hide();
									}
								});
							}
						}
					}
					getBuildData.buildMainData();
					var resultsData = publicJSON['gridExtAgents'];
					Ext.getCmp('gridSearch').enable();
					Ext.getCmp('associateDissociate').enable();
					//Ext.getCmp('deleteAgent').enable();

					Ext.getCmp('gridDisplay').getStore().loadRawData(resultsData);
					Ext.getCmp('gridSearch').setRawValue('');
				}
			},
			failure: function()
			{
				tmpMask.hide();
			}
		});
	},

	forwardGivenURL : function(forwardURL,hostip,hostname)
	{
		var getBuildData = this;
		var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
		tmpMask.show();
		Ext.Ajax.request({
			url: forwardURL,
			method: 'POST',
			success: function( response )
			{
				tmpMask.hide();
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
				if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
				{
					var resultStatus = publicJSON['requestStatus'];
					if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
					{
						var resultStatus = publicJSON['result'];
						var addToRemote = publicJSON['addToRemote'];
						var toRmtAgent = publicJSON['toRemoteMod'];
						if (addToRemote == undefined && toRmtAgent == undefined)
						{
							Ext.MessageBox.show(
							{
								title : resultStatus['title'],
								msg : resultStatus['message1'],
								icon : 'iconInformation',
								buttons : Ext.Msg.OK,
								width : 400,
								fn : function(btn){
									Ext.getCmp('AddModView').destroy();
								}
							});
						}

						if (addToRemote != null && addToRemote == 'true')
						{
							var queryStr = "mode=add&externalResultString=eG_CLI_0010&addAsRemote=true&hostip="+hostip+"&hostname="+encodeURIComponent(hostname);
							tmpMask.show();
							Ext.Ajax.request({
								url: 'RemoteAgent/data/EgnewremoteagentspJson.jsp?'+queryStr,
								method: 'POST',
								success: function( response )
								{
									tmpMask.hide();
									var jsonText = response.responseText;
									publicJSON = Ext.decode(jsonText);
									if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
									{
										var resultStatus = publicJSON['requestStatus'];
										if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
										{
											var resultStatus = publicJSON['result'];
											Ext.MessageBox.show(
											{
												title :resultStatus['title'],
												msg : resultStatus['message1'],
												icon : 'iconInformation',
												buttons : Ext.Msg.OK,
												width : 400,
												fn : function(btn){
													Ext.getCmp('AddModView').destroy();
												}
											});
										}
									}
								},
								failure: function()
								{
									tmpMask.hide();
								}
							});
						}
						if (toRmtAgent != null && toRmtAgent == 'true')
						{
							var queryModStr = "mode=add&addAsRemote=true&hostip="+hostip+"&hostname="+encodeURIComponent(hostname);
							tmpMask.show();
							Ext.Ajax.request({
								url: 'RemoteAgent/data/EgnewremoteagentspJson.jsp?'+queryModStr,
								method: 'POST',
								success: function( response )
								{
									tmpMask.hide();
									var jsonText = response.responseText;
									publicJSON = Ext.decode(jsonText);
									if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
									{
										var resultStatus = publicJSON['requestStatus'];
										if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
										{
											var resultStatus = publicJSON['result'];
											Ext.MessageBox.show(
											{
												title : resultStatus['title'],
												msg : resultStatus['message1'],
												icon : 'iconInformation',
												buttons : Ext.Msg.OK,
												fn : function(btn){
													Ext.getCmp('AddModView').destroy();
												}
											});
										}
									}
								},
								failure: function()
								{
									tmpMask.hide();
								}
							});
						}
					}
					else
					{
						var errorStatus = publicJSON['error'];
						var notProperlyUpdated = publicJSON['notProperlyUpdated'];
						var errMsg1 = errorStatus['message1'];
						var errMsg2 = errorStatus['message2'];
						var err2Show = errMsg1;
						if (errMsg2 != null && errMsg2 != 'undefined')
						{
							err2Show += errMsg2;
						}
						if (notProperlyUpdated == undefined)
						{
							Ext.MessageBox.show(
							{
								title : errorStatus['title'],
								msg : err2Show,
								buttons : Ext.Msg.OK,
								icon : 'iconExclamation',
								fn : function(btn){
									Ext.getCmp('AddModView').destroy();
								}
							});
						}
						var AddSameAsRem = publicJSON['AddSameAsRem'];
						if (AddSameAsRem != undefined && AddSameAsRem == 'true')
						{
							Ext.Msg.show({
								title:errorStatus['title'],
								msg: errorStatus['message1']+errorStatus['message2']+'.',
								icon : 'iconExclamation',
								buttons: Ext.Msg.OKCANCEL,
								fn: function(response) {
									if (response == 'ok')
									{
										tmpMask.show();
										Ext.Ajax.request({
											url: 'RemoteAgent/data/EgnewremoteagentspJson.jsp?mode=add&addAsRemote=true&hostip='+hostip+"&hostname="+encodeURI(hostname),
											method: 'POST',
											success: function( response )
											{
												tmpMask.hide();
												var jsonText = response.responseText;
												publicJSON = Ext.decode(jsonText);
												if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
												{
													var resultStatus = publicJSON['requestStatus'];
													if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
													{
														var result = publicJSON['result'];
														Ext.MessageBox.show(
														{
															title : result['title'],
															msg : result['message1'],
															icon : 'iconInformation',
															buttons: Ext.Msg.OK,
															fn : function(btn){
																Ext.getCmp('AddModView').destroy();
															}
														});
													}
												}
											},
											failure: function()
											{
												tmpMask.hide();
											}
										});
									}
									else
									{
										Ext.getCmp('AddModView').destroy();
									}
								}
							});
						}

						if (notProperlyUpdated != null && notProperlyUpdated == 'true')
						{
							var qString = "mode=add&addAsRemote=true&hostip="+hostip+"&hostname="+encodeURIComponent(hostname);
							tmpMask.show();
							Ext.Ajax.request({
								url: 'RemoteAgent/data/EgnewremoteagentspJson.jsp?'+qString,
								method: 'POST',
								success: function( response )
								{
									tmpMask.hide();
									var jsonText = response.responseText;
									publicJSON = Ext.decode(jsonText);
									if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
									{
										var resultStatus = publicJSON['requestStatus'];
										if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
										{
											var resultStatus = publicJSON['result'];
											Ext.MessageBox.show(
											{
												title : resultStatus['title'],
												msg : resultStatus['message1'],
												icon : 'iconInformation',
												buttons: Ext.Msg.OK,
												fn : function(btn){
													Ext.getCmp('AddModView').destroy();
												}
											});
										}
									}
								},
								failure: function()
								{
									tmpMask.hide();
								}
							});
						}
					}
					getBuildData.buildMainData();
					var resultsData = publicJSON['gridExtAgents'];
					Ext.getCmp('gridSearch').enable();
					Ext.getCmp('associateDissociate').enable();
					//Ext.getCmp('deleteAgent').enable();

					Ext.getCmp('gridDisplay').getStore().loadRawData(resultsData);
					Ext.getCmp('gridSearch').setRawValue('');
				}
			},
			failure: function()
			{
				tmpMask.hide();
			}
		});
	},
	
	validationForAddModify: function(){
		var hostip = Ext.getCmp('Hostip').getValue();
		var hostname = Ext.getCmp('Hostname').getValue();
		var zonelocation = Ext.getCmp('zoneLocation').getValue(); //murugan
		if(hostname.charAt(0) == '.' || hostname.charAt(hostname.length - 1) == '.')
		{
			Ext.Msg.show(
			{
				title : extPageTitle,
				msg : checkdots + '.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('Hostname').focus(true);
				}
			});
			return false;
		}
		else
		{
			for(var k=0;k < hostname.length;k++)
			{
				if(hostname.charAt(k) == '.' && hostname.charAt(k + 1) == '.')
				{
					Ext.MessageBox.show(
					{
						title : extPageTitle,
						msg : checkconsecutivedots+'.',
						icon : 'iconExclamation',
						buttons : Ext.Msg.OK,
						fn : function(btn){
							Ext.getCmp('Hostname').focus(true);
						}
					});
					return false;
				}
				else
				{
					continue;
				}
			}
		}

		var temp=false;
		var regExp = /^(([0-9]+\.)+){3}[0-9]+$/;
		var hostnameIsIP = regExp.test(hostname);
		var host_Name=true;
		if(isDouble == "false")
			host_Name = validateSingleByte(hostname);

		if (btnText == 'Add')
		{
			if (ex_varStr != null)
			{
				for(var j=0;j<ex_varStr.length;j++)
				{
					var ex_varListStr = ex_varStr[j].trim();
					if(ex_varListStr.toLowerCase() == hostname.toLowerCase())
					temp=true;
				}
			}
		}

		var comValidIPVar = commonValidationsExtjs(hostip);
		var validateIPVar = validateIpExtjs(hostip);
		var validHostFieldIPVar = validateHostFieldExtjs(hostip);
		var checkspaceIPVar = checkspaceExtjs(hostip);
		var checkSpecialIPVar = checkSpecialExtjs(hostip,"`~!@#$%^&*()+={}[]|;\"\'<>,?/");
		var checkspaceNameVar = checkspaceExtjs(hostname);
		var checkSpecialNameVar = checkSpecialExtjs(hostname,"`~!@#$%^&*()+={}[]|:;\"\'<>,?\\\/");
		var checkspaceZoneVar = checkspaceExtjs(zonelocation);
		var checkSpecialZoneVar = checkSpecialExtjs(zonelocation,"`~!@#$%^&*()+={}[]|:;\"\'<>,?\\\/");

		var internalAgentMappedWithHostName = false;
		for(var i = 0; i < intAgentsListStr.length; i++)
		{
			if(intAgentsListStr[i].trim() == hostname.trim())
			{
				internalAgentMappedWithHostName = true;
				break;
			}
		}

		if(!checkblank(hostip))
		{
			if (isAllowHostName=='false')
			{
				Ext.Msg.show(
				{
					title : extPageTitle,
					msg : checkBlankIP+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('Hostip').focus(true);
					}
				});
			}
			else
			{
				Ext.Msg.show(
				{
					title : extPageTitle,
					msg : checkBlankIPName +'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('Hostip').focus(true);
					}
				});
			}
		}
		else if(comValidIPVar != '0')
		{
			var errorMessage = this.getRespectiveMsg(comValidIPVar);
			Ext.Msg.show(
			{
				title : extPageTitle,
				msg : errorMessage+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('Hostip').focus(true);
				}
			});
		}
		else if(isAllowHostName == 'false' && validateIPVar != '0')
		{
			var errorMessage = this.getRespectiveMsg(validateIPVar);
			Ext.Msg.show(
			{
				title : extPageTitle,
				msg : errorMessage+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('Hostip').focus(true);
				}
			});
		}
		else if(isAllowHostName=='true' && validHostFieldIPVar != '0')
		{
			var errorMessage = this.getRespectiveMsg(validHostFieldIPVar);
			Ext.Msg.show(
			{
				title : extPageTitle,
				msg : errorMessage+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('Hostip').focus(true);
				}
			});
			return;
		}
		else if(isAllowHostName=='true' && checkspaceIPVar != '0')
		{
			var errorMessage = this.getRespectiveMsg(checkspaceIPVar);
			Ext.Msg.show(
			{
				title : extPageTitle,
				msg : errorMessage+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('Hostip').focus(true);
				}
			});
		}
		else if (isAllowHostName=='true' && checkSpecialIPVar != '0')
		{
			var errorMessage = this.getRespectiveMsg(checkSpecialIPVar);
			Ext.Msg.show(
			{
				title : extPageTitle,
				msg : errorMessage+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('Hostip').focus(true);
				}
			});
		}
		else if(!checkblank(hostname))
		{
			Ext.Msg.show(
			{
				title : extPageTitle,
				msg : checkBlankHostName + '.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('Hostname').focus(true);
				}
			});
		}
		else if(checkspaceNameVar != '0')
		{
			var errorMessage = this.getRespectiveMsg(checkspaceNameVar);
			Ext.Msg.show(
			{
				title : extPageTitle,
				msg : errorMessage+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('Hostname').focus(true);
				}
			});
		}
		else if(checkSpecialNameVar != '0')
		{
			var errorMessage = this.getRespectiveMsg(checkSpecialNameVar);
			Ext.Msg.show(
			{
				title : extPageTitle,
				msg : errorMessage+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('Hostname').focus(true);
				}
			});
		}
		else if(hostnameIsIP && hostip != hostname)
		{
			Ext.Msg.show(
			{
				title : extPageTitle,
				msg : hostNameIsIP + '.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('Hostname').focus(true);
				}
			});
		}
		//else if(temp)
		//{
			//Ext.Msg.show(
			//{
				//title : extPageTitle,
				//msg : hostNameByOtherAgent + '.',
				//icon : 'iconExclamation',
				//buttons : Ext.Msg.OK,
				//fn : function(btn){
					//Ext.getCmp('Hostname').focus(true);
				//}
			//});
		//}
		else if(!host_Name)
		{
			Ext.Msg.show(
			{
				title : extPageTitle,
				msg : checkDBL + '.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('Hostname').focus(true);
				}
			});
			
		}
		/*else if(!checkblank(zonelocation))
		{
			Ext.Msg.alert("EXTERNAL AGENT",zoneLbl);
			Ext.getCmp('zoneLocation').focus(true);
		}*/
		else if(checkspaceZoneVar != '0')
		{
			var errorMessage = this.getRespectiveMsg(checkspaceZoneVar);
			Ext.Msg.show(
			{
				title : extPageTitle,
				msg : errorMessage+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('zoneLocation').focus(true);
				}
			});
		}
		else if(checkSpecialZoneVar != '0')
		{
			var errorMessage = this.getRespectiveMsg(checkSpecialZoneVar);
			Ext.Msg.show(
			{
				title : extPageTitle,
				msg : errorMessage+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('zoneLocation').focus(true);
				}
			});
		}
		else if(internalAgentMappedWithHostName)
		{
			Ext.Msg.show(
			{
				title : extPageTitle,
				msg : intAgentMappingAlert+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('Hostname').focus(true);
				}
			});
		}
		else
		{
			return true;
		}
	},

	getRespectiveMsg: function(Var){
		
		switch(Var)
		{
			case '1' : return _checkIp;
			case '2' : return _validateHostDot;
			case '3' : return _validateHostUScore;
			case '4' : return _validateHostHypen;
			case '5' : return _checkspaceIp;
			case '6' : return _checkAlpha;
			case '7' : return _checkspecial;
			case '8' : return _valIp;
			case '9' : return _validateIp;
			case '10' : return _checknum;
			case '11' : return _chkIpv6;
			case '12' : return _doubleColon;
			case '13' : return _grpIpv6;
			case '14' : return _digitIpv6;
			case '15' : return _validateIpv6;
			case '16' : return _checkNumberLabel;
			case '17' : return _checkblank;
		}
	},

	associateDissociate: function(btn){
		assignAgent = "";
		Ext.getCmp('extviewport').removeAll();
		this.getController('ExternalAgent.controller.AssignExtCtrl').buildFieldData();
		Ext.getCmp('extviewport').add({xtype: 'assignexternalagent'});
		this.getController('ExternalAgent.controller.AssignExtCtrl').afterMainRender();
	},

	dwnldAgent: function()
	{

		window.location.href="/final/admin/EgDownloadAgentPack.jsp?from=External&fromWizard="+fromWizard;
	},

	comboFromFieldLoad: function(){
		var me = this;
		me.getController('ExternalAgent.controller.AssignExtCtrl').buildFieldData();

		var eagent = Ext.getCmp('extAgent').getValue();
		var othereagent = "null";
		if (eagent == -1)
		{
			eagent = "null";
		}

		Ext.Ajax.request({
			url: 'ExternalAgent/data/EgConfigExtAgentsJson.jsp?eagent='+encodeURIComponent(eagent)+'&othereagent='+encodeURIComponent(othereagent),
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
				if (Ext.getCmp('itemselectextagent').fromField.store.getCount() >= 1)
				{
					Ext.getCmp('itemselectextagent').fromField.store.removeAll();
				}
				if (Ext.getCmp('itemselectextagent').toField.store.getCount() >= 1)
				{
					Ext.getCmp('itemselectextagent').toField.store.removeAll();
				}

				Ext.getCmp('itemselectextagent').fromField.store.add(publicJSON['ManagedHostByThisAgent']);
				me.getController('ExternalAgent.controller.AssignExtCtrl').initializeFields2();
				if (eagent == "null")
				{
					Ext.getCmp('otherExtAgent').setDisabled(true);
				}
				else
				{
					Ext.getCmp('otherExtAgent').setDisabled(false);
				}
				Ext.getCmp('itemselectextagent').toField.store.add(publicJSON['ManagedHostByOthrAgnt']);
			}
		});
	},

	comboToFieldLoad: function(value){
		this.getController('ExternalAgent.controller.AssignExtCtrl').buildFieldData();

		var eagent = Ext.getCmp('extAgent').getValue();
		var othereagent = Ext.getCmp('otherExtAgent').getValue();
		if (eagent == -1)
		{
			Ext.getCmp('otherExtAgent').setValue("-1");
			eagent = "null";
		}
		if (othereagent == -1)
		{
			othereagent = "null";
		}
		Ext.Ajax.request({
			url: 'ExternalAgent/data/EgConfigExtAgentsJson.jsp?eagent='+encodeURIComponent(eagent)+'&othereagent='+encodeURIComponent(othereagent),
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
				if (Ext.getCmp('itemselectextagent').toField.store.getCount() >= 1)
				{
					Ext.getCmp('itemselectextagent').toField.store.removeAll();
				}
				Ext.getCmp('itemselectextagent').toField.store.add(publicJSON['ManagedHostByOthrAgnt']);
			}
		});
	},

	updation: function(btn){
		var me = this;
		var eagent = Ext.getCmp('extAgent').getValue();
		if (eagent == '-1')
		{
			Ext.Msg.show(
			{
				title : assignExtPageTitle,
				msg : publicJSON['screenLabels']['admin.test.Please choose an external agent']+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK
			});
		}
		else
		{
			var existingAgents = publicJSON['existingAgents'];
			if (existingAgents != null && existingAgents != "undefined")
			{
				var existAgentsArr = existingAgents.split(",");
			}

			var prevManagedHostByOther = publicJSON['ManagedHostByOthrAgnt'];

			var managedHostsByOther = Ext.getCmp('itemselectextagent').getValue();
			if (managedHostsByOther == undefined)
			{
				Ext.Msg.show(
				{
					title : assignExtPageTitle,
					msg : publicJSON['screenLabels']['admin.external.Please choose atleast one agent to manage or unmanage']+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK
				});
				return;
			}
			var ArrVal = new Array();
			for (var k=0;k<managedHostsByOther.length;k++)
			{
				var DataVal = false;
				if (prevManagedHostByOther != null && prevManagedHostByOther != "undefined")
				{
					for (var m=0;m<prevManagedHostByOther.length;m++)
					{
						var prevManagedHostByOtherValue  =  prevManagedHostByOther[m];
						for (var key in prevManagedHostByOtherValue)
						{
							if (prevManagedHostByOtherValue[key] == managedHostsByOther[k])
							{
								DataVal = true;
								break;
							}
						}
					}
					if (!DataVal)
					{
						ArrVal[ArrVal.length]= managedHostsByOther[k];
					}
				}
				else
				{
					ArrVal[ArrVal.length]= managedHostsByOther[k];
				}
			}
			var fmanage = ArrVal;

			var Arr = new Array();
			var noOfManAgent = Ext.getCmp('itemselectextagent').fromField.store.getCount();

			var allValue = new Array();
			for (var i=0;i < noOfManAgent;i++)
			{
				allValue[allValue.length]=Ext.getCmp('itemselectextagent').fromField.store.getAt(i).get('valueField');
			}
			for (var m=0;m<allValue.length;m++ )
			{
				var isData = false;
				if (existingAgents != null && existingAgents.length > 0)
				{
					var existAgentsArr = existingAgents.split(",");
					for (var j=0;j<existAgentsArr.length;j++ )
					{
						if (allValue[m] == existAgentsArr[j])
						{
							isData = true;
							break;
						}
					}
					if (!isData)
					{
						Arr[Arr.length] = allValue[m];
					}
				}
				else
				{
					Arr[Arr.length] = allValue[m];
				}
			}
			var funmanage = Arr;

			if (existingAgents == "undefined" || existingAgents == null)
			{
				existingAgents = "null";
			}

			var hiddenObj = Ext.getCmp('assignhiddencontainer');
			var temp = {
				xtype: 'hiddenfield',
				name: 'fmanage',
				value: fmanage
			};
			hiddenObj.add(temp);

			var temp = {
				xtype: 'hiddenfield',
				name: 'existingAgents',
				value: existingAgents
			};
			hiddenObj.add(temp);

			var temp = {
				xtype: 'hiddenfield',
				name: 'funmanage',
				value: funmanage
			};
			hiddenObj.add(temp);

			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
			myMask.show(); 

			var hiddenAssignObj = Ext.getCmp('assignexternalagent').getForm();
			hiddenAssignObj.submit({
			url: 'ExternalAgent/data/EgconfigextagentspJson.jsp?eagent='+encodeURIComponent(eagent),
			method: 'POST',
			timeout: 500000,
			standardSubmit: false,
			success: function( form,action )
			{
				myMask.hide(); 
				var jsonText = action.response.responseText;
				publicJSON = Ext.decode(jsonText);
				if ( !Ext.isEmpty( jsonText ) && action.response.status == 200 )
				{
					var resultStatus = publicJSON['requestStatus'];
					if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
					{
						var resultStatus = publicJSON['result'];
						Ext.MessageBox.show(
						{
							title : resultStatus['title'],
							msg : resultStatus['message1'],
							icon : 'iconInformation',
							buttons : Ext.Msg.OK,
							fn : function(btn)
							{
								me.comboFromFieldLoad();
							}
						});
					}
					else
					{
						var errorStatus = publicJSON['error'];
						Ext.MessageBox.show(
						{
							title : errorStatus['title'],
							msg :errorStatus['message1'],
							icon : 'iconExclamation',
							buttons : Ext.Msg.OK,
							fn : function(btn)
							{
								me.comboFromFieldLoad();
							}
						});
					}
				}
				hiddenObj.removeAll();
			},
			failure: function(form, action)
			{
				myMask.hide(); 
				hiddenObj.removeAll();
			}
		});
		}
	},

	backbutton: function(){
		if (fromPage == 'AgentStatus')
		{
			window.location.href="/final/admin/EgServerList.jsp?from=AgentAssign&agentType=ExternalAgents&agentStatus=All";
		}
		else
		{
			fromAssignExt = "";
			Ext.getCmp('extviewport').removeAll();
			this.buildMainData();
			Ext.getCmp('extviewport').add({xtype: 'externalagents'});
			this.afterMainRender();
		}
	},

	//deleteAgent: function(btn){
		//Ext.getCmp('extviewport').removeAll();
		//this.getController('ExternalAgent.controller.DeleteExtCtrl').buildDeleteFieldData();
		//Ext.getCmp('extviewport').add({xtype: 'deleteexternalagents'});
		//this.getController('ExternalAgent.controller.DeleteExtCtrl').afterMainRender();
		//var hasDelAgnt = publicJSON['externalAgentArray'];
		//if (hasDelAgnt = "" || hasDelAgnt.length == 0)
		//{
			//Ext.getCmp('compsearch').disable();
		//}
		//else
		//{
			//Ext.getCmp('compsearch').enable();
		//}
	//},

	deletefun: function(){
		var deleteAgent = Ext.getCmp('components').getValue();
		if (deleteAgent == "" || deleteAgent.length == 0)
		{
			Ext.Msg.show(
			{
				title : deleteExtPageTitle,
				msg : publicJSON['screenLabels']['admin.common.Please select external agent(s)']+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK
			});
		}
		else
		{
			Ext.MessageBox.show(
			{
				title : deleteExtPageTitle, 
				msg : deleteMsg,
				fn : this.deleting,
				icon : 'iconConfirmation',
				buttons : Ext.Msg.YESNO,
				scope : this
			});
		}
	},

	handleDeleteSelected: function(){
		var grid=Ext.getCmp('gridDisplay').getSelectionModel().getSelection();
		var values='';
		var array=new Array();
		var selectedGroups="";
		if(grid=="")
		{
			Ext.MessageBox.show(
			{
				title : 'External Agents',
				msg : noExtSelected+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK
			});
			return false;
		}
		for(var i=0; i < grid.length ; i++)
		{
			values=grid[i];
			id=values.get('Hostname');
			if(id!=null)
			{
				array.push(id);
			}
		}
		for(var j=0; j < array.length; j++)
		{
			selectedGroups +=array[j]+",";
		}
		Ext.Msg.show(
		{
			title : 'External Agents',
			msg : deleteSelected+'.',
			icon : 'iconConfirmation',
			buttons : Ext.Msg.YESNO,
			fn : function(buttonText) {
				if (buttonText == "yes") 
				{
					var qrString = "from=deleteExternalAgentsPage"+"&externalAgents="+encodeURIComponent(selectedGroups);
					Ext.Ajax.request({
					url: 'ExternalAgent/data/deletegroupsexternalpJson.jsp?'+qrString,
					method: 'POST',
					success: function( response )
					{
						var jsonText = response.responseText;
						publicJSON = Ext.decode(jsonText);
						if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
						{
							var resultStatus = publicJSON['requestStatus'];
							if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
							{
								var resultStatus = publicJSON['result'];
								Ext.MessageBox.show(
								{
									title : resultStatus['title'],
									msg : resultStatus['message1'],
									icon : 'iconInformation',
									buttons : Ext.Msg.OK,
									fn : appCnt.buildMainData()
								});
							}
							else
							{
								var errorStatus = publicJSON['error'];
								Ext.Msg.show(
								{
									title : errorStatus['title'],
									msg : errorStatus['message1'],
									icon : 'iconExclamation',
									buttons : Ext.Msg.OK
								});
							}
						}
						Ext.getCmp('gridDisplay').store.loadData(publicJSON['gridExtAgents']);
					}
					});
				}
			}
		});
	},

	deleting: function(btn){
		this.getController('ExternalAgent.controller.DeleteExtCtrl').buildDeleteFieldData();
		if (btn == 'yes')
		{
			var extAgent = Ext.getCmp('components').getValue();
			if (extAgent == null)
			{
				Ext.Msg.show(
				{
					title : deleteExtPageTitle,
					msg : publicJSON['screenLabels']['admin.common.Please select external agent(s)']+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK
				});
			}
			else
			{
				var DeleteUrl = publicJSON['deleteLink'];
				var qrString = "from=deleteExternalAgentsPage"+"&externalAgents="+encodeURIComponent(extAgent);
				Ext.Ajax.request({
				url: 'ExternalAgent/data/deletegroupsexternalpJson.jsp?'+qrString,
				method: 'POST',
				success: function( response )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode(jsonText);
					if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
					{
						var resultStatus = publicJSON['requestStatus'];
						if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
						{
							var resultStatus = publicJSON['result'];
							Ext.MessageBox.show(
							{
								title : resultStatus['title'],
								msg : resultStatus['message1'],
								icon : 'iconInformation',
								buttons : Ext.Msg.OK,
								fn : refreshDelete
							});
						}
						else
						{
							var errorStatus = publicJSON['error'];
							Ext.Msg.show(
							{
								title : errorStatus['title'],
								msg : errorStatus['message1'],
								icon : 'iconExclamation',
								buttons : Ext.Msg.OK
							});
						}
					}
					Ext.getCmp('compsearch').setRawValue('');
				}
			});
			}
		}
	},

	mainFormEvent : function(obj){
		this.getController('ExternalAgent.controller.DeleteExtCtrl').buildDeleteFieldData();
		var compsearch = Ext.getCmp('compsearch').getValue();
		if (compsearch == "" || compsearch.length == 0)
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');
		}

		Ext.Ajax.request({
		url: 'ExternalAgent/data/DeleteExternalAgentsJson.jsp?compsearch='+compsearch,
		method: 'POST',
		success: function( response )
		{
			if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode( jsonText );
			}
			var value = publicJSON['searchArr'];
			if (value != null && value.length > 0)
			{
				Ext.getCmp('components').show();
				Ext.getCmp('deleteBtn').show();
				Ext.getCmp('delExtLabel').show();
				Ext.getCmp('NoDelSearchFound').hide();
				Ext.getCmp('components').getStore().loadRawData(publicJSON['searchArr']);
			}
			else
			{
				Ext.getCmp('components').hide();
				Ext.getCmp('deleteBtn').hide();
				Ext.getCmp('delExtLabel').hide();
				Ext.getCmp('NoDelSearchFound').show();
				Ext.getCmp('delSearch').update('<table><tr><td align="center" height="400"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+noExtFound+'.</td></tr></table></td></tr></table>');
			}
		}
		});
	},

	backDelButton: function(btn){
		fromDeleteExt = "";
		Ext.getCmp('extviewport').removeAll();
		this.buildMainData();
		Ext.getCmp('extviewport').add({xtype: 'externalagents'});
		this.afterMainRender();
	},

	afterMainRender : function(){
		if (fromAssignExt != null && fromAssignExt == "true")
		{
			Ext.getCmp('extviewport').removeAll();
			this.getController('ExternalAgent.controller.AssignExtCtrl').buildFieldData();
			Ext.getCmp('extviewport').add({xtype: 'assignexternalagent'});
			this.getController('ExternalAgent.controller.AssignExtCtrl').buildGivenAgentData(assignAgent);
			this.getController('ExternalAgent.controller.AssignExtCtrl').afterMainRender();
		}
		else if (fromDeleteExt != null && fromDeleteExt == "true")
		{
			Ext.getCmp('extviewport').removeAll();
			this.getController('ExternalAgent.controller.DeleteExtCtrl').buildDeleteFieldData();
			Ext.getCmp('extviewport').add({xtype: 'deleteexternalagents'});
			this.getController('ExternalAgent.controller.DeleteExtCtrl').afterMainRender();
		}
		else
		{
			if (isClientEmulation == "false")
			{
				Ext.getCmp('ClientEmul').hide();
			}
			if(isLimitedAdmin == "true")
			{
				Ext.getCmp("bulkAddAgent").hide();
			}
			else
			{
				Ext.getCmp("bulkAddAgent").show();
			}

			var resultsData = publicJSON['gridExtAgents'];
			if (resultsData == null || resultsData.length == 0)
			{
				Ext.getCmp('associateDissociate').disable();
				//Ext.getCmp('deleteAgent').disable();
				Ext.getCmp('gridDisplay').store.loadData('');
				Ext.getCmp('gridDisplay').getView().emptyText = '<table align="center"><tr><td align="center" height="300"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+noExtPrtDesc+'.</td></tr></table></td></tr></table>';
				Ext.getCmp('gridDisplay').getView().refresh();
			}
			else
			{
				Ext.getCmp('associateDissociate').enable();
				//Ext.getCmp('deleteAgent').enable();
				Ext.getCmp('gridDisplay').getStore().loadRawData(resultsData);
			}
			var noExtFound = publicJSON['NoExtFound'];
			if (noExtFound == "true")
			{
				Ext.getCmp('gridSearch').disable();
			}
			else
			{
				Ext.getCmp('gridSearch').enable();
			}
		}
	}

});

	function refreshDelete(btn){
		Ext.Ajax.request({
		url: 'ExternalAgent/data/DeleteExternalAgentsJson.jsp',
		method: 'POST',
		async: false,
		success: function( response )
		{
			if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode( jsonText );
			}
		}
	});
	Ext.getCmp('components').getStore().loadData(publicJSON['externalAgentArray']);
}

	function refreshAssignExt(btn){
	var eagent = Ext.getCmp('extAgent').getValue();

	Ext.Ajax.request({
		url: 'ExternalAgent/data/EgConfigExtAgentsJson.jsp?eagent='+encodeURIComponent(eagent),
		method: 'POST',
		success: function( response )
		{
			if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode( jsonText );
			}
			if (Ext.getCmp('itemselectextagent').fromField.store.getCount() >= 1)
			{
				Ext.getCmp('itemselectextagent').fromField.store.removeAll();
			}
			if (Ext.getCmp('itemselectextagent').toField.store.getCount() >= 1)
			{
				Ext.getCmp('itemselectextagent').toField.store.removeAll();
			}

			Ext.getCmp('itemselectextagent').fromField.store.add(publicJSON['ManagedHostByThisAgent']);
			Ext.getCmp('itemselectextagent').toField.store.add(publicJSON['ManagedHostByOthrAgnt']);
		}
	});
}



