Ext.define('ExternalAgent.view.ExternalAgent', {
	extend: 'Ext.window.Window',
	alias: 'widget.externalagent',
	id : 'AddModView',
	title: extAddPageTitle,
	width: 550,
	//height: 275,
	padding:'5 10 10 10',
	autoScroll: true,
	modal: true,
	listeners : {
		close : function()
		{
			Ext.Ajax.request({
				url:'ExternalAgent/data/EgDispExtAgentsJson.jsp', 
				method:'POST'
			});
		}
	},
	items:[
		/*{
			xtype: 'component',
			cls:'adminHeadInfoText',
			html: '<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp'+extAddModPageDesc+'.</center>',
			width:'100%',
			height: 25,
			padding: 3
		},*/
		{
			xtype: 'container',
			layout: {
				type: 'vbox',
				align: 'center',
				pack: 'center'
			},
			defaults: {
				labelSeparator: '',
				margin: 5,
				width: 350,
				labelWidth: 150
			},
			margin: 20,
			items: [
				//{
					//xtype: 'textfield',
					//cls:'textbox',
					//fieldLabel: 'Host IP/Name',
					//id: 'Hostip',
					//afterLabelTextTpl:'<img data-qtip="'+ipMsg+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>'
				//},
				{
					xtype: 'fieldcontainer',
					fieldLabel: 'Host IP/Name',
					id : 'hostIpCt',
					layout: {
						type: 'column'
					},
					columnWidth: 1,
					items: [
						{
							xtype: 'textfield',
							id:'Hostip',
							name:'Hostip',
							cls:'textbox',
							columnWidth: 1
						},
						{
							xtype: 'label',
							id:'hostIpTip',
							html: '<img data-qtip="'+ipMsg+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>',
							labelSeparator: ''
						}
					]
				},
				{
					xtype: 'textfield',
					cls:'textbox',
					fieldLabel: 'Nick name',
					enforceMaxLength: true,
					maxLength: 32,
					id: 'Hostname',
					listeners: {
						'blur' : function(obj){
							var val = obj.getValue().toString().toLowerCase();
							if(val != null && val != undefined && val != "" && val == "none")
							{
								Ext.getCmp('client').hide();
								Ext.getCmp('remoteagent').hide();
							}
							else
							{
								Ext.getCmp('client').show();
								Ext.getCmp('remoteagent').show();
							}
						},
						'change' : function(obj){
							var val = obj.getValue().toString().toLowerCase();
							if(val != null && val != undefined && val != "" && val == "none")
							{
								Ext.getCmp('client').hide();
								Ext.getCmp('remoteagent').hide();
							}
							else
							{
								Ext.getCmp('client').show();
								Ext.getCmp('remoteagent').show();
							}
						}
					}
				},
				{
					xtype: 'textfield',
					cls:'textbox',
					fieldLabel: 'Location (Optional)',
					enforceMaxLength: true,
					maxLength: 32,
					hidden :locationFlag,
					id: 'zoneLocation'
				},
				{
					xtype: 'radiogroup',
					cls:'radiobt',
					fieldLabel: 'Client emulation',
					id: 'client',
					columns: 2,
					vertical: false,
					items: [
						{ boxLabel: 'Yes', name: 'rb1', inputValue: '1' ,id: 'clientemulyes'},
						{ boxLabel: 'No', name: 'rb1', inputValue: '2',id: 'clientemulno',checked: true}
					]
				},
				{
					xtype: 'radiogroup',
					cls:'radiobt',
					fieldLabel: ' Add as Remote agent',
					id: 'remoteagent',
					columns: 2,
					vertical: false,
					items: [
						{ boxLabel: 'Yes', name: 'rb2', inputValue: '1' ,id: 'remoteagentyes'},
						{ boxLabel: 'No', name: 'rb2', inputValue: '2',id: 'remoteagentno', checked: true}
					]
				},
				{
					xtype: 'button',
					cls:'button20',
					text: 'Update',
					id: 'UpdateBTN',
					width: 80
				}
			]
		}
	]
});



