Ext.define('ExternalAgent.view.FileUploadForm', {
	extend: 'Ext.FormPanel',
	alias: 'widget.fileuploadform',
	id: 'fileUploadForm',
	width:'100%',
	fileUpload : true,
	height: 200,
	resizable: false,
	draggable: false,
	modal: true,
	items: [{
			xtype: 'container',
			layout: {
				type: 'vbox',
				pack: 'center',
				align: 'center'
			},
			defaults:{
				labelSeparator: '',
				margin: 5,
				anchor: '100%',
				labelWidth: 220
			},
			margin: 10,
			items:[{
					xtype: 'radiogroup',
					fieldLabel: selActionLabel,
					cls: 'radiobt',
					id : 'bulkExtAgent',
					name : 'bulkExtAgent',
					columns: 3,
					vertical: true,
					listeners:{
						change:function(grp, newValue, oldValue, eOpts){
							if(newValue['actionType'] === 'delete'){
								Ext.get('chg_href').dom.href = '/final/servlet/com.egurkha.admin.EgCLIBulkActionController?downloadCSV=delExtAgentCSV';
							} else {
								Ext.get('chg_href').dom.href = '/final/servlet/com.egurkha.admin.EgCLIBulkActionController?downloadCSV=addExtAgentCSV';
							} 
						}
					},
					items: [
							{ 
							boxLabel: addLabel,
							labelAlign: 'top',
							name: 'actionType',
							id:'add',
							inputValue: 'add',
							checked: true
							},
							{ 
							boxLabel: deleteLabel,
							labelAlign: 'top',
							name: 'actionType',
							id:'delete',
							inputValue: 'delete'
							
							}
						],
					width: 480,
					labelWidth: 220
				},
				{
					xtype: 'fileuploadfield',
					cls: 'fileupload',
					fieldLabel: ChooseFileLabel,
					//allowBlank: false,
					buttonText: browsebtnLabel,
					name : 'FILE_0',
					id : 'FILE_0',
				},
				{
				xtype: 'component',
				margin:0,
				id:'chg_href',
				autoEl: {
					tag: 'a',
					id:'chg_href',
					href: '/final/servlet/com.egurkha.admin.EgCLIBulkActionController?downloadCSV=addExtAgentCSV',//Here we are changing url dynamically  
					html: '<span style="padding-left:90px"><u>'+downloadlinkLabel+'</u></span>'

					}
				}
			]},
			{
			xtype: 'container',
			layout: {
			type: 'hbox',
			pack: 'center'
			},
			margin: 20,
			items: [
				{
					xtype: 'button',
					text: uploadbtnLabel,
					id: 'fileUploadBtn',
					action:'bulkAgentAction',
					cls:'button20'
				}]
			}]
});



