Ext.define('GeoMapXML.controller.Main',{
	extend: 'Ext.app.Controller',
	refs:[
		{selector:'main', ref:'main'},
		{selector:'assignnetworklocation', ref:'assignnetworklocation'},
		{selector:'assignnetlocateditwindow', ref:'assignnetlocateditwindow'},
		{selector:'xmlactivities', ref:'xmlactivities'}
	],
	init:function(){
		me = this;
		appCnt = this;
		this.control({
			'main':
			{
				'afterrender': this.afterMainRender
			},
			'assignnetlocateditwindow button[itemId="assign"]':
			{
				'click': this.assignToAgentsFromEdit
			},
			'assignnetworklocation button[itemId="assign"]':
			{
				'click': this.assignToAgentsFromNew
			},
			'assignnetworklocation scrollcombo[itemId="xmlfiles"]':
			{
				'select': this.selectXMLFile
			},
			'assignnetworklocation scrollcombo[itemId="viewby"]':
			{
				'select': this.selectCategory
			},
			'assignnetworklocation scrollcombo[itemId="comptype"]':
			{
				'select': this.selectComponentType
			},
			'assignnetworklocation scrollcombo[itemId="selectiondatalist"]':
			{
				'select': this.selectAgent
			},
			'main scrollcombo[itemId="filterby"]':
			{
				'select': this.filterByCategory
			},
			'main scrollcombo[itemId="filtercomptype"]':
			{
				'select': this.filterByCompType
			},
			'main trigger[itemId="searchTrigger"]':
			{
				'change': this.filterGrid
			},
			'main  button[itemId="configureNwLocation"]':
			{
				'click': this.showXMLActivityWindow
			},
			'main  button[itemId="assignNetLocation"]':
			{
				'click': this.showANLocationWindow
			},
			//'main grid[id="netlocatemapgrid"]': {
				//'itemmouseenter': this.showActions,
				//'itemmouseleave': this.hideActions
			//},
			'xmlactivities  button[itemId="uploadNewXML"]':
			{
				'click': this.showUploadXMLWindow
			},
			'xmlactivities  button[itemId="mainBackBtn"]':
			{
				'click': this.gotoMainPage
			},
			'xmlactivities':
			{
				'afterrender': this.xmlActivityWindowRender
			}
		});
	},
	gotoMainPage: function(obj)
	{
		var homepage = obj.up('#viewPort');
		myMask = new Ext.LoadMask(homepage, {msg:"Loading..."});
		homepage.removeAll();
		myMask.show();
		homepage.add({ xtype : 'main' });
		myMask.hide();
	},
	showActions: function(view, task, node, rowIndex, e)
	{
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
		Ext.each(icons, function(icon){
			//Ext.get(icon).removeCls('x-hidden');
		});
	},
	hideActions: function(view, task, node, rowIndex, e)
	{
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
		Ext.each(icons, function(icon){
			//Ext.get(icon).addCls('x-hidden');
		});
	},
	handleXMLDataEditEvent: function(gridView,row,col)
	{
		gridObj = Ext.ComponentQuery.query('#xmldatagrid')[0];
		btnText = 'Edit';
		//var rec = gridObj.up('#xmldatagrid').getStore().getAt(row);
		var rec = gridObj.getStore().getAt(row);
		var locationName = rec.get('NwLocation');
		var existFileName = rec.get('XMLFiles');
		this.showXMLDataReuploadWindow(locationName,existFileName);
	},
	showXMLDataReuploadWindow: function(locationName,existFileName)
	{
		Ext.widget('window', {
						title: titleMsg,
						itemId: 'xmlfilewindow',
						padding:'5 10 10 10',
						resizable: 'false',
						modal: true,
						items: [
							{
								xtype: 'form',
								itemId: 'uploadform',
								url: '../servlet/com.eg.EgUploadServlet',
								params:{
									click:'reupload'
								},
								layout: {
									type: 'vbox',
									align: 'center'
								},
								items: [
									{
										xtype:'textfield',
										cls:'textbox',
										itemId: 'locationName',
										width: 300,
										labelAlign: 'top',
										fieldLabel : 'Name',
										labelSeparator: '',
										value: locationName,
										margin: 10
									},
									{
										xtype:'textfield',
										itemId: 'prevFileName',
										cls:'textbox',
										readOnly:true,
										width: 300,
										labelAlign: 'top',
										fieldLabel : 'Existing Geo location file',
										labelSeparator: '',
										value: existFileName,
										margin: 10
									},
									{
										xtype: 'fileuploadfield',
										cls: 'fileupload',
										itemId: 'file1',
										labelSeparator: '',
										emptyText: emptyMsg,
										fieldLabel: 'New Geo location file',
										labelAlign: 'top',
										width: 300,
										buttonText: 'Browse',
										margin: 10
									},
									{
										xtype: 'button',
										text: 'Reupload',
										itemId: 'upload',
										action: 'upload',
										cls: 'button20',
										align: 'center',
										margin: '20 10 20 10',
										width: 80,
										handler: function (button, e)
										{
											var locationObj = this.up('#uploadform').getComponent('locationName');
											var locationName =locationObj.getValue();
											var isDouble = publicJsonData['isDouble'];
											var survives = publicJsonData['existFileNames'];
											var survivesArr = new Array();
											survivesArr = survives.split(',');

											var formObj = Ext.ComponentQuery.query('#uploadform')[0];
											formObj.add({
												xtype: 'hidden',
												name: 'locationName',
												value: locationName
											});

											var fileObj = this.up('#uploadform').getComponent('file1');
											var fileName = fileObj.getValue();
											var fileExtXML = ".xml";
											var upload_XML = publicJsonData['uploadXML'];
											var isUpload = false;
											for (i = 0; i <= (fileName.length) - 1; i++)
											{
												if (isDouble == "false")
												{
													if(!validateSingleByte(filesel))
													{
														Ext.Msg.show({
															title: label15,
															msg: doubleByteAlert,
															width: doubleByteAlert.length * 7,
															buttons: Ext.Msg.OK,
															icon: 'iconExclamation'
														});
														return false;
													}
												}
												var isFileExt = true;
												if ((fileName.toLowerCase().indexOf(fileExtXML)) == -1)
												{
													if ((fileName.toLowerCase().indexOf(fileExtXML)) == -1)
													{
														isFileExt = false;
													}
												}

												if (!isFileExt)
												{
													Ext.Msg.show({
														title: label15,
														msg: fileexten,
														width: fileexten.length * 7,
														buttons: Ext.Msg.OK,
														icon: 'iconExclamation'
													});
													return false;
												}

												if (fileName[i].length > 0)
													isUpload = true;
											}
											if (isUpload)
											{
												if(upload_XML == "true")
												{
													filenameOnly="";
													if(fileName.indexOf("\\")> -1)
														filenameOnly = fileName.substring(fileName.lastIndexOf("\\")+1,fileName.length);
													else if(fileName.indexOf("/")> -1)
														filenameOnly = fileName.substring(fileName.lastIndexOf("/")+1,fileName.length);
													else
														filenameOnly = fileName;

													var exten_str="";
													var exten_idx = filenameOnly.lastIndexOf(".");
													if(exten_idx > 0)
														exten_str = filenameOnly.substring(exten_idx);
													exten_str = exten_str.toLowerCase();
													if((exten_str != ".txt" && exten_str != ".xml"))
													{
														Ext.Msg.show({
															title: label15,
															msg: fileexten,
															width: fileexten.length * 7,
															buttons: Ext.Msg.OK,
															icon: 'iconExclamation'
														});
															return false;
													}

													//var existingFileNames=publicJsonData['ExistingFiles'];
													var existingFileNames = publicJsonData['existNetworkXMLFiles'];
													var isAlreadyMapped = false;
													isAlreadyMapped = existingFileNames[locationName+':'+filenameOnly]

													//if((existingFileNames.indexOf(filenameOnly)!=-1))
													if(isAlreadyMapped)
													{
														var uploadformObj = this.up('#uploadform').getForm();
														Ext.Msg.show({
															title: label15,
															msg: "'"+filenameOnly+"' "+overWriteAlert,
															buttons: Ext.MessageBox.YESNO,
															icon: 'iconConfirmation',
															fn: function(response) {
																if (response != "yes")
																{
																	fileObj.reset();
																	return false;
																}
																else
																{
																	if (uploadformObj.isValid())
																	{
																		uploadformObj.submit({
																			method: 'POST',
																			success: function (form, action)
																			{
																				var jsonText = action.response.responseText;
																				publicJson = Ext.decode(jsonText);
																				if (!Ext.isEmpty(publicJson.uploadStatus) && publicJson.uploadStatus == 'true')
																				{
																					Ext.Msg.show({
																						title: label15,
																						msg: alert2,
																						width: 350,
																						buttons: Ext.Msg.OK,
																						icon: 'iconInformation',
																						fn: function() {
																							me.xmlActivityWindowRender();
																						}
																					});
																					button.up('.window').close();
																				}
																			},
																			failure: function (form, action) {
																				switch (action.failureType) {
																					case Ext.form.action.Action.CLIENT_INVALID:
																						Ext.Msg.show ({
																							title: label15,
																							msg: 'Form fields may not be submitted with invalid values',
																							buttons: Ext.MessageBox.OK,
																							icon: 'iconExclamation',
																						});
																						break;
																					case Ext.form.action.Action.CONNECT_FAILURE:
																						Ext.Msg.show ({
																							title: label15,
																							msg: 'Ajax communication failed',
																							buttons: Ext.MessageBox.OK,
																							icon: 'iconExclamation',
																						});
																						break;
																					case Ext.form.action.Action.SERVER_INVALID:
																						Ext.Msg.show ({
																							title: label15,
																							msg: action.result.msg,
																							buttons: Ext.MessageBox.OK,
																							icon: 'iconExclamation',
																						});
																				}
																			}
																		});
																	}
																}
															}
														});
													}
													else
													{
														var uploadform = this.up('#uploadform').getForm();
														if (uploadform.isValid())
														{
															uploadform.submit({
																success: function (form, action) {
																	Ext.Msg.show({
																		title: label15,
																		msg: alert2,
																		width: 350,
																		buttons: Ext.Msg.OK,
																		icon: 'iconInformation',
																		fn: function() {
																			me.xmlActivityWindowRender();
																		}
																	});
																	button.up('.window').close();
																},
																failure: function (form, action) {
																	switch (action.failureType) {
																		case Ext.form.action.Action.CLIENT_INVALID:
																			Ext.Msg.show ({
																				title: label15,
																				msg: 'Form fields may not be submitted with invalid values',
																				buttons: Ext.MessageBox.OK,
																				icon: 'iconExclamation',
																			});
																			break;
																		case Ext.form.action.Action.CONNECT_FAILURE:
																			Ext.Msg.show ({
																				title: label15,
																				msg: 'Ajax communication failed',
																				buttons: Ext.MessageBox.OK,
																				icon: 'iconExclamation',
																			});
																			break;
																		case Ext.form.action.Action.SERVER_INVALID:
																			Ext.Msg.show ({
																				title: label15,
																				msg: action.result.msg,
																				buttons: Ext.MessageBox.OK,
																				icon: 'iconExclamation',
																			});
																	}
																}
															});
														}
													}
												}
												else
												{
													var uploadform = this.up('#uploadform').getForm();
													if (uploadform.isValid())
													{
														uploadform.submit({
															success: function (form, action) {
																Ext.Msg.show({
																	title: label15,
																	msg: alert2,
																	width: 350,
																	buttons: Ext.Msg.OK,
																	icon: 'iconInformation',
																	fn: function() {
																		me.xmlActivityWindowRender();
																	}
																});
																button.up('.window').close();
															},
															failure: function (form, action) {
																switch (action.failureType) {
																	case Ext.form.action.Action.CLIENT_INVALID:
																		Ext.Msg.show ({
																			title: label15,
																			msg: 'Form fields may not be submitted with invalid values',
																			buttons: Ext.MessageBox.OK,
																			icon: 'iconExclamation',
																		});
																		break;
																	case Ext.form.action.Action.CONNECT_FAILURE:
																		Ext.Msg.show ({
																			title: label15,
																			msg: 'Ajax communication failed',
																			buttons: Ext.MessageBox.OK,
																			icon: 'iconExclamation',
																		});
																		break;
																	case Ext.form.action.Action.SERVER_INVALID:
																		Ext.Msg.show ({
																			title: label15,
																			msg: action.result.msg,
																			buttons: Ext.MessageBox.OK,
																			icon: 'iconExclamation',
																		});
																}
															}
														});
													}
												}
											}
											else
											{
												Ext.Msg.show({
													title: label15,
													msg: nofileselect,
													buttons: Ext.Msg.OK,
													icon: 'iconExclamation'
												});
												return false;
											}
										}
									}
								],
								listeners:
								{
									afterrender: function ()
									{
										 me.windowupload('reupload');
									}
								}
							}
						]
					}).show()
	},
	handleXMLDataDeleteEvent: function(grid, rowIndex, colIndex)
	{
		var DispValues = grid.getStore().getAt(rowIndex);
		var delXMLNames = DispValues.get('NwLocation');

		if (Ext.isEmpty(delXMLNames))
		{
			Ext.Msg.show({
				title: label15,
				msg: 'Please select any one data',
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}

		Ext.Msg.show({
			title: label15,
			msg: deleteConfirmAlert+" '"+delXMLNames+"' ?",
			width: deleteConfirmAlert.length * 12,
			buttons: Ext.MessageBox.YESNO,
			icon: 'iconConfirmation',
			fn: function(response) {
				if(response == 'yes')
				{
					var url = 'GeoMapXML/data/EgAssignGeoXmlToAgentsJsonp.jsp?from=deleteXML';
					Ext.Ajax.request({
						url: url,
						params: {
							selectedXMLs: delXMLNames
						},
						method: 'POST',
						scope: this,
						timeout:120000,
						success: function (response) 
						{
							if (response.status == 200 && !Ext.isEmpty(response.responseText)) 
							{
								var jsonDelData = Ext.decode(response.responseText);
								if (!Ext.isEmpty(jsonDelData.success) && jsonDelData.success)
								{
									Ext.Msg.show({
										title:label15,
										msg: alert4,
										icon:'iconInformation',
										buttons: Ext.Msg.OK,
										fn: function()
										{
											appCnt.xmlActivityWindowRender();
										}
									});
								}
							}
						},
						failure: function (form,action) {
							switch (action.failureType) {
								case Ext.form.action.Action.CLIENT_INVALID:
									Ext.Msg.show ({
										title: label15,
										msg: 'Form fields may not be submitted with invalid values',
										buttons: Ext.MessageBox.OK,
										icon: 'iconExclamation',
									});
									break;
								case Ext.form.action.Action.CONNECT_FAILURE:
									Ext.Msg.show ({
										title: label15,
										msg: 'Ajax communication failed',
										buttons: Ext.MessageBox.OK,
										icon: 'iconExclamation',
									});
									break;
								case Ext.form.action.Action.SERVER_INVALID:
									Ext.Msg.show ({
										title: label15,
										msg: action.result.msg,
										buttons: Ext.MessageBox.OK,
										icon: 'iconExclamation',
									});
							}
						}
					});
				}
			}
		});
	},
	handleDeleteIconClick: function(grid, rowIndex, colIndex)
	{
		var DispValues = grid.getStore().getAt(rowIndex);
		var deleteTypeName = DispValues.get('Type');
		var deleteOrgType = DispValues.get('OriginalTypeName');
		var deleteType = DispValues.get('OriginalType');
		var edit_delete = DispValues.get('edit_delete');

		if(edit_delete != undefined && !Ext.isEmpty(edit_delete) && (edit_delete == false || edit_delete == 'false'))
		{
			Ext.Msg.show ({
				title: 'WARNING',
				msg: 'User\'s are not allowed to edit/delete components from another service/segment/zone/remote Agent',
				buttons: Ext.MessageBox.OK,
				icon: 'iconExclamation',
			});
			return;
		}

		Ext.Msg.show({
			title: pageName,
			msg: deleteConfirmAlert1+" '"+deleteTypeName+"' ?",
			buttons: Ext.MessageBox.YESNO,
			icon: 'iconConfirmation',
			fn: function(response) {
				if(response == 'yes')
				{
					Ext.Ajax.request({
						url:'GeoMapXML/data/EgGeoXMLJson.jsp?action=delete&strTypeName='+deleteOrgType+"&type="+deleteType,
						method:'POST',
						async : false,
						scope:this,
						timeout:120000,
						success:function(response)
						{
							if (response.status == 200 && !Ext.isEmpty(response.responseText))
							{
								//isDeletedAssociations
								Ext.Msg.show({
									title: pageName,
									msg: alert1,
									buttons: Ext.Msg.OK,
									width: alert1.length * 7,
									icon: 'iconInformation',
									fn: function() {
										Ext.getCmp('filtercomptype').setVisible(false);
										me.afterMainRender();
									}
								});
							}
							
						}
					});
				}
			}
		});
	},
	handleXMLDataDeleteAllEvent: function(Obj)
	{
		var mainObj = Obj.up('#xmldatagrid');
		var grid = mainObj.getSelectionModel().getSelection();
		var values='';
		var locationNameArr=new Array();

		if(grid=="")
		{
			Ext.Msg.show({
				title: label15,
				msg: noDeleteNwLocateAlert,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}

		for(var i=0; i < grid.length ; i++)
		{
			values=grid[i];
			var locationName = values.get('NwLocation');
			if(locationName != null)
			{
				locationNameArr.push(locationName);
			}
		}

		if(locationNameArr != null && locationNameArr.length > 0 )
		{
			Ext.Msg.show({
				title: label15,
				msg: deleteMultipleConfirmAlert,
				buttons: Ext.MessageBox.YESNO,
				icon: 'iconConfirmation',
				fn: function(response) {
					if(response == 'yes')
					{
						var url = 'GeoMapXML/data/EgAssignGeoXmlToAgentsJsonp.jsp?from=deleteXML';
						Ext.Ajax.request({
							url: url,
							timeout:120000,
							params: {
								selectedXMLs: locationNameArr
							},
							method: 'POST',
							scope: this,
							success: function (response) 
							{
								if (response.status == 200 && !Ext.isEmpty(response.responseText)) 
								{
									var jsonDelData = Ext.decode(response.responseText);
									if (!Ext.isEmpty(jsonDelData.success) && jsonDelData.success)
									{
										Ext.Msg.show({
											title: label15,
											msg: alert5,
											width: 350,
											buttons: Ext.Msg.OK,
											icon: 'iconInformation',
											fn: function() {
												appCnt.xmlActivityWindowRender();
											}
										});
									}
								}
							},
							failure: function (form,action) 
							{
								switch (action.failureType) {
									case Ext.form.action.Action.CLIENT_INVALID:
										Ext.Msg.show ({
											title: label15,
											msg: 'Form fields may not be submitted with invalid values',
											buttons: Ext.MessageBox.OK,
											icon: 'iconExclamation',
										});
										break;
									case Ext.form.action.Action.CONNECT_FAILURE:
										Ext.Msg.show ({
											title: label15,
											msg: 'Ajax communication failed',
											buttons: Ext.MessageBox.OK,
											icon: 'iconExclamation',
										});
										break;
									case Ext.form.action.Action.SERVER_INVALID:
										Ext.Msg.show ({
											title: label15,
											msg: action.result.msg,
											buttons: Ext.MessageBox.OK,
											icon: 'iconExclamation',
										});
								}
							}
						});
					}
				}
			});
		}
	},
	handleDeleteSelected: function()
	{
		var mainObj = this.getMain();
		
		var grid = mainObj.down('#netlocatemapgrid').getSelectionModel().getSelection();
		var values='';
		var typeNameArray=new Array();
		var typeArray=new Array();
		var selectedData="";

		if(grid=="")
		{
			Ext.Msg.show({
				title: pageName,
				msg: noDeleteElementAlert,
				width:350,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}

		for(var i=0; i < grid.length ; i++)
		{
			values=grid[i];
			var typename = values.get('OriginalTypeName');
			var type = values.get('OriginalType');
			var edit_delete = values.get('edit_delete');

			if(edit_delete != undefined && !Ext.isEmpty(edit_delete) && (edit_delete == false || edit_delete == 'false'))
			{
				Ext.Msg.show ({
					title: 'WARNING',
					msg: 'User\'s are not allowed to edit/delete components from another service/segment/zone/remote Agent',
					buttons: Ext.MessageBox.OK,
					icon: 'iconExclamation',
				});
				return;
			}

			if(typename != null)
			{
				typeNameArray.push(typename);
			}
			if(type!=null)
			{
				typeArray.push(type);
			}
		}

		for(var j=0; j < typeNameArray.length; j++)
		{
			selectedData += typeNameArray[j]+"|sep|"+typeArray[j]+",";
		}

		if(selectedData != null && selectedData.length > 0 )
		{
			Ext.Msg.show({
				title: pageName,
				msg: deleteMultipleConfirmAlert,
				buttons: Ext.MessageBox.YESNO,
				icon: 'iconConfirmation',
				fn: function(response) {
					if(response == 'yes')
					{
						if(selectedData.length > 1)
						{
							selectedData = selectedData.substring(0,selectedData.length-1);
						}

						Ext.Ajax.request({
							url:'GeoMapXML/data/EgGeoXMLJson.jsp?action=deleteAll&strTypeAndNames='+selectedData,
							method:'POST',
							timeout:120000,
							async : false,
							scope:this,
							success:function(response)
							{
								Ext.Msg.show({
									title: pageName,
									msg: alert6,
									width: 350,
									buttons: Ext.Msg.OK,
									icon: 'iconInformation',
									fn: function() {
										Ext.getCmp('filtercomptype').setVisible(false);
										me.afterMainRender();
									}
								});
							},
							failure: function (form,action) 
							{
								switch (action.failureType) {
									case Ext.form.action.Action.CLIENT_INVALID:
										Ext.Msg.show ({
											title: pageName,
											msg: 'Form fields may not be submitted with invalid values',
											buttons: Ext.MessageBox.OK,
											icon: 'iconExclamation',
										});
										break;
									case Ext.form.action.Action.CONNECT_FAILURE:
										Ext.Msg.show ({
											title: pageName,
											msg: 'Ajax communication failed',
											buttons: Ext.MessageBox.OK,
											icon: 'iconExclamation',
										});
										break;
									case Ext.form.action.Action.SERVER_INVALID:
										Ext.Msg.show ({
											title: pageName,
											msg: action.result.msg,
											buttons: Ext.MessageBox.OK,
											icon: 'iconExclamation',
										});
								}
							}
						});
					}
				}
			});
		}
	},
	afterMainRender: function()
	{
		var searchVal = this.getMain().down('#searchTrigger').getValue();
		if (searchVal != null && !Ext.isEmpty(searchVal))
		{
			this.getMain().down('#searchTrigger').reset();
		}
		this.getMain().down('#searchTrigger').setDisabled(true);
		this.getMain().down('#netlocatemapgrid').hide();
		Ext.Ajax.request({
			url: 'GeoMapXML/data/EgGeoXMLJson.jsp?',
			method: 'POST',
			timeout:120000,
			scope: this,
			success: function(response)
			{
				if (response.status == 200 && !Ext.isEmpty(response.responseText)) 
				{
					var jsonText = response.responseText;
					publicJson = Ext.decode(jsonText);
					var isNoXMLFiles = publicJson['isNoXMLFiles'];
					this.getMain().down('#netlocatemapgrid').show();
					
					var gridXMLDataArr = publicJson['gridXMLDataArr'];
					var gridXMLDataCompArr = publicJson['gridXMLDataCompArr'];
					componentRawData = gridXMLDataArr;
					componentListRawData = gridXMLDataCompArr;
					var isDeleteButton = publicJson['isDeleteButton'];
					var isSearchBox = publicJson['isSearchBox'];
					this.getMain().down('#netlocatemapgrid').getStore().suspendEvents(true);
					this.getMain().down('#netlocatemapgrid').getStore().removeAll();
					this.getMain().down('#netlocatemapgrid').getStore().loadRawData(gridXMLDataArr);
					this.getMain().down('#netlocatemapgrid').getStore().resumeEvents();
					this.getMain().down('#netlocatemapgrid').getSelectionModel().deselectAll(true);
					if (!isNoXMLFiles)
					{
						this.getMain().down('#filterby').setDisabled(false);
						var filterAssociationArr = publicJson['associations'];
						var filterByValue = publicJson['filterby'];
						this.getMain().down('#filterby').getStore().suspendEvents(true);
						this.getMain().down('#filterby').getStore().removeAll();
						this.getMain().down('#filterby').getStore().loadRawData(filterAssociationArr);
						if (!Ext.isEmpty(filterByValue))
						{
							this.getMain().down('#filterby').setValue(filterByValue);
						}
						else
						{
							this.getMain().down('#filterby').setValue(filterAssociationArr[0].valueField);
						}
						this.getMain().down('#filterby').getStore().resumeEvents();

						this.getMain().down('#searchTrigger').setDisabled(false);
						//this.getMain().down('#netlocatemapgrid').getSelectionModel().deselectAll(true);
					}
					else
					{
						this.getMain().down('#filterby').setDisabled(true);
						this.getMain().down('#searchTrigger').setDisabled(true);
					}
				}
			},
			failure: function(form,action)
			{
				switch (action.failureType) {
					case Ext.form.action.Action.CLIENT_INVALID:
						Ext.Msg.show ({
							title: pageName,
							msg: 'Form fields may not be submitted with invalid values',
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation',
						});
						break;
					case Ext.form.action.Action.CONNECT_FAILURE:
						Ext.Msg.show ({
							title: pageName,
							msg: 'Ajax communication failed',
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation',
						});
						break;
					case Ext.form.action.Action.SERVER_INVALID:
						Ext.Msg.show ({
							title: pageName,
							msg: action.result.msg,
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation',
						});
				}
			}
		});
	},
	filterGrid : function()
    {
		var compStore = componentRawData;
		var mainObj = this.getMain();
		var xmlGridObj = mainObj.down('#netlocatemapgrid');
		var findVal = mainObj.down('#searchTrigger').getValue();
		var filterByValue = mainObj.down('#filterby').getValue();

		if (!Ext.isEmpty(filterByValue) && filterByValue.toLowerCase() == 'all')
		{
			if ( Ext.isEmpty( findVal) || findVal == undefined )
			{
				Ext.get('MyTrigger_0').setStyle('display','none');
				Ext.get('MyTrigger_1').setStyle('display','block');

				xmlGridObj.show();
				xmlGridObj.getStore().loadRawData(compStore);
				xmlGridObj.getSelectionModel().deselectAll(true);
			}
			else
			{
				Ext.get('MyTrigger_1').setStyle('display','none');
				Ext.get('MyTrigger_0').setStyle('display','block');

				var isRecordFound = false;
				var genStore = new Ext.data.Store({
										fields : ['Type','NwLocation','XMLFiles','OriginalTypeName','OriginalType','edit_delete'],
										data : []                                
									});
				for ( var i = 0; i < compStore.length ; i++ )
				{
					var getRecord = compStore[i]['Type'];

					if ( getRecord.toLowerCase().indexOf(findVal.toLowerCase()) > -1 )
					{
						isRecordFound = true;
						genStore.add({
							'Type': compStore[i]['Type'],
							'NwLocation': compStore[i]['NwLocation'],
							'XMLFiles': compStore[i]['XMLFiles'],
							'OriginalTypeName': compStore[i]['OriginalTypeName'],
							'OriginalType': compStore[i]['OriginalType'],
							'edit_delete': compStore[i]['edit_delete'],
						});
					}
				}
				if ( isRecordFound )
				{
					xmlGridObj.getStore().removeAll();  
					for ( var i = 0; i < genStore.getCount() ; i++ )
					{
						var getRecord = genStore.getAt(i);
						xmlGridObj.getStore().add(getRecord);
					}
					xmlGridObj.getSelectionModel().deselectAll(true);
					xmlGridObj.show();
				}
				else
				{
					xmlGridObj.getStore().removeAll();
					xmlGridObj.store.loadData('');
					xmlGridObj.getView().emptyText = '<table align="center"><tr><td align="center" height="350"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+NoXMLAssignedDataSearch+'.</td></tr></table></td></tr></table>';
					xmlGridObj.getView().refresh();
				}
			}
		}
		else if (!Ext.isEmpty(filterByValue) && filterByValue.toLowerCase() == 'independent servers')
		{
			var filterCompType = mainObj.down('#filtercomptype').getValue();
			var isRecordFound = false;
			var genStore = new Ext.data.Store({
							fields : ['Type','NwLocation','XMLFiles','OriginalTypeName','OriginalType','edit_delete'],
							data : []                                
						});

			if ( Ext.isEmpty( findVal) || findVal == undefined )
			{
				Ext.get('MyTrigger_0').setStyle('display','none');
				Ext.get('MyTrigger_1').setStyle('display','block');

				if (!Ext.isEmpty(filterCompType) && filterCompType.toLowerCase() == 'all')
				{
					for ( var i = 0; i < compStore.length ; i++ )
					{
						var OriginalType = compStore[i]['OriginalType'];
						if (filterByValue == OriginalType)
						{
							isRecordFound = true;
							genStore.add({
								'Type': compStore[i]['Type'],
								'NwLocation': compStore[i]['NwLocation'],
								'XMLFiles': compStore[i]['XMLFiles'],
								'OriginalTypeName': compStore[i]['OriginalTypeName'],
								'OriginalType': compStore[i]['OriginalType'],
								'edit_delete': compStore[i]['edit_delete'],
							});
						}
					}
				}
				else if (!Ext.isEmpty(filterCompType))
				{
					for ( var i = 0; i < compStore.length ; i++ )
					{
						var OriginalType = compStore[i]['OriginalType'];
						var OriginalTypeName = compStore[i]['OriginalTypeName'];
						var comptype = OriginalTypeName.substring(0,OriginalTypeName.indexOf(":"));

						if (filterByValue == OriginalType && comptype == filterCompType)
						{
							isRecordFound = true;
							genStore.add({
								'Type': compStore[i]['Type'],
								'NwLocation': compStore[i]['NwLocation'],
								'XMLFiles': compStore[i]['XMLFiles'],
								'OriginalTypeName': compStore[i]['OriginalTypeName'],
								'OriginalType': compStore[i]['OriginalType'],
								'edit_delete': compStore[i]['edit_delete'],
							});
						}
					}
				}
			} 
			else
			{
				Ext.get('MyTrigger_1').setStyle('display','none');
				Ext.get('MyTrigger_0').setStyle('display','block');

				if (!Ext.isEmpty(filterCompType) && filterCompType.toLowerCase() == 'all')
				{
					for ( var i = 0; i < compStore.length ; i++ )
					{
						var getRecord = compStore[i]['Type'];
						var OriginalType = compStore[i]['OriginalType'];
						if (!Ext.isEmpty(getRecord) && getRecord.indexOf("(") != -1)
						{
							getRecord = getRecord.substring(0,getRecord.lastIndexOf("("));
						}

						if (filterByValue == OriginalType && getRecord.toLowerCase().indexOf(findVal.toLowerCase()) > -1 )
						{
							isRecordFound = true;
							genStore.add({
								'Type': compStore[i]['Type'],
								'NwLocation': compStore[i]['NwLocation'],
								'XMLFiles': compStore[i]['XMLFiles'],
								'OriginalTypeName': compStore[i]['OriginalTypeName'],
								'OriginalType': compStore[i]['OriginalType'],
								'edit_delete': compStore[i]['edit_delete'],
							});
						}
					}
				}
				else if (!Ext.isEmpty(filterCompType))
				{
					for ( var i = 0; i < compStore.length ; i++ )
					{
						var getRecord = compStore[i]['Type'];
						var OriginalTypeName = compStore[i]['OriginalTypeName'];
						var OriginalType = compStore[i]['OriginalType'];
						var comptype = OriginalTypeName.substring(0,OriginalTypeName.indexOf(":"));
						if (!Ext.isEmpty(getRecord) && getRecord.indexOf("(") != -1)
						{
							getRecord = getRecord.substring(0,getRecord.lastIndexOf("("));
						}


						if (filterByValue == OriginalType && comptype == filterCompType && getRecord.toLowerCase().indexOf(findVal.toLowerCase()) > -1 )
						{
							isRecordFound = true;
							genStore.add({
								'Type': compStore[i]['Type'],
								'NwLocation': compStore[i]['NwLocation'],
								'XMLFiles': compStore[i]['XMLFiles'],
								'OriginalTypeName': compStore[i]['OriginalTypeName'],
								'OriginalType': compStore[i]['OriginalType'],
								'edit_delete': compStore[i]['edit_delete'],
							});
						}
					}
				}
			}

			if ( isRecordFound )
			{
				xmlGridObj.getStore().removeAll();  
				for ( var i = 0; i < genStore.getCount() ; i++ )
				{
					var getRecord = genStore.getAt(i);
					xmlGridObj.getStore().add(getRecord);
				}
				xmlGridObj.getSelectionModel().deselectAll(true);
				xmlGridObj.show();
			}
			else
			{
				xmlGridObj.getStore().removeAll();
				xmlGridObj.store.loadData('');
				xmlGridObj.getView().emptyText = '<table align="center"><tr><td align="center" height="350"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+NoXMLAssignedDataSearch+'.</td></tr></table></td></tr></table>';
				xmlGridObj.getView().refresh();
			}
		}
		else if (!Ext.isEmpty(filterByValue))
		{
			var genStore = new Ext.data.Store({
								fields : ['Type','NwLocation','XMLFiles','OriginalTypeName','OriginalType','edit_delete'],
								data : []                                
							});

			var isRecordFound = false;

			if ( Ext.isEmpty( findVal) || findVal == undefined )
			{
				Ext.get('MyTrigger_0').setStyle('display','none');
				Ext.get('MyTrigger_1').setStyle('display','block');

				//xmlGridObj.show();
				//xmlGridObj.getStore().loadRawData(compStore);
				//xmlGridObj.getSelectionModel().deselectAll(true);

				for ( var i = 0; i < compStore.length ; i++ )
				{
					var OriginalType = compStore[i]['OriginalType'];
					if ( filterByValue == OriginalType)
					{
						isRecordFound = true;
						genStore.add({
							'Type': compStore[i]['Type'],
							'NwLocation': compStore[i]['NwLocation'],
							'XMLFiles': compStore[i]['XMLFiles'],
							'OriginalTypeName': compStore[i]['OriginalTypeName'],
							'OriginalType': compStore[i]['OriginalType'],
							'edit_delete': compStore[i]['edit_delete'],
						});
					}
				}
			}
			else
			{
				Ext.get('MyTrigger_1').setStyle('display','none');
				Ext.get('MyTrigger_0').setStyle('display','block');

				for ( var i = 0; i < compStore.length ; i++ )
				{
					var getRecord = compStore[i]['Type'];
					if (!Ext.isEmpty(getRecord) && getRecord.indexOf("(") != -1)
					{
						getRecord = getRecord.substring(0,getRecord.lastIndexOf("("));
					}
					var OriginalType = compStore[i]['OriginalType'];
					if (filterByValue == OriginalType && getRecord.toLowerCase().indexOf(findVal.toLowerCase()) > -1 )
					{
						isRecordFound = true;
						genStore.add({
							'Type': compStore[i]['Type'],
							'NwLocation': compStore[i]['NwLocation'],
							'XMLFiles': compStore[i]['XMLFiles'],
							'OriginalTypeName': compStore[i]['OriginalTypeName'],
							'OriginalType': compStore[i]['OriginalType'],
							'edit_delete': compStore[i]['edit_delete'],
						});
					}
				}
			}

			if ( isRecordFound )
			{
				xmlGridObj.getStore().removeAll();  
				for ( var i = 0; i < genStore.getCount() ; i++ )
				{
					var getRecord = genStore.getAt(i);
					xmlGridObj.getStore().add(getRecord);
				}
				xmlGridObj.getSelectionModel().deselectAll(true);
				xmlGridObj.show();
			}
			else
			{
				xmlGridObj.getStore().removeAll();
				xmlGridObj.store.loadData('');
				xmlGridObj.getView().emptyText = '<table align="center"><tr><td align="center" height="350"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+NoXMLAssignedDataSearch+'.</td></tr></table></td></tr></table>';
				xmlGridObj.getView().refresh();
			}
		}
		
	},
	xmlDataGridFilter : function(obj)
    {
		var compStore = publicJsonData.gridXMLDataArr;
		var mainObj = obj.up("#xmlactivitiesform");
		var xmlGridObj = mainObj.down('#xmldatagrid');
		var findVal = mainObj.down('#nwlocationFetch').getValue();

		if ( Ext.isEmpty( findVal) || findVal == undefined )
		{
			Ext.get('XMLTrigger_0').setStyle('display','none');
			Ext.get('XMLTrigger_1').setStyle('display','block');

			xmlGridObj.show();
			xmlGridObj.getStore().loadRawData(compStore);
			xmlGridObj.getSelectionModel().deselectAll(true);
		}
		else
		{
			Ext.get('XMLTrigger_1').setStyle('display','none');
			Ext.get('XMLTrigger_0').setStyle('display','block');

			var isRecordFound = false;
			var genStore = new Ext.data.Store({
									fields : ['NwLocation','XMLFiles'],
									data : []                                
								});
			for ( var i = 0; i < compStore.length ; i++ )
			{
				var getRecord = compStore[i]['NwLocation'];
				if ( getRecord.toLowerCase().indexOf(findVal.toLowerCase()) > -1 )
				{
					isRecordFound = true;
					genStore.add({
						'NwLocation': compStore[i]['NwLocation'],
						'XMLFiles': compStore[i]['XMLFiles']
					});
				}
			}
			if ( isRecordFound )
			{
				xmlGridObj.getStore().removeAll();  
				for ( var i = 0; i < genStore.getCount() ; i++ )
				{
					var getRecord = genStore.getAt(i);
					xmlGridObj.getStore().add(getRecord);
				}
				xmlGridObj.getSelectionModel().deselectAll(true);
				xmlGridObj.show();
			}
			else
			{
				xmlGridObj.getStore().removeAll();
				xmlGridObj.store.loadData('');
				xmlGridObj.getView().emptyText = '<table align="center"><tr><td align="center" height="350"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+NoXMLAssignedDataSearch+'.</td></tr></table></td></tr></table>';
				xmlGridObj.getView().refresh();
			}
		}
	},
	showUploadXMLWindow: function()
	{
		var url = 'GeoMapXML/data/EgXMLFileUpload.jsp?page=EgXMLFileUpload';
		Ext.Ajax.request({
			url: url,
			timeout:120000,
			method: 'POST',
			scope: this,
			success: function (response) {
				if (response.status == 200 && !Ext.isEmpty(response.responseText)) {
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					publicJsonData = jsonData;
					Ext.widget('window', {
						title: titleMsg,
						itemId: 'xmlfilewindow',
						padding:'5 10 10 10',
						resizable: 'false',
						modal: true,
						items: [
							{
								xtype: 'form',
								itemId: 'uploadform',
								url: '../servlet/com.eg.EgUploadServlet',
								params:{
									click:'upload'
								},
								layout: {
									type: 'vbox',
									align: 'center'
								},
								items: [
									{
										xtype: 'textfield',
										cls:'textbox',
										itemId: 'locationName',
										labelSeparator: '',
										fieldLabel: 'Name',
										labelAlign: 'top',
										width: 300,
										margin: 10,
										listeners:{
											'blur':function(el){
												var s_spl = "`~!@#$%^&*()+={}[]|\\:;\"\'<>,?\/";
												try
												{
													var text = el.getValue();
													for(count = 0; count < text.length; count++)
													{
														var check_char = s_spl.indexOf(text.charAt(count));
														if(check_char >= 0)
														{
															Ext.Msg.show({
																title : 'Network Location',
																msg : 'special characters not allowed.',
																icon : 'iconExclamation',
																buttons : Ext.Msg.OK,
																fn : function()
																{
																	el.setValue('');
																}
															});
															return false;
														}
													}
												}
												catch (e)
												{
												}
											}
										}
									},
									{
										xtype: 'fileuploadfield',
										cls: 'fileupload',
										itemId: 'file1',
										labelSeparator: '',
										emptyText: emptyMsg,
										fieldLabel: 'Geo location file',
										labelAlign: 'top',
										width: 300,
										buttonText: 'Browse',
										margin: 10
									},
									{
										xtype: 'container',
										margin:0,
										id:'chg_href',
										html: '<span style="padding-left:180px"><b><u>Download sample XML</u></b></span>',
										autoEl: {
											tag: 'a',
											href: '/final/servlet/com.egurkha.admin.EgCLIBulkActionController?downloadCSV=SampXml',//Here we are changing url dynamically  											
										}										
									},
									{
										xtype: 'button',
										text: label5,
										itemId: 'upload',
										action: 'upload',
										cls: 'button20',
										align: 'center',
										width: 60,
										margin: '20 10 20 10',
										handler: function (button, e)
										{
											var locationObj = this.up('#uploadform').getComponent('locationName');
											var locationName =locationObj.getValue();
											var isDouble = publicJsonData['isDouble'];
											var gridXMLDataArr = publicJsonData['gridXMLDataArr'];
											var fileObj = this.up('#uploadform').getComponent('file1');
											var fileName = fileObj.getValue();
											var survives = publicJsonData['existFileNames'];
											var survivesArr = new Array();
											survivesArr = survives.split(',');
											if (Ext.isEmpty(locationName))
											{
												Ext.Msg.show({
													title: label15,
													msg: _checkempty,
													buttons: Ext.Msg.OK,
													icon: 'iconExclamation',
													fn: function()
													{
														locationObj.focus(true);
													}
												});
												return false;
											}

											if (!Ext.isEmpty(locationName))
											{
												if (isDouble == "false")
												{
													if(!validateSingleByte(locationName))
													{
														Ext.Msg.show({
															title: label15,
															msg: doubleByteAlert,
															width: doubleByteAlert.length * 7,
															buttons: Ext.Msg.OK,
															icon: 'iconExclamation',
															fn: function()
															{
																locationObj.focus(true);
															}
														});
														return false;
													}
												}
												else if(!Ext.isEmpty(survivesArr))
												{
													for(var s=0;s<survivesArr.length;s++)
													{
														var strSurviveName = survivesArr[s].trim();
														if (strSurviveName == locationName)
														{
															Ext.Msg.show({
																title: label15,
																msg: existNetworkLocationName,
																width: existNetworkLocationName.length * 7,
																buttons: Ext.Msg.OK,
																icon: 'iconExclamation',
																fn: function()
																{
																	locationObj.focus(true);
																}
															});
															return false;
														}
													}
												}
											}
											
											if(!Ext.isEmpty(gridXMLDataArr))
											{
												try
												{
													fileName = fileName.trim();
													for (var a in gridXMLDataArr )
													{
														var f_n = gridXMLDataArr[a].XMLFiles;
														if (f_n == fileName )
														{
															Ext.Msg.show({	
																title: label15,
																msg: existNetworkFileName,
																width: existNetworkFileName.length * 7,
																buttons: Ext.Msg.OK,
																icon: 'iconExclamation',
																fn: function()
																{
																	locationObj.focus(true);
																}
															});
															return false;
														}
													}
												}
												catch (r)
												{
												}
												
											}

											var formObj = Ext.ComponentQuery.query('#uploadform')[0];
											formObj.add({
												xtype: 'hidden',
												name: 'locationName',
												value: locationName
											});

											var fileObj = this.up('#uploadform').getComponent('file1');
											var fileName = fileObj.getValue();
											var fileExtXML = ".xml";
											var upload_XML = publicJsonData['uploadXML'];
											var isUpload = false;
											for (i = 0; i <= (fileName.length) - 1; i++)
											{
												if (isDouble == "false")
												{
													if(!validateSingleByte(filesel))
													{
														Ext.Msg.show({
															title: label15,
															msg: doubleByteAlert,
															width: doubleByteAlert.length * 7,
															buttons: Ext.Msg.OK,
															icon: 'iconExclamation'
														});
														return false;
													}
												}
												var isFileExt = true;
												if ((fileName.toLowerCase().indexOf(fileExtXML)) == -1)
												{
													if ((fileName.toLowerCase().indexOf(fileExtXML)) == -1)
													{
														isFileExt = false;
													}
												}

												if (!isFileExt)
												{
													Ext.Msg.show({
														title: label15,
														msg: fileexten,
														width: fileexten.length * 7,
														buttons: Ext.Msg.OK,
														icon: 'iconExclamation'
													});
													return false;
												}

												if (fileName[i].length > 0)
													isUpload = true;
											}
											if (isUpload)
											{
												if(upload_XML == "true")
												{
													filenameOnly="";
													if(fileName.indexOf("\\")> -1)
														filenameOnly = fileName.substring(fileName.lastIndexOf("\\")+1,fileName.length);
													else if(fileName.indexOf("/")> -1)
														filenameOnly = fileName.substring(fileName.lastIndexOf("/")+1,fileName.length);
													else
														filenameOnly = fileName;

													var exten_str="";
													var exten_idx = filenameOnly.lastIndexOf(".");
													if(exten_idx > 0)
														exten_str = filenameOnly.substring(exten_idx);
													exten_str = exten_str.toLowerCase();
													if((exten_str != ".txt" && exten_str != ".xml"))
													{
														Ext.Msg.show({
															title: label15,
															msg: fileexten,
															width: fileexten.length * 7,
															buttons: Ext.Msg.OK,
															icon: 'iconExclamation'
														});
															return false;
													}

													var uploadform = this.up('#uploadform').getForm();
													if (uploadform.isValid())
													{
														uploadform.submit({
															success: function (form, action) {
																Ext.Msg.show({
																	title: label15,
																	msg: alert2,
																	width: 350,
																	buttons: Ext.Msg.OK,
																	icon: 'iconInformation',
																	fn: function() {
																		me.xmlActivityWindowRender();
																	}
																});
																button.up('.window').close();
															},
															failure: function (form, action) {
																switch (action.failureType) {
																	case Ext.form.action.Action.CLIENT_INVALID:
																		Ext.Msg.show ({
																			title: label15,
																			msg: 'Form fields may not be submitted with invalid values',
																			buttons: Ext.MessageBox.OK,
																			icon: 'iconExclamation',
																		});
																		break;
																	case Ext.form.action.Action.CONNECT_FAILURE:
																		Ext.Msg.show ({
																			title: label15,
																			msg: 'Ajax communication failed',
																			buttons: Ext.MessageBox.OK,
																			icon: 'iconExclamation',
																		});
																		break;
																	case Ext.form.action.Action.SERVER_INVALID:
																		Ext.Msg.show ({
																			title: label15,
																			msg: action.result.msg,
																			buttons: Ext.MessageBox.OK,
																			icon: 'iconExclamation',
																		});
																}
															}
														});
													}
												}
												else
												{
													var uploadform = this.up('#uploadform').getForm();
													if (uploadform.isValid())
													{
														uploadform.submit({
															success: function (form, action) {
																Ext.Msg.show({
																	title: label15,
																	msg: alert2,
																	width: 350,
																	buttons: Ext.Msg.OK,
																	icon: 'iconInformation',
																	fn: function() {
																		me.xmlActivityWindowRender();
																	}
																});
																button.up('.window').close();
															},
															failure: function (form, action) {
																switch (action.failureType) {
																	case Ext.form.action.Action.CLIENT_INVALID:
																		Ext.Msg.show ({
																			title: label15,
																			msg: 'Form fields may not be submitted with invalid values',
																			buttons: Ext.MessageBox.OK,
																			icon: 'iconExclamation',
																		});
																		break;
																	case Ext.form.action.Action.CONNECT_FAILURE:
																		Ext.Msg.show ({
																			title: label15,
																			msg: 'Ajax communication failed',
																			buttons: Ext.MessageBox.OK,
																			icon: 'iconExclamation',
																		});
																		break;
																	case Ext.form.action.Action.SERVER_INVALID:
																		Ext.Msg.show ({
																			title: label15,
																			msg: action.result.msg,
																			buttons: Ext.MessageBox.OK,
																			icon: 'iconExclamation',
																		});
																}
															}
														});
													}
												}
											}
											else
											{
												Ext.Msg.show({
													title: label15,
													msg: nofileselect,
													buttons: Ext.Msg.OK,
													icon: 'iconExclamation'
												});
												return false;
											}
										}
									}
								],
								listeners: {
									afterrender: function () {
										me.windowupload('upload');
									}
								}
							}
						]
					}).show()
				}
			}
		});
	},
	showXMLActivityWindow: function(obj)
	{
		var viewportObj = obj.up('#viewPort');
		viewportObj.removeAll();
		viewportObj.add({
			xtype:'xmlactivities'
		});
	},
	xmlActivityWindowRender: function () 
	{
		var me = Ext.ComponentQuery.query('#xmlactivitiesform')[0];
		var a = me.getForm();

		var xmlDataGridObj = me.down("#xmldatagrid");
		var xmlFecthObj = me.down("#nwlocationFetch");
		xmlFecthObj.setDisabled(true);

		var url = 'GeoMapXML/data/EgXMLFileUpload.jsp?page=EgXMLFileUpload';
		Ext.Ajax.request({
			url: url,
			method: 'POST',
			scope: this,
			timeout:120000,
			success: function (response) 
			{
				if (response.status == 200 && !Ext.isEmpty(response.responseText)) 
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					publicJsonData = jsonData;
					var gridXMLDataArr = publicJsonData.gridXMLDataArr;

					xmlDataGridObj.getStore().removeAll();
					if (!Ext.isEmpty(gridXMLDataArr))
					{
						xmlFecthObj.setDisabled(false);
						var xmlFecth = xmlFecthObj.getValue();
						if (!Ext.isEmpty(xmlFecth))
						{
							xmlFecthObj.reset();
						}
						xmlDataGridObj.getStore().loadRawData(gridXMLDataArr);
					}
					xmlDataGridObj.getSelectionModel().deselectAll(true);
				}
			},
			failure: function (form,action) 
			{
				switch (action.failureType) {
					case Ext.form.action.Action.CLIENT_INVALID:
						Ext.Msg.show ({
							title: label15,
							msg: 'Form fields may not be submitted with invalid values',
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation',
						});
						break;
					case Ext.form.action.Action.CONNECT_FAILURE:
						Ext.Msg.show ({
							title: label15,
							msg: 'Ajax communication failed',
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation',
						});
						break;
					case Ext.form.action.Action.SERVER_INVALID:
						Ext.Msg.show ({
							title: label15,
							msg: action.result.msg,
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation',
						});
				}
			}
		});
	},
	windowupload: function (from) 
	{
		var me = Ext.ComponentQuery.query('#uploadform')[0];
		var a = me.getForm();
		var prevFileNameObj = me.down("#prevFileName");

		if (!Ext.isEmpty(from))
		{
			me.add({
				xtype: 'hidden',
				name: 'click',
				value: from
			});
		}

		if (!Ext.isEmpty(prevFileNameObj))
		{
			me.add({
				xtype: 'hidden',
				name: 'prevFileName',
				value: prevFileNameObj.getValue()
			});
		}
		var hiddenParams = publicJsonData.hiddenParams;
		for (var hiddenParam in hiddenParams) {
			if (!a.findField("'" + hiddenParam + "'")) {
				me.add({
					xtype: 'hidden',
					name: hiddenParam,
					value: hiddenParams[hiddenParam]
				});
			} else {
				a.findField("'" + hiddenParam + "'")
					.setValue(hiddenParams[hiddenParam]);
			}
		}
	},
	showANLocationWindow: function () 
	{
		Ext.widget('window', {
			title: 'Assign Elements To Network Location',
			width: '720px',
			height: '350px',
			padding:'5 10 10 10',
			modal: true,
			items: [
				{
					xtype: 'assignnetworklocation'
				}
			],
			listeners: {
				afterrender: function() {
					me.assignNLWindowRender();
				}
			}
		}).show();

		var formObj = this.getAssignnetworklocation();
		var viewByObj = formObj.down('#viewby');
		var selectionDataObj = formObj.down('#selectiondatalist');

		var xmlFilesObj = formObj.down('#xmlfiles');
		if (selectionDataObj.fromField.store.getCount() > 0)
		{
			selectionDataObj.fromField.store.removeAll();
		}

		if (selectionDataObj.toField.store.getCount() > 0)
		{
			selectionDataObj.toField.store.removeAll();
		}

		var assignBtnObj = formObj.down('#assign');
		var viewByStoreData = publicAssignJson.associations;
		var XMLDataFieldArr = publicAssignJson.XMLDataFieldArr;
		if (!Ext.isEmpty(viewByStoreData))
		{
			viewByObj.getStore().loadRawData(viewByStoreData);
			viewByObj.setValue(viewByStoreData[0].valueField);
		}

		if (!Ext.isEmpty(XMLDataFieldArr))
		{
			xmlFilesObj.getStore().loadRawData(XMLDataFieldArr);
			xmlFilesObj.setValue(XMLDataFieldArr[0].valueField);
		}
		assignBtnObj.setDisabled(true);
	},
	assignNLWindowRender: function()
	{
		Ext.Ajax.request({
			url:'GeoMapXML/data/EgAssignGeoXmlToAgentsJson.jsp?from=new',
			method:'POST',
			async : false,
			timeout:120000,
			scope:this,
			success:function(response)
			{
				if (response.status == 200 && !Ext.isEmpty(response.responseText)) 
				{
					var jsonText = response.responseText;
					publicAssignJson = Ext.decode(jsonText);
				}
			},
			failure: function (form,action) 
			{
				switch (action.failureType) {
					case Ext.form.action.Action.CLIENT_INVALID:
						Ext.Msg.show ({
							title: label15,
							msg: 'Form fields may not be submitted with invalid values',
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation',
						});
						break;
					case Ext.form.action.Action.CONNECT_FAILURE:
						Ext.Msg.show ({
							title: label15,
							msg: 'Ajax communication failed',
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation',
						});
						break;
					case Ext.form.action.Action.SERVER_INVALID:
						Ext.Msg.show ({
							title: label15,
							msg: action.result.msg,
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation',
						});
				}
			}
		});
	},
	selectCategory: function()
	{
		var formObj = this.getAssignnetworklocation();
		var viewBy = formObj.down('#viewby').getValue();
		var xmlFileName = formObj.down('#xmlfiles').getValue();

		var selectionDataObj = formObj.down('#selectiondatalist');
		if (selectionDataObj.fromField.store.getCount() > 0)
		{
			selectionDataObj.fromField.store.removeAll();
		}

		if (selectionDataObj.toField.store.getCount() > 0)
		{
			selectionDataObj.toField.store.removeAll();
		}

		var viewByDisplayValue = formObj.down('#viewby').getDisplayValue();
		var compTypeObj = formObj.down('#comptype');
		formObj.down('#assign').setDisabled(true);
		Ext.Ajax.request({
			url:'GeoMapXML/data/EgAssignGeoXmlToAgentsJson.jsp?from=new&associate='+viewBy+'&xmlfile='+xmlFileName,
			method:'POST',
			timeout:120000,
			async : false,
			scope:this,
			success:function(response)
			{
				if (response.status == 200 && !Ext.isEmpty(response.responseText)) 
				{
					var jsonText = response.responseText;
					publicAssignJson = Ext.decode(jsonText);
					var associate = publicAssignJson.associate;

					if (!Ext.isEmpty(associate) && associate.toLowerCase() == 'independent servers')
					{
						var componentTypes = publicAssignJson.componentTypes;
						compTypeObj.show();
						if (!Ext.isEmpty(componentTypes))
						{
							compTypeObj.setFieldLabel("Component type");
							compTypeObj.getStore().loadRawData(componentTypes);
							compTypeObj.setValue(componentTypes[0].valueField);
						}
					}
					else
					{
						compTypeObj.hide();
						var selectionData = publicAssignJson.elements;
						if (!Ext.isEmpty(selectionData))
						{
							selectionDataObj.show();
							//selectionDataObj.getStore().loadRawData(selectionData);
							//selectionDataObj.setValue(selectionData[0].valueField);

							var elementsDatatoFieldArr = publicAssignJson.elementsDatatoFieldArr;
							var elementsDatafromFieldArr = publicAssignJson.elementsDatafromFieldArr;

							formObj.down('#assign').setDisabled(false);

							if (!Ext.isEmpty(elementsDatafromFieldArr))
							{
								selectionDataObj.fromField.store.add(elementsDatafromFieldArr);
							}

							if (!Ext.isEmpty(elementsDatatoFieldArr))
							{
								selectionDataObj.toField.store.add(elementsDatatoFieldArr);
							}
						}
					}
				}
			}
		});
	},
	selectXMLFile: function()
	{
		var formObj = this.getAssignnetworklocation();
		var viewBy = formObj.down('#viewby').getValue();
		var xmlFileName = formObj.down('#xmlfiles').getValue();

		var selectionDataObj = formObj.down('#selectiondatalist');
		if (selectionDataObj.fromField.store.getCount() > 0)
		{
			selectionDataObj.fromField.store.removeAll();
		}

		if (selectionDataObj.toField.store.getCount() > 0)
		{
			selectionDataObj.toField.store.removeAll();
		}

		var viewByObj = formObj.down('#viewby');
		var compTypeObj = formObj.down('#comptype');
		if (compTypeObj.store.getCount() > 0)
		{
			compTypeObj.getStore().removeAll();
		}
		compTypeObj.hide();

		formObj.down('#assign').setDisabled(true);

		Ext.Ajax.request({
			url:'GeoMapXML/data/EgAssignGeoXmlToAgentsJson.jsp?from=new&xmlfile='+xmlFileName,
			method:'POST',
			timeout:120000,
			async : false,
			scope:this,
			success:function(response)
			{
				if (response.status == 200 && !Ext.isEmpty(response.responseText)) 
				{
					var jsonText = response.responseText;
					publicAssignJson = Ext.decode(jsonText);
					var xmlFileName = publicAssignJson.xmlFileName;
					var viewByStoreData = publicAssignJson.associations;

					if (!Ext.isEmpty(viewByStoreData))
					{
						viewByObj.getStore().loadRawData(viewByStoreData);
						viewByObj.setValue(viewByStoreData[0].valueField);
					}

				}
			}
		});
	},
	selectComponentType: function()
	{
		var formObj = this.getAssignnetworklocation();
		var viewBy = formObj.down('#viewby').getValue();
		var comptype = formObj.down('#comptype').getValue();

		var xmlFileName = formObj.down('#xmlfiles').getValue();

		var selectionDataObj = formObj.down('#selectiondatalist');
		if (selectionDataObj.fromField.store.getCount() > 0)
		{
			selectionDataObj.fromField.store.removeAll();
		}

		if (selectionDataObj.toField.store.getCount() > 0)
		{
			selectionDataObj.toField.store.removeAll();
		}

		var viewByDisplayValue = formObj.down('#comptype').getDisplayValue();
		formObj.down('#assign').setDisabled(true);
		Ext.Ajax.request({
			url:'GeoMapXML/data/EgAssignGeoXmlToAgentsJson.jsp?from=new&associate='+viewBy+'&comptype='+comptype+'&xmlfile='+xmlFileName,
			method:'POST',
			async : false,
			timeout:120000,
			scope:this,
			success:function(response)
			{
				if (response.status == 200 && !Ext.isEmpty(response.responseText)) 
				{
					var jsonText = response.responseText;
					publicAssignJson = Ext.decode(jsonText);
					var selectionData = publicAssignJson.elements;
					if (!Ext.isEmpty(selectionData))
					{
						selectionDataObj.show();
						//selectionDataObj.getStore().loadRawData(selectionData);
						//selectionDataObj.setValue(selectionData[0].valueField);

						var elementsDatatoFieldArr = publicAssignJson.elementsDatatoFieldArr;
						var elementsDatafromFieldArr = publicAssignJson.elementsDatafromFieldArr;

						formObj.down('#assign').setDisabled(false);

						if (!Ext.isEmpty(elementsDatafromFieldArr))
						{
							selectionDataObj.fromField.store.add(elementsDatafromFieldArr);
						}

						if (!Ext.isEmpty(elementsDatatoFieldArr))
						{
							selectionDataObj.toField.store.add(elementsDatatoFieldArr);
						}
					}
				}
			}
		});

	},
	selectAgent: function()
	{
		var formObj = this.getAssignnetworklocation();
		var viewBy = formObj.down('#viewby').getValue();
		var selectionData = formObj.down('#selectiondatalist').getValue();
		formObj.down('#assign').setDisabled(true);

		var xmlFileName = formObj.down('#xmlfiles').getValue();

		var selectionDataObj = formObj.down('#selectiondatalist');
		if (selectionDataObj.fromField.store.getCount() > 0)
		{
			selectionDataObj.fromField.store.removeAll();
		}

		if (selectionDataObj.toField.store.getCount() > 0)
		{
			selectionDataObj.toField.store.removeAll();
		}

		if (!Ext.isEmpty(selectionData) && selectionData != '-1')
		{
			Ext.Ajax.request({
				url:'GeoMapXML/data/EgAssignGeoXmlToAgentsJson.jsp?from=new&selectiondata='+selectionData+"&associate="+viewBy,
				method:'POST',
				timeout:120000,
				async : false,
				scope:this,
				success:function(response)
				{
					if (response.status == 200 && !Ext.isEmpty(response.responseText)) 
					{
						var jsonText = response.responseText;
						publicAssignJson = Ext.decode(jsonText);

						var elementsDatatoFieldArr = publicAssignJson.elementsDatatoFieldArr;
						var elementsDatafromFieldArr = publicAssignJson.elementsDatafromFieldArr;

						formObj.down('#assign').setDisabled(false);

						if (!Ext.isEmpty(elementsDatafromFieldArr))
						{
							selectionDataObj.fromField.store.add(elementsDatafromFieldArr);
						}

						if (!Ext.isEmpty(elementsDatatoFieldArr))
						{
							selectionDataObj.toField.store.add(elementsDatatoFieldArr);
						}
					}
				}
			});
		}
	},
	assignToAgentsFromEdit :  function()
	{
		var formObj = this.getAssignnetlocateditwindow();
		var hiddenContainer = formObj.down('#hiddenContainer');
		var viewBy = formObj.down('#viewby').getValue();
		var selectionData = formObj.down('#selectiondatalist').getValue();
		var from = formObj.through;

		var xmlFilesObj = formObj.down('#xmlfiles');
		var marray = new Array();
		var fromStore = xmlFilesObj.fromField.store;
		for(var z = 0;z<fromStore.getCount();z++)
		{
			var tmpVal = fromStore.getAt(z).get("valueField");
			marray.push(tmpVal);
		}

		if (Ext.isEmpty(marray) || marray.length <= 0)
		{
			Ext.Msg.show({
				title: pageName,
				msg: alert7,
				width: 350,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
			});
			return;
		}

		var chosenHosts = {
			xtype : 'hiddenfield',
			name : 'allotlocation',
			value : marray
		}
		var tmpActionObj = {
			xtype : 'hiddenfield',
			name : 'action',
			value : 'add'
		}

		hiddenContainer.add(chosenHosts);
		hiddenContainer.add(tmpActionObj);
		if (formObj.getForm().isValid())
		{
			formObj.getForm().submit({
				url:'GeoMapXML/data/EgAssignGeoXmlToAgentsJsonp.jsp?from=edit&selectiondata='+selectionData+"&associate="+viewBy,
				method:'POST',
				async : false,
				scope:this,
				success: function (form, action) {
					if (action.response.status == 200 && !Ext.isEmpty(action.response.responseText)) 
					{
						Ext.Msg.show({
							title: pageName,
							msg: alert3,
							width: 350,
							buttons: Ext.Msg.OK,
							icon: 'iconInformation',
							fn: function() {
								formObj.up('.window').close();
								me.afterMainRender();
							}
						});
					}
				},
				failure: function (form, action) {
					Ext.Msg.show({
						title: pageName,
						msg: 'failure',
						width: 350,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function()
						{
							formObj.up('.window').close();
						}
					});
				}
			});
		}
	},
	assignToAgentsFromNew : function()
	{
		var formObj = this.getAssignnetworklocation();
		var hiddenContainer = formObj.down('#hiddenContainer');
		var viewBy = formObj.down('#viewby').getValue();
		var selectionData = formObj.down('#selectiondatalist').getValue();
		var strXMLFile = formObj.down('#xmlfiles').getValue();
		var from = formObj.through;

		var selectionDataObj = formObj.down('#selectiondatalist');
		var marray = new Array();
		var fromStore = selectionDataObj.fromField.store;
		for(var z = 0;z<fromStore.getCount();z++)
		{
			var tmpVal = fromStore.getAt(z).get("valueField");
			marray.push(tmpVal);
		}

		if (Ext.isEmpty(marray) || marray.length <= 0)
		{
			Ext.Msg.show({
				title: pageName,
				msg: alert7,
				width: 350,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
			});
			return;
		}

		var chosenHosts = {
			xtype : 'hiddenfield',
			name : 'elements',
			value : marray
		}
		var tmpActionObj = {
			xtype : 'hiddenfield',
			name : 'action',
			value : 'add'
		}

		hiddenContainer.add(chosenHosts);
		hiddenContainer.add(tmpActionObj);
		if (formObj.getForm().isValid())
		{
			formObj.getForm().submit({
				url:'GeoMapXML/data/EgAssignGeoXmlToAgentsJsonp.jsp?from=new&selectiondata='+selectionData+"&associate="+viewBy+'&xmlfile='+strXMLFile,
				method:'POST',
				async : false,
				scope:this,
				success: function (form, action) {
					if (action.response.status == 200 && !Ext.isEmpty(action.response.responseText)) 
					{
						Ext.Msg.show({
							title: pageName,
							msg: alert3,
							width: 350,
							buttons: Ext.Msg.OK,
							icon: 'iconInformation',
							fn: function() {
								formObj.up('.window').close();
								me.afterMainRender();
							}
						});
					}
				},
				failure: function (form, action) {
					Ext.Msg.show({
						title: pageName,
						msg: 'failure',
						width: 350,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function()
						{
							formObj.up('.window').close();
						}
					});
				}
			});
		}
	},
	handleEditIconClick: function(gridView, row, col)
	{
		btnText = 'Edit';
		var rec = this.getMain().down('#netlocatemapgrid').getStore().getAt(row);
		var Type = rec.get('Type');
		var OrgType = rec.get('OriginalType');
		var OrgTypeName = rec.get('OriginalTypeName');
		var edit_delete = rec.get('edit_delete');
		
		if(edit_delete != undefined && !Ext.isEmpty(edit_delete) && (edit_delete == false || edit_delete == 'false'))
		{
			Ext.Msg.show ({
				title: 'WARNING',
				msg: 'User\'s are not allowed to edit/delete components from another service/segment/zone/remote Agent',
				buttons: Ext.MessageBox.OK,
				icon: 'iconExclamation',
			});
			return;
		}
		this.showANLocationEditWindow(Type,OrgType,OrgTypeName);
	},
	showANLocationEditWindow: function(associate,OrgType,OrgTypeName)
	{
		var viewObj = this;
		Ext.widget('window', {
			title: label2,
			width: '720px',
			height: '350px',
			padding:'5 10 10 10',
			modal: true,
			items: [
				{
					xtype: 'assignnetlocateditwindow'
				}
			],
			listeners: {
				afterrender: function() 
				{
					var formObj = viewObj.getAssignnetlocateditwindow();
					formObj.through = 'edit';
					var comptype = '';
					var urlString = 'GeoMapXML/data/EgAssignGeoXmlToAgentsJson.jsp?from=edit&associate='+OrgType+"&selectiondata="+OrgTypeName;

					if (OrgType.toLowerCase() == 'independent servers')
					{
						comptype = OrgTypeName.substring(0,OrgTypeName.indexOf(":"));
						urlString = urlString+"&comptype="+comptype;
					}

					Ext.Ajax.request({
						url: urlString,
						method:'POST',
						timeout:120000,
						async : false,
						scope:this,
						success:function(response)
						{
							if (response.status == 200 && !Ext.isEmpty(response.responseText)) 
							{
								var jsonText = response.responseText;
								publicAssignJson = Ext.decode(jsonText);

								var associate = publicAssignJson.associate;
								var selectiondata = publicAssignJson.selectiondata;

								if (!Ext.isEmpty(associate) && !Ext.isEmpty(selectiondata))
								{
									var viewByObj = formObj.down('#viewby');
									var viewByStoreData = publicAssignJson.associations;
									if (!Ext.isEmpty(viewByStoreData))
									{
										viewByObj.getStore().loadRawData(viewByStoreData);
										viewByObj.setValue(associate);
										viewByObj.setReadOnly(true);
									}

									var compTypeObj = formObj.down('#comptype');
									var selectionDataObj = formObj.down('#selectiondatalist');

									if (associate.toLowerCase() == 'independent servers')
									{
										compTypeObj.show();
										var componentTypes = publicAssignJson.componentTypes;
										var selectedCompType = publicAssignJson.selectedCompType;
										if (!Ext.isEmpty(componentTypes))
										{
											compTypeObj.getStore().loadRawData(componentTypes);
											compTypeObj.setValue(selectedCompType);
											compTypeObj.setReadOnly(true);
										}

										selectionDataObj.show();
										//var compObjDisplay = compTypeObj.getDisplayValue();
										selectionDataObj.setFieldLabel("Component name");

										var selectionStoreData = publicAssignJson.elements;
										if (!Ext.isEmpty(selectionStoreData))
										{
											selectionDataObj.getStore().loadRawData(selectionStoreData);
											selectionDataObj.setValue(selectiondata);
											selectionDataObj.setReadOnly(true);
										}
									}
									else
									{
										compTypeObj.hide();
										selectionDataObj.show();
										var viewObjDisplay = viewByObj.getDisplayValue();
										selectionDataObj.setFieldLabel(viewObjDisplay);
										var selectionStoreData = publicAssignJson.elements;
										if (!Ext.isEmpty(selectionStoreData))
										{
											selectionDataObj.getStore().loadRawData(selectionStoreData);
											selectionDataObj.setValue(selectiondata);
											selectionDataObj.setReadOnly(true);
										}
									}

									var xmlFilesObj = formObj.down('#xmlfiles');
									if (xmlFilesObj.fromField.store.getCount() > 0)
									{
										xmlFilesObj.fromField.store.removeAll();
									}

									if (xmlFilesObj.toField.store.getCount() > 0)
									{
										xmlFilesObj.toField.store.removeAll();
									}

									var xmlDatatoFieldArr = publicAssignJson.XMLDatatoFieldArr;
									var XMLDatafromFieldArr = publicAssignJson.XMLDatafromFieldArr;

									formObj.down('#assign').setDisabled(false);

									if (!Ext.isEmpty(XMLDatafromFieldArr))
									{
										xmlFilesObj.fromField.store.add(XMLDatafromFieldArr);
									}

									if (!Ext.isEmpty(xmlDatatoFieldArr))
									{
										xmlFilesObj.toField.store.add(xmlDatatoFieldArr);
									}
								}
							}
						},
						failure: function (form,action) 
						{
							switch (action.failureType) {
								case Ext.form.action.Action.CLIENT_INVALID:
									Ext.Msg.show ({
										title: pageName,
										msg: 'Form fields may not be submitted with invalid values',
										buttons: Ext.MessageBox.OK,
										icon: 'iconExclamation',
									});
									break;
								case Ext.form.action.Action.CONNECT_FAILURE:
									Ext.Msg.show ({
										title: pageName,
										msg: 'Ajax communication failed',
										buttons: Ext.MessageBox.OK,
										icon: 'iconExclamation',
									});
									break;
								case Ext.form.action.Action.SERVER_INVALID:
									Ext.Msg.show ({
										title: pageName,
										msg: action.result.msg,
										buttons: Ext.MessageBox.OK,
										icon: 'iconExclamation',
									});
							}
						}
					});
				}
			}
		}).show();
	},
	filterByCategory: function()
	{
		var mainObj = this.getMain();
		var filterBy = mainObj.down('#filterby').getValue();
		var gridStoreArr = publicJson.gridXMLDataArr;

		var findVal = mainObj.down('#searchTrigger').getValue();
		if (!Ext.isEmpty( findVal))
		{
			mainObj.down('#searchTrigger').reset();
		}

		var xmlGridObj = mainObj.down('#netlocatemapgrid');
		var filterCompTypeObj = mainObj.down('#filtercomptype');
		var compStore = componentRawData;

		filterCompTypeObj.hide();
		if (!Ext.isEmpty(filterBy) && filterBy.toLowerCase() == 'all')
		{
			filterCompTypeObj.hide();
			xmlGridObj.getStore().loadRawData(compStore);
			xmlGridObj.getSelectionModel().deselectAll(true);
		}
		else if (!Ext.isEmpty(filterBy) && filterBy.toLowerCase() == 'independent servers')
		{
			filterCompTypeObj.show();
			var filteCompTypesArr = publicJson.filterCompTypesArr;
			var filteCompType = publicJson.filterCompType;
			filterCompTypeObj.getStore().loadRawData(filteCompTypesArr);

			if (!Ext.isEmpty(filteCompType))
			{
				filterCompTypeObj.setValue(filteCompType);
			}
			else
			{
				filterCompTypeObj.setValue(filteCompTypesArr[0].valueField);
			}
			filterCompTypeObj.fireEvent('select',this.filterByCompType);
		}
		else
		{
			filterCompTypeObj.hide()
			var isRecordFound = false;
			var genStore = new Ext.data.Store({
									fields : ['Type','NwLocation','XMLFiles','OriginalTypeName','OriginalType','edit_delete'],
									data : []                                
								});
			for ( var i = 0; i < compStore.length ; i++ )
			{
				var getRecord = compStore[i]['OriginalType'];
				if ( getRecord.toLowerCase() == filterBy.toLowerCase())
				{
					isRecordFound = true;
					genStore.add({
						'Type': compStore[i]['Type'],
						'NwLocation': compStore[i]['NwLocation'],
						'XMLFiles': compStore[i]['XMLFiles'],
						'OriginalTypeName': compStore[i]['OriginalTypeName'],
						'OriginalType': compStore[i]['OriginalType'],
						'edit_delete': compStore[i]['edit_delete'],
					});
				}
			}
			if ( isRecordFound )
			{
				xmlGridObj.getStore().removeAll();  
				for ( var i = 0; i < genStore.getCount() ; i++ )
				{
					var getRecord = genStore.getAt(i);
					xmlGridObj.getStore().add(getRecord);
				}
				xmlGridObj.getSelectionModel().deselectAll(true);
				xmlGridObj.show();
			}
			else
			{
				xmlGridObj.getStore().removeAll();
				xmlGridObj.store.loadData('');
				xmlGridObj.getView().emptyText = '<table align="center"><tr><td align="center" height="350"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+NoXMLAssignedData1+'.</td></tr></table></td></tr></table>';
				xmlGridObj.getView().refresh();
			}
		}
	},
	filterByCompType: function()
	{
		var mainObj = this.getMain();
		var xmlGridObj = mainObj.down('#netlocatemapgrid');
		var filterCompTypeObj = mainObj.down('#filtercomptype');
		var filterCompType = filterCompTypeObj.getValue();
		var filterCompStore = componentListRawData;

		var findVal = mainObj.down('#searchTrigger').getValue();
		if (!Ext.isEmpty( findVal))
		{
			mainObj.down('#searchTrigger').reset();
		}

		var isRecordFound = false;
		var genStore = new Ext.data.Store({
								fields : ['Type','NwLocation','XMLFiles','OriginalTypeName','OriginalType','edit_delete'],
								data : []                                
							});

		if (!Ext.isEmpty(filterCompType) && filterCompType.toLowerCase() == 'all')
		{
			for ( var i = 0; i < filterCompStore.length ; i++ )
			{
				var OriginalTypeName = filterCompStore[i]['OriginalTypeName'];
				var OriginalType = filterCompStore[i]['OriginalType'];
				var comptype = OriginalTypeName.substring(0,OriginalTypeName.indexOf(":"));

				if (OriginalType.toLowerCase() == 'independent servers')
				{
					isRecordFound = true;
					genStore.add({
						'Type': filterCompStore[i]['Type'],
						'NwLocation': filterCompStore[i]['NwLocation'],
						'XMLFiles': filterCompStore[i]['XMLFiles'],
						'OriginalTypeName': filterCompStore[i]['OriginalTypeName'],
						'OriginalType': filterCompStore[i]['OriginalType'],
						'edit_delete': filterCompStore[i]['edit_delete'],
					});
				}
			}
		}
		else if(!Ext.isEmpty(filterCompType))
		{
			for ( var i = 0; i < filterCompStore.length ; i++ )
			{
				var OriginalTypeName = filterCompStore[i]['OriginalTypeName'];
				var OriginalType = filterCompStore[i]['OriginalType'];
				var comptype = OriginalTypeName.substring(0,OriginalTypeName.indexOf(":"));

				if (OriginalType.toLowerCase() == 'independent servers' && comptype.toLowerCase() == filterCompType.toLowerCase())
				{
					isRecordFound = true;
					genStore.add({
						'Type': filterCompStore[i]['Type'],
						'NwLocation': filterCompStore[i]['NwLocation'],
						'XMLFiles': filterCompStore[i]['XMLFiles'],
						'OriginalTypeName': filterCompStore[i]['OriginalTypeName'],
						'OriginalType': filterCompStore[i]['OriginalType'],
						'edit_delete': filterCompStore[i]['edit_delete'],
					});
				}
			}
		}

		if ( isRecordFound )
		{
			xmlGridObj.getStore().removeAll();  
			for ( var i = 0; i < genStore.getCount() ; i++ )
			{
				var getRecord = genStore.getAt(i);
				xmlGridObj.getStore().add(getRecord);
			}
			xmlGridObj.getSelectionModel().deselectAll(true);
			xmlGridObj.show();
		}
		else
		{
			xmlGridObj.getStore().removeAll();
			xmlGridObj.store.loadData('');
			xmlGridObj.getView().emptyText = '<table align="center"><tr><td align="center" height="350"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+NoXMLAssignedData1+'.</td></tr></table></td></tr></table>';
			xmlGridObj.getView().refresh();
		}
	}

});





