var newCheckGridSelectionModel = Ext.create('Ext.selection.CheckboxModel', {
	selType: 'checkboxmodel',
	mode: 'MULTI',
	checkOnly: true,
	deselectAll: function() {
		var rowIndex=0;
		while(typeof(Ext.ComponentQuery.query('#netlocatemapgrid')[0].getStore().getAt(rowIndex))!='undefined') {
			var record =Ext.ComponentQuery.query('#netlocatemapgrid')[0].getStore().getAt(rowIndex);
			Ext.ComponentQuery.query('#netlocatemapgrid')[0].getSelectionModel().deselect(rowIndex, true);
			rowIndex++;
		}
		var view = Ext.ComponentQuery.query('#netlocatemapgrid')[0].getView();
		var headerCt = view.headerCt;
		var checkHd = headerCt.child('gridcolumn[isCheckerHd]');
		if (checkHd)
		{
			checkHd.el.removeCls(Ext.baseCSSPrefix +'grid-hd-checker-on');
		}
	},
	selectAll: function(){
		var rowIndex=0;
		while(typeof(Ext.ComponentQuery.query('#netlocatemapgrid')[0].getStore().getAt(rowIndex))!='undefined') {
			var record = Ext.ComponentQuery.query('#netlocatemapgrid')[0].getStore().getAt(rowIndex);
			Ext.ComponentQuery.query('#netlocatemapgrid')[0].getSelectionModel().select(rowIndex, true);
			rowIndex++;
		}

		var view = Ext.ComponentQuery.query('#netlocatemapgrid')[0].getView();
		var headerCt = view.headerCt;
		var hdSelectStatus = this.selected.getCount() === this.store.getCount();
		var checkHd = headerCt.child('gridcolumn[isCheckerHd]');
		if (checkHd) {
			checkHd.el.addCls(Ext.baseCSSPrefix +'grid-hd-checker-on');
		}
	}
});

Ext.define('GeoMapXML.view.Main', {
	extend: 'utilities.innerScrollContainer',
	alias: 'widget.main',
	title: pageName,
	margin: '8 8 0 8',
	border: true,
	frame: true,
	header:{cls:'zonereporthead'},

	layout: {
		type: 'vbox',
		align: 'stretch'
	},

	requires: [
		'utilities.ScrollCombo',
		'utilities.CustomGrid'
	],

	dockedItems: [{
		xtype: 'toolbar',
		dock: 'top',
		cls:'adminHeadInfoText',
		height: 25,
		padding: 3,
		border:true,
		layout:{pack:'center'},
		items: [
			{
				xtype: 'component',
				html: '<center><img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="iconAdminInfo" valign="middle" >&nbsp;&nbsp;'+pageDesc+'</center>',
			}
		]
	}],

	items: [
		{
			xtype: 'customgrid',
			cls:'gridSkin',
			itemId: 'netlocatemapgrid',
			store: new Ext.data.Store({
				fields: ['Type','NwLocation','XMLFiles','OriginalTypeName','OriginalType'],
				data: []
			}),
			flex: 1,
			margin: 10,
			autoScroll: true,
			scroll: true,
			viewConfig: {
				deferEmptyText: true
			},
			emptyText: '<table align="center"><tr><td align="center" height="300"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">No files found.</td></tr></table></td></tr></table>',
			selModel: newCheckGridSelectionModel,
			columns: {
				defaults: {
					sortable: true,
					hideable: false,
					menuDisabled: true,
					draggable: false,
					resizable: false,
					isCheckerHd: false
				},
				items: [
					{
						text: label3,
						dataIndex: 'Type',
						itemId: 'typeName',
						flex: 1,
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							//metaData.tdAttr = "data-qtip='Modify' data-qclass='yellowTip'";
							var filterByObj = this.down('#filterby');
							var filterByValue = filterByObj.getValue();
							if (!Ext.isEmpty(filterByValue) && filterByValue.toLowerCase() != 'all')
							{
								if (!Ext.isEmpty(value) && value.indexOf("(") != -1)
								{
									value = value.substring(0,value.lastIndexOf("("));
								}
							}
							return value;
						}
					},
					{
						text: label4,
						dataIndex: 'NwLocation',
						itemId: 'location',
						flex: 1
					},
					{
						xtype: 'actioncolumn',
						width: 36,
						iitemId: 'EditOver',
						sortable: false,
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							metaData.tdAttr = "data-qtip='Modify' data-qclass='yellowTip'";
							//return "<img src=\"/final/images/clear.png\" style='cursor:pointer' onclick=\"javascript:appCnt.handleEditIconClick('"+gridView+"','"+row+"','"+col+"')\" class='iconModify'></img>";
						},
						items: [
							{
								iconCls: 'iconModify',
								sortable: false,
								handler: function(grid, rowIndex, colIndex) {
									me.handleEditIconClick(grid, rowIndex, colIndex);
								}
							}
						]
					},
					{
						header: '<img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" id="deleteSelected" style="cursor:pointer" data-qclass="yellowTip" class="iconDeleteAll" data-qtip="Delete All"/>',
						xtype: 'actioncolumn',
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							metaData.tdAttr = "data-qtip='Delete' data-qclass='yellowTip'";
						},
						listeners: {
							headerclick: function(ct, header, e, t,grid, rowIndex, colIndex) {
								me.handleDeleteSelected(grid, rowIndex, colIndex);
							}
						},
						//cls: 'tasks-icon-column-header tasks-delete-column-header',
						width: 36,
						//icon: '../../../../resources/images/delete.png',
						items: [
							{
								iconCls: 'iconDelete',
								sortable: false,
								handler: function(grid, rowIndex, colIndex) {
									me.handleDeleteIconClick(grid, rowIndex, colIndex);
								}
							}
						]
					}
				]
			},
			tools:[
				{
					xtype: 'button',
					itemId: 'configureNwLocation',
					text: label15,
					cls: 'button20',
					margin: 5,
					width: 170
				},
				{
					xtype: 'button',
					itemId: 'assignNetLocation',
					text: 'Assign Elements To Network Location',
					cls: 'button20',
					margin: 5,
					width: 220
				}
			],
			tbar: [
				{
					xtype:'scrollcombo',
					editable : false,
					fieldLabel:label6,
					itemId: 'filterby',
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : []
					}),
					displayField : 'displayField',
					valueField : 'valueField',
					queryMode : 'local',
					labelAlign: 'left',
					labelSeparator: ' ',
					width: 180,
					labelWidth: 60,
					margin: '5 5 5 0'
				},
				{
					xtype:'scrollcombo',
					editable : false,
					fieldLabel:label7,
					itemId: 'filtercomptype',
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : []
					}),
					displayField : 'displayField',
					valueField : 'valueField',
					queryMode : 'local',
					labelAlign: 'left',
					labelSeparator: ' ',
					margin: 5,
					hidden: true,
					//defaultListConfig: {
						//minWidth: 250,
						//maxHeight: 300
					//},
					width: 350,
					labelWidth: 110
				},
				{
					xtype:'tbfill',
				},
				{
					xtype: 'toolbar',
					ui: 'footer',
					items: [
						{
							xtype: 'trigger',
							labelAlign: 'top',
							labelSeparator: ' ',
							itemId: 'searchTrigger',
							trigger1Cls: 'x-form-clear-trigger',
							trigger2Cls: 'x-form-search-trigger',
							cls: 'whitedropdown_search',
							emptyText: label8,
							disabled: true,
							getTriggerMarkup: function() {
								var me = this,
								i = 0,
								hideTrigger = (me.readOnly || me.hideTrigger),
								triggerCls,
								triggerBaseCls = me.triggerBaseCls,
								triggerConfigs = [],
								unselectableCls = Ext.dom.Element.unselectableCls,
								style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
								cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;
								// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
								// single triggerCls config. Should rethink this, perhaps something more structured like a list of
								// trigger config objects that hold cls, handler, etc.
								// triggerCls is a synonym for trigger1Cls, so copy it.
								if (!me.trigger1Cls) {
									me.trigger1Cls = me.triggerCls;
								}
								// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
								for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
									if (i == 0)
									{
										triggerConfigs.push({
											tag: 'td',
											role: 'presentation',
											valign: 'top',
											cls: cls,
											id : 'MyTrigger_'+i,
											style: style + "display:none;",
											cn: {
												cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
												role: 'presentation'
											}
										});
									}
									else
									{
										triggerConfigs.push({
											tag: 'td',
											role: 'presentation',
											valign: 'top',
											cls: cls,
											id : 'MyTrigger_'+i,
											style: style,
											cn: {
												cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
												role: 'presentation'
											}
										});
									}
								}
								triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
								return Ext.DomHelper.markup(triggerConfigs);
							},
							onTrigger1Click: function()
							{
								this.reset();
							},
							onTrigger2Click: function()
							{
								me.filterGrid();
							}
						}
					]
				}
			]
		}
	]
});



