var newCheckXMLGridSelModel = Ext.create('Ext.selection.CheckboxModel', {
	selType: 'checkboxmodel',
	mode: 'MULTI',
	checkOnly: true,
	deselectAll: function() {
		var rowIndex=0;
		while(typeof(Ext.ComponentQuery.query('#xmldatagrid')[0].getStore().getAt(rowIndex))!='undefined') {
			var record =Ext.ComponentQuery.query('#xmldatagrid')[0].getStore().getAt(rowIndex);
			Ext.ComponentQuery.query('#xmldatagrid')[0].getSelectionModel().deselect(rowIndex, true);
			rowIndex++;
		}
		var view = Ext.ComponentQuery.query('#xmldatagrid')[0].getView();
		var headerCt = view.headerCt;
		var checkHd = headerCt.child('gridcolumn[isCheckerHd]');
		if (!Ext.isEmpty(view) && checkHd)
		{
			checkHd.el.removeCls(Ext.baseCSSPrefix +'grid-hd-checker-on');
		}
	},
	selectAll: function(){
		var rowIndex=0;
		while(typeof(Ext.ComponentQuery.query('#xmldatagrid')[0].getStore().getAt(rowIndex))!='undefined') {
			var record = Ext.ComponentQuery.query('#xmldatagrid')[0].getStore().getAt(rowIndex);
			Ext.ComponentQuery.query('#xmldatagrid')[0].getSelectionModel().select(rowIndex, true);
			rowIndex++;
		}

		var view = Ext.ComponentQuery.query('#xmldatagrid')[0].getView();
		var headerCt = view.headerCt;
		//var hdSelectStatus = this.selected.getCount() === this.store.getCount();
		var checkHd = headerCt.child('gridcolumn[isCheckerHd]');
		if (checkHd) {
			checkHd.el.addCls(Ext.baseCSSPrefix +'grid-hd-checker-on');
		}
	}
});

Ext.define('GeoMapXML.view.XMLActivities',{
	extend:'Ext.form.Panel',
	alias:'widget.xmlactivities',
	cls:'outerpanel',
	title: label15,
	margin: '8 8 0 8',
	header:{cls:'zonereporthead'},

	layout: {
		type: 'vbox',
		align: 'stretch'
	},
	dockedItems: [{
		xtype: 'toolbar',
		dock: 'top',
		cls:'adminHeadInfoText',
		height: 25,
		padding: 3,
		border:true,
		layout:{pack:'center'},
		items: [
			{
				xtype: 'component',
				html: '<center><img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="iconAdminInfo" valign="middle" >&nbsp;&nbsp;'+pageDesc1+'.</center>',
			}
		]
	}],
	itemId: 'xmlactivitiesform',
	items: [
		{
			xtype: 'customgrid',
			cls:'gridSkin',
			itemId: 'xmldatagrid',
			store: new Ext.data.Store({
				fields: ['NwLocation','XMLFiles'],
				data: []
			}),
			flex: 1,
			margin: 10,
			autoScroll: true,
			scroll: true,
			viewConfig: {
				deferEmptyText: true
			},
			emptyText: '<table align="center"><tr><td align="center" height="300"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">No files found.</td></tr></table></td></tr></table>',
			selModel: newCheckXMLGridSelModel,
			columns: {
				defaults: {
					sortable: true,
					hideable: false,
					menuDisabled: true,
					draggable: false,
					resizable: false,
					isCheckerHd: false
				},
				items: [
					{
						text: 'Name',
						dataIndex: 'NwLocation',
						itemId: 'location',
						flex: 1
					},
					{
						text: label16,
						dataIndex: 'XMLFiles',
						itemId: 'xmlfiles',
						flex: 1
					},
					{
						xtype: 'actioncolumn',
						width: 36,
						iitemId: 'EditOver',
						sortable: false,
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							metaData.tdAttr = "data-qtip='Reupload' data-qclass='yellowTip'";
							//return "<img src=\"/final/images/clear.png\" style='cursor:pointer' onclick=\"javascript:appCnt.handleXMLDataEditEvent('"+gridView+"','"+row+"','"+col+"')\" class='iconUpload'></img>";
						},
						items: [
							{
								iconCls: 'iconUpload',
								sortable: false,
								handler: function(grid, rowIndex, colIndex) {
									me.handleXMLDataEditEvent(grid, rowIndex, colIndex);
								}
							}
						]
					},
					{
						header: '<img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" id="deleteSelected" style="cursor:pointer" data-qclass="yellowTip" class="iconDeleteAll" data-qtip="Delete All"/>',
						xtype: 'actioncolumn',
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							metaData.tdAttr = "data-qtip='Delete' data-qclass='yellowTip'";
						},
						listeners: {
							headerclick: function(ct, header, e, t,grid, rowIndex, colIndex) {
								me.handleXMLDataDeleteAllEvent(this);
							}
						},
						//cls: 'tasks-icon-column-header tasks-delete-column-header',
						width: 36,
						//icon: '../../../../resources/images/delete.png',
						items: [
							{
								iconCls: 'iconDelete',
								sortable: false,
								handler: function(grid, rowIndex, colIndex) {
									me.handleXMLDataDeleteEvent(grid, rowIndex, colIndex);
								}
							}
						]
					}
				]
			},
			tbar: [
				{
					xtype:'tbfill',
				},
				{
					xtype: 'toolbar',
					ui: 'footer',
					margin: 3,
					items:[
						{
							xtype: 'trigger',
							itemId: 'nwlocationFetch',
							trigger1Cls: 'x-form-clear-trigger',
							trigger2Cls: 'x-form-search-trigger',
							cls: 'whitedropdown_search',
							emptyText: 'Search network location',
							disabled: true,
							listeners: {
								change: function() {
									me.xmlDataGridFilter(this)
								}
							},
							getTriggerMarkup: function() {
								var me = this,
								i = 0,
								hideTrigger = (me.readOnly || me.hideTrigger),
								triggerCls,
								triggerBaseCls = me.triggerBaseCls,
								triggerConfigs = [],
								unselectableCls = Ext.dom.Element.unselectableCls,
								style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
								cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;
								// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
								// single triggerCls config. Should rethink this, perhaps something more structured like a list of
								// trigger config objects that hold cls, handler, etc.
								// triggerCls is a synonym for trigger1Cls, so copy it.
								if (!me.trigger1Cls) {
									me.trigger1Cls = me.triggerCls;
								}
								// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
								for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
									if (i == 0)
									{
										triggerConfigs.push({
											tag: 'td',
											role: 'presentation',
											valign: 'top',
											cls: cls,
											id : 'XMLTrigger_'+i,
											style: style + "display:none;",
											cn: {
												cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
												role: 'presentation'
											}
										});
									}
									else
									{
										triggerConfigs.push({
											tag: 'td',
											role: 'presentation',
											valign: 'top',
											cls: cls,
											id : 'XMLTrigger_'+i,
											style: style,
											cn: {
												cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
												role: 'presentation'
											}
										});
									}
								}
								triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
								return Ext.DomHelper.markup(triggerConfigs);
							},
							onTrigger1Click: function()
							{
								this.reset();
							},
							onTrigger2Click: function()
							{
								me.xmlDataGridFilter();
							}
						},
						{
							xtype: 'button',
							itemId: 'uploadNewXML',
							text: label1,
							cls: 'button20',
							margin: 5,
							width: 170
						}
					]
				}
			]
		}
	],

	tools: [
		{
			xtype: 'button',
			text: label17,
			cls:'backbutton',
			iconCls:'iconBack',
			itemId: 'mainBackBtn'
		}
	]
});



