<%
/**********************************************************************************
*	Name			:	EgUploadXML.jsp
*	Purpose			:	Upload the XML file and Delete the XML file.
***********************************************************************************/
%>
<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.MappingNameSorter"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import="com.eg.EgRoleInfo" %>
<%@ page import="com.eg.EgExternalInfo" %>
<%//@ page import="com.eg.UploadXMLFile" %>
<%@ page import="java.util.ArrayList" %>
<%@ page import="java.util.Collections" %>
<%@ page import= "com.egurkha.util.StringUtils"%>
<%@ page import="java.io.File"%>
<%@ page import ="net.sf.json.*"%>
<%@ page import="com.egurkha.admin.AuditLogThread"%>

<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<jsp:useBean id="userinfo" class="egurkha.UserInfoBean" scope="page"/>

<%
	session.setAttribute("egPageDesc","EgUploadXMLJson.jsp");
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%
	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();
	JSONObject hiddenObj = new JSONObject();

	//tells information about the corresponding authenticated user
	EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));

	String userLanguage = _user.getLanguage();
	IniUI  iniUI = IniUI.getInstance();
	if (userLanguage == null)
		userLanguage = iniUI.getDefaultLanguage();
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);

	StringUtils util = new StringUtils();

	File deleteFileObj = null;
	String dirPath = EgInstallInfo.getInstallDir()+"/manager/config/GeoXmlFiles";
	String action = request.getParameter("action");
	String filterby = request.getParameter("filterby");

	if (util.isNull(action))
	{
		action = "view";
	}

	if (util.isNull(action))
	{
		filterby = "";
	}

	JSONArray associations = new JSONArray();
	JSONObject Associate = new JSONObject();

	ArrayList segments = userinfo.getSegments(false);
	ArrayList services = userinfo.getServices(false);
	ArrayList serviceGroups = userinfo.getServiceGroups(false);
	ArrayList comps = userinfo.getIndependentServers();
	ArrayList zones = userinfo.getZones(false);
	
	EgTopoInfo topoInfo = new EgTopoInfo("manager");
	EgGroupInfo groupInfo = new EgGroupInfo();


	EgExternalInfo extInfo = new EgExternalInfo("manager");
	String[] externalAgents = extInfo.getAllExternalAgents();
	String [] remoteAgents = extInfo.getAllRemoteAgents();

	if((zones.size()<1) && (services.size()<1) && (serviceGroups.size()<1) && (segments.size()<1) && (comps.size()<1) && externalAgents.length <1 && remoteAgents.length <1)
	{
		Associate.put("displayField",_mapping.getTextDescription("admin.service.No Elements Available"));
		Associate.put("valueField","-1");
		associations.add(Associate);
	}
	else
	{
		Associate = new JSONObject();
		Associate.put("displayField",_mapping.getTextDescription("admin.service.All"));
		Associate.put("valueField","all");
		associations.add(Associate);
		Associate = new JSONObject();
		if (false && externalAgents.length > 0)
		{
			Associate.put("displayField",_mapping.getTextDescription("admin.common.External Agent"));
			Associate.put("valueField","ExternalAgent");
			associations.add(Associate);
		}

		if (remoteAgents.length > 0)
		{
			Associate.put("displayField",_mapping.getTextDescription("admin.common.Remote Agent"));
			Associate.put("valueField","RemoteAgent");
			associations.add(Associate);
		}

		if (zones.size() > 0)
		{
			Associate.put("displayField",_mapping.getTextDescription("admin.common.Zone"));
			Associate.put("valueField","Zone");
			associations.add(Associate);
		}

		if (services.size() > 0)
		{
			Associate = new JSONObject();
			Associate.put("displayField",_mapping.getTextDescription("admin.common.Service"));
			Associate.put("valueField","Service");
			associations.add(Associate);
		}

		if (serviceGroups.size() > 0)
		{
			Associate = new JSONObject();
			Associate.put("displayField",_mapping.getTextDescription("admin.common.Service Group"));
			Associate.put("valueField","ServiceGroup");
			associations.add(Associate);
		}

		if (segments.size() > 0)
		{
			Associate = new JSONObject();
			Associate.put("displayField",_mapping.getTextDescription("admin.common.Segment"));
			Associate.put("valueField","Segment");
			associations.add(Associate);
		}

		if (comps.size() > 0)
		{
			Associate = new JSONObject();
			Associate.put("displayField",_mapping.getTextDescription("admin.common.Component"));
			Associate.put("valueField","Independent servers");
			associations.add(Associate);


			JSONArray componentTypes = new JSONArray();
			JSONObject compTypeObj = new JSONObject();

			rootJson.put("showCompTypeCombo",true);

			String strCompType = request.getParameter("filterCompType");

			if (util.isNull(strCompType))
			{
				strCompType = "all";
			}

			List allUserCompTypes = Arrays.asList(ri.getServerTypes());
			if (allUserCompTypes != null && allUserCompTypes.size() >0)
			{
				compTypeObj.put("displayField",_mapping.getTextDescription("admin.service.All"));
				compTypeObj.put("valueField","all");
				componentTypes.add(compTypeObj);

				ArrayList serverList = sorter.getSortedCompTypeList(allUserCompTypes);
				for (int i=0;i<serverList.size();i++)
				{
					compTypeObj = new JSONObject();
					EgName nameObj = (EgName)serverList .get(i);
					String tmpVal = nameObj.getActualName();	
					String tmpDis = nameObj.getLocalName();
					compTypeObj.put("displayField",tmpDis);
					compTypeObj.put("valueField",tmpVal);
					componentTypes.add(compTypeObj);
					if (tmpVal.equals(strCompType))
					{
						rootJson.put("filterCompType",tmpVal);
					}
				}
			}
			else
			{
				compTypeObj.put("displayField",_mapping.getTextDescription("admin.common.Not applicable"));
				compTypeObj.put("valueField","-1");
				componentTypes.add(compTypeObj);
			}
			rootJson.put("filterCompTypesArr",componentTypes);
		}
	}
	rootJson.put("associations",associations);


	String deletedXMLFileNames[] = request.getParameterValues("XMLfiles");
	
	IniFile iniXMLObj = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_geomapxml.ini",true);

	String[] allSubjects = iniXMLObj.getSubjects();

	ArrayList allotedSubjectList = new ArrayList();
	if (allSubjects != null && allSubjects.length > 0)
	{
		for(int a=0;a<allSubjects.length;a++)
		{
			String strSubject = allSubjects[a];
			if (!StringUtils.isNull(strSubject) && strSubject.equalsIgnoreCase("xmls"))
			{
				continue;
			}
			allotedSubjectList.add(strSubject);
		}
	}
	rootJson.put("dirPath",dirPath);

	/* code for auditlog starts */
	AuditLogThread auditLogThread = new AuditLogThread();	
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Configure Network Location");
	/* code for auditlog ends */

	if(action != null && action.equals("delete"))
	{
		//String deleteXMLFile = request.getParameter("deleteXMLFile");
		String strDelTypeName = request.getParameter("strTypeName");
		String strDelType = request.getParameter("type");
		rootJson.put("isDeletedAssociations", false);

		if (!util.isNull(strDelTypeName) && strDelTypeName.length() > 0)
		{
			String subject = "NetworkMappingTo";
			String tmpAssociate = strDelType;
			if (tmpAssociate.equalsIgnoreCase("Independent servers"))
			{
				tmpAssociate = "Component";
			}
			if (!util.isNull(tmpAssociate))
			{
				subject +=tmpAssociate+"s"; 
			}

			//String[] tempDeleteXMLArr = util.getTokens(strDelXMLFileNames,",");
			//deletedXMLFileNames = new String[tempDeleteXMLArr.length];
			//for (int i=0;i<tempDeleteXMLArr.length;i++)
			//{
				//String tmpVal = tempDeleteXMLArr[i];
				//deletedXMLFileNames[i] = tmpVal;
			//}
			String strAuditData = strDelTypeName + " ("+strDelType+"s)";
			if (tmpAssociate.equalsIgnoreCase("Component")) {
				String compType = strDelTypeName.substring(0,strDelTypeName.indexOf(":"));
				strAuditData = strDelTypeName.substring(strDelTypeName.indexOf(":")+1);
				if (!util.isNull(strAuditData) && strAuditData.endsWith(":NULL")) {
					strAuditData = strAuditData.substring(0,strAuditData.indexOf(":"));
				}
				strAuditData = strAuditData + " ("+_mapping.getComponentTypeDescription(compType)+")";
			}

			auditLogThread.setValue("Activity","strDelTypeAndNames");
			auditLogThread.setValue("Description","The configured element has been deleted");
			auditLogThread.setCurrentValue("ColumnName","Deleted Elements");
			auditLogThread.setCurrentValue("Element",strAuditData);
			auditLogThread.sendItToDB();


			IniFile deleteXMLIniObj = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_geomapxml.ini",true);
			deleteXMLIniObj.deleteValue(subject,strDelTypeName);
			deleteXMLIniObj.saveFile();
			EgConfigFilesSync.releaseInstance(deleteXMLIniObj);
			rootJson.put("isDeletedAssociations", true);
		}
	}
	else if (action != null && action.equals("deleteAll"))
	{
		String strDelTypeAndNames = request.getParameter("strTypeAndNames");
		rootJson.put("isDeletedAssociations", false);
		if (!util.isNull(strDelTypeAndNames) && strDelTypeAndNames.length() > 0)
		{
			String[] tempDeleteXMLArr = util.getTokens(strDelTypeAndNames,",");

			String[] deletedXMLTypeName = new String[tempDeleteXMLArr.length];
			String[] deletedXMLType = new String[tempDeleteXMLArr.length];
			for (int i=0;i<tempDeleteXMLArr.length;i++)
			{
				String tmpVal = tempDeleteXMLArr[i];
				String[] strTypeAndNameArr = util.getTokens(tmpVal,"|sep|");
				deletedXMLTypeName[i] = strTypeAndNameArr[0];
				deletedXMLType[i] = strTypeAndNameArr[1];
			}

			ArrayList auditDelElementList = new ArrayList();
			if(deletedXMLTypeName!=null && deletedXMLTypeName.length > 0)
			{
				IniFile deleteXMLIniObj = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_geomapxml.ini",true);
				for(int j=0;j<deletedXMLTypeName.length;j++)
				{
					String strTypeName = deletedXMLTypeName[j].trim();
					String strType = deletedXMLType[j].trim();
					String subject = "NetworkMappingTo";

					String tmpAssociate = strType;
					if (tmpAssociate.equalsIgnoreCase("Independent servers"))
					{
						tmpAssociate = "Component";
					}

					auditDelElementList.add(strTypeName+" ("+tmpAssociate+"s)");
					if (!util.isNull(tmpAssociate))
					{
						subject +=tmpAssociate+"s"; 
					}
					deleteXMLIniObj.deleteValue(subject,strTypeName);

					if(EgInstallInfo.isClusterSupported)
					{
						//UploadXMLFile uploadXML = new UploadXMLFile();
						//uploadXML.deleteXMLFile(del_file);
					}
				}

				deleteXMLIniObj.saveFile();
				EgConfigFilesSync.releaseInstance(deleteXMLIniObj);
				rootJson.put("isDeletedAssociations", true);
			}
			auditLogThread.setValue("Activity","Delete Assigned Element");
			auditLogThread.setValue("Description","The configured elements have been deleted");
			auditLogThread.setCurrentValue("ColumnName","Deleted Elements");
			auditLogThread.setCurrentValue("Element(s)",util.getString(auditDelElementList));
			auditLogThread.sendItToDB();
		}
	}
	else 
	{
		if (allotedSubjectList != null && !allotedSubjectList.isEmpty())
		{
			screenLabels.put("mulitselt_title",_mapping.getTextDescription("admin.user.Select the XML files to be deleted"));

			//Collections.sort(fileNameList,String.CASE_INSENSITIVE_ORDER);

			//fields: ['Type','NwLocation','XMLFiles'],

			JSONArray XMLUploadDataArr = new JSONArray();
			JSONArray XMLUploadDataGridArr = new JSONArray();
			JSONObject gridXMLDataObj = new JSONObject();
			JSONArray gridXMLDataArr = new JSONArray();
			JSONArray gridXMLDataCompArr = new JSONArray();

			String mappingSubject = "NetworkMappingTo";
			String strXMLSubject = "XMLs";
			ArrayList XMLFileNameList = new ArrayList();
			String strXMLValues = "";
			
			Hashtable extra_comp_grid_details = new Hashtable();

			String associateExtAgent =  mappingSubject+"ExternalAgents";
			String[] strNetworkMappingExtAgents = iniXMLObj.getVariables(associateExtAgent);
			if (strNetworkMappingExtAgents != null && strNetworkMappingExtAgents.length > 0)
			{
				for (int z=0;z<strNetworkMappingExtAgents.length;z++)
				{
					String strExtAgent = strNetworkMappingExtAgents[z];
					String strExtAgtValues = iniXMLObj.getValue(associateExtAgent,strExtAgent);
					XMLFileNameList = util.egTokenizer(strExtAgtValues,",");
					if (XMLFileNameList != null && !XMLFileNameList.isEmpty())
					{
						strXMLValues = "";

						if (XMLFileNameList.size() == 1)
						{
							String strSingleXMLFileName = iniXMLObj.getValue(strXMLSubject,(String) XMLFileNameList.get(0));
							if (!util.isNull(strSingleXMLFileName) && strSingleXMLFileName.indexOf(",") != -1)
							{
								strSingleXMLFileName = strSingleXMLFileName.substring(0,strSingleXMLFileName.indexOf(","));
							}
							strXMLValues = strSingleXMLFileName;
						}
						else
						{
							for (int x=0;x<XMLFileNameList.size();x++)
							{
								String strXMLFileName = (String) XMLFileNameList.get(x);
								String tmpXMLFileName =  iniXMLObj.getValue(strXMLSubject,strXMLFileName);
								if (!util.isNull(tmpXMLFileName) && tmpXMLFileName.indexOf(",") != -1)
								{
									tmpXMLFileName = tmpXMLFileName.substring(0,tmpXMLFileName.indexOf(","));
								}

								strXMLValues += tmpXMLFileName + ",";
							}

							if (!util.isNull(strXMLValues) && strXMLValues.endsWith(","))
							{
								strXMLValues = strXMLValues.substring(0,strXMLValues.length() - 1);
							}
						}
					}


					gridXMLDataObj.put("Type",strExtAgent+" (External Agent)");
					gridXMLDataObj.put("NwLocation",strExtAgtValues);
					gridXMLDataObj.put("XMLFiles",strXMLValues);
					gridXMLDataObj.put("OriginalTypeName",strExtAgent);
					gridXMLDataObj.put("OriginalType","ExternalAgent");
					gridXMLDataArr.add(gridXMLDataObj);
				}
			}

			String associateRemoteAgent =  mappingSubject+"RemoteAgents";
			String[] strNetworkMappingRmtAgent = iniXMLObj.getVariables(associateRemoteAgent);
			if (strNetworkMappingRmtAgent != null && strNetworkMappingRmtAgent.length > 0)
			{
				for (int z=0;z<strNetworkMappingRmtAgent.length;z++)
				{
					String strRmtAgent = strNetworkMappingRmtAgent[z];
					String strRmtAgtValues = iniXMLObj.getValue(associateRemoteAgent,strRmtAgent);
					XMLFileNameList = util.egTokenizer(strRmtAgtValues,",");
					if (XMLFileNameList != null && !XMLFileNameList.isEmpty())
					{
						strXMLValues = "";

						if (XMLFileNameList.size() == 1)
						{
							String strSingleXMLFileName = iniXMLObj.getValue(strXMLSubject,(String) XMLFileNameList.get(0));
							if (!util.isNull(strSingleXMLFileName) && strSingleXMLFileName.indexOf(",") != -1)
							{
								strSingleXMLFileName = strSingleXMLFileName.substring(0,strSingleXMLFileName.indexOf(","));
							}
							strXMLValues = strSingleXMLFileName;
						}
						else
						{
							for (int x=0;x<XMLFileNameList.size();x++)
							{
								String strXMLFileName = (String) XMLFileNameList.get(x);
								String tmpXMLFileName =  iniXMLObj.getValue(strXMLSubject,strXMLFileName);
								if (!util.isNull(tmpXMLFileName) && tmpXMLFileName.indexOf(",") != -1)
								{
									tmpXMLFileName = tmpXMLFileName.substring(0,tmpXMLFileName.indexOf(","));
								}

								strXMLValues += tmpXMLFileName + ",";
							}

							if (!util.isNull(strXMLValues) && strXMLValues.endsWith(","))
							{
								strXMLValues = strXMLValues.substring(0,strXMLValues.length() - 1);
							}
						}
					}

					List temp_raComps = getAllComponentsForRemoteAgent(strRmtAgent);
					for(int p=0;p<temp_raComps.size();p++){
						String comp = (String)temp_raComps.get(p);
						
						if(extra_comp_grid_details.containsKey(comp))
						{
							HashSet al_list = (HashSet)extra_comp_grid_details.get(comp);
							al_list.addAll(XMLFileNameList);
						}
						else
							extra_comp_grid_details.put(comp,new HashSet(XMLFileNameList));
					}


					gridXMLDataObj.put("Type",strRmtAgent+" (Remote Agent)");
					gridXMLDataObj.put("NwLocation",strRmtAgtValues);
					gridXMLDataObj.put("XMLFiles",strXMLValues);
					gridXMLDataObj.put("OriginalTypeName",strRmtAgent);
					gridXMLDataObj.put("OriginalType","RemoteAgent");
					gridXMLDataArr.add(gridXMLDataObj);
				}
			}

			String associateZone =  mappingSubject+"Zones";
			String[] strNetworkMappingZones = iniXMLObj.getVariables(associateZone);
			if (strNetworkMappingZones != null && strNetworkMappingZones.length > 0)
			{
				for (int z=0;z<strNetworkMappingZones.length;z++)
				{
					String strZone = strNetworkMappingZones[z];
					String strZoneValues = iniXMLObj.getValue(associateZone,strZone);
					XMLFileNameList = util.egTokenizer(strZoneValues,",");
					if (XMLFileNameList != null && !XMLFileNameList.isEmpty())
					{
						strXMLValues = "";

						if (XMLFileNameList.size() == 1)
						{
							String strSingleXMLFileName = iniXMLObj.getValue(strXMLSubject,(String) XMLFileNameList.get(0));
							if (!util.isNull(strSingleXMLFileName) && strSingleXMLFileName.indexOf(",") != -1)
							{
								strSingleXMLFileName = strSingleXMLFileName.substring(0,strSingleXMLFileName.indexOf(","));
							}
							strXMLValues = strSingleXMLFileName;
						}
						else
						{
							for (int x=0;x<XMLFileNameList.size();x++)
							{
								String strXMLFileName = (String) XMLFileNameList.get(x);
								String tmpXMLFileName =  iniXMLObj.getValue(strXMLSubject,strXMLFileName);
								if (!util.isNull(tmpXMLFileName) && tmpXMLFileName.indexOf(",") != -1)
								{
									tmpXMLFileName = tmpXMLFileName.substring(0,tmpXMLFileName.indexOf(","));
								}

								strXMLValues += tmpXMLFileName + ",";
							}

							if (!util.isNull(strXMLValues) && strXMLValues.endsWith(","))
							{
								strXMLValues = strXMLValues.substring(0,strXMLValues.length() - 1);
							}
						}
					}

					List temp_zoneComps = groupInfo.getAllComponentsUnderZone(strZone,true);
					for(int p=0;p<temp_zoneComps.size();p++){
						String comp = (String)temp_zoneComps.get(p);
						
						if(extra_comp_grid_details.containsKey(comp))
						{
							HashSet al_list = (HashSet)extra_comp_grid_details.get(comp);
							al_list.addAll(XMLFileNameList);
						}
						else
							extra_comp_grid_details.put(comp,new HashSet(XMLFileNameList));
					}

					gridXMLDataObj.put("Type",strZone+" (Zone)");
					gridXMLDataObj.put("NwLocation",strZoneValues);
					gridXMLDataObj.put("XMLFiles",strXMLValues);
					gridXMLDataObj.put("OriginalTypeName",strZone);
					gridXMLDataObj.put("OriginalType","Zone");
					gridXMLDataArr.add(gridXMLDataObj);
				}
			}

			String associateService =  mappingSubject+"Services";
			String[] strNetworkMappingServices = iniXMLObj.getVariables(associateService);
			if (strNetworkMappingServices != null && strNetworkMappingServices.length > 0)
			{
				for (int s=0;s<strNetworkMappingServices.length;s++)
				{
					String strService = strNetworkMappingServices[s];
					String strServiceValues = iniXMLObj.getValue(associateService,strService);
					XMLFileNameList = new ArrayList();
					XMLFileNameList = util.egTokenizer(strServiceValues,",");
					if (XMLFileNameList != null && !XMLFileNameList.isEmpty())
					{
						strXMLValues = "";
						if (XMLFileNameList.size() == 1)
						{
							String strSingleXMLFileName = iniXMLObj.getValue(strXMLSubject,(String) XMLFileNameList.get(0));
							if (!util.isNull(strSingleXMLFileName) && strSingleXMLFileName.indexOf(",") != -1)
							{
								strSingleXMLFileName = strSingleXMLFileName.substring(0,strSingleXMLFileName.indexOf(","));
							}
							strXMLValues = strSingleXMLFileName;
						}
						else
						{
							for (int x=0;x<XMLFileNameList.size();x++)
							{
								String strXMLFileName = (String) XMLFileNameList.get(x);
								String tmpXMLFileName =  iniXMLObj.getValue(strXMLSubject,strXMLFileName);
								if (!util.isNull(tmpXMLFileName) && tmpXMLFileName.indexOf(",") != -1)
								{
									tmpXMLFileName = tmpXMLFileName.substring(0,tmpXMLFileName.indexOf(","));
								}

								strXMLValues += tmpXMLFileName + ",";
							}

							if (!util.isNull(strXMLValues) && strXMLValues.endsWith(","))
							{
								strXMLValues = strXMLValues.substring(0,strXMLValues.length() - 1);
							}
						}
					}

					List temp_serviceComps = topoInfo.getComponentsForSite(strService);
					for(int p=0;p<temp_serviceComps.size();p++){
						String comp = (String)temp_serviceComps.get(p);
						comp = comp.substring(comp.lastIndexOf(":")+1) +":"+comp.substring(0,comp.lastIndexOf(":"));
						if(extra_comp_grid_details.containsKey(comp))
						{
							HashSet al_list = (HashSet)extra_comp_grid_details.get(comp);
							al_list.addAll(XMLFileNameList);
						}
						else
							extra_comp_grid_details.put(comp,new HashSet(XMLFileNameList));
					}
					gridXMLDataObj.put("Type",strService+" (Service)");
					gridXMLDataObj.put("NwLocation",strServiceValues);
					gridXMLDataObj.put("XMLFiles",strXMLValues);
					gridXMLDataObj.put("OriginalTypeName",strService);
					gridXMLDataObj.put("OriginalType","Service");
					gridXMLDataArr.add(gridXMLDataObj);
				}
			}

			String associateServiceGrp =  mappingSubject+"ServiceGroups";
			String[] strNetworkMappingServiceGrps = iniXMLObj.getVariables(associateServiceGrp);
			if (strNetworkMappingServiceGrps != null && strNetworkMappingServiceGrps.length > 0)
			{
				for (int sg=0;sg<strNetworkMappingServiceGrps.length;sg++)
				{
					String strServiceGrp = strNetworkMappingServiceGrps[sg];
					String strServiceGrpValues = iniXMLObj.getValue(associateServiceGrp,strServiceGrp);
					XMLFileNameList = new ArrayList();
					XMLFileNameList = util.egTokenizer(strServiceGrpValues,",");
					if (XMLFileNameList != null && !XMLFileNameList.isEmpty())
					{
						strXMLValues = "";
						if (XMLFileNameList.size() == 1)
						{
							String strSingleXMLFileName = iniXMLObj.getValue(strXMLSubject,(String) XMLFileNameList.get(0));
							if (!util.isNull(strSingleXMLFileName) && strSingleXMLFileName.indexOf(",") != -1)
							{
								strSingleXMLFileName = strSingleXMLFileName.substring(0,strSingleXMLFileName.indexOf(","));
							}
							strXMLValues = strSingleXMLFileName;
						}
						else
						{
							for (int x=0;x<XMLFileNameList.size();x++)
							{
								String strXMLFileName = (String) XMLFileNameList.get(x);
								String tmpXMLFileName =  iniXMLObj.getValue(strXMLSubject,strXMLFileName);
								if (!util.isNull(tmpXMLFileName) && tmpXMLFileName.indexOf(",") != -1)
								{
									tmpXMLFileName = tmpXMLFileName.substring(0,tmpXMLFileName.indexOf(","));
								}

								strXMLValues += tmpXMLFileName + ",";
							}

							if (!util.isNull(strXMLValues) && strXMLValues.endsWith(","))
							{
								strXMLValues = strXMLValues.substring(0,strXMLValues.length() - 1);
							}
						}
					}
					gridXMLDataObj.put("Type",strServiceGrp+" (Service Group)");
					gridXMLDataObj.put("NwLocation",strServiceGrpValues);
					gridXMLDataObj.put("XMLFiles",strXMLValues);
					gridXMLDataObj.put("OriginalTypeName",strServiceGrp);
					gridXMLDataObj.put("OriginalType","ServiceGroup");
					gridXMLDataArr.add(gridXMLDataObj);
				}
			}

			String associateSegment =  mappingSubject+"Segments";
			String[] strNetworkMappingSegments = iniXMLObj.getVariables(associateSegment);
			if (strNetworkMappingSegments != null && strNetworkMappingSegments.length > 0)
			{
				for (int seg=0;seg<strNetworkMappingSegments.length;seg++)
				{
					String strSegment = strNetworkMappingSegments[seg];
					String strSegmentValues = iniXMLObj.getValue(associateSegment,strSegment);
					XMLFileNameList = new ArrayList();
					XMLFileNameList = util.egTokenizer(strSegmentValues,",");
					if (XMLFileNameList != null && !XMLFileNameList.isEmpty())
					{
						strXMLValues = "";
						if (XMLFileNameList.size() == 1)
						{
							String strSingleXMLFileName = iniXMLObj.getValue(strXMLSubject,(String) XMLFileNameList.get(0));
							if (!util.isNull(strSingleXMLFileName) && strSingleXMLFileName.indexOf(",") != -1)
							{
								strSingleXMLFileName = strSingleXMLFileName.substring(0,strSingleXMLFileName.indexOf(","));
							}
							strXMLValues = strSingleXMLFileName;
						}
						else
						{
							for (int x=0;x<XMLFileNameList.size();x++)
							{
								String strXMLFileName = (String) XMLFileNameList.get(x);
								String tmpXMLFileName =  iniXMLObj.getValue(strXMLSubject,strXMLFileName);
								if (!util.isNull(tmpXMLFileName) && tmpXMLFileName.indexOf(",") != -1)
								{
									tmpXMLFileName = tmpXMLFileName.substring(0,tmpXMLFileName.indexOf(","));
								}

								strXMLValues += tmpXMLFileName + ",";
							}

							if (!util.isNull(strXMLValues) && strXMLValues.endsWith(","))
							{
								strXMLValues = strXMLValues.substring(0,strXMLValues.length() - 1);
							}
						}
					}

					List temp_segmentComps = topoInfo.getComponentsForSegment(strSegment);
					for(int p=0;p<temp_segmentComps.size();p++){
						String comp = (String)temp_segmentComps.get(p);
						comp = comp.substring(comp.lastIndexOf(":")+1) +":"+comp.substring(0,comp.lastIndexOf(":"));
						if(extra_comp_grid_details.containsKey(comp))
						{
							HashSet al_list = (HashSet)extra_comp_grid_details.get(comp);
							al_list.addAll(XMLFileNameList);
						}
						else
							extra_comp_grid_details.put(comp,new HashSet(XMLFileNameList));
					}

					gridXMLDataObj.put("Type",strSegment+" (Segment)");
					gridXMLDataObj.put("NwLocation",strSegmentValues);
					gridXMLDataObj.put("XMLFiles",strXMLValues);
					gridXMLDataObj.put("OriginalTypeName",strSegment);
					gridXMLDataObj.put("OriginalType","Segment");
					gridXMLDataArr.add(gridXMLDataObj);
				}
			}

			String associateComponent =  mappingSubject+"Components";
			String[] strNetworkMappingComponents = iniXMLObj.getVariables(associateComponent);
			if (strNetworkMappingComponents != null && strNetworkMappingComponents.length > 0)
			{
				for (int c=0;c<strNetworkMappingComponents.length;c++)
				{
					String strComponent = strNetworkMappingComponents[c];
					String strComponentValues = iniXMLObj.getValue(associateComponent,strComponent);
					XMLFileNameList = new ArrayList();
					XMLFileNameList = util.egTokenizer(strComponentValues,",");
					if (XMLFileNameList != null && !XMLFileNameList.isEmpty())
					{
						strXMLValues = "";
						if (XMLFileNameList.size() == 1)
						{
							String strSingleXMLFileName = iniXMLObj.getValue(strXMLSubject,(String) XMLFileNameList.get(0));
							if (!util.isNull(strSingleXMLFileName) && strSingleXMLFileName.indexOf(",") != -1)
							{
								strSingleXMLFileName = strSingleXMLFileName.substring(0,strSingleXMLFileName.indexOf(","));
							}
							strXMLValues = strSingleXMLFileName;
						}
						else
						{
							for (int x=0;x<XMLFileNameList.size();x++)
							{
								String strXMLFileName = (String) XMLFileNameList.get(x);
								String tmpXMLFileName =  iniXMLObj.getValue(strXMLSubject,strXMLFileName);

								if (!util.isNull(tmpXMLFileName) && tmpXMLFileName.indexOf(",") != -1)
								{
									tmpXMLFileName = tmpXMLFileName.substring(0,tmpXMLFileName.indexOf(","));
								}
								strXMLValues += tmpXMLFileName + ",";
							}

							if (!util.isNull(strXMLValues) && strXMLValues.endsWith(","))
							{
								strXMLValues = strXMLValues.substring(0,strXMLValues.length() - 1);
							}
						}
					}
					if(extra_comp_grid_details.containsKey("||"+strComponent))
					{
						HashSet al_list = (HashSet)extra_comp_grid_details.get("||"+strComponent);
						al_list.addAll(XMLFileNameList);
					}
					else
						extra_comp_grid_details.put("||"+strComponent,new HashSet(XMLFileNameList));

					if (!util.isNull(strComponent) && strComponent.indexOf(":") != -1)
					{
						String strCompName = strComponent.substring(strComponent.indexOf(":")+1);
						String strCompType = strComponent.substring(0,strComponent.indexOf(":"));

						if (!util.isNull(strCompName) && strCompName.endsWith(":NULL"))
						{
							strCompName = strCompName.substring(0,strCompName.indexOf(":NULL"));
						}
						strComponent = strCompName + " ("+_mapping.getComponentTypeDescription(strCompType)+")";


					}
					gridXMLDataObj.put("Type",strComponent);
					gridXMLDataObj.put("NwLocation",strComponentValues);
					gridXMLDataObj.put("XMLFiles",strXMLValues);
					gridXMLDataObj.put("OriginalTypeName",strNetworkMappingComponents[c]);
					gridXMLDataObj.put("OriginalType","Independent servers");
					gridXMLDataArr.add(gridXMLDataObj);
				}
			}
			if(extra_comp_grid_details != null && extra_comp_grid_details.size() > 0)
			{
				Iterator it = extra_comp_grid_details.entrySet().iterator();
				while(it.hasNext())
				{
					Map.Entry entry = (Map.Entry)it.next();
					String _strComponent = (String)entry.getKey();
					boolean isOrgCompAdded = false;
					if(_strComponent.startsWith("||"))
					{
						isOrgCompAdded = true;
						_strComponent = _strComponent.substring(2);
					}

					HashSet nw_locs = (HashSet)entry.getValue();
					XMLFileNameList = new ArrayList(nw_locs);
					
					String locationStr = "";
					if (XMLFileNameList != null && !XMLFileNameList.isEmpty())
					{
						strXMLValues = "";
						if (XMLFileNameList.size() == 1)
						{
							locationStr = (String) XMLFileNameList.get(0);
							String strSingleXMLFileName = iniXMLObj.getValue(strXMLSubject,locationStr);
							if (!util.isNull(strSingleXMLFileName) && strSingleXMLFileName.indexOf(",") != -1)
							{
								strSingleXMLFileName = strSingleXMLFileName.substring(0,strSingleXMLFileName.indexOf(","));
							}
							strXMLValues = strSingleXMLFileName;
						}
						else
						{
							for (int x=0;x<XMLFileNameList.size();x++)
							{
								String strXMLFileName = (String) XMLFileNameList.get(x);
								String tmpXMLFileName =  iniXMLObj.getValue(strXMLSubject,strXMLFileName);

								if (!util.isNull(tmpXMLFileName) && tmpXMLFileName.indexOf(",") != -1)
								{
									tmpXMLFileName = tmpXMLFileName.substring(0,tmpXMLFileName.indexOf(","));
								}
								strXMLValues += tmpXMLFileName + ",";
								locationStr+= strXMLFileName + ",";
							}

							if (!util.isNull(strXMLValues) && strXMLValues.endsWith(","))
							{
								strXMLValues = strXMLValues.substring(0,strXMLValues.length() - 1);
							}
							if (!util.isNull(locationStr) && locationStr.endsWith(","))
							{
								locationStr = locationStr.substring(0,locationStr.length() - 1);
							}
						}
					}

					String disp_strComponent = _strComponent;
					if (!util.isNull(_strComponent) && _strComponent.indexOf(":") != -1)
					{
						String strCompName = _strComponent.substring(_strComponent.indexOf(":")+1);
						String strCompType = _strComponent.substring(0,_strComponent.indexOf(":"));

						if (!util.isNull(strCompName) && strCompName.endsWith(":NULL"))
						{
							strCompName = strCompName.substring(0,strCompName.indexOf(":NULL"));
						}
						disp_strComponent = strCompName + " ("+_mapping.getComponentTypeDescription(strCompType)+")";

					}

					gridXMLDataObj.put("Type",disp_strComponent);
					gridXMLDataObj.put("NwLocation",locationStr);
					gridXMLDataObj.put("XMLFiles",strXMLValues);
					gridXMLDataObj.put("OriginalTypeName",_strComponent);
					gridXMLDataObj.put("OriginalType","Independent servers");
					gridXMLDataObj.put("edit_delete",new Boolean(isOrgCompAdded));
					gridXMLDataCompArr.add(gridXMLDataObj);


				}
			}

			rootJson.put("gridXMLDataArr",gridXMLDataArr);
			rootJson.put("gridXMLDataCompArr",gridXMLDataCompArr);

		//ArrayList fileNameList = new ArrayList();
		//File uploadXMLDir = new File(dirPath);
		//if(uploadXMLDir.exists())
		//{
			//File uploadXMLFiles[] = uploadXMLDir.listFiles();
			//if(uploadXMLFiles != null)
			//{
				//for(int i=0;i<uploadXMLFiles.length;i++)
				//{
					//File temp = (File)uploadXMLFiles[i];
					//if(!temp.isDirectory())
					//{
						//String fileName = temp.getName();
						//fileNameList.add(fileName);
					//}
				//}
			//}
		//}

		//for(int k=0;k<fileNameList.size();k++)
		//{
			//JSONObject XMLUploadDataObj = new JSONObject();
			//JSONObject XMLUploadDataGridObj = new JSONObject();
			//String fileName = (String)fileNameList.get(k);
			//XMLUploadDataObj.put("displayField",fileName);
			//XMLUploadDataObj.put("valueField",fileName);
			//XMLUploadDataGridObj.put("XMLname",fileName);

			//XMLUploadDataArr.add(XMLUploadDataObj);
			//XMLUploadDataGridArr.add(XMLUploadDataGridObj);
		//}
		//rootJson.put("XMLUploadDataArr",XMLUploadDataArr);
		//rootJson.put("XMLUploadDataGridArr",XMLUploadDataGridArr);

			rootJson.put("isDeleteButton",true);
			rootJson.put("isSearchBcx",true);
			rootJson.put("isNoXMLFiles",false);

		}
		else
		{
			rootJson.put("isDeleteButton",false);
			rootJson.put("isSearchBox",false);
			rootJson.put("isNoXMLFiles",true);
		}
	}

	rootJson.put("filterby",filterby);
	rootJson.put("hiddenObj",hiddenObj);
	rootJson.put("screenLabels",screenLabels);
	out.println(rootJson.toString());
	if(request.getQueryString()!=null)
		session.setAttribute("adminLastAccessedURL","/final/admin/EgGeoMapXmlFiles.jsp?"+request.getQueryString());
	else session.setAttribute("adminLastAccessedURL","/final/admin/EgGeoMapXmlFiles.jsp");
%>



<%!
	public ArrayList getAllComponentsForRemoteAgent(String s_eagent){
		ArrayList component_list = new ArrayList();
		if(s_eagent == null)
			return component_list;

		EgDiscInfo discInfo = new EgDiscInfo("manager");
		EgExternalInfo extInfo = new EgExternalInfo("manager");
		try
		{
			String[] s_eagent_servers = extInfo.getRemoteComponents();
			if (s_eagent_servers != null)
			{
				for(int i=0;i < s_eagent_servers.length;i++)
				{
					String s_tmp = s_eagent_servers[i];
					String s_val = extInfo.getRemoteAgentForHost(s_tmp);
					boolean isMatch = ((s_val.equals(s_eagent)) || (s_val.indexOf(",") > -1 && (s_val.indexOf(s_eagent+",") > -1 || s_val.startsWith(s_eagent+",") || s_val.endsWith(s_eagent))) );
					if(isMatch)
					{
						List types = discInfo.getServerTypesForNick(s_tmp);
						if(types != null && types.size() > 0)
						{
							for (int k=0;k<types.size();k++)
							{
								String _type = (String)types.get(k);
								String port_no = discInfo.getPortForHost(s_tmp,_type);
								if(component_list == null)
									component_list = new ArrayList();
								component_list.add(_type+":"+s_tmp+":"+port_no);
							}
						}
					}
				}
			}
		}
		catch (Exception ee)
		{
			return null;
		}
		return component_list;
	}
%>
