Ext.define('GlobalThreshold.controller.Main',{
	extend: 'Ext.app.Controller',
	refs:[
		{selector:'globalthresholds', ref:'globalthresholds'}
	],
	init:function(){
		this.control({
			'globalthresholds button[id="updateBtn"]':
			{
				'click': this.confirmUpdateData
			},
			'globalthresholds':
			{
				'afterrender': this.afterMainRender
			}
		});
	},
	afterMainRender: function()
	{
		Ext.Ajax.request({
			url:'GlobalThreshold/data/ConfigureGlobalThreshTestsJson.jsp?reqfrom=navlink',
			method:'POST',
			scope:this,
			success:function(response)
			{
				var jsonText = response.responseText;
				publicJson = Ext.decode(jsonText);
				var associateTests = publicJson['ASSOCIATETEST_LIST'];
				var disassociateTests = publicJson['DISASSOCIATETEST_LIST'];
				if((associateTests == null || associateTests == 'undefined') && (disassociateTests == null || disassociateTests == 'undefined'))
				{
					Ext.getCmp('updateBtn').setDisabled(true);
				}
				Ext.getCmp('gloablThreshItemSelector').getStore().removeAll();
				Ext.getCmp('gloablThreshItemSelector').getStore().loadRawData(publicJson['ALLTEST_LIST']);
				Ext.getCmp('gloablThreshItemSelector').setValue(publicJson['DISASSOCIATETEST_LIST']);
			}
		});
	},
	confirmUpdateData: function()
	{
		me = this;
		var existingAssociateTests = publicJson['pfManage'];
		if (existingAssociateTests != null && existingAssociateTests != "undefined")
		{
			var existAssociateTestsArr = existingAssociateTests.split(",");
		}
		var disAssociateTests = publicJson['DISASSOCIATETEST_LIST'];
		var allTestListsFromItemSelector = Ext.getCmp('gloablThreshItemSelector').getValue();
		var ArrVal = new Array();
		var flagEnable = false;
		var flagDisable = false;
		if (disAssociateTests != null && disAssociateTests != "undefined")
		{
			for (var k=0;k<disAssociateTests.length;k++)
			{
				var DataVal = false;
				for (var m=0;m<allTestListsFromItemSelector.length;m++)
				{
					if (allTestListsFromItemSelector[m] == disAssociateTests[k])
					{
						DataVal = true;
						break;
					}
				}
				if (!DataVal)
				{
					flagEnable = true;
					ArrVal[ArrVal.length]= disAssociateTests[k];
				}
			}
		}

		var currentValue = "";
		var fmanage="";
		if(ArrVal != null)
		{
			for (var i=0;i<ArrVal.length;i++)
			{
				fmanage+=ArrVal[i]+"$$";
				currentValue+=ArrVal[i]+",";
			}
		}
		var unManageArr = new Array();
		var Arr = new Array();
		for (var j=0;j<existAssociateTestsArr.length ;j++ )
		{
			var isData = false;
			for (var i=0;i<allTestListsFromItemSelector.length;i++)
			{
				var allValue = allTestListsFromItemSelector[i];
				if (allValue == existAssociateTestsArr[j])
				{
					flagDisable = true;
					unManageArr[unManageArr.length]=existAssociateTestsArr[j];
					isData = true;
					break;
				}
			}
			if (!isData)
			{
				Arr[Arr.length]=existAssociateTestsArr[j];
			}
		}

		var funmanage = "";
		if(unManageArr != null)
		{
			for (var i=0;i<unManageArr.length;i++)
			{
				funmanage+=unManageArr[i]+"$$";
			}
		}

		if(Arr != null)
		{
			for (var i=0;i<Arr.length;i++)
			{
				currentValue+=Arr[i]+",";
			}
		}
		
		if(!flagEnable && !flagDisable)
		{
			Ext.Msg.show({
				title: pageName,
				msg: alert1,
				icon: 'iconExclamation',
				width: alert1.length * 7,
				buttons: Ext.MessageBox.OK
			});
			return;
		}
		qrString = "fmanage="+fmanage+"&currentValue="+currentValue+"&funmanage="+funmanage+"&pfmanage="+existingAssociateTests;
		if(flagEnable)
		{
			Ext.Msg.show({
				title: pageName,
				msg: alert3+' '+alert4,
				width: (alert3+' '+alert4).length * 7,
				buttons: Ext.MessageBox.YESNO,
				icon: 'iconConfirmation',
				fn: function(response) {
					me.updateData(response);
				}
			});
		}
		else
		{
			var myHomeMask = new Ext.LoadMask(Ext.getBody(), {msg:"Updating..."});
			myHomeMask.show();

			Ext.Ajax.request({
				url: 'GlobalThreshold/data/ConfigureGlobalThreshTestsp.jsp?',
				method: 'POST',
				params:qrString,
				timeout: 120000,
				success: function( response )
				{
					myHomeMask.hide();
					var jsonText = response.responseText;
					if (response.status == 200 && !Ext.isEmpty(jsonText))
					{
						Ext.Msg.show({
							title: pageName,
							msg: alert2,
							width: alert2.length * 7,
							buttons: Ext.MessageBox.OK,
							icon: 'iconInformation',
							fn: function() {
						//Ext.Msg.alert(pageName,alert2);
								me.afterMainRender();
							}
						});
					}
				},
				failure: function(response, opts)
				{
					myHomeMask.hide();
					Ext.Msg.show({
						title: pageName,
						msg: 'Problem encountered while processing the request by the server - '+response.statusText,
						icon: 'iconExclamation',
						buttons: Ext.Msg.OK
					});
				}
			});
		}
	},
	updateData: function(btn)
	{
		if(btn != null && btn == 'yes')
		{
			var myHomeMask = new Ext.LoadMask(Ext.getBody(), {msg:"Updating..."});
			myHomeMask.show();

			Ext.Ajax.request({
				url: 'GlobalThreshold/data/ConfigureGlobalThreshTestsp.jsp?',
				method: 'POST',
				params:qrString,
				timeout: 120000,
				success: function( response )
				{
					myHomeMask.hide();
					var jsonText = response.responseText;
					if (response.status == 200 && !Ext.isEmpty(jsonText))
					{
						Ext.Msg.show({
							title: pageName,
							msg: alert2,
							width: alert2.length * 7,
							buttons: Ext.MessageBox.OK,
							icon: 'iconInformation',
							fn: function() {
								me.afterMainRender();
							}
						});
					}
				},
				failure: function(response, opts)
				{
					myHomeMask.hide();
					Ext.Msg.show({
						title: pageName,
						msg: 'Problem encountered while processing the request by the server - '+response.statusText,
						icon: 'iconExclamation',
						buttons: Ext.Msg.OK
					});
				}
			});
		}
		else
		{
			me.afterMainRender();
		}
	}
});



