var noThresholdRuleHtml = '<table align="center"><tr><td align="center" height="400"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+noThresoldRuleMsg+'.</td></tr></table></td></tr></table>';

Ext.define('GroupThreshold.view.ThresholdRules', {
	extend: 'Ext.form.Panel',
	alias: 'widget.thresholdrules',
	//cls:'outerpanel',
	title: threshGrpTitle,
	margin: '8 8 0 8',
	//frame: true,
	//header:{cls:'zonereporthead'},

	ui:'simplePanel simplePanelHeaderBorder',

	requires : [
		'utilities.ScrollCombo',
		'utilities.CustomGrid'
	],

	layout: {
		type: 'vbox',
		align: 'stretch'
	},

	/*dockedItems: [{
		xtype: 'toolbar',
		dock: 'top',
		cls:'adminHeadInfoText',
		height: 25,
		padding: 3,
		border:true,
		layout:{pack:'center'},
		items: [
			{
				xtype: 'component',
				html: '<center><img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="iconAdminInfo" valign="middle" >&nbsp;&nbsp;'+pageDesc1+'.</center>',
			}
		]
	}],*/

	items: [
		{
			xtype: 'customgrid',
			cls:'gridSkin',
			id: 'thresholdRulesGrid',
			hidden: true,
			store: new Ext.data.Store({
				fields:['ThresholdRule','AssociatedGroups','modifyUrl','deleteUrl','isView'],
				data: []
			}),
			flex: 1,
			margin: 10,
			autoScroll: true,
			viewConfig: {
				deferEmptyText: true
			},
			emptyText: noThresholdRuleHtml,
			columns: {
				defaults: {
					sortable: true,
					hideable: false,
					menuDisabled: true,
					draggable: false,
					resizable: false
				},
				items: [
					{
						text: labelTxt12,
						dataIndex: 'ThresholdRule',
						flex:1
					},
					{
						text: labelTxt13,
						dataIndex: 'AssociatedGroups',
						flex:1,
						sortable: false
					},
					{
						xtype: 'actioncolumn',
						id: 'viewID',
						//cls: 'tasks-icon-column-header tasks-view-column-header',
						width: 36,
						//icon: '../../../../resources/images/folder-open.gif',
						iconCls: 'iconDetailedList',
						//tooltip: viewText,
						sortable: false,
						handler: function(grid, rowIndex, colIndex, column, e) 
						{
							var isView = grid.getStore().getAt(rowIndex).get('isView');
							if (isView)
							{
								me.handleThreshRuleViewIconClick(grid, rowIndex, colIndex);
							}
							else
							{
								return false;
							}
						},
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							var isView = record.get('isView');
							if (isView)
							{
								//return "<div style='cursor:pointer' class='iconDetailedList' onclick=\"javascript:me.handleThreshRuleViewIconClick('"+gridView+"','"+row+"','"+col+"')\" ></div>";
							}
							else
							{
								metaData.style = "filter:alpha(opacity=20);opacity:.2;cursor:hand;";
								//return '<div class="iconDetailedListDisabled"></div>';
							}
							metaData.tdAttr = "data-qtip='View' data-qclass='yellowTip'";
						}
					},
					{
						xtype: 'actioncolumn',
						//cls: 'tasks-icon-column-header tasks-edit-column-header',
						width: 36,
						//icon: '../../../../resources/images/edit_task.png',
						iconCls: 'iconModify',		
						//tooltip: btnText4,
						sortable: false,
						handler: function(grid, rowIndex, colIndex, column, e) 
						{
							var isModifyURL = grid.getStore().getAt(rowIndex).get('modifyUrl');
							if (!Ext.isEmpty(isModifyURL) && isModifyURL != undefined && isModifyURL != 'none')
							{
								me.handleThreshRuleEditIconClick(grid, rowIndex, colIndex);
							}
							else
							{
								return false;
							}
						},
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							var isModify = record.get('modifyUrl');
							if (!Ext.isEmpty(isModify) && isModify != undefined && isModify != 'none')
							{
								//return "<div style='cursor:pointer' onclick=\"javascript:me.handleThreshRuleEditIconClick('"+gridView+"','"+row+"','"+col+"')\" class='iconModify'></div>";
							}
							else
							{
								metaData.style = "filter:alpha(opacity=20);opacity:.2;cursor:hand;";
								//return '<div class="iconModifyDisabled"></div>';
							}
							metaData.tdAttr = "data-qtip='Modify' data-qclass='yellowTip'";
						}
					},
					{
						xtype: 'actioncolumn',
						//cls: 'tasks-icon-column-header tasks-delete-column-header',
						width: 36,
						//icon: '../../../../resources/images/delete.png',
						//iconCls: 'iconDelete',
						//tooltip: delText,
						sortable: false,
						//handler: function(grid, rowIndex, colIndex, column, e) { me.handleThreshRuleDeleteIconClick(grid, rowIndex, colIndex); },
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							var isDelete = record.get('deleteUrl');
							metaData.tdAttr = "data-qtip='Delete' data-qclass='yellowTip'";
							if (!Ext.isEmpty(isDelete) && isDelete != undefined && isDelete != 'none')
							{
								return "<div style='cursor:pointer' onclick=\"javascript:me.handleThreshRuleDeleteIconClick('"+gridView+"','"+row+"','"+col+"')\" class='iconDelete'></div>";
							}
							else
							{
								return '<div class="iconDeleteDisabled"></div>';
							}
						}
					}
				]
			},
			tbar: [
				{
					xtype:'tbfill',
				},
				{
					xtype: 'trigger',
					id: 'searchRuleTrigger',
					trigger1Cls: 'x-form-clear-trigger',
					trigger2Cls: 'x-form-search-trigger', 
					cls: 'whitedropdown_search',
					emptyText: 'Search',
					getTriggerMarkup: function() {
						var me = this,
						i = 0,
						hideTrigger = (me.readOnly || me.hideTrigger),
						triggerCls,
						triggerBaseCls = me.triggerBaseCls,
						triggerConfigs = [],
						unselectableCls = Ext.dom.Element.unselectableCls,
						style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
						cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;
						// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
						// single triggerCls config. Should rethink this, perhaps something more structured like a list of
						// trigger config objects that hold cls, handler, etc.
						// triggerCls is a synonym for trigger1Cls, so copy it.
						if (!me.trigger1Cls) {
							me.trigger1Cls = me.triggerCls;
						}
						// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
						for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
							if (i == 0)
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+i,
									style: style + "display:none;",
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
							else
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+i,
									style: style,
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
						}
						triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
						return Ext.DomHelper.markup(triggerConfigs);
					},
					onTrigger1Click: function()
					{
						this.reset();
					},
					onTrigger2Click: function(Obj)
					{
						var searchVal = Ext.getCmp('searchRuleTrigger').getValue();
						me.filterThresholdRuleTriggerEvent(searchVal);
					}
				},
				{
					xtype: 'toolbar',
					ui: 'footer',
					items:[
						{
							xtype: 'button',
							id: 'addNewRuleBtn',
							cls:'button20',
							text: labelTxt11
						},
						{
							xtype: 'button',
							cls:'button20',
							id: 'thresholdRulesAssociateBtn',
							text: labelTxt3
						}
					]
				}
			]
		}
	],

	tools: [
		{
			xtype: 'button',
			text: btnText1,
			cls:'backbutton',
			iconCls:'iconBack',
			id: 'rulePageMainBackBtn'
		}
	],
	listeners: {
		boxready: function() 
		{
			new Ext.ToolTip({
				target: document.getElementById('threshGrpTitle'),
				anchor: 'top',
				anchorOffset:42,
				mouseOffset: [-55, 0],
				html: pageDesc1,
				cls: "adminInfoTooltip"
			});
		}
	}

});



