Ext.define('Groups.controller.ConfigGroupControl',{
	extend:'Ext.app.Controller',
	views:['ComponentGroup'],
	refs:[
		{selector:'componentgroup', ref:'componentgroup'},
	],
	init:function(){
		//this.buildFieldData()

		this.control({
			'componentgroup':
			{
				'afterrender': this.afterMainRender
			}
		});
	},
	buildFieldData: function(mode,zone){
		Ext.Ajax.request({
			url: 'Groups/data/EgConfigGroupsJson.jsp?mode='+encodeURIComponent(mode)+'&zone='+encodeURIComponent(zone),
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},
	initializeFields: function(groupName){
		var me=this;
		var executiveForm = this.getComponentgroup().getForm();
		var screenLabels = publicJSON['screenLabels'];
		if (groupName == "null")
		{
			me.setValueWithOptionInList(executiveForm, 'groupcombo', publicJSON['ExistingGroupNames'],'');
		}
		else
		{
			me.setValueWithOptionInList(executiveForm, 'groupcombo', publicJSON['ExistingGroupNames'],groupName);
		}
	},

	setValueWithOptionInList: function(form, fieldName, list, value) {
		form.findField(fieldName).getStore().loadRawData(list);
		form.findField(fieldName).suspendEvents(false);
		var valueAssigned = false;
		if (list.length > 0)
		{
			for(var listCounter = 0 ; listCounter < list.length ; listCounter++){
				if(list[listCounter].valueField == value && !Ext.isEmpty(value) && value != null){
					form.findField(fieldName).setValue(value);
					valueAssigned = true;
				}
			}
		}
		if(!valueAssigned){
			form.findField(fieldName).setValue(list[0].valueField);
		}
		form.findField(fieldName).resumeEvents();
	},

	afterMainRender : function(mode,groupName,zoneName)
	{
		var GroupController = this.getController('Groups.controller.Main');
		var me=this;
		var modifyGroupName="";
		var executiveForm = this.getComponentgroup().getForm();
		if(mode!=null && mode=="modify")
		{
			modifyGroupName = groupName;
			Ext.getCmp('groupname').hide(true);
			Ext.getCmp('groupcombo').show(true);
			this.initializeFields(groupName);
		}
		else if(mode=="add")
		{
			Ext.getCmp('groupcombo').hide(true);
			Ext.getCmp('groupname').show(true);
		}
		//me.setValueWithOptionInList(executiveForm, 'zonecombo', publicJSON['ExistingZoneNames'],"");

		Ext.Ajax.request({
			url: 'Groups/data/EgConfigGroupsJson.jsp?group='+encodeURIComponent(modifyGroupName)+"&mode="+encodeURIComponent(mode)+'&zone='+encodeURIComponent(zoneName),
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}

				var chosenCType = Ext.getCmp('componentType').getValue();
				var availabelitemselectHosts = Ext.getCmp('itemselectHosts').getValue();

				if (Ext.isEmpty(chosenCType) || Ext.isEmpty(availabelitemselectHosts))
				{
					Ext.getCmp('componentType').getStore().suspendEvents(true);
					Ext.getCmp('componentType').getStore().clearFilter(true);
					Ext.getCmp('componentType').getStore().loadRawData(publicJSON['componentType']);
					Ext.getCmp('componentType').getStore().resumeEvents();
					Ext.getCmp('componentType').setValue('-1');

					Ext.getCmp('itemselectHosts').getStore().suspendEvents(true);
					Ext.getCmp('itemselectHosts').getStore().loadRawData(publicJSON['itemSelectorValue']);
					Ext.getCmp('itemselectHosts').getStore().resumeEvents();
					Ext.getCmp('itemselectHosts').setValue(publicJSON['otherHosts']);

					me.setValueWithOptionInList(executiveForm, 'zonecombo', publicJSON['ExistingZoneNames'],"");
					Ext.getCmp('zonecombo').setValue(Ext.getCmp('zonecombo').getStore().getAt(0));
				}
				else if (chosenCType == '-1')
				{
					Ext.getCmp('itemselectHosts').getStore().suspendEvents(true);
					Ext.getCmp('itemselectHosts').getStore().loadRawData(publicJSON['itemSelectorValue']);
					Ext.getCmp('itemselectHosts').getStore().resumeEvents();
					Ext.getCmp('itemselectHosts').setValue(publicJSON['otherHosts']);

					me.setValueWithOptionInList(executiveForm, 'zonecombo', publicJSON['ExistingZoneNames'],"");
					Ext.getCmp('zonecombo').setValue(Ext.getCmp('zonecombo').getStore().getAt(0));
				}
				else
				{
					GroupController.compoTypeLoad();
				}

				Ext.getCmp('UpdateBTN').setText(publicJSON['screenLabels']['admin.common.buttonText']);
				
			}
		});
		Ext.getCmp('groupname').focus();
	}
});



