Ext.define('Groups.controller.Main',{
	extend:'Ext.app.Controller',
	views:['Groups','ComponentGroup','RenameGroup'],
	refs:[
		{selector:'componentgroups', ref:'componentgroups'},
		{selector:'componentgroup', ref:'componentgroup'},
		{selector:'renamegroup', ref:'renamegroup'},
	],
	init:function(){
		appCnt = this;
		this.buildFieldData()

		this.control({
			'componentgroups':
			{
				'afterrender': this.afterMainRender
			},
			'componentgroups [id="gridDisplay"]': {
				//'itemmouseenter': this.showActions,
				//'itemmouseleave': this.hideActions,
				//'viewready':this.expandAllRows
			},
			'componentgroups trigger[name="gridSearch"]': {
				'change': this.mainGridSearch
			},
			'componentgroups button[id="addGroup"]': {
				'click': this.addGroup
			},
			'componentgroup combo[id="groupcombo"]':
			{
				'select': this.comboLoad
			},
			'componentgroup multiselectSi[id="zonecombo"]':
			{
				'change': this.zonecombo
			},
			'componentgroup combo[id="componentType"]':
			{
				'select': this.compoTypeLoad
			},
			'componentgroup button[id="UpdateBTN"]':
			{
				'click': this.updation
			},
			'componentgroup button[id="backbutton"]':
			{
				'click': this.backbutton
			},
			'renamegroup button[id="renameBTN"]':
			{
				'click': this.renameGroup
			},
			'componentgroup textfield[id="groupname"]':
			{
				'blur': this.validateName
			},
		});
	},
	/*expandAllRows: function()
	{
		var titlesGrid = Ext.getCmp('gridDisplay');     
		var expander = titlesGrid.getPlugin('rowexpanderDiv');
		for(i = 0; i <titlesGrid.getStore().getCount(); i++)
		{
			expander.toggleRow(i);
		}
	},*/
	validateName: function()
	{
		var grpName = Ext.getCmp('groupname').getValue();
		if(grpName != null && grpName.trim().length > 0)
		{
			if(this.specialCharacterCheck(grpName))
			{
				Ext.Msg.show({
					title : pageTitle,
					msg : publicJSON['screenLabels']['admin.common.special characters not allowed']+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function()
					{
						Ext.getCmp('groupname').focus();
					}
				});
				return false;
			}
		}
	},
	specialCharacterCheck: function(text)
	{
		var s_spl = "`~!@#$%^&*()+={}[]|\\:;\"\'<>,?\/";
		try
		{
			for(count = 0; count < text.length; count++)
			{
				var check_char = s_spl.indexOf(text.charAt(count));
				if(check_char >= 0)
					return true;
			}
		}
		catch (e)
		{
		}
		return false;
	},
	expandAllRows:function()
	{
		var titlesGrid = Ext.getCmp('gridDisplay');
		var store = titlesGrid.getStore();
		var expander = titlesGrid.getPlugin('rowexpanderDiv');
		for(var i = 0; i < store.getCount(); i++) {
			var record = store.getAt(i);
			if(!expander.recordsExpanded[record.internalId]){
				expander.toggleRow(i);
			}   
		}
	},
	collapseAllRows: function()
	{
		var titlesGrid = Ext.getCmp('gridDisplay');
		var store = titlesGrid.getStore();
		var expander = titlesGrid.getPlugin('rowexpanderDiv');
		for(var i = 0; i < store.getCount(); i++) {
			var record = store.getAt(i);
			if(expander.recordsExpanded[record.internalId]){
				expander.toggleRow(i);
			}   
		}
	},
	backbutton: function()
	{
		/*Ext.getCmp('viewport').removeAll();
		appCnt.buildFieldData();
		Ext.getCmp('viewport').add({xtype: 'componentgroups'});
		appCnt.afterMainRender();*/
		window.location.href="EgComponentGroups.jsp?fromWizard="+fromWizard;
		if (comeFrom == 'comp_mng_umng')
		{
			window.location.href = "EgConfigEnv.jsp?srvtype="+comptype+"&activeCompTypes="+activeCompTypes+"&fromWizard="+fromWizard;
			return;
		}
		else if (comeFrom == 'agg_mng_umng')
		{
			window.location.href = "aggConfigEnv.jsp?srvtype="+comptype+"&activeCompTypes="+activeCompTypes+"&fromWizard="+fromWizard;
			return;
		}
		else if (comeFrom == 'discovery_mng_umng')
		{
			window.location.href = "EgDiscoveryPane.jsp?server="+comptype+"&activeCompTypes="+activeCompTypes+"&selectedNode=node11";
			return;
		}
		else if (comeFrom == 'comp_add_modify')
		{
			window.location.href = "EgDispServer.jsp?comptype="+comptype+"&activeCompTypes="+activeCompTypes+"&fromWizard="+fromWizard;
			return;
		}
		else if (comeFrom == 'comp_add_mod_new')
		{
			window.location.href = "EgAdminOperations.jsp?server="+comptype+"&fromAction="+fromAction+"&classify="+classify;
			return;
		}
	},
	
	showActions: function(view, task, node, rowIndex, e){
		var hideIcon = view.getStore().getAt(rowIndex);
		var isDisabled = hideIcon.get('isDisabled');
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
		Ext.each(icons, function(icon){
		if (isDisabled == 'true')
		{
			Ext.get(icons[0]).removeCls('x-hidden');
		}
		else
		{
			Ext.get(icon).removeCls('x-hidden');
		}
	});
	},
	renameGroup:function()
	{
		var old_name=Ext.getCmp('currentname').getValue();
		var new_name=Ext.getCmp('newname').getValue();
		
		if(new_name=='' || new_name.length ==0)
		{
			Ext.Msg.show({
				title : renameTitle,
				msg : publicJSON['screenLabels']['admin.common.field value cannot be blank']+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK
			});
			return;
		}
		else if(old_name==new_name)
		{
			Ext.Msg.show({
				title : renameTitle,
				msg : publicJSON['screenLabels']['sameName']+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK
			});
			return;
		}
		var s_spl = "`~!@#$%^&*()+={}[]|\\:;\"\'<>,?\/";
		var isDouble = publicJSON['isDouble'];
		for(count = 0; count < new_name.length; count++)
		{
			var check_char = s_spl.indexOf(new_name.charAt(count));
			if(!isDouble)
			{
				var charValue=new_name.charCodeAt(count);
				if(charValue>255)
				{
					Ext.Msg.show({
						title : renameTitle,
						msg : publicJSON['screenLabels']['admin.common.DBL not allowed']+'.',
						icon : 'iconExclamation',
						buttons : Ext.Msg.OK
					});
					return false;
				}
			}
			if(new_name.charAt(count) == ' ')
			{
				Ext.Msg.show({
					title : renameTitle,
					msg : publicJSON['screenLabels']['admin.common.space not allowed']+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK
					});
				return false;
			}
			else if(check_char >= 0)
			{
				Ext.Msg.show({
					title : renameTitle,
					msg : publicJSON['screenLabels']['admin.common.special characters not allowed']+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK
				});
				return false;
			}
		}
		var renameUrl = "Groups/data/renameJson.jsp?rename=Group&old_name="+encodeURIComponent(old_name)+"&new_name="+encodeURIComponent(new_name);
		Ext.Ajax.request({
			url: renameUrl,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var myjsonText = response.responseText;
					renameJSON = Ext.decode(response.responseText);
					if(renameJSON.renamed)
					{
						window.location.href="EgComponentGroups.jsp?fromWizard="+fromWizard;
					}
					else
					{
						Ext.Msg.show({
							title : renameJSON.rename,
							msg : renameJSON.message,
							icon : 'iconInformation',
							buttons : Ext.Msg.OK
						});
						
					}
				}
				
			}
		});
		
	},
	hideActions: function(view, task, node, rowIndex, e){
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
		Ext.each(icons, function(icon){
		Ext.get(icon).addCls('x-hidden');
	});
	},
	handleRenameIconClick: function(grid, rowIndex, colIndex){
		btnText = 'Rename';
		//var rec = grid.getStore().getAt(rowIndex);
		var rec =  Ext.getCmp("gridDisplay").getStore().getAt(rowIndex);
		var groupName = rec.get('Groupname');
		this.showEditWindow(groupName);
	},
	showEditWindow: function(groupName)
	{
		Ext.widget('renamegroup').show();
		Ext.getCmp('currentname').setValue(groupName);
		
		Ext.Ajax.request({
			url: 'Groups/data/renamehelpJson.jsp',
			method: 'POST'
		});
	},
	handleEditIconClick: function(grid, rowIndex, colIndex){
		btnText = 'Edit';
		var rec =  Ext.getCmp("gridDisplay").getStore().getAt(rowIndex);
		var groupName = rec.get('Groupname');
		var configGroupController = this.getController('Groups.controller.ConfigGroupControl');
		Ext.getCmp('viewport').removeAll();
		configGroupController.buildFieldData("modify","");
		Ext.getCmp('viewport').add({xtype: 'componentgroup'});
		configGroupController.afterMainRender("modify",groupName,"");
	},
	handleGroupDetailsIconClick :function(grid, rowIndex, colIndex)
	{
		var rec =  Ext.getCmp("gridDisplay").getStore().getAt(rowIndex);
		var groupName = rec.get('Groupname');
		var me =this;
		Ext.widget("window",{
			extend:'Ext.container.Container',
			alias:'widget.cfgsecuritygroup',
			title : "",
			id:'groupWindow',
			modal : true,
			border : false,
			floatable:true,
			floating :true,
			autoScroll:false,
			closeAction: 'destory',
			doClose: function() {
				this.destroy();
			},
			width: 500,
			//height: 450,
			padding:'5 10 10 10',
			
			items:[
				{
					xtype: 'container',
					layout: {
						type: 'hbox',
						pack: 'center'
					},
					items : [
						{
							xtype: 'multiselectfield',
							flex : 1,
							height: 350,
							margin: 5,
							cls:'multiselect',
							id: 'securityGrpList',
							autoScroll : true,
							scroll : true,
							hidden : true,
							store: Ext.data.Store({
								fields: ['displayField','valueField'],
								data: []
							}),
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local'
						},
						{
							xtype : 'component',
							id : 'errorDiv',
							border : false,
							hidden : true,
							style : {'text-align':'center'},
							html : '<div class = "iconExclamation" style="margin:28% auto auto auto"></div><div style="margin-bottom:28%"></div>'
						}
					]
				}
			],
			listeners : {
				'afterrender' : function() {
					var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading... Please wait.'});
					myMask.show();
					var me = this;
					Ext.Ajax.request({
						url: 'Groups/data/EgConfigGroupsJson.jsp?group='+encodeURIComponent(groupName),
						method: 'POST',
						async: false,
						success: function(response)
						{
							myMask.hide();
							var jsonText = Ext.decode(response.responseText);
							if (!Ext.isEmpty(jsonText.associateCompValue))
							{
								Ext.getCmp('securityGrpList').getStore().loadRawData(jsonText.associateCompValue);
								Ext.getCmp('securityGrpList').show()
								Ext.getCmp('groupWindow').setTitle("Hosts Associated with "+groupName)
								Ext.getCmp('errorDiv').hide();
								
							}
							else
							{
								Ext.getCmp('securityGrpList').hide()
								Ext.getCmp('errorDiv').show();
								
							}
						},
						failure : function()
						{
							myMask.hide();
						}
					});
				}
			}
		}).show();
		
	},
	
	handleDeleteIconClick: function(grid, rowIndex, colIndex){

		var gridObj = Ext.getCmp('gridDisplay');
		var DispValues = gridObj.getStore().getAt(rowIndex);
		var groupName = DispValues.get('Groupname');
		Ext.Msg.show(
		{
			title : mainPageTitle,
			msg : publicJSON['screenLabels']['deleteiconMsg1']+" '"+groupName+"' "+ publicJSON['screenLabels']['deleteiconMsg2'],
			icon : 'iconConfirmation',
			buttons : Ext.Msg.YESNO,
			fn : function(buttonText) {
				if (buttonText == "yes") 
				{
					var resultUrl = "Groups/data/EgconfiggrouppJson.jsp?deleteGroups="+encodeURIComponent(groupName)+"&mode=delete";
					Ext.Ajax.request({
						url: resultUrl,
						method: 'POST',
						async:false,
						success: function( response )
						{
							if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
							{
								var myjsonText = response.responseText;
								var myjsonObj = Ext.decode( myjsonText );
								var isUpdated = myjsonObj['isUpdated'];
								var myupdateUrl = myjsonObj['updateUrl'];
								if(isUpdated=='true')
								{
									window.location.href=myupdateUrl+"?fromWizard="+fromWizard;
								}
								else
								{
									Ext.Msg.show({
										title : mainPageTitle,
										msg : myjsonObj['screenLabels']['ErrorInUpdation']+'.',
										icon : 'iconExclamation',
										buttons : Ext.Msg.OK
									});
								}
							}
						}
					});
				}
			}
		});
	},

	handleDeleteSelected: function(){
		var grid=Ext.getCmp('gridDisplay').getSelectionModel().getSelection();
		var values='';
		var array=new Array();
		var selectedGroups="";
		if(grid=="")
		{
			Ext.MessageBox.show({
				title : 'Component Groups',
				msg : publicJSON['screenLabels']['no group selected']+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK
			});
			return false;
		}
		for(var i=0; i < grid.length ; i++)
		{
			values=grid[i];
			id=values.get('Groupname');
			if(id!=null)
			{
				array.push(id);
			}
		}
		for(var j=0; j < array.length; j++)
		{
			selectedGroups +=array[j]+",";
		}
		Ext.Msg.show({
			title : mainPageTitle,
			msg : publicJSON['screenLabels']['deleteforSelectedMessage'],
			icon : 'iconConfirmation',
			buttons : Ext.Msg.YESNO,
			fn : function(buttonText) {
				if (buttonText == "yes") 
				{
					var resultUrl = "Groups/data/EgconfiggrouppJson.jsp?deleteGroups="+encodeURIComponent(selectedGroups)+"&mode=delete";
					Ext.Ajax.request({
						url: resultUrl,
						method: 'POST',
						async:false,
						success: function( response )
						{
							if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
							{
								var myjsonText = response.responseText;
								var myjsonObj = Ext.decode( myjsonText );
								var isUpdated = myjsonObj['isUpdated'];
								var myupdateUrl = myjsonObj['updateUrl'];
								if(isUpdated=='true')
								{
									window.location.href=myupdateUrl+"?fromWizard="+fromWizard;
								}
								else
								{
									Ext.Msg.show({
										title : mainPageTitle,
										msg : myjsonObj['screenLabels']['ErrorInUpdation']+'.',
										icon : 'iconExclamation',
										buttons : Ext.Msg.OK
									});
								}
							}
						}
					});
				}
			}
		});
	},

	
	buildFieldData: function(){
		Ext.Ajax.request({
			url: 'Groups/data/EgDispGroupsJson.jsp?reqfrom=navlink',
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},
	afterMainRender : function()
	{
		if(comeFrom == 'comp_mng_umng' || comeFrom == 'agg_mng_umng' || comeFrom == 'discovery_mng_umng' || comeFrom == 'comp_add_modify' || comeFrom == 'comp_add_mod_new')
		{
			var configGroupController = this.getController('Groups.controller.ConfigGroupControl');
			Ext.getCmp('viewport').removeAll();
			configGroupController.buildFieldData("modify",groupName);
			Ext.getCmp('viewport').add({xtype: 'componentgroup'});
			configGroupController.afterMainRender("modify",groupName,"");
			return;
		}
		var resultsData = publicJSON['gridValues'];
		Ext.getCmp('gridDisplay').show();
		Ext.getCmp('gridDisplay').getStore().suspendEvents(true);
		Ext.getCmp('gridDisplay').getStore().loadRawData(resultsData);
		Ext.getCmp('gridDisplay').getStore().resumeEvents();
		
		var noExtFound = publicJSON['NoExtFound'];
		if (noExtFound == "true")
		{
			Ext.getCmp('gridSearch').disable();
		}
		else
		{
			Ext.getCmp('gridSearch').enable();
		}
		if(publicJSON['disableAddGrp'] === "true")
		{
			Ext.getCmp('NoExtPresent').show();
			Ext.getCmp('gridDisplay').hide();
		}
		else
		{
			Ext.getCmp('NoExtPresent').hide();
			Ext.getCmp('gridDisplay').show();
		}
	},
	mainGridSearch : function(obj){
		var gridsearch = Ext.getCmp('gridSearch').getValue();

		if (gridsearch == "" || gridsearch.length == 0)
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');
		}

		Ext.Ajax.request({
			url: 'Groups/data/EgDispGroupsJson.jsp?egTitleSearchStr='+encodeURIComponent(gridsearch),
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
				var value = publicJSON['gridValues'];
				Ext.getCmp('gridDisplay').show();
				if (value != null && value.length > 0)
				{
					Ext.getCmp('gridDisplay').getStore().suspendEvents(true);
					Ext.getCmp('gridDisplay').store.loadRawData(publicJSON['gridValues']);
					Ext.getCmp('gridDisplay').getStore().resumeEvents();
				}
				else
				{
					Ext.getCmp('gridDisplay').store.loadData('');
					Ext.getCmp('gridDisplay').getView().emptyText='<table border="0" height="350px" width="100%"><tr><td align=center valign=middle><img src="/final/images/spacer.gif" class="iconInformation" valign="middle" /><div class="commonErrorMsgText">'+nogrpSearch+'.</div></td></tr></table>';
					Ext.getCmp('gridDisplay').getView().refresh();
				}
				if(publicJSON['disableAddGrp'] === "true")
					Ext.getCmp('addGroup').setDisabled(true);
				else
					Ext.getCmp('addGroup').setDisabled(false);
			}
		});
	},
	addGroup : function()
	{
		var configGroupController = this.getController('Groups.controller.ConfigGroupControl');
		Ext.getCmp('viewport').removeAll();
		configGroupController.buildFieldData("add","");
		Ext.getCmp('viewport').add({xtype: 'componentgroup'});
		configGroupController.afterMainRender("add","","");
	},

	comboLoad: function()
	{
		var groupCombo = Ext.getCmp('groupcombo').getValue();
		groupCombo = encodeURIComponent(groupCombo);
		var mode = publicJSON['addModifyMode'];
		var configGroupController = this.getController('Groups.controller.ConfigGroupControl');
		var executiveForm = this.getComponentgroup().getForm();
		Ext.Ajax.request({
			url: 'Groups/data/EgConfigGroupsJson.jsp?group='+groupCombo+"&mode="+mode+"&user_id=-1",
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
				Ext.getCmp('itemselectHosts').getStore().suspendEvents(true);
				Ext.getCmp('itemselectHosts').getStore().loadRawData(publicJSON['itemSelectorValue']);
				Ext.getCmp('itemselectHosts').getStore().resumeEvents();
				Ext.getCmp('itemselectHosts').setValue(publicJSON['otherHosts']);

				Ext.getCmp('componentType').getStore().suspendEvents(true);
				Ext.getCmp('componentType').getStore().clearFilter(true);
				Ext.getCmp('componentType').getStore().loadRawData(publicJSON['componentType']);
				Ext.getCmp('componentType').getStore().resumeEvents();
				Ext.getCmp('componentType').setValue('-1');

				Ext.getCmp('UpdateBTN').setText(publicJSON['screenLabels']['admin.common.buttonText']);

				configGroupController.setValueWithOptionInList(executiveForm, 'zonecombo', publicJSON['ExistingZoneNames'],"");
				Ext.getCmp('zonecombo').setValue(Ext.getCmp('zonecombo').getStore().getAt(0));
			}
		});
	},
	zonecombo : function()
	{
		var zone = Ext.getCmp('zonecombo').getValue();
		var action = '';
		if(zone != 'none')
			action = 'combo';
		var mode= publicJSON['addModifyMode'];
		if(mode=="add")
			var groupname = Ext.getCmp('groupname').getValue();
		else
			var groupname = Ext.getCmp('groupcombo').getValue();
		
		Ext.Ajax.request({
			url: 'Groups/data/EgConfigGroupsJson.jsp?group='+groupname+"&mode="+mode+'&zone='+zone+'&action='+action,
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
				Ext.getCmp('itemselectHosts').getStore().suspendEvents(true);
				Ext.getCmp('itemselectHosts').getStore().loadRawData(publicJSON['itemSelectorValue']);
				Ext.getCmp('itemselectHosts').getStore().resumeEvents();
				Ext.getCmp('itemselectHosts').setValue(publicJSON['otherHosts']);

				Ext.getCmp('componentType').getStore().suspendEvents(true);
				Ext.getCmp('componentType').getStore().clearFilter(true);
				Ext.getCmp('componentType').getStore().loadRawData(publicJSON['componentType']);
				Ext.getCmp('componentType').getStore().resumeEvents();
				Ext.getCmp('componentType').setValue('-1');

				//Ext.getCmp('UpdateBTN').setText(publicJSON['screenLabels']['admin.common.buttonText']);
			}
		});
	},

	compoTypeLoad : function()
	{
		var zone = Ext.getCmp('zonecombo').getValue();
		var comptype = Ext.getCmp('componentType').getValue();
		var action = '';
		if(zone != 'none')
			action = 'combo';
		var mode= publicJSON['addModifyMode'];
		if(mode=="add")
			var groupname = Ext.getCmp('groupname').getValue();
		else
			var groupname = Ext.getCmp('groupcombo').getValue();
		
		Ext.Ajax.request({
			url: 'Groups/data/EgConfigGroupsJson.jsp?group='+groupname+"&mode="+mode+'&zone='+zone+'&action='+action+'&comptype='+comptype,
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
				Ext.getCmp('componentType').getStore().suspendEvents(true);
				Ext.getCmp('componentType').getStore().clearFilter(true);
				Ext.getCmp('componentType').getStore().loadRawData(publicJSON['componentType']);
				Ext.getCmp('componentType').getStore().resumeEvents();

				Ext.getCmp('itemselectHosts').getStore().suspendEvents(true);
				Ext.getCmp('itemselectHosts').getStore().loadRawData(publicJSON['itemSelectorValue']);
				Ext.getCmp('itemselectHosts').getStore().resumeEvents();
				Ext.getCmp('itemselectHosts').setValue(publicJSON['otherHosts']);

				//Ext.getCmp('UpdateBTN').setText(publicJSON['screenLabels']['admin.common.buttonText']);
			}
		});
	},

	updation: function(btn)
	{
		var configGroupController = this.getController('Groups.controller.ConfigGroupControl');
		var isDouble = publicJSON['isDouble'];
		var mode= publicJSON['addModifyMode'];
		
		var groupname = '';
		if(mode=="add")
			groupname = Ext.getCmp('groupname').getValue();
		else
			groupname = Ext.getCmp('groupcombo').getValue();

		var zone = Ext.getCmp('zonecombo').getValue();

		var assocaitedHostCount = Ext.getCmp('itemselectHosts').fromField.getStore().getCount();

		var s_spl = "`~!@#$%^&*()+={}[]|\\:;\"\'<>,?\/";
		if(groupname!=null)
		{
			for(count = 0; count < groupname.length; count++)
			{
				var check_char = s_spl.indexOf(groupname.charAt(count));
				if(groupname.charAt(count) == ' ')
				{
					Ext.Msg.show({
						title : pageTitle,
						msg : publicJSON['screenLabels']['admin.common.space not allowed']+'.',
						icon : 'iconExclamation',
						buttons : Ext.Msg.OK,
						fn : function()
						{
							Ext.getCmp('groupname').focus();
						}
					});
					return false;
				}
				else if(check_char >= 0)
				{
					Ext.Msg.show({
						title : pageTitle,
						msg : publicJSON['screenLabels']['admin.common.special characters not allowed']+'.',
						icon : 'iconExclamation',
						buttons : Ext.Msg.OK,
						fn : function()
						{
							Ext.getCmp('groupname').focus();
						}
					});
					return false;
				}
				else if(!isDouble)
				{
					var charValue=groupname.charCodeAt(count);
					if(charValue>255)
					{
						Ext.Msg.show({
							title : pageTitle,
							msg : publicJSON['screenLabels']['admin.common.DBL not allowed']+'.',
							icon : 'iconExclamation',
							buttons : Ext.Msg.OK,
							fn : function()
							{
								Ext.getCmp('groupname').focus();
							}
						});
						return false;
					}
				}
			}
		}
		if (groupname==null || groupname.length == 0)
		{
			Ext.Msg.show({
				title : pageTitle,
				msg : publicJSON['screenLabels']['admin.common.Please enter a name']+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn)
				{
					Ext.getCmp('groupname').focus();
					return false;
				}
			});
		}
		else if(assocaitedHostCount == null || assocaitedHostCount == undefined || assocaitedHostCount == 0)
		{
			Ext.Msg.show({
				title : pageTitle,
				msg : errMsg+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn)
				{
					if(mode.toLowerCase() == "modify")
					{
						Ext.getCmp('itemselectHosts').getStore().suspendEvents(true);
						Ext.getCmp('itemselectHosts').getStore().loadRawData(publicJSON['itemSelectorValue']);
						Ext.getCmp('itemselectHosts').getStore().resumeEvents();
						Ext.getCmp('itemselectHosts').setValue(publicJSON['otherHosts']);
					}
					return false;
				}
			});
		}
		else
		{
			var updateUrl = 'Groups/data/EgconfiggrouppJson.jsp?';
			var unmanagedHostList = Ext.getCmp('itemselectHosts').getValue();

			var Arr = new Array();
			for (var i=0;i<Ext.getCmp('itemselectHosts').getStore().getCount();i++)
			{
				var allValue = Ext.getCmp('itemselectHosts').getStore().getAt(i).get('valueField');
				var isData = false;
				for (var j=0;j<unmanagedHostList.length ;j++ )
				{
					if (allValue == unmanagedHostList[j])
					{
						isData = true;
						break;
					}
				}
				if (!isData)
				{
					Arr[Arr.length]=allValue;
				}
			}
			var tempmanagedHostList = Arr;
			var managedHostList = tempmanagedHostList.toString();

			var flagEnable = false;
			var managedHost_Only = new Array();
			var managedStr = publicJSON['existingHosts'];
			managedStr = ","+managedStr+",";
			var newlyManagedHost="";
			var newlyManagedHostTokens = managedHostList.split(",");
			for(i = 0; i < newlyManagedHostTokens.length; i++)
			{
				newlyManagedHost = newlyManagedHostTokens[i];
				if(managedStr.indexOf(","+newlyManagedHost+",") == -1)
				{
					managedHost_Only[i] = newlyManagedHost;
					flagEnable = true;
				}
			}

			var flagDisable = false;
			var unManagedHosts_Only = new Array();
			var unManagedStr = publicJSON['notExistingHosts'];
			var unmanagedHostListVal = unmanagedHostList.toString();
			var newlyUnManagedHost="";
			var newlyUnManagedHostTokens = unmanagedHostListVal.split(",");
			unManagedStr = ","+unManagedStr+",";
			for(i = 0; i < newlyUnManagedHostTokens.length; i++)
			{
				newlyUnManagedHost = newlyUnManagedHostTokens[i];
				if(unManagedStr.indexOf(","+newlyUnManagedHost+",") == -1)
				{
					unManagedHosts_Only[i] = newlyUnManagedHost;
					flagDisable = true;
				}
			}

			Ext.Ajax.request({
				url: 'Groups/data/EgConfigGroupsJson.jsp?group='+encodeURIComponent(groupname)+"&mode="+encodeURIComponent(mode)+"&zone="+encodeURIComponent(zone)+"&validate=true",
				method: 'POST',
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						var jsonObj = Ext.decode( jsonText );
						var isValidName = jsonObj['screenLabels']['isValid']; 
						if(isValidName=="false")
						{
							Ext.Msg.show({
								title : pageTitle,
								msg : jsonObj['screenLabels']['admin.common.ErroInAddingGroup']+'.',
								icon : 'iconExclamation',
								buttons : Ext.Msg.OK
							});
							return;
						}
						else
						{
							if(managedHostList=="")
							{
								Ext.Msg.show({
									title : pageTitle,
									msg : publicJSON['screenLabels']['admin.common.Please associate atleast one component to a group']+'.',
									icon : 'iconExclamation',
									buttons : Ext.Msg.OK
								});
								return;
							}
							var oldGroupName='';
							if(mode!=null && mode=="modify")
							{
								oldGroupName = publicJSON['oldGroupName'];
								oldGroupName = encodeURIComponent(oldGroupName);
							}

							var hiddenObj = Ext.getCmp('hiddencontainer');
							var temp = {
								xtype: 'hiddenfield',
								name: 'chosenHosts',
								value: managedHostList
							};
							hiddenObj.add(temp);

							var temp = {
								xtype: 'hiddenfield',
								name: 'existingHosts',
								value: unmanagedHostList
							};
							hiddenObj.add(temp);

							var resultUrl  = updateUrl+"&group="+encodeURIComponent(groupname)+"&mode="+encodeURIComponent(mode)+"&zone="+encodeURIComponent(zone)+"&oldGroupName="+encodeURIComponent(oldGroupName);
							var myMask = new Ext.LoadMask(Ext.getCmp('componentgroup'), {msg: 'Updating...'});
							myMask.show();

							var hiddenGrpObj = Ext.getCmp('componentgroup').getForm();
								hiddenGrpObj.submit({
								url: resultUrl,
								method: 'POST',
								timeout : 120,
								standardSubmit: false,
								success: function( form,action )
								{
									myMask.hide();
									var myjsonText = action.response.responseText;
									if ( !Ext.isEmpty( myjsonText ) && action.response.status == 200 )
									{
										var myjsonObj = Ext.decode( myjsonText );
										var isUpdated = myjsonObj['isUpdated'];
										var myupdateUrl = myjsonObj['updateUrl'];
										if(isUpdated=='true')
										{
											if(mode=='add')
											{
												Ext.Msg.show({
													title : pageTitle,
													msg : "Group '"+groupname+"' "+publicJSON['screenLabels']['admin.common.added successfully'],
													icon : 'iconInformation',
													buttons : Ext.Msg.OK
												});
												configGroupController.buildFieldData("modify",zone);
												configGroupController.afterMainRender("modify",groupname,zone);
											}
											else
											{
												Ext.Msg.show({
													title : pageTitle,
													msg : "Group '"+groupname+"' "+publicJSON['screenLabels']['admin.common.updated successfully'],
													icon : 'iconInformation',
													buttons : Ext.Msg.OK
												});
												configGroupController.buildFieldData("modify",zone);
												configGroupController.afterMainRender("modify",groupname,zone);
											}
										}
										else
										{
											if(myjsonObj['error'] == 'true')
											{
												Ext.Msg.show({
													title : pageTitle,
													msg : publicJSON['screenLabels']['admin.common.not updated successfully'],
													icon : 'iconError',
													buttons : Ext.Msg.OK
												});
												configGroupController.buildFieldData("modify",zone);
												configGroupController.afterMainRender("modify",groupname,zone);
											}
										}
									}
									hiddenObj.removeAll();
								},
								failure: function()
								{
									hiddenObj.removeAll();
								}
							});
						}
					}
				}
			});
		}
	}
	
});



