
var mySelectionModel = Ext.create('Ext.selection.CheckboxModel', {
	selType: 'checkboxmodel',
	mode: 'MULTI',
	checkOnly: true,
	renderer : function(val, meta, record, rowIndex, colIndex, store,view){
		if( record.get('isDisabled')=='true')
		{
			//meta.tdCls = Ext.baseCSSPrefix;
			meta.tdCls = "noEllipsis";
			return '<img src="/final/images/spacer.gif" class="iconLock"  style="margin-left:-5px;width:16px;height:16px;"/>';
		}
		else
		{
			//meta.tdCls = Ext.baseCSSPrefix + 'grid-cell-special ' + Ext.baseCSSPrefix + 'grid-cell-row-checker';
			meta.tdCls = "noEllipsis";
			return '<img src="/final/images/spacer.gif"  class="' + Ext.baseCSSPrefix + 'grid-row-checker"/>';
		}
	},
	selectAll: function(){
		var rowIndex=0;
		while(typeof(Ext.getCmp('gridDisplay').getStore().getAt(rowIndex))!='undefined') {
			var record = Ext.getCmp('gridDisplay').getStore().getAt(rowIndex);
			if (record.get('isDisabled')=='true'){
				Ext.getCmp('gridDisplay').getSelectionModel().deselect(rowIndex, true);
			}
			else {
				Ext.getCmp('gridDisplay').getSelectionModel().select(rowIndex, true);
			}
			rowIndex++;
		}
		var view = Ext.getCmp('gridDisplay').getView();
		var headerCt = view.headerCt;
		var hdSelectStatus = this.selected.getCount() === this.store.getCount();
		var checkHd = headerCt.child('gridcolumn[isCheckerHd]');
		if (checkHd) {
			checkHd.el.addCls(Ext.baseCSSPrefix +'grid-hd-checker-on');
		}
	},
	deselectAll: function(){
		var rowIndex=0;
		while(typeof(Ext.getCmp('gridDisplay').getStore().getAt(rowIndex))!='undefined') {
			var record = Ext.getCmp('gridDisplay').getStore().getAt(rowIndex);
			Ext.getCmp('gridDisplay').getSelectionModel().deselect(rowIndex, true);
			rowIndex++;
		}
		var view = Ext.getCmp('gridDisplay').getView();
		var headerCt = view.headerCt;
		var hdSelectStatus = this.selected.getCount() === this.store.getCount();
		var checkHd = headerCt.child('gridcolumn[isCheckerHd]');
		if (checkHd) {
			checkHd.el.removeCls(Ext.baseCSSPrefix +'grid-hd-checker-on');
		}
	}
});

Ext.define('Groups.view.Groups', {
	//extend: 'utilities.innerScrollContainer',
	extend: 'Ext.form.Panel',
	alias: 'widget.componentgroups',
	//cls:'outerpanel',
	ui:'simplePanel simplePanelHeaderBorder',
	id: 'mainGroup',
	title:homeTitle,
	margin:'8 8 0 8',
	//header:{cls:'textUpper'},
	autoScroll: false,
	scroll: false,

	requires: [
		'Ext.ux.CheckColumn',
		'Ext.ux.RowExpander',
		'Ext.grid.*',
		'utilities.CustomGrid',
		'utilities.innerScrollContainer'
	],

	/*dockedItems: [{
		xtype: 'toolbar',
		cls:'adminHeadInfoText',
		dock: 'top',
		height: 25,
		border:true,
		padding: 3,
		layout:{pack:'center'},
		items: [
			{
				xtype: 'component',
				html: '<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp'+pageDescc+'.</center>',
			}
		]
	}],*/

	layout: {
		type: 'vbox',
		align: 'stretch'
	},

	items: [
		{
			xtype: 'container',
			id: 'NoExtPresent',
			hidden:true,
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			items: [
				{
					xtype: 'label',
					html: '<table border="0" height="400px" width="100%"><tr><td align=center valign=middle><img src="/final/images/spacer.gif" class="iconInformation" valign="middle" /><div class="commonErrorMsgText">'+noCompMsg+'</div></td></tr></table>',
				}
			]
		},
		{
			xtype: 'customgrid',
			cls:'gridSkin',
			id: 'gridDisplay',
			store:new Ext.data.Store({
				fields: ['Groupname','isDisabled','associations','isDisableModification'],
				data: []
			}),
			autoScroll:true,
			flex: 1,
			margin: 10,
			selModel:mySelectionModel,
			listeners : {
				beforeselect: function(selModel, record, index) {
					if (record.get('isDisabled')=='true') {
						 return false;
					}
				},
				rowclick : function (in_this, rowIndex, e) {
					var record = in_this.getStore().getAt(rowIndex);
					if (record.get('isDisabled')=='true'){
						in_this.getSelectionModel().deselectRow(rowIndex);
					}
				}
			},
			viewConfig: {
				deferEmptyText: true
			},
			emptyText: '<table border="0" height="350px" width="100%"><tr><td align=center valign=middle><img src="/final/images/spacer.gif" class="iconInformation" valign="middle" /><div class="commonErrorMsgText">'+noGroupMsg+'</div></td></tr></table>',
			columns: {
				defaults: {
					sortable: true,
					hideable: false,
					menuDisabled: true,
					draggable: false,
					resizable: false
				},
				items: [
					{
						text: Groupname,
						dataIndex: 'Groupname',
						id: 'DispGroupName',
						width: 300,
						//flex:1,
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							var isGroupLocked = record.get('isDisableModification');
							if(isGroupLocked=='false')
							{
								var tmpDiv = "";
								tmpDiv = '<a  href=\'javascript:appCnt.handleEditIconClick("'+Ext.getCmp("gridDisplay")+'","'+row+'","'+col+'")\'><img src="/final/images/spacer.gif" class="iconGroup"  style="border:0px;vertical-align:bottom;margin-right:5px"/>'+record.get('Groupname')+'</a>';
								return tmpDiv;
							}
							else
							{
								var tmpDiv = "";
								tmpDiv = '<img src="/final/images/spacer.gif" class="iconGroup"  style="border:0px;vertical-align:bottom;margin-right:5px"/>'+record.get('Groupname');
								return tmpDiv;
							}
						}
					},
					{
						text: associations,
						dataIndex: 'associations',
						id: 'DispAssociations',
						flex:1
					},
					{
						
						xtype: 'actioncolumn',
						//cls: 'iconEdit',
						width: 36,
						id: 'showGroupDetails',
						menuDisabled : true,
						sortable : false,
						hidable : false,
						iconCls : 'iconData',
						tooltip: 'View Group Details',
						handler: function(grid, rowIndex, colIndex) {
							appCnt.handleGroupDetailsIconClick(grid, rowIndex, colIndex);
						},
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							metaData.tdAttr = "data-qtip='"+label_Modify+"' data-qclass='yellowTip'";
						}
					},
					{
						//header : '<div class="iconModify"></div>',
						xtype: 'actioncolumn',
						//cls: 'iconEdit',
						width: 36,
						id: 'EditOver',
						//icon: '../../../../resources/images/edit_task.png',
						//iconCls: 'iconModify',
						//tooltip: 'Modify',
						sortable: false,
						handler: function(grid, rowIndex, colIndex) {
							appCnt.handleEditIconClick(grid, rowIndex, colIndex);
						},
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							metaData.tdCls = "noEllipsis";
							metaData.tdAttr = "data-qtip='"+label_Modify+"' data-qclass='yellowTip'";
							var isGroupLocked = record.get('isDisableModification');
							if(isGroupLocked=="true")
							{
								return '<img src="/final/images/spacer.gif" class="iconModifyDisabled"/>';
								
							}
							else
							{
								return "<img src='/final/images/spacer.gif' class='iconModify' style='cursor:pointer' onclick=\"javascript:appCnt.handleEditIconClick('"+gridView+"','"+row+"','"+col+"')\" />";
							}
							
						}
					},
					{
						xtype: 'actioncolumn',
						//cls: 'tasks-icon-column-header tasks-edit-column-header',
						width: 36,
						id: 'RenameOver',
						//icon: '../../../../resources/images/edit_task.png',
						//iconCls: 'iconRename',
						//tooltip: 'Rename',
						sortable: false,
						handler: function(grid, rowIndex, colIndex) {
							appCnt.handleRenameIconClick(grid, rowIndex, colIndex);
						},
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							metaData.tdCls = "noEllipsis";
							metaData.tdAttr = "data-qtip='"+renameBtn+"' data-qclass='yellowTip'";
							var isGroupLocked = record.get('isDisableModification');
							if(isGroupLocked!="false")
							{
								return '<img src="/final/images/spacer.gif" class="iconRenameDisabled"/>';
							}
							else
							{
							
								return "<img src='/final/images/spacer.gif' style='cursor:pointer' onclick=\"javascript:appCnt.handleRenameIconClick('"+gridView+"','"+row+"','"+col+"')\" class='iconRename'/>";
							}
							
						}
					},
					{
						header : '<div class="iconDeleteAll" data-qtip="'+label_delSel+'" data-qclass="yellowTip"></div>',
						xtype: 'actioncolumn',
						//cls: 'tasks-icon-column-header tasks-delete-column-header',
						width: 36,
						id: 'DeleteOver',
						//icon: '../../../../resources/images/delete.png',
						//iconCls: 'x-hidden',
						//tooltip: 'Delete',
						sortable: false,
						listeners: {
							headerclick: function(g, index, ev) {
								appCnt.handleDeleteSelected();
							}
						},
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							var isGroupLocked = record.get('isDisabled');
							metaData.tdCls = "noEllipsis";
							metaData.tdAttr = "data-qtip='"+label_Delete+"' data-qclass='yellowTip'";
							if (isGroupLocked != "false")
							{
								return '<img src="/final/images/spacer.gif" class="iconDeleteDisabled"/>';
							}
							else
							{
								return "<img src='/final/images/spacer.gif' style='cursor:pointer' onclick=\"javascript:appCnt.handleDeleteIconClick('"+gridView+"','"+row+"','"+col+"')\" class='iconDelete'/>";
							}
						}
						//handler: function(grid, rowIndex, colIndex) {
						//	appCnt.handleDeleteIconClick(grid, rowIndex, colIndex);
						//}
					}
				]
			},
			tbar: [
				{
					xtype:'tbfill',
				},
				{
					xtype: 'trigger',
					trigger1Cls: 'x-form-clear-trigger',
					trigger2Cls: 'x-form-search-trigger',
					cls:'whitedropdown_search',
					id: 'gridSearch',
					name: 'gridSearch',
					emptyText: 'Search',
					getTriggerMarkup: function() {
						var me = this,
							i = 0,
							hideTrigger = (me.readOnly || me.hideTrigger),
							triggerCls,
							triggerBaseCls = me.triggerBaseCls,
							triggerConfigs = [],
							unselectableCls = Ext.dom.Element.unselectableCls,
							style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
							cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;

						// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
						// single triggerCls config. Should rethink this, perhaps something more structured like a list of
						// trigger config objects that hold cls, handler, etc.
						// triggerCls is a synonym for trigger1Cls, so copy it.
						if (!me.trigger1Cls) {
							me.trigger1Cls = me.triggerCls;
						}

						// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
						for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
							if (i == 0)
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+i,
									style: style + "display:none;",
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
							else
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+i,
									style: style,
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
						}
						triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
						return Ext.DomHelper.markup(triggerConfigs);
					},
					onTrigger1Click : function() {
						this.reset();
					},
					onTrigger2Click : function() {
						appCnt.mainGridSearch();
					}
				},
				{
					xtype: 'toolbar',
					ui: 'footer',
					items:[
						{
							xtype: 'button',
							text: addGroup,
							cls:'button20',
							id: 'addGroup'
						}
					]
				}
			]
		}
	],
	listeners: {
		close: function() 
		{
			window.location.href = '/final/admin/EgAdminOperations.jsp?fromAction='+fromWizard;
		},
		boxready: function() 
		{
			new Ext.ToolTip({
				target: document.getElementById('homeTitle'),
				anchor: 'top',
				anchorOffset:42,
				mouseOffset: [-55, 0],
				html: pageDescc+'.',
				cls: "adminInfoTooltip"
			});
		}
	}

});



