Ext.define('ICBackup.controller.Main',{
	extend:'Ext.app.Controller',
	views:['ICBackupView'],
	requires:['ICBackup.view.ICBackupView'],
	refs:[
		{selector:'icbackupview', ref:'icbackupview'},
	],
	init:function(){
		ctrler = this;
		this.control({
			'icbackupview button[id="backup"]':
			{
				'click':this.doBackup
			},
			'icbackupview button[id="revert"]':
			{
				'click':this.deRevert
			}
		});
	},
	doBackup: function()
	{
		Ext.Msg.show({
			title: pageTitle,
			msg: confirmMsg1,
			buttons: Ext.Msg.OKCANCEL,
			icon: 'iconConfirmation',
			width: 450,
			fn: function(response) {
				if (response == 'ok')
				{
					var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: updating});
					tmpMask.show();
					Ext.Ajax.request(
					{
						url: 'ICBackup/data/EgbackupconfigpJson.jsp?type=backup',
						method: 'POST',
						async:false,
						success: function( response )
						{
							tmpMask.hide();
							if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
							{
								var jsonText = response.responseText;
								publicJSON = Ext.decode( jsonText );
								if (publicJSON.AlertType == 'Result')
								{
									Ext.Msg.show({
										title: publicJSON.AlertTitle,
										msg: publicJSON.AlertMsg,
										buttons: Ext.Msg.OK,
										icon: 'iconInformation'
									});
								}
								else if (publicJSON.AlertType == 'Error')
								{
									Ext.Msg.show({
										title: publicJSON.AlertTitle,
										msg: publicJSON.AlertMsg,
										buttons: Ext.Msg.OK,
										icon: 'iconError'
									});
								}
							}
						}
					});
				}
			}
		});
	},
	deRevert: function()
	{
		Ext.Msg.show({
			title:pageTitle,
			msg: confirmMsg2,
			buttons: Ext.Msg.OKCANCEL,
			icon: 'iconConfirmation',
			fn: function(response) {
				if (response == 'ok')
				{
					var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: updating});
					tmpMask.show();
					Ext.Ajax.request(
					{
						url: 'ICBackup/data/EgbackupconfigpJson.jsp?type=revert',
						method: 'POST',
						async:false,
						success: function( response )
						{
							tmpMask.hide();
							if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
							{
								var jsonText = response.responseText;
								publicJSON = Ext.decode( jsonText );
								if (publicJSON.AlertType == 'Result')
								{
									Ext.Msg.show({
										title: publicJSON.AlertTitle,
										msg: publicJSON.AlertMsg,
										buttons: Ext.Msg.OK,
										icon: 'iconInformation'
									});
								}
								else if (publicJSON.AlertType == 'Error')
								{
									Ext.Msg.show({
										title: publicJSON.AlertTitle,
										msg: publicJSON.AlertMsg,
										buttons: Ext.Msg.OK,
										icon: 'iconError'
									});
								}
							}
						}
					});
				}
			}
		});
	}
});



