Ext.define('ICComponent.controller.AddCompCtrlr',{
	extend:'Ext.app.Controller',
	views:['NewComponentType'],
	requires:['ICComponent.view.NewComponentType'],
	refs:[
		{selector:'newcomponenttype', ref:'newcomponenttype'}
	],
	init:function(){
		addctrler = this;
		this.buildMainData()
		this.control({
			'newcomponenttype':
			{
				'afterrender': this.afterMainRender
			},
			'newcomponenttype button[id="add"]':
			{
				'click': this.addCompType
			},
			'newcomponenttype radiogroup[id="duplicateServer"]':
			{
				'change': this.duplicateSelection
			},
			'newcomponenttype button[id="back"]':
			{
				'click':this.goBack
			}
		});
	},
	buildMainData: function()
	{
		Ext.Ajax.request(
		{
			url: 'ICComponent/data/EgAddUDServerJson.jsp',
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},
	afterMainRender: function()
	{
		if (publicJSON.showDuplicateRadio)
		{
			Ext.getCmp('duplicateServer').show();
		}
		else
		{
			Ext.getCmp('duplicateServer').hide();
			Ext.getCmp('duplicateServer').setDisabled(true);
			Ext.getCmp('nonDupComponentType').hide();
			Ext.getCmp('nonDupComponentType').setDisabled(true);
		}
		if (publicJSON.showPort)
		{
			Ext.getCmp('port').setValue(publicJSON.portValue);
		}
		Ext.getCmp('imageList').getStore().loadRawData(publicJSON.imageList);
		Ext.getCmp('imageList').setValue("others");
		//$('#'+Ext.getCmp('imageList').inputEl.id).removeClass().addClass("others");
	},
	goBack: function()
	{
		window.location.href= '/final/admin/EgUDServer.jsp';
	},
	duplicateSelection: function()
	{
		var selVal = Ext.getCmp('duplicateServer').getValue().duprb;
		if (selVal=='Yes')
		{
			Ext.getCmp('imageList').hide();
			Ext.getCmp('imageList').disable();
			Ext.getCmp('port').hide();
			Ext.getCmp('port').disable();
			Ext.getCmp('sitesupport').hide();
			Ext.getCmp('sitesupport').disable();

			var dupList = Ext.getCmp('nonDupComponentType')
			dupList.show();
			dupList.enable();
			dupList.getStore().removeAll();
			dupList.getStore().loadRawData(publicJSON.duplicateList);
			dupList.setValue(publicJSON.selectedCompforDuplicate);
		}
		else
		{
			Ext.getCmp('imageList').show();
			Ext.getCmp('imageList').enable();
			Ext.getCmp('port').show();
			Ext.getCmp('port').enable();
			Ext.getCmp('sitesupport').show();
			Ext.getCmp('sitesupport').enable();

			Ext.getCmp('nonDupComponentType').hide();
			Ext.getCmp('nonDupComponentType').disable();
		}
	},
	addCompType: function()
	{
		//var imgName = Ext.getCmp('imageList').getValue();
		var imgName = Ext.get('cTypeID').getValue();
		var urlStr = "ICComponent/data/EgaddudserverpJson.jsp?imageName="+encodeURIComponent(imgName);
		var isDuplicate = Ext.getCmp('duplicateServer').getValue().duprb;
		if (this.validate() == false)
		{
			return;
		}
		
		if (isDuplicate == 'Yes')
		{
			this.doDuplicate();
			return;
		}

		var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: updating+'...'});
		tmpMask.show();
		this.getNewcomponenttype().submit({
			url: urlStr,
			method: 'POST',
			success: function(form, action)
			{
				tmpMask.hide();
				var jsonText = action.response.responseText;
				publicJSON = Ext.decode(jsonText);
				if(publicJSON.AlertType == 'Result')
				{
					Ext.Msg.show({
						title: publicJSON.AlertTitle,
						msg: publicJSON.AlertMsg,
						buttons: Ext.Msg.OK,
						icon: 'iconInformation',
						width: 350,
						fn: function(response) {
							if(response == 'ok') {
								window.location.href= '/final/admin/EgUDServer.jsp';
							}
						}
					});
				}
				else if (publicJSON.AlertType == 'Error')
				{
					Ext.Msg.show({
						title: publicJSON.AlertTitle,
						msg: publicJSON.AlertMsg,
						buttons: Ext.Msg.OK,
						icon: 'iconError',
						fn: function(response) {
							if(response == 'ok') {
								Ext.getCmp('server').focus(true);
							}
						}
					});
				}
			},
			failure: function(form, action)
			{
				 tmpMask.hide();
			}
		});
	},
	doDuplicate: function()
	{
		var selServer = Ext.getCmp('nonDupComponentType').getValue();
		//var imgName = Ext.getCmp('imageList').getValue();
		var imgName = Ext.get('cTypeID').getValue();
		var server = Ext.getCmp('server').getValue();
		var urlStr = "ICComponent/data/EgDuplicateServerJson.jsp?serverName="+encodeURIComponent(selServer)+"&duplicate="+encodeURIComponent(server)+"&eximage="+encodeURIComponent(imgName)+"&isduplicate=yes";

		Ext.Ajax.request(
		{
			url : urlStr,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);

				if(publicJSON.AlertType == 'Result')
				{
					Ext.Msg.show({
						title: publicJSON.AlertTitle,
						msg: publicJSON.AlertMsg,
						buttons: Ext.Msg.OK,
						icon: 'iconInformation',
						fn: function(response) {
							if(response == 'ok') {
								window.location.href='/final/admin/EgUDServer.jsp';
							}
						}
					});
				}
				else if (publicJSON.AlertType == 'Error')
				{
					Ext.Msg.show({
						title: publicJSON.AlertTitle,
						msg: publicJSON.AlertMsg,
						buttons: Ext.Msg.OK,
						icon: 'iconError',
						fn: function(response) {
							if(response == 'ok') {
								Ext.getCmp('server').focus(true);
							}
						}
					});
				}
			},
			failure : function(response)
			{
			}
		});
	},
	validate: function()
	{
		var server = Ext.getCmp('server').getValue();
		
		var splChar = "abcdefghijklmnoprstuvwxyzABCDEFGHIJKMOPQRSTVWXYZ`~!@#$%^&*()-_+=[]{}|\\:;\"\'<>.?\/";
		var cmpName=true;
		var portNumber=true;
		var isDuplicate = Ext.getCmp('duplicateServer').getValue().duprb;

		if(isDouble=="false")
		{
			cmpName = validateSingleByte(server);
		}

		if(!checkblank(server))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: alertMsg1,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				width: 350
			});
			Ext.getCmp('server').focus(true);
			return false;
		}
		else if(!checkspace(server))
		{
			Ext.getCmp('server').focus(true);
			return false;
		}
		else if(!checkspecialnomess(server,"`~!@#$%^&*()-+={}[]|\\:;\"\'<>,.?\/"))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: alertMsg2,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			Ext.getCmp('server').focus(true);
			return false;
		}
		else if(!checkForNameWithEx(server))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: alertMsg3,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				width: 350
			});
			Ext.getCmp('server').focus(true);
			return false;
		}
		else if(!cmpName)
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: alertMsg4,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			Ext.getCmp('server').focus(true);
			return false;
		}
		else if (server.toLowerCase().indexOf("agg_") == 0)
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: alertMsg17,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			Ext.getCmp('server').focus(true);
			return false;
		}
		if (isDuplicate == 'No')
		{
			var port = Ext.getCmp('port').getValue();
			var ss = Ext.getCmp('sitesupport').getValue().siterb;
			//var imgName = Ext.getCmp('imageList').getValue();
			var imgName = Ext.get('cTypeID').getValue();
			portNumber = validateSingleByte(port);
			var flag = true;
			for(var k=0;k < port.length;k++)
			{
				if(port.charAt(k) == ',' && port.charAt(k + 1) == ',')
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: alertMsg7,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});

					Ext.getCmp('port').focus(true);
					flag = false;
					break;
				}
				else
				{
					continue;
				}
			}

			if (flag == false)
			{
				return false;
			}

			if(!checkblank(port))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: alertMsg8,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				Ext.getCmp('port').focus(true);
				return false;
			}
			else if(!checkspace(port))
			{
				Ext.getCmp('port').focus(true);
				return false;
			}
			else if(!checkcomma(port))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: alertMsg9,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				Ext.getCmp('port').focus(true);
				return false;
			}
			else if(port == "0")
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: alertMsg10,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				Ext.getCmp('port').focus(true);
				return false;
			}
			else if(!checkspecialnomess(port,splChar) || !portNumber)
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: alertMsg11,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				Ext.getCmp('port').focus(true);
				return false;
			}
			else if(port == "NULL" && ss == "Yes")
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: alertMsg12,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				Ext.getCmp('port').focus(true);
				return false;
			}
			else if (imgName == null || imgName == '')
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: alertMsg13,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return false;
			}
		}
		else
		{
			var selServer = Ext.getCmp('nonDupComponentType').getValue();
			if (selServer == "-1")
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: alertMsg14,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return false;
			}
		}
		return true;
	}
});



