Ext.define('ICComponent.controller.ConfTestCtrlr',{
	extend:'Ext.app.Controller',
	requires:['ICComponent.view.AssociateCfTests'],
	refs:[
		{selector:'associatecftests', ref:'associatecftests'}
	],
	init:function(){
		addctrler = this;
		//this.buildMainData()
		this.control({
			'associatecftests':
			{
				'afterrender': this.afterMainRender
			},
			'associatecftests button[id="back"]':
			{
				'click':this.goBack
			},
			'associatecftests button[id="update"]':
			{
				'click':this.updateTests
			}
		});
	},
	buildMainData: function(serverName)
	{
		Ext.Ajax.request(
		{
			url: 'ICComponent/data/EgConfigUDConfigTestJson.jsp?server='+encodeURIComponent(serverName),
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},
	afterMainRender: function()
	{
		Ext.getCmp('confTestFldSet').setTitle(configTestsFor+ '  <b>' +publicJSON.serverDispValue+'</b>');
		var itemSelObj = Ext.getCmp('testsList');
		itemSelObj.fromField.store.removeAll();
		itemSelObj.toField.store.removeAll();

		if (publicJSON.assoTests != null)
		{
			itemSelObj.fromField.store.add(publicJSON.assoTests);
		}
		
		if (publicJSON.disoTests != null)
		{
			itemSelObj.toField.store.add(publicJSON.disoTests);
		}	
	},
	goBack: function()
	{
		window.location.href= '/final/admin/EgUDServer.jsp';
	},
	updateTests: function()
	{
		var itemSelObj = Ext.getCmp('testsList');
		var storeObj = itemSelObj.fromField.store;
		var associatedNow = '';
		
		if (storeObj.getCount() == 0)
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: alertMsg16,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}

		for (var s=0; s < storeObj.getCount();s++)
		{
			var newVal = storeObj.getAt(s).get('valueField');
			associatedNow += newVal+',';
		}
		var me = Ext.getCmp('hiddenContnr');
		me.removeAll();
		var hiddenParams = publicJSON.hiddens;
		for (var param in hiddenParams) {
				me.add({
					xtype: 'hidden',
					name: param,
					value: hiddenParams[param]
				});
		}
		me.add({
			xtype: 'hidden',
			name: 'fassociate',
			value: associatedNow
		});
		var urlStr = "ICComponent/data/EgconfigudconfigtestpJson.jsp";
		var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: updating+'...'});
		tmpMask.show();
		this.getAssociatecftests().submit({
			url: urlStr,
			//async:false,
			method: 'POST',
			success: function(form, action)
			{
				tmpMask.hide();
				var jsonText = action.response.responseText;
				var resultJSON = Ext.decode(jsonText);
				if(resultJSON.loadConfigLayerPage)
				{
					Ext.getCmp('iccompviewport').removeAll();
					addctrler.getController('LayerCtrlr').init();
					addctrler.getController('LayerCtrlr').buildMainData(resultJSON.server);
					Ext.getCmp('iccompviewport').add(
						{
							xtype: 'associatelayers'
						});
				}
				if(resultJSON.AlertType=='Result')// || resultJSON.AlertType=='Error')
				{
					Ext.Msg.show({
						title:resultJSON.AlertTitle,
						msg:resultJSON.AlertMsg,
						buttons: Ext.Msg.OK,
						fn:function()
						{
							addctrler.buildMainData(resultJSON.server);
							addctrler.afterMainRender();
						},
						icon: 'iconInformation'
					});
				}
			},
			failure: function(form, action)
			{
				 tmpMask.hide();
			}
		});
	}
});



