Ext.define('ICComponent.controller.LayerCtrlr',{
	extend:'Ext.app.Controller',
	views:['AssociateLayers'],
	requires:['ICComponent.view.AssociateLayers'],
	refs:[
		{selector:'associatelayers', ref:'associatelayers'}
	],
	init:function(){
		addctrler = this;
		//this.buildMainData()
		this.control({
			'associatelayers':
			{
				'afterrender': this.afterMainRender
			},
			'associatelayers button[id="back"]':
			{
				'click':this.goBack
			},
			'associatelayers button[id="update"]':
			{
				'click':this.updateLayers
			}
		});
	},
	buildMainData: function(serverName)
	{
		Ext.Ajax.request(
		{
			url: 'ICComponent/data/EgConfigUDServerJson.jsp?server='+encodeURIComponent(serverName),
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},
	afterMainRender: function()
	{
		Ext.getCmp('fldSet').setTitle(layersFor+ '  <b>' +publicJSON.serverDispValue+'</b>');
		var itemSelObj = Ext.getCmp('layersList');
		itemSelObj.fromField.store.removeAll();
		itemSelObj.toField.store.removeAll();

		if (publicJSON.assoLayers != null)
		{
			itemSelObj.fromField.store.add(publicJSON.assoLayers);
		}
		
		if (publicJSON.disoLayers != null)
		{
			itemSelObj.toField.store.add(publicJSON.disoLayers);
		}
	},
	goBack: function()
	{
		window.location.href= '/final/admin/EgUDServer.jsp';
	},
	updateLayers: function()
	{
		var itemSelObj = Ext.getCmp('layersList');
		var storeObj = itemSelObj.fromField.store;
		var associatedNow = '';
		
		for (var s=0; s < storeObj.getCount();s++)
		{
			var newVal = storeObj.getAt(s).get('valueField');
			associatedNow += newVal+',';
		}
		var me = Ext.getCmp('hiddenContnr');
		me.removeAll();
		var hiddenParams = publicJSON.hiddens;
		for (var param in hiddenParams) {
				me.add({
					xtype: 'hidden',
					name: param,
					value: hiddenParams[param]
				});
		}
		me.add({
			xtype: 'hidden',
			name: 'fassociate',
			value: associatedNow
		});
		var urlStr = "ICComponent/data/EgconfigudserverpJson.jsp";
		var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: updating+'...'});
		tmpMask.show();
		this.getAssociatelayers().submit({
			url: urlStr,
			//async:false,
			timeout : 120,
			method: 'POST',
			success: function(form, action)
			{
				tmpMask.hide();
				var jsonText = action.response.responseText;
				var resultJSON = Ext.decode(jsonText);
				if(resultJSON.AlertType=='Result')
				{
					Ext.Msg.show({
						title: resultJSON.AlertTitle,
						msg: resultJSON.AlertMsg,
						buttons: Ext.Msg.OK,
						icon: 'iconInformation'
					});
				}
				else if (resultJSON.AlertType=='Error')
				{
					Ext.Msg.show({
						title: resultJSON.AlertTitle,
						msg: resultJSON.AlertMsg,
						buttons: Ext.Msg.OK,
						icon: 'iconError'
					});
				}
			},
			failure: function(form, action)
			{
				 tmpMask.hide();
			}
		});
	}
});



