Ext.define('ICComponent.controller.Main',{
	extend:'Ext.app.Controller',
	views:['Components'],
	requires:['ICComponent.view.Components'],
	refs:[
		{selector:'components', ref:'components'}
	],
	init:function(){
		ctrler = this;
		this.buildMainData()
		this.control({
			'components':
			{
				'afterrender': this.afterMainRender
			},
			'components [id="pdGrid"]':
			{
				//'itemmouseenter': this.showActions,
				//'itemmouseleave': this.hideActions
			},
			'components [id="udGrid"]':
			{
				//'itemmouseenter': this.showActions,
				//'itemmouseleave': this.hideActions
			},
			'components trigger[id="searchBox"]':
			{
				'change': this.searchComponent
			},
			'components button[id="addCompButton"]':
			{
				'click': this.addNewCompType
			},
			'components trigger[id="searchBox2"]':
			{
				'change': this.searchComponent2
			},
			
		});
	},
	buildMainData: function()
	{
		Ext.Ajax.request(
		{
			url: 'ICComponent/data/EgUDServerJson.jsp',
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},
	afterMainRender: function()
	{
		var pdGridObj = Ext.getCmp('pdGrid');
		var udGridObj = Ext.getCmp('udGrid');
		if (publicJSON.showPreDefinedComps)
		{
			pdGridObj.show();
			pdGridObj.getStore().removeAll();
			pdGridObj.getStore().loadRawData(publicJSON.preDefindGrid);
		}

		if (publicJSON.showUserDefinedComps)
		{
			udGridObj.show();
			udGridObj.getStore().removeAll();
			udGridObj.getStore().loadRawData(publicJSON.usrDefinedGrid);
		}
		this.getComponents().doLayout();

		if (!publicJSON.showPreDefinedComps)
		{
			pdGridObj.getStore().removeAll();
			Ext.getCmp('searchBox1').disable();
		}
		if (!publicJSON.showUserDefinedComps)
		{
			udGridObj.getStore().removeAll();
			Ext.getCmp('searchBox2').disable();
		}
		if (isConfigMgmt == 'true')
		{
			Ext.getCmp('configTestsPD').show();
			Ext.getCmp('configTestsUD').show();
		}
		else
		{
			Ext.getCmp('configTestsPD').hide();
			Ext.getCmp('configTestsUD').hide();
		}
	},
	showActions: function(view, task, node, rowIndex, e)
	{
		var hideIcon = view.getStore().getAt(rowIndex);
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
			Ext.each(icons, function(icon){
		Ext.get(icon).removeCls('x-hidden');
		});
	},
	hideActions: function(view, task, node, rowIndex, e)
	{
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
		Ext.each(icons, function(icon){
			Ext.get(icon).addCls('x-hidden');
		});
	},
	searchComponent:function()
	{
		var searchStr = Ext.getCmp('searchBox').getValue();
		searchStr = encodeURIComponent(searchStr);
		var urlStr = 'ICComponent/data/EgUDServerJson.jsp?searchStr='+searchStr;
		if (searchStr == "" || searchStr.length == 0)
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');
		}

		Ext.Ajax.request(
		{
			url : urlStr,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
			},
			failure : function(response)
			{
			}
		});

		var pdGridObj = Ext.getCmp('pdGrid');
		if (publicJSON.showPreDefinedComps)
		{
			pdGridObj.show();
			pdGridObj.getStore().removeAll();
			pdGridObj.getStore().loadRawData(publicJSON.preDefindGrid);
		}
		else
		{
			pdGridObj.getStore().removeAll();
			if (searchStr == "" || searchStr.length == 0)
			{
				Ext.get('noPdCompsAlrtDiv').update(noUDServ);
			}
			else
			{
				Ext.get('noPdCompsAlrtDiv').update(noPDServFound);
			}
		}
	},
	searchComponent2:function()
	{
		var searchStr = Ext.getCmp('searchBox2').getValue();
		searchStr = encodeURIComponent(searchStr);
		var urlStr = 'ICComponent/data/EgUDServerJson.jsp?searchStr='+searchStr;
		if (searchStr == "" || searchStr.length == 0)
		{
			Ext.get('My2Trigger_0').setStyle('display','none');
			Ext.get('My2Trigger_1').setStyle('display','block');
		}
		else
		{
			Ext.get('My2Trigger_1').setStyle('display','none');
			Ext.get('My2Trigger_0').setStyle('display','block');
		}

		Ext.Ajax.request(
		{
			url : urlStr,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
			},
			failure : function(response)
			{
			}
		});

		var udGridObj = Ext.getCmp('udGrid');
		if (publicJSON.showUserDefinedComps)
		{
			udGridObj.show();
			udGridObj.getStore().removeAll();
			udGridObj.getStore().loadRawData(publicJSON.usrDefinedGrid);
		}
		else
		{
			udGridObj.getStore().removeAll();
			if (searchStr == "" || searchStr.length == 0)
			{
				Ext.get('noUdCompsAlrtDiv').update(noUDServ);
			}
			else 
			{
				Ext.get('noUdCompsAlrtDiv').update(noUDServFound);
			}
		}
	},
	addNewCompType : function()
	{
		Ext.getCmp('iccompviewport').removeAll();
		this.getController('AddCompCtrlr').init();
		Ext.getCmp('iccompviewport').add(
			{
				xtype: 'newcomponenttype'
			});
	},
	layerAssign: function(grid, rowIndex, colIndex)
	{
		var obj = grid.getStore().getAt(rowIndex);
		var serverName = obj.get('ActualValue');
		Ext.getCmp('iccompviewport').removeAll();
		this.getController('LayerCtrlr').init();
		this.getController('LayerCtrlr').buildMainData(serverName);
		Ext.getCmp('iccompviewport').add(
			{
				xtype: 'associatelayers'
			});
	},
	perfTestsAssign: function(grid, rowIndex, colIndex)
	{
		var obj = grid.getStore().getAt(rowIndex);
		var serverName = obj.get('ActualValue');
		Ext.getCmp('iccompviewport').removeAll();
		this.getController('PerfTestCtrlr').init();
		this.getController('PerfTestCtrlr').buildMainData(serverName);
		Ext.getCmp('iccompviewport').add(
			{
				xtype: 'associatepftests'
			});
	},
	configTestsAssign:  function(grid, rowIndex, colIndex)
	{
		var obj = grid.getStore().getAt(rowIndex);
		var serverName = obj.get('ActualValue');
		Ext.getCmp('iccompviewport').removeAll();
		this.getController('ConfTestCtrlr').init();
		this.getController('ConfTestCtrlr').buildMainData(serverName);
		Ext.getCmp('iccompviewport').add(
			{
				xtype: 'associatecftests'
			});
	},
	modifyCompType: function(grid, rowIndex, colIndex)
	{
		var obj = grid.getStore().getAt(rowIndex);
		var serverName = obj.get('ActualValue');
		Ext.getCmp('iccompviewport').removeAll();
		this.getController('ModifyCompCtrlr').init();
		this.getController('ModifyCompCtrlr').buildMainData(serverName);
		Ext.getCmp('iccompviewport').add(
			{
				xtype: 'modifycomponenttype'
			});
	},
	deleteCompType: function(grid, rowIndex, colIndex)
	{
		var obj = grid.getStore().getAt(rowIndex);
		var serverName = obj.get('ActualValue');
		Ext.Msg.show({
			title: pageTitle,
			msg: confrmMsg1,
			buttons: Ext.Msg.YESNO,
			icon: 'iconConfirmation',
			fn: function(response) 
			{
				if(response == 'yes')
				{
					var urlStr = "ICComponent/data/EgDelUDServerJson.jsp?server="+encodeURIComponent(serverName);
					Ext.Ajax.request({
						url: urlStr,
						method: 'POST',
						success: function( response )
						{
							var jsonText = response.responseText;
							var resultJSON = Ext.decode(jsonText);
							
							if (resultJSON.AlertType=='Result')
							{
								Ext.Msg.show({
									title: resultJSON.AlertTitle,
									msg: resultJSON.AlertMsg,
									buttons: Ext.Msg.OK,
									width: 300,
									icon: 'iconInformation',
									fn: function()
									{
										ctrler.buildMainData();
										ctrler.afterMainRender();
									}
								});
							}
							else if (resultJSON.AlertType=='Error')
							{
								Ext.Msg.show({
									title: resultJSON.AlertTitle,
									msg: resultJSON.AlertMsg,
									buttons: Ext.Msg.OK,
									icon: 'iconError'
								});
							}
						}
					});
				}
			}
		});
	}
});



