Ext.define('ICComponent.controller.ModifyCompCtrlr',{
	extend:'Ext.app.Controller',
	views:['NewComponentType'],
	requires:['ICComponent.view.ModifyComponentType'],
	refs:[
		{selector:'modifycomponenttype', ref:'modifycomponenttype'}
	],
	init:function(){
		addctrler = this;
		this.buildMainData()
		this.control({
			'modifycomponenttype':
			{
				'afterrender': this.afterMainRender
			},
			'modifycomponenttype button[id="update"]':
			{
				'click': this.modifyCompType
			},
			'modifycomponenttype button[id="back"]':
			{
				'click':this.goBack
			}
		});
	},
	buildMainData: function(serverName)
	{
		Ext.Ajax.request(
		{
			url: 'ICComponent/data/EgModifyCompJson.jsp?server='+encodeURIComponent(serverName),
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},
	afterMainRender: function()
	{
		Ext.getCmp('server').setValue(publicJSON.server);
		Ext.getCmp('server').setReadOnly(true);
		Ext.getCmp('imageList').getStore().loadRawData(publicJSON.imageList);
		Ext.getCmp('imageList').setValue(publicJSON.imageSelected);
		//alert(publicJSON.imageSelected);
		//$('#'+Ext.getCmp('imageList').inputEl.id).removeClass().addClass(publicJSON.imageSelected);
	},
	goBack: function()
	{
		window.location.href= '/final/admin/EgUDServer.jsp';
	},
	modifyCompType: function()
	{
		var imageExist = publicJSON.imageSelected;
		//var imageNew = Ext.getCmp('imageList').getValue();
		var imageNew = Ext.get('cTypeID').getValue();
	//	if (imageExist == imageNew)
	//	{
	//		Ext.Msg.show({
	//			title: pageTitle6,
	//			msg: alertMsg18,
	//			buttons: Ext.Msg.OK,
	//			icon: 'iconInformation'
	//		});
	//		return;
	//	}
		if (this.validate() == false)
		{
			return;
		}
		var imageChanged = false;
		var dispNameChanged = false;
		if (imageExist != imageNew)
		{
			imageChanged = true;
		}

		var urlStr = "ICComponent/data/EgModifyComppJson.jsp?imageName="+imageNew;
		urlStr += "&imageChanged="+imageChanged;
		urlStr += "&$_image="+publicJSON.hiddens.$_image;

		var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: updating+'...'});
		tmpMask.show();
		this.getModifycomponenttype().submit({
			url: urlStr,
			method: 'POST',
			success: function(form, action)
			{
				tmpMask.hide();
				var jsonText = action.response.responseText;
				publicJSON = Ext.decode(jsonText);
				if(publicJSON.AlertType == 'Result')
				{
					Ext.Msg.show({
						title: publicJSON.AlertTitle,
						msg: publicJSON.AlertMsg,
						buttons: Ext.Msg.OK,
						icon: 'iconInformation',
						fn: function(response) {
							if(response == 'ok') {
								window.location.href= '/final/admin/EgUDServer.jsp';
							}
						}
					});
				}else if (publicJSON.AlertType == 'Error')
				{
					Ext.Msg.show({
						title: publicJSON.AlertTitle,
						msg: publicJSON.AlertMsg,
						buttons: Ext.Msg.OK,
						icon: 'iconError',
						fn: function(response) {
							if(response == 'ok') {
								window.location.href= '/final/admin/EgUDServer.jsp';
							}
						}
					});
				}
			},
			failure: function(form, action)
			{
				 tmpMask.hide();
			}
		});
	},
	validate: function()
	{
		//var imgName = Ext.getCmp('imageList').getValue();
		var imgName = Ext.get('cTypeID').getValue();
		if (imgName == null || imgName == '')
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: alertMsg13,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}
		return true;
	}
});



