Ext.define('ICComponent.controller.PerfTestCtrlr',{
	extend:'Ext.app.Controller',
	requires:['ICComponent.view.AssociatePfTests'],
	refs:[
		{selector:'associatepftests', ref:'associatepftests'}
	],
	init:function(){
		addctrler = this;
		//this.buildMainData()
		this.control({
			'associatepftests':
			{
				'afterrender': this.afterMainRender
			},
			'associatepftests button[id="back"]':
			{
				'click':this.goBack
			},
			'associatepftests button[id="update"]':
			{
				'click':this.updateTests
			}
		});
	},
	buildMainData: function(serverName)
	{
		Ext.Ajax.request(
		{
			url: 'ICComponent/data/EgConfigUDTestJson.jsp?server='+encodeURIComponent(serverName),
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},
	afterMainRender: function()
	{
		Ext.getCmp('perfTestFldSet').setTitle(testsFor+ '  <b>' +publicJSON.serverDispValue+'</b>');
		var itemSelObj = Ext.getCmp('testsList');
		itemSelObj.fromField.store.removeAll();
		itemSelObj.toField.store.removeAll();

		if (publicJSON.assoTests != null)
		{
			itemSelObj.fromField.store.add(publicJSON.assoTests);
		}
		
		if (publicJSON.disoTests != null)
		{
			itemSelObj.toField.store.add(publicJSON.disoTests);
		}
	},
	goBack: function()
	{
		window.location.href= '/final/admin/EgUDServer.jsp';
	},
	updateTests: function()
	{
		var itemSelObj = Ext.getCmp('testsList');
		var storeObj = itemSelObj.fromField.store;
		var associatedNow = '';
		
		if (storeObj.getCount() == 0)
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: alertMsg15,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}

		for (var s=0; s < storeObj.getCount();s++)
		{
			var newVal = storeObj.getAt(s).get('valueField');
			associatedNow += newVal+',';
		}
		var me = Ext.getCmp('hiddenContnr');
		me.removeAll();
		var hiddenParams = publicJSON.hiddens;
		for (var param in hiddenParams) {
				me.add({
					xtype: 'hidden',
					name: param,
					value: hiddenParams[param]
				});
		}
		me.add({
			xtype: 'hidden',
			name: 'fassociate',
			value: associatedNow
		});
		var urlStr = "ICComponent/data/EgconfigudtestpJson.jsp";
		var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: updating+'...'});
		tmpMask.show();
		this.getAssociatepftests().submit({
			url: urlStr,
			//async:false,
			method: 'POST',
			success: function(form, action)
			{
				tmpMask.hide();
				var jsonText = action.response.responseText;
				var resultJSON = Ext.decode(jsonText);
				if(resultJSON.AlertType=='Result')
				{
					Ext.Msg.show({
						title: resultJSON.AlertTitle,
						msg: resultJSON.AlertMsg,
						buttons: Ext.Msg.OK,
						fn:function()
							{
								addctrler.buildMainData(resultJSON.ServerName);
								addctrler.afterMainRender();
							},
						icon: 'iconInformation'
					});
				}
				else if (resultJSON.AlertType=='Error')
				{
					Ext.Msg.show({
						title: resultJSON.AlertTitle,
						msg: resultJSON.AlertMsg,
						buttons: Ext.Msg.OK,
						icon: 'iconError'
					});
				}
			},
			failure: function(form, action)
			{
				 tmpMask.hide();
			}
		});
	}
});



