Ext.define('ICComponent.view.AssociateLayers', {
	extend: 'Ext.form.Panel',
	alias: 'widget.associatelayers',

	title: pageTitle2,
	cls:'outerpanel',
	margin:"8 8 0 8",

	layout: {
		type: 'vbox',
		align: 'stretch'
	},

	items: [
		{
			xtype: 'component',
			cls:'adminHeadInfoText',
			html: "<center>"+'<img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp'+pageDesc3+"."+"</center>",
			width:'100%',
			height: 25,
			padding: 3
		},
		{
			xtype: 'container',
			id:'hiddenContnr',
			hidden:true
		},
		{
			xtype: 'fieldset',
			id:'fldSet',
			title: '',
			layout: {
				type: 'hbox',
				pack: 'center',
				align: 'stretch'
			},
			flex: 1,
			margin: '20 50 0 50',
			items: [
				{
					xtype: 'itemselector',
					cls:'multiselect',
					id:'layersList',
					buttonsText: {
						add: disso,
						remove: asso,
						top: mveTop,
						up: mveUp,
						down: mveDown,
						bottom: mveBottom
					},
					store: new Ext.data.Store({
						fields: ['displayField','valueField'],
						data: []
					}),
					displayField: 'displayField',
					valueField: 'valueField',
					height: 415,
					width: 880,
					fromTitle: assoLays,
					toTitle: dissoLays,
					queryMode : 'local',

					setupItems: function() {
						var me = this;

						me.fromField = me.createList(me.fromTitle);
						me.toField = me.createList(me.toTitle);

						return {
							border: false,
							layout: {
								type: 'hbox',
								align: 'stretch'
							},
							items: [
								{
									xtype: 'container',
									margins: '0 4',
									//width: 22,
									layout: {
										type: 'vbox',
										pack: 'center'
									},
									items: me.createCustomButtons('left')
								},
								me.fromField,
								{
									xtype: 'container',
									margins: '0 4',
									//width: 22,
									layout: {
										type: 'vbox',
										pack: 'center'
									},
									items: me.createCustomButtons('center')
								},
								me.toField
							]
						};
					},

					createCustomButtons: function(position){
						var me = this,
							buttons = [];

						if (!me.hideNavIcons) {
							Ext.Array.forEach(me.buttons, function(name) {
								if ((name == 'add' || name == 'remove') && position == 'center')
								{
									buttons.push({
										xtype: 'button',
										tooltip: me.buttonsText[name],
										handler: me['on' + Ext.String.capitalize(name) + 'BtnClick'],
										cls: Ext.baseCSSPrefix + 'form-itemselector-btn',
										iconCls: Ext.baseCSSPrefix + 'form-itemselector-' + name,
										navBtn: true,
										scope: me,
										width:16,
										height:16,
										margin: '4 0 0 0'
									});
								}
								else if (name != 'add' && name != 'remove' && position == 'left')
								{
									buttons.push({
										xtype: 'button',
										tooltip: me.buttonsText[name],
										handler: me['on' + Ext.String.capitalize(name) + 'BtnClick'],
										cls: Ext.baseCSSPrefix + 'form-itemselector-btn',
										iconCls: Ext.baseCSSPrefix + 'form-itemselector-' + name,
										navBtn: true,
										scope: me,
										width:16,
										height:16,
										margin: '4 0 0 0'
									});
								}
							});
						}
						return buttons;
					},

					onTopBtnClick : function() {
						var list = this.fromField.boundList,
							store = list.getStore(),
							selected = this.getSelections(list);

						store.suspendEvents();
						store.remove(selected, true);
						store.insert(0, selected);
						store.resumeEvents();
						list.refresh();
						this.syncValue();
						list.getSelectionModel().select(selected);
					},

					onBottomBtnClick : function() {
						var list = this.fromField.boundList,
							store = list.getStore(),
							selected = this.getSelections(list);

						store.suspendEvents();
						store.remove(selected, true);
						store.add(selected);
						store.resumeEvents();
						list.refresh();
						this.syncValue();
						list.getSelectionModel().select(selected);
					},

					onUpBtnClick : function() {
						var list = this.fromField.boundList,
							store = list.getStore(),
							selected = this.getSelections(list),
							rec,
							i = 0,
							len = selected.length,
							index = 0;

						// Move each selection up by one place if possible
						store.suspendEvents();
						for (; i < len; ++i, index++) {
							rec = selected[i];
							index = Math.max(index, store.indexOf(rec) - 1);
							store.remove(rec, true);
							store.insert(index, rec);
						}
						store.resumeEvents();
						list.refresh();
						this.syncValue();
						list.getSelectionModel().select(selected);
					},

					onDownBtnClick : function() {
						var list = this.fromField.boundList,
							store = list.getStore(),
							selected = this.getSelections(list),
							rec,
							i = selected.length - 1,
							index = store.getCount() - 1;

						// Move each selection down by one place if possible
						store.suspendEvents();
						for (; i > -1; --i, index--) {
							rec = selected[i];
							index = Math.min(index, store.indexOf(rec) + 1);
							store.remove(rec, true);
							store.insert(index, rec);
						}
						store.resumeEvents();
						list.refresh();
						this.syncValue();
						list.getSelectionModel().select(selected);
					}
				}
			]
		},
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			margin: '20 0 20 0',
			items: [
				{
					xtype: 'button',
					cls:'button20',
					id:'update',
					text: update,
					width: 80
				}
			]
		}
	],

	tools: [
		{
			xtype: 'button',
			cls:'backbutton',
			iconCls:'iconBack',
			text: back,
			id:'back'
		}
	]

});



