Ext.define('ICComponent.view.Components', {
	extend: 'utilities.innerScrollContainer',
	alias: 'widget.components',
	margin: "8 8 0 8",
	//frame:true,
	cls:'outerpanel',
	title: pageTitle,

	requires: [
		'utilities.CustomGrid',
		'utilities.adminMsg'
	],

	dockedItems: [
		{
			xtype: 'adminmsg',
			align:'center',
			addIcon:'iconAdminInfo',
			html: pageDesc,
			spaceforImg:5,
			padding: 5
		}
	],

	items: [
		{
			xtype: 'container',
			flex: 1,
			layout: {
				type: 'hbox',
				align:'stretch',
			},
			items: [
				{
					xtype: 'customgrid',
					cls:'gridSkin admin_grid',
					id:'pdGrid',
					frame:false,
					border:true,
					padding:0,
					scroll:true,
					autoScroll:true,
					flex:1,
					title: pdServs,
					store: new Ext.data.Store({
						fields: ['ComponentType', 'ActualValue'],
						data : []
					}),
					columns: {
						defaults: {
							sortable: true,
							hideable: false,
							menuDisabled: true,
							draggable: false,
							resizable: false
						},
						items: [
							{
								text: comp,
								dataIndex: 'ComponentType',
								flex:1
							},
							{
								text: '',
								dataIndex: 'ActualValue',
								flex:1,
								hidden: true
							},
							{
								xtype: 'actioncolumn',
								//cls: 'tasks-icon-column-header tasks-configlayer-column-header',
								width: 36,
								//icon: '../../../../resources/images/layer-stack.png',
								iconCls: 'iconLayerstack',
								//tooltip: layerTooltip,
								sortable: false,
								renderer: function(value, metaData, record, row, col, store, gridView)
								{
									metaData.tdAttr = "data-qtip='Associate/Dissociate Layers' data-qclass='yellowTip'";
								},
								handler: function(grid, rowIndex, colIndex) {
									ctrler.layerAssign(grid, rowIndex, colIndex);
								}
							},
							{
								xtype: 'actioncolumn',
								//cls: 'tasks-icon-column-header tasks-ptest-column-header',
								width: 36,
								//icon: '../../../../resources/images/P.png',
								iconCls: 'iconTest',
								//tooltip: testTooltip,
								sortable: false,
								renderer: function(value, metaData, record, row, col, store, gridView)
								{
									metaData.tdAttr = "data-qtip='Associate/Dissociate Performance Tests' data-qclass='yellowTip'";
								},
								handler: function(grid, rowIndex, colIndex) {
									ctrler.perfTestsAssign(grid, rowIndex, colIndex);
								}
							},
							{
								xtype: 'actioncolumn',
								id:'configTestsPD',
								//cls: 'tasks-icon-column-header tasks-ctest-column-header',
								width:36,
								//icon: '../../../../resources/images/C.png',
								iconCls: 'iconICConfigTest',
								//tooltip: testTooltip2,
								sortable: false,
								renderer: function(value, metaData, record, row, col, store, gridView)
								{
									metaData.tdAttr = "data-qtip='Associate/Dissociate Configuration Tests' data-qclass='yellowTip'";
								},
								handler: function(grid, rowIndex, colIndex) {
									ctrler.configTestsAssign(grid, rowIndex, colIndex);
								},
								hidden:true
							}
						]
					},
					margin: '10 5 10 10',
					flex: 1,
					emptyText: '<table border="0" width="100%" height="400px"><tr><td align="center" valign="middle"><div class="iconInformation"></div><div class="commonErrorMsgText" id="noPdCompsAlrtDiv">'+noPDServ+'</div></td></tr></table>',
					viewConfig: {
						deferEmptyText: false
					},
					tools: [
						/*{
							xtype:'tbfill',
						},*/
						{
							xtype: 'trigger',
							cls:'whitedropdown_search',
							trigger1Cls: 'x-form-clear-trigger',
							trigger2Cls: 'x-form-search-trigger',
							emptyText: 'Search',
							padding:0,
							margin:0,
							id:'searchBox',
							onTrigger1Click: function() {
								this.reset();
							},
							onTrigger2Click: function() {
								ctrler.searchComponent();
							},
							getTriggerMarkup: function() {
								var me = this,
								i = 0,
								hideTrigger = (me.readOnly || me.hideTrigger),
								triggerCls,
								triggerBaseCls = me.triggerBaseCls,
								triggerConfigs = [],
								unselectableCls = Ext.dom.Element.unselectableCls,
								style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
								cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;

								// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
								// single triggerCls config. Should rethink this, perhaps something more structured like a list of
								// trigger config objects that hold cls, handler, etc.
								// triggerCls is a synonym for trigger1Cls, so copy it.
								if (!me.trigger1Cls) {
									me.trigger1Cls = me.triggerCls;
								}

								// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
								for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
									if (i == 0)
									{
										triggerConfigs.push({
											tag: 'td',
											role: 'presentation',
											valign: 'top',
											cls: cls,
											id : 'MyTrigger_'+i,
											style: style + "display:none;",
											cn: {
												cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
												role: 'presentation'
											}
										});
									}
									else
									{
										triggerConfigs.push({
											tag: 'td',
											role: 'presentation',
											valign: 'top',
											cls: cls,
											id : 'MyTrigger_'+i,
											style: style,
											cn: {
												cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
												role: 'presentation'
											}
										});
									}
								}
								triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
								return Ext.DomHelper.markup(triggerConfigs);
							}
						}
					]
				},
				{
					xtype: 'customgrid',
					id:'udGrid',
					frame:false,
					border:true,
					scroll:true,
					cls:'gridSkin admin_grid',
					padding:0,
					flex:1,
					title: udServs,
					store: new Ext.data.Store({
						fields: ['ComponentType', 'ActualValue'],
						data : []
					}),
					autoScroll: true,
					columns: {
						defaults: {
							sortable: true,
							hideable: false,
							menuDisabled: true,
							draggable: false,
							resizable: false
						},
						items: [
							{
								text: comp,
								dataIndex: 'ComponentType',
								flex:1
							},
							{
								text: '',
								dataIndex: 'ActualValue',
								hidden: true
							},
							{
								xtype: 'actioncolumn',
								//cls: 'tasks-icon-column-header tasks-edit-column-header',
								width: 36,
								id: 'EditOver',
								//icon: '../../../../resources/images/edit_task.png',
								iconCls: 'iconModify',
								//tooltip: modify,
								sortable: false,
								renderer: function(value, metaData, record, row, col, store, gridView)
								{
									metaData.tdAttr = "data-qtip='Modify' data-qclass='yellowTip'";
								},
								handler: function(grid, rowIndex, colIndex) {
									ctrler.modifyCompType(grid, rowIndex, colIndex);
								}
							},
							{
								xtype: 'actioncolumn',
								//cls: 'tasks-icon-column-header tasks-configlayer-column-header',
								width: 36,
								//icon: '../../../../resources/images/layer-stack.png',
								iconCls: 'iconLayerstack',
								//tooltip: layerTooltip,
								sortable: false,
								renderer: function(value, metaData, record, row, col, store, gridView)
								{
									metaData.tdAttr = "data-qtip='Associate/Dissociate Layers' data-qclass='yellowTip'";
								},
								handler: function(grid, rowIndex, colIndex) {
									ctrler.layerAssign(grid, rowIndex, colIndex);
								}
							},
							{
								xtype: 'actioncolumn',
								//cls: 'tasks-icon-column-header tasks-ptest-column-header',
								width:36,
								//icon: '../../../../resources/images/P.png',
								iconCls: 'iconTest',
								//tooltip: testTooltip,
								sortable: false,
								renderer: function(value, metaData, record, row, col, store, gridView)
								{
									metaData.tdAttr = "data-qtip='Associate/Dissociate Performance Tests' data-qclass='yellowTip'";
								},
								handler: function(grid, rowIndex, colIndex) {
									ctrler.perfTestsAssign(grid, rowIndex, colIndex);
								}
							},
							{
								xtype: 'actioncolumn',
								id:'configTestsUD',
								//cls: 'tasks-icon-column-header tasks-ctest-column-header',
								width: 36,
								//icon: '../../../../resources/images/C.png',
								iconCls: 'iconICConfigTest',
								//tooltip: testTooltip2,
								sortable: false,
								renderer: function(value, metaData, record, row, col, store, gridView)
								{
									metaData.tdAttr = "data-qtip='Associate/Dissociate Configuration Tests' data-qclass='yellowTip'";
								},
								handler: function(grid, rowIndex, colIndex) {
									ctrler.configTestsAssign(grid, rowIndex, colIndex);
								},
								hidden:true
							},
							{
								xtype: 'actioncolumn',
								//cls: 'tasks-icon-column-header tasks-delete-column-header',
								width: 36,
								id: 'DeleteOver',
								//icon: '../../../../resources/images/delete.png',
								iconCls: 'iconDelete',
								//tooltip: deleteTooltip,
								sortable: false,
								renderer: function(value, metaData, record, row, col, store, gridView)
								{
									metaData.tdAttr = "data-qtip='Delete' data-qclass='yellowTip'";
								},
								handler: function(grid, rowIndex, colIndex) {
									ctrler.deleteCompType(grid, rowIndex, colIndex);
								}
							}
						]
					},
					margin: '10 10 10 5',
					flex: 1,
					emptyText:  '<table border="0" width="100%" height="400px"><tr><td align="center" valign="middle"><div class="iconInformation"></div><div class="commonErrorMsgText" id="noUdCompsAlrtDiv">'+noUDServ+'</div></td></tr></table>',
					viewConfig: {
						deferEmptyText: false
					},
					tools: [
						/*{
							xtype:'tbfill',
						},*/
						{
							xtype: 'trigger',
							cls:'whitedropdown_search',
							trigger1Cls: 'x-form-clear-trigger',
							trigger2Cls: 'x-form-search-trigger',
							emptyText: 'Search',
							id:'searchBox2',
							padding:0,
							margin:'0 5 0 0',
							onTrigger1Click: function() {
								this.reset();
							},
							onTrigger2Click: function() {
								ctrler.searchComponent2();
							},
							getTriggerMarkup: function() {
								var me = this,
								i = 0,
								hideTrigger = (me.readOnly || me.hideTrigger),
								triggerCls,
								triggerBaseCls = me.triggerBaseCls,
								triggerConfigs = [],
								unselectableCls = Ext.dom.Element.unselectableCls,
								style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
								cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;

								// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
								// single triggerCls config. Should rethink this, perhaps something more structured like a list of
								// trigger config objects that hold cls, handler, etc.
								// triggerCls is a synonym for trigger1Cls, so copy it.
								if (!me.trigger1Cls) {
									me.trigger1Cls = me.triggerCls;
								}

								// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
								for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
									if (i == 0)
									{
										triggerConfigs.push({
											tag: 'td',
											role: 'presentation',
											valign: 'top',
											cls: cls,
											id : 'My2Trigger_'+i,
											style: style + "display:none;",
											cn: {
												cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
												role: 'presentation'
											}
										});
									}
									else
									{
										triggerConfigs.push({
											tag: 'td',
											role: 'presentation',
											valign: 'top',
											cls: cls,
											id : 'My2Trigger_'+i,
											style: style,
											cn: {
												cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
												role: 'presentation'
											}
										});
									}
								}
								triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
								return Ext.DomHelper.markup(triggerConfigs);
							}
						},
						{
							xtype: 'toolbar',
							ui: 'footer',
							padding:0,
							margin:0,
							items:[
								{
									xtype: 'button',
									cls:'button20',
									padding:0,
									margin:0,
									id: 'addCompButton',
									text: addNewType
								}
							]
						}
					]
				}
			]
		}
	]

});



