Ext.define('ICComponentExportImport.controller.Main',{
	extend: 'Ext.app.Controller',
	refs:[
		{selector:'icctypeexportimportconfig', ref:'icctypeexportimportconfig'},
		{selector:'downloadutils', ref:'downloadutils'}
	],
	init:function(){
		me = this,
		ctrler = this,
		this.control({
			'icctypeexportimportconfig':
			{
				'afterrender': this.loadGridChanges
			},
			'icctypeexportimportconfig button[id="icExportBtn"]':
			{
				'click': this.exportICData
			},
			'icctypeexportimportconfig tabpanel[id="icexportimportTab"]':
			{
				'tabchange': this.tabChange
			},
			'icctypeexportimportconfig button[id="icImportBtn"]':
			{
				'click': this.importICData
			},
			'icctypeexportimportconfig button[id="cancelBtn"]':
			{
				'click':this.removeUploadData
			},
			'icctypeexportimportconfig trigger[id="searchBox"]':
			{
				'change': this.searchComponentType
			},
			'icctypeexportimportconfig trigger[id="searchBoxImport"]':
			{
				'change': this.searchImportTest
			},
			'icctypeexportimportconfig button[id="uploadBtn"]':
			{
				'click':this.uploadSelectedData
			}
		});
	},
	tabChange: function(type)
	{
		var selectTab = Ext.getCmp('icexportimportTab').getActiveTab().getItemId();
		if(selectTab == 'icCompExportTab')
		{
			this.afterMainRender();
		}
		else if (selectTab == 'icCompImportTab')
		{
			this.removeUploadData();
			Ext.getCmp('searchBox').setValue('');
			var rowIndex=0;
			while(typeof(Ext.getCmp('icCompTypegrid').getStore().getAt(rowIndex))!='undefined') {
				var record = Ext.getCmp('icCompTypegrid').getStore().getAt(rowIndex);
				Ext.getCmp('icCompTypegrid').getSelectionModel().deselect(rowIndex, true);
				rowIndex++;
			}
		}
		Ext.Ajax.request({
			url: 'ICComponentExportImport/data/exportimporthelpJson.jsp?selectTab='+selectTab,
			method: 'POST',
			async: false
		});
	},
	removeUploadData: function()
	{
		if (Ext.getCmp('icImpCompTypegrid').isVisible())
		{
			Ext.getCmp('icImpCompTypegrid').hide();
		}
		if (Ext.getCmp('importBtnContainer').isVisible())
		{
			Ext.getCmp('importBtnContainer').hide();
		}
		Ext.getCmp('uploadFileContainer').show();
	},

	searchComponentType : function()
	{
		var me = this;
		var searchValue = Ext.getCmp('searchBox').getValue();
		if (searchValue == "" || searchValue.length == 0)
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');
		}
		Ext.Ajax.request({
			url : 'ICComponentExportImport/data/EgIcExportCompTypeJson.jsp?',
			params :
			{
				'searchValue' : searchValue,
				'reqFrom' : 'searchCType'
			},
			method : 'POST',
			async: false,
			scope : this,
			success : function(response)
			{
				if(response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var rowIndex=0;
					while(typeof(Ext.getCmp('icCompTypegrid').getStore().getAt(rowIndex))!='undefined') {
						var record = Ext.getCmp('icCompTypegrid').getStore().getAt(rowIndex);
						Ext.getCmp('icCompTypegrid').getSelectionModel().deselect(rowIndex, true);
						rowIndex++;
					}
					var jsonText = response.responseText;
					jsonData = Ext.decode(jsonText);
					Ext.getCmp('icCompTypegrid').getStore().removeAll();
					var searchGrid = jsonData['SearchGridData'];
					Ext.getCmp('icCompTypegrid').getStore().loadRawData(searchGrid);
				}
			}
		});
	},
	searchImportTest : function()
	{
		var me = this;
		var searchValue = Ext.getCmp('searchBoxImport').getValue();
		var hiddenFieldVal = Ext.getCmp('hiddenFieldImport').getValue();

		if (searchValue == "" || searchValue.length == 0)
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');
		}
		Ext.Ajax.request({
			url : 'ICComponentExportImport/data/EgICImportCompTypeFilesJson.jsp?',
			params :
			{
				'searchValue' : searchValue,
				'fileName' : hiddenFieldVal,
				'reqFrom' : 'searchCType'
			},
			method : 'POST',
			async: false,
			scope : this,
			success : function(response)
			{
				if(response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var rowIndex=0;
					while(typeof(Ext.getCmp('icImpCompTypegrid').getStore().getAt(rowIndex))!='undefined') {
						var record = Ext.getCmp('icImpCompTypegrid').getStore().getAt(rowIndex);
						Ext.getCmp('icImpCompTypegrid').getSelectionModel().deselect(rowIndex, true);
						rowIndex++;
					}
					var jsonText = response.responseText;
					jsonData = Ext.decode(jsonText);
					Ext.getCmp('icImpCompTypegrid').getStore().removeAll();
					var searchGrid = jsonData['SearchImpCTypeArr'];
					Ext.getCmp('icImpCompTypegrid').getStore().loadRawData(searchGrid);
				}
			}
		});
	},
	loadGridChanges : function()
	{
		Ext.Ajax.request({
			url: 'ICComponentExportImport/data/EgIcExportCompTypeJson.jsp?',
			params :
			{
				'reqFrom' : 'loadData'
			},

			method : 'POST',
			async : false,
			scope : this,
			success : function(response)
			{
				if(response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					jsonData = Ext.decode(jsonText);
					Ext.getCmp('icCompTypegrid').getStore().loadRawData(jsonData['ComponentTypeArr']);
				}
			}
		});
	},
	afterMainRender: function()
	{
		me= this;
		me.loadGridChanges();
	},
	exportICData : function(btn)
	{
		var viewStoreObj = Ext.getCmp('icCompTypegrid');
		var storeObj = viewStoreObj.getStore();
		var noOfRecords = storeObj.getCount();
		var selectionModelObj = viewStoreObj.getSelectionModel();
		if(noOfRecords > 0)
		{
			var testSelected = false;
			var compType = "";
			var exportData = "";
			var totalVal = "";
			if(selectionModelObj.getSelection().length > 0)
				testSelected = true;
			if(testSelected)
			{
				var selectedCType = selectionModelObj.getSelection();
				for(var i = 0;i< selectedCType.length; i++)
				{
					var exportCType = selectedCType[i];
					compType = exportCType.get('comptype');
					totalVal = compType + ",";
					exportData += totalVal;
				}
				var qString = "selectedIC="+encodeURIComponent(exportData)+"&requestFrom="+encodeURIComponent("ICCompType");

				var s_qryString = "/final/servlet/com.egurkha.admin.EgICExportConfigureServlet?"+qString;
				var downloadUtils =  Ext.widget('downloadutils');
				downloadUtils.savePDF(s_qryString);
			}
			else
			{
				Ext.Msg.show({
					title: pageName,
					msg: alert5,
					width: alert5.length * 7,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
			}
		}
	},
	uploadSelectedData: function()
	{
		me = this;
		var fileName = Ext.getCmp('icImportFileField').getValue();
		var fileExt = ".zip";
		var hiddenFieldVal = Ext.getCmp('hiddenFieldImport').setValue(fileName);

		if(fileName.lastIndexOf(".zip") == -1)
		{
			Ext.Msg.show({
				title: pageName,
				msg: alert1+" '"+fileExt+"'",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			Ext.getCmp('icImportFileField').reset();
			Ext.getCmp('icImportFileField').focus();
			return;
		}
		var frmMain = this.getIcctypeexportimportconfig().getForm();
		if (frmMain.isValid())
		{
			var myMask = new Ext.LoadMask(Ext.getBody(), {msg:'Loading...'});
			myMask.show();
			this.getIcctypeexportimportconfig().submit({
				url: 'ICComponentExportImport/data/EgICImportCompTypeFilesJson.jsp?fileName='+encodeURIComponent(fileName)+"&reqFrom="+encodeURIComponent("loadData")+"&com.eg.CSRF_NONCE="+csrfToken,
				method: 'POST',
				success: function(form, action){
					myMask.hide();
					var jsonText = action.response.responseText;
					publicJson = Ext.decode(jsonText);
					var validZipFile = publicJson['validZipFile'];
					if(validZipFile=="true")
					{
						//me.loadImportGridData(fileName);
						Ext.getCmp('icImpCompTypegrid').getStore().loadRawData(publicJson['ImportCompTypeArr']);
						Ext.getCmp('icImpCompTypegrid').show();
						Ext.getCmp('uploadFileContainer').hide();
						Ext.getCmp('importBtnContainer').show();
					}
					else
					{
						Ext.Msg.show({
							title: pageName,
							msg: alertZipMsg,
							width: alertZipMsg.length * 7,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
						Ext.getCmp('uploadFileContainer').show();
					}
				},
				failure: function(form, action) // if result page doest not contain success:true, this method fires
				{
					myMask.hide();
					var jsonText = Ext.decode(action.response.responseText);
					var jsonText = action.response.responseText;
					publicJson = Ext.decode(jsonText);
					var isNoData = publicJson['isNoData'];
					var alertMsg = publicJson['screenLabels']['No_Data_Msg'];
					if(!Ext.isEmpty(isNoData) && isNoData)
					{
						Ext.Msg.show({
							title: pageName,
							msg: alertMsg,
							width: alertMsg.length * 7,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
					}
				}
			});
		}
	},
	importICData : function()
	{
		var viewStoreImpObj = Ext.getCmp('icImpCompTypegrid');
		var storeObj = viewStoreImpObj.getStore();
		var noOfRecords = storeObj.getCount();
		var selectionModelObj = viewStoreImpObj.getSelectionModel();
		var fileName = publicJson['folderName'];
		if(noOfRecords > 0)
		{
			var compTypeSelected = false;
			var compType = "";
			var importData = "";
			if(selectionModelObj.getSelection().length > 0)
				compTypeSelected = true;
			if(compTypeSelected)
			{
				var selectedCType = selectionModelObj.getSelection();
				for(var i = 0;i< selectedCType.length; i++)
				{
					var importCType = selectedCType[i];
					compType = importCType.get('comptype');
					importData += compType + "," ;
				}
				var urlStr =  'ICComponentExportImport/data/EgICImportCompTypefilesp.jsp?selectedCType='+encodeURIComponent(importData)+"&folderName="+encodeURIComponent(fileName)+"&requestFrom="+encodeURIComponent("overwriteImportData");
				Ext.Ajax.request(
				{
					url : 'ICComponentExportImport/data/EgICImportCompTypefilesp.jsp?',
					params :
					{
						'selectedCType' : importData,
						'folderName'	: fileName,
						'requestFrom' : 'validateImportData'
					},
					method : 'POST',
					success : function(response)
					{
						var jsonText = response.responseText;
						validataJsonData = Ext.decode(jsonText);
						var result = validataJsonData['IcTestsExist'];
						var testVal = validataJsonData['ExistingIcTestsArr'];
						var isValidImport = validataJsonData['isValidImport'];
						if(isValidImport)
						{
							if(result != null && result != undefined && result == 'true')
							{
								Ext.MessageBox.confirm({
									title: pageName,
									msg:valAlert,
									buttons: Ext.Msg.YESNO,
									icon: 'iconInformation',
									fn: function(btn)
									{
										if(btn == 'yes')
										{
											var myMask = new Ext.LoadMask(Ext.getBody(), {msg:'Loading...'});
											myMask.show();
											Ext.Ajax.request({
												url:urlStr,
												method:'POST',
												scope:this,
												timeout: 600000000,
												success:function(response)
												{
													if(response.status == 200 && !Ext.isEmpty(response.responseText))
													{
														myMask.hide();
														var jsonText = Ext.decode(response.responseText);
														Ext.Msg.show({
															title: pageName,
															msg: alert3,
															buttons: Ext.Msg.OK,
															icon: 'iconInformation',
															fn: function() {
																me.removeUploadData();
															}
														});
													}
												}
											});
										}
										else
										{
											var urlVal =  'ICComponentExportImport/data/EgICImportCompTypefilesp.jsp?selectedCType='+encodeURIComponent(importData)+"&folderName="+encodeURIComponent(fileName)+"&requestFrom="+encodeURIComponent("nonOverwriteImportData")+"&existIcTestsVal="+encodeURIComponent(testVal);
											var myMask = new Ext.LoadMask(Ext.getBody(), {msg:'Loading...'});
											myMask.show();
											Ext.Ajax.request({
												url:urlVal,
												method:'POST',
												scope:this,
												timeout: 600000000,
												success:function(response)
												{
													if(response.status == 200 && !Ext.isEmpty(response.responseText))
													{
														myMask.hide();
														var jsonVal = Ext.decode(response.responseText);
														var importTests = jsonVal['SingleTests'];
														if(importTests == 'true')
														{
															me.removeUploadData();
														}
														else
														{
															Ext.Msg.show({
																title: pageName,
																msg: alert3,
																buttons: Ext.Msg.OK,
																icon: 'iconInformation',
																fn: function() {
																	me.removeUploadData();
																}
															});
														}
													}
												}
											});
										}
									}
								});
							}
							else
							{
								Ext.MessageBox.confirm({
									title: pageName,
									msg:alert6,
									buttons: Ext.Msg.YESNO,
									icon: 'iconInformation',
									fn : function(btn)
									{
										if(btn == 'yes')
										{
											var myMask = new Ext.LoadMask(Ext.getBody(), {msg:'Loading...'});
											myMask.show();
											Ext.Ajax.request({
												url:urlStr,
												method:'POST',
												scope:this,
												//async: false,
												timeout: 600000000,
												success:function(response)
												{
													if(response.status == 200 && !Ext.isEmpty(response.responseText))
													{
														myMask.hide();
														var jsonText = Ext.decode(response.responseText);
														Ext.Msg.show({
															title: pageName,
															msg: alert3,
															buttons: Ext.Msg.OK,
															icon: 'iconInformation',
															fn: function() {
																me.removeUploadData();
															}
														});
													}
												}
											});
										}
										else
										{
											me.removeUploadData();
										}
									}
								});
							}
						}
						else
						{
							Ext.Msg.show({
								title: pageName,
								msg: alert9,
								width: alert9.length * 7,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function() {
									me.removeUploadData();
								}
							});
							return false;
						}
					}
				});
			}
			else
			{
				Ext.Msg.show({
					title: pageName,
					msg: alert4,
					width: alert4.length * 7,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return false;
			}
		}
	},
	/*loadImportGridData : function(fileName)
	{
		var hiddenFieldVal = Ext.getCmp('hiddenFieldImport').getValue();
		Ext.Ajax.request({
			url: 'ICComponentExportImport/data/EgICImportCompTypeFilesJson.jsp?fileName='+encodeURIComponent(hiddenFieldVal)+"&reqFrom="+encodeURIComponent("loadData"),
			method : 'POST',
			async : false,
			scope : this,
			success : function(response)
			{
				if(response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					publicJson = Ext.decode(jsonText);
					Ext.getCmp('icImpCompTypegrid').getStore().loadRawData(publicJson['ImportCompTypeArr']);
				}
			}
		});
	}*/
});
