Ext.define('ICComponentExportImport.view.ICExportImportConfiguration',{
	extend : 'Ext.form.Panel',
	alias : 'widget.icctypeexportimportconfig',
	headers: {'Content-type':'multipart/form-data'},
	title: pageName,
	margin:'8 8 0 8',
	cls:'outerpanel',
	padding:0,
	id : 'icexportimportconfiguration',


	requires: [
		'utilities.CustomGrid',
	],

	layout : {
		type : 'vbox',
		align : 'stretch'
	},

	dockedItems: [
		{
			xtype: 'toolbar',
			cls:'adminHeadInfoText',
			dock: 'top',
			layout:{pack:'center'},
			width:'100%',
			height: 25,
			padding: 3,
			items: [
				{
					xtype: 'component',
					html: '<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp'+pageDesc+'.</center>'
				}
			]
		}
	],

	items : [
		{
			xtype: 'tabpanel',
			id:'icexportimportTab',
			name:'icexportimportTab',
			cls: 'tablayout',
			plain: true,
			style:{'border':'0px !important'},
			border: false,
			frame: false,
			tabPosition: 'top',
			flex: 1,
			margin: 15,
			items : [
				{
					title: exportTitle,
					itemId: 'icCompExportTab',
					scroll: false,
					autoScroll: true,
					cls: 'tabLayoutInnerBorder',
					style: {'border-top':'0px'},
					bodyStyle: {'overflow':'auto !important'},
					layout: {
						type: 'vbox',
						align: 'stretch',
						pack :'center'
					},
					items: [
						 {
							xtype: 'customgrid',
							cls:'gridSkin admin_grid',
							id:'icCompTypegrid',
							name:'icCompTypegrid',
							autoScroll:true,
							border : false,
							flex:1,
							margin: 10,
							viewConfig: {
								emptyText: "<table height='250' width='100%'><tr><td align=center><img src='/final/images/spacer.gif' class='iconInformation'><div class='commonErrorMsgText'>" + emptyMessage + ".</div></td></tr></table>"
							},
							selModel : new Ext.selection.CheckboxModel({
								checkOnly : true,
								width : 25,
								injectCheckbox : 'first'
							}),
							store: new Ext.data.Store({
								fields: ['comptype'],
								data: [],
								sorters: [{
									property: 'comptype',
									direction: 'ASC'
								}],
								sortOnLoad: true
							}),
							columns : {
								defaults : {
									sortable : true,
									hideable : false,
									menuDisabled : true,
									draggable : false ,
									resizable : false
								},
								items : [
									{
										text : 'Component type',
										dataIndex : 'comptype',
										flex : 1
									}
								]
							},
							tools: [
								{
									xtype: 'trigger',
									cls:'whitedropdown_search',
									trigger1Cls: 'x-form-clear-trigger',
									trigger2Cls: 'x-form-search-trigger',
									emptyText: 'Search',
									id:'searchBox',
									padding: 2,
									onTrigger1Click: function() {
										this.reset();
									},
									onTrigger2Click: function() {
										ctrler.searchComponentType();
									},
									getTriggerMarkup: function() {
										var me = this,
										i = 0,
										hideTrigger = (me.readOnly || me.hideTrigger),
										triggerCls,
										triggerBaseCls = me.triggerBaseCls,
										triggerConfigs = [],
										unselectableCls = Ext.dom.Element.unselectableCls,
										style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
										cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;
										// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
										// single triggerCls config. Should rethink this, perhaps something more structured like a list of
										// trigger config objects that hold cls, handler, etc.
										// triggerCls is a synonym for trigger1Cls, so copy it.
										if (!me.trigger1Cls) {
											me.trigger1Cls = me.triggerCls;
										}
										// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
										for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
											if (i == 0)
											{
												triggerConfigs.push({
													tag: 'td',
													role: 'presentation',
													valign: 'top',
													cls: cls,
													id : 'MyTrigger_'+i,
													style: style + "display:none;",
													cn: {
														cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
														role: 'presentation'
													}
												});
											}
											else
											{
												triggerConfigs.push({
													tag: 'td',
													role: 'presentation',
													valign: 'top',
													cls: cls,
													id : 'MyTrigger_'+i,
													style: style,
													cn: {
														cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
														role: 'presentation'
													}
												});
											}
										}
										triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
										return Ext.DomHelper.markup(triggerConfigs);
									}
								}
							]
						},
						{
							xtype: 'container',
							layout: {
								type: 'hbox',
								pack: 'center'
							},
							margin: '5 0 10 0',
							items: [
								{
									xtype: 'button',
									cls:'button20',
									id: 'icExportBtn',
									text: 'Export'
								}
							]
						}
					]
				},
				{
					title: importTitle,
					itemId: 'icCompImportTab',
					scroll: false,
					autoScroll: true,
					cls: 'tabLayoutInnerBorder',
					style: {'border-top':'0px'},
					bodyStyle: {'overflow':'auto !important'},
					layout: {
						type: 'vbox',
						align: 'stretch'
					},
					items: [
						{
							xtype: 'container',
							id: 'uploadFileContainer',
							layout: {
								type: 'vbox',
								pack: 'start',
								align: 'center'
							},
							flex: 1,
							items: [
								{
									xtype: 'filefield',
									cls: 'fileupload',
									id: 'icImportFileField',
									name: 'icImportFileField',
									width: 500,
									fieldLabel: labelTxt,
									labelAlign: 'top',
									labelSeparator: ' ',
									buttonText: browseTxt,
									margin: '10 0 5 0'
								},
								{
									xtype: 'hiddenfield',
									name: 'File Upload Val',
									id : 'hiddenFieldImport',
									value: 'value from hidden field'
								},
								{
									xtype: 'container',
									id: 'uploadBtnContainer',
									layout: {
										type: 'hbox',
										pack: 'center'
									},
									margin: '5 0 10 0',
									items: [
										{
											xtype: 'button',
											cls:'button20',
											id: 'uploadBtn',
											text: uploadTxt
										}
									]
								}
							]
						},
						{
							xtype: 'customgrid',
							cls:'gridSkin admin_grid',
							id:'icImpCompTypegrid',
							name:'icImpCompTypegrid',
							autoScroll:true,
							border : false,
							flex: 1,
							margin: 10,
							viewConfig: {
								emptyText: "<table height='250' width='100%'><tr><td align=center><img src='/final/images/spacer.gif' class='iconInformation'><div class='commonErrorMsgText'>" + emptyMessage + ".</div></td></tr></table>"
							},
							selModel : new Ext.selection.CheckboxModel({
								checkOnly : true,
								width : 25,
								injectCheckbox : 'first'
							}),
							store: new Ext.data.Store({
								fields: ['comptype'],
								data: [],
								sorters: [{
									property: 'comptype',
									direction: 'ASC'
								}],
								sortOnLoad: true
							}),
							columns : {
								defaults : {
									sortable : true,
									hideable : false,
									menuDisabled : true,
									draggable : false ,
									resizable : false
								},
								items : [
									{
										text : 'Component type',
										dataIndex : 'comptype',
										flex : 1
									}
								]
							},
							tools: [
								{
									xtype: 'trigger',
									cls:'whitedropdown_search',
									trigger1Cls: 'x-form-clear-trigger',
									trigger2Cls: 'x-form-search-trigger',
									emptyText: 'Search',
									id:'searchBoxImport',
									padding: 2,
									onTrigger1Click: function() {
										this.reset();
									},
									onTrigger2Click: function() {
										ctrler.searchComponentType();
									},
									getTriggerMarkup: function() {
										var me = this,
										i = 0,
										hideTrigger = (me.readOnly || me.hideTrigger),
										triggerCls,
										triggerBaseCls = me.triggerBaseCls,
										triggerConfigs = [],
										unselectableCls = Ext.dom.Element.unselectableCls,
										style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
										cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;
										// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
										// single triggerCls config. Should rethink this, perhaps something more structured like a list of
										// trigger config objects that hold cls, handler, etc.
										// triggerCls is a synonym for trigger1Cls, so copy it.
										if (!me.trigger1Cls) {
											me.trigger1Cls = me.triggerCls;
										}
										// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
										for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
											if (i == 0)
											{
												triggerConfigs.push({
													tag: 'td',
													role: 'presentation',
													valign: 'top',
													cls: cls,
													id : 'MyTrigger_'+i,
													style: style + "display:none;",
													cn: {
														cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
														role: 'presentation'
													}
												});
											}
											else
											{
												triggerConfigs.push({
													tag: 'td',
													role: 'presentation',
													valign: 'top',
													cls: cls,
													id : 'MyTrigger_'+i,
													style: style,
													cn: {
														cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
														role: 'presentation'
													}
												});
											}
										}
										triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
										return Ext.DomHelper.markup(triggerConfigs);
									}
								}
							],
							bbar: [
								{
									xtype : 'displayfield',
									id : 'impfield',
									value : '* Already existing component type',
								}
							],
							hidden: true
						},
						{
							xtype: 'container',
							id: 'importBtnContainer',
							layout: {
								type: 'hbox',
								pack: 'center'
							},
							margin: '5 0 10 0',
							items: [
								{
									xtype: 'button',
									cls: 'button20',
									id: 'icImportBtn',
									text: importTxt
								},
								{
									xtype: 'button',
									cls: 'button20',
									id: 'cancelBtn',
									text: cancelTxt,
									margin: '0 0 0 10'
								}
							],
							hidden: true
						}
					]
				}
			]
		}
	]
});



