Ext.define('ICLayer.controller.AddLayerCtrlr',{
	extend:'Ext.app.Controller',
	views:['NewLayer'],
	requires:['ICLayer.view.NewLayer'],
	refs:[
		{selector:'newlayer', ref:'newlayer'}
	],
	init:function(){
		addctrler = this;
		this.buildMainData()
		this.control({
			'newlayer':
			{
				'afterrender': this.afterMainRender
			},
			'newlayer button[id="add"]':
			{
				'click': this.addLayer
			},
			'newlayer radiogroup[id="duplicatelayer"]':
			{
				'change': this.duplicateSelection
			},
			'newlayer button[id="back"]':
			{
				'click':this.goBack
			}
		});
	},
	buildMainData: function()
	{
		Ext.Ajax.request(
		{
			url: 'ICLayer/data/EgAddUDLayerJson.jsp',
			method: 'POST',
			async:false,
			timout: 300000,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},
	afterMainRender: function()
	{
		if (publicJSON.showDuplicateRadio)
		{
			Ext.getCmp('duplicatelayer').show();
		}
		else
		{
			Ext.getCmp('duplicatelayer').hide();
			Ext.getCmp('duplicatelayer').setDisabled(true);
			Ext.getCmp('nonDupLayer').hide();
			Ext.getCmp('nonDupLayer').setDisabled(true);
		}
	},
	goBack: function()
	{
		window.location.href= '/final/admin/EgUDLayer.jsp';
	},
	duplicateSelection: function()
	{
		var selVal = Ext.getCmp('duplicatelayer').getValue().duprb;
		var dupList = Ext.getCmp('nonDupLayer')
		if (selVal=='Yes')
		{
			dupList.show();
			dupList.enable();
			dupList.getStore().removeAll();
			dupList.getStore().loadRawData(publicJSON.nonDupLayersList);
			dupList.setValue(publicJSON.selectedNonDuplicate);
		}
		else
		{
			dupList.hide();
			dupList.disable();
		}
	},
	addLayer: function()
	{
		var isDuplicate = Ext.getCmp('duplicatelayer').getValue().duprb;
		
		if (this.validate() == false)
		{
			return;
		}
		
		if (isDuplicate == 'Yes')
		{
			this.doDuplicate();
			return;
		}

		var urlStr = "ICLayer/data/EgaddudlayerpJson.jsp";
		var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: updating+'...'});
		tmpMask.show();
		this.getNewlayer().submit({
			url: urlStr,
			method: 'POST',
			timeout:300,
			success: function(form, action)
			{
				tmpMask.hide();
				var jsonText = action.response.responseText;
				publicJSON = Ext.decode(jsonText);
				if(publicJSON.AlertType == 'Result')
				{
					Ext.Msg.show({
						title: publicJSON.AlertTitle,
						msg: publicJSON.AlertMsg,
						buttons: Ext.Msg.OK,
						icon: 'iconInformation',
						fn: function(response) {
							if(response == 'ok') {
								window.location.href= '/final/admin/EgUDLayer.jsp';
							}
						}
					});
				}
				else if (publicJSON.AlertType == 'Error')
				{
					Ext.Msg.show({
						title: publicJSON.AlertTitle,
						msg: publicJSON.AlertMsg,
						buttons: Ext.Msg.OK,
						icon: 'iconError',
						fn: function(response) {
							if(response == 'ok') {
								window.location.href= '/final/admin/EgUDLayer.jsp';
							}
						}
					});
				}
			},
			failure: function(form, action)
			{
				 tmpMask.hide();
			}
		});
	},
	doDuplicate: function()
	{
		var layer = Ext.getCmp('layer').getValue();
		var dupLayer = Ext.getCmp('nonDupLayer').getValue();
		var urlStr = "ICLayer/data/EgDuplicateLayerJson.jsp?LayerName="+encodeURIComponent(dupLayer)+"&duplicate="+encodeURIComponent(layer);
		var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: updating+'...'});
		tmpMask.show();
		this.getNewlayer().submit({
			url: urlStr,
			method: 'POST',
			timeout: 300,
			success: function(form, action)
			{
				tmpMask.hide();
				var jsonText = action.response.responseText;
				publicJSON = Ext.decode(jsonText);

				if(publicJSON.AlertType == 'Result')
				{
					Ext.Msg.show({
						title: publicJSON.AlertTitle,
						msg: publicJSON.AlertMsg,
						buttons: Ext.Msg.OK,
						icon: 'iconInformation',
						fn: function(response) {
							if(response == 'ok') {
								window.location.href= '/final/admin/EgUDLayer.jsp';
							}
						}
					});
				}
				else if (publicJSON.AlertType == 'Error')
				{
					Ext.Msg.show({
						title: publicJSON.AlertTitle,
						msg: publicJSON.AlertMsg,
						buttons: Ext.Msg.OK,
						icon: 'iconError',
						fn: function(response) {
							if(response == 'ok') {
								window.location.href= '/final/admin/EgUDLayer.jsp';
							}
						}
					});
				}
			},
			failure: function(form, action)
			{
				 tmpMask.hide();
			}
		});
	},
	validate: function()
	{
		var layer = Ext.getCmp('layer').getValue();
		var layer_Name=true;
		if(isDouble=="false")
		{
			layer_Name = validateSingleByte(layer);
		}

		if(!checkblank(layer))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: alertMsg1,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(response) {
					if(response == 'ok') {
						Ext.getCmp('layer').focus(true);
					}
				}
			});
			return false;
		}
		else if(!checkspace(layer))
		{
			Ext.getCmp('layer').focus(true);
			return false;
		}
		else if(!checkspecialnomess(layer,"`~!@#$%^&*()+=-/?'\"]{}[\\|;:.,><"))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: alertMsg2,
				buttons: Ext.Msg.OK,
				icon : 'iconExclamation',
				fn: function(response) {
					if(response == 'ok') {
						Ext.getCmp('layer').focus(true);
					}
				}
			});
			return false;
		}
		else if(!this.checkForLayerNameWithEx(layer))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: alertMsg1,
				buttons: Ext.Msg.OK,
				icon : 'iconExclamation',
				fn: function(response) {
					if(response == 'ok') {
						Ext.getCmp('layer').focus(true);
					}
				}
			});
			return false;
		}
		else if(!layer_Name)
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: alertMsg3,
				buttons: Ext.Msg.OK,
				icon : 'iconExclamation',
				fn: function(response) {
					if(response == 'ok') {
						Ext.getCmp('layer').focus(true);
					}
				}
			});
			return false;
		}
		var isDuplicate = Ext.getCmp('duplicatelayer').getValue().duprb;
		if (isDuplicate == 'Yes')
		{
			var strLayer = Ext.getCmp('nonDupLayer').getValue();
			if (strLayer == "-1")
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: alertMsg4,
					buttons: Ext.Msg.OK,
					icon : 'iconExclamation'
				});
				return false;
			}
		}
		return true;
	},
	checkForLayerNameWithEx:function(value)
	{
		var totalLen = value.length;
		var len = totalLen - 3;
		var val = value.substring(len,totalLen + 1);
		val = val.toUpperCase();
		if(val == "_EX")
		{
			if(value.charAt(0) == '_')
				return false;
			else
				return true;
		}
		else
			return false;
	},
});



