Ext.define('ICLayer.controller.Main',{
	extend:'Ext.app.Controller',
	views:['Layers'],
	requires:['ICLayer.view.Layers'],
	refs:[
		{selector:'layers', ref:'layers'}
	],
	init:function(){
		ctrler = this;
		this.buildMainData()
		this.control({
			'layers':
			{
				'afterrender': this.afterMainRender
			},
			'layers trigger[id="searchBox"]':
			{
				'change': this.searchLayer
			},
			'layers trigger[id="searchBox2"]':
			{
				'change': this.searchLayer2
			},
			'layers [id="pdGrid"]':
			{
				//'itemmouseenter': this.showActions,
				//'itemmouseleave': this.hideActions
			},
			'layers [id="udGrid"]':
			{
				//'itemmouseenter': this.showActions,
				//'itemmouseleave': this.hideActions
			},
			'layers button[id="addLayerButton"]':
			{
				'click':this.addNewLayer
			}
		});
	},
	buildMainData: function()
	{
		if (currentView == 'AddLayer')
		{
			return;
		}
		Ext.Ajax.request(
		{
			url: 'ICLayer/data/EgUDLayerJson.jsp',
			method: 'POST',
			async:false,
			timeout: 300000,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},
	afterMainRender: function()
	{
		if (currentView == 'AddLayer')
		{
			this.addNewLayer();
			return;
		}
		var pdGridObj = Ext.getCmp('pdGrid');
		var udGridObj = Ext.getCmp('udGrid');
		if (publicJSON.noPDLayersFound)
		{
			pdGridObj.getStore().removeAll();
			Ext.getCmp('searchBox1').disable();
		}
		if (publicJSON.noUDLayersFound)
		{
			udGridObj.getStore().removeAll();
			Ext.getCmp('searchBox2').disable();
		}
		if (publicJSON.showPDLayers)
		{
			pdGridObj.getStore().removeAll();
			pdGridObj.getStore().loadRawData(publicJSON.pdLayers);
		}else
		{
			pdGridObj.getStore().removeAll();
		}
		if (publicJSON.showUDLayers)
		{
			udGridObj.getStore().removeAll();
			udGridObj.getStore().loadRawData(publicJSON.udLayers);
		}else
		{
			udGridObj.getStore().removeAll();
		}
		this.getLayers().doLayout();
	},
	searchLayer: function()
	{
		//alert();
		var searchStr = Ext.getCmp('searchBox').getValue();
		searchStr = encodeURIComponent(searchStr);
		var urlStr = 'ICLayer/data/EgUDLayerJson.jsp?searchStr='+searchStr;
		if (searchStr == "" || searchStr.length == 0)
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');
		}

		Ext.Ajax.request(
		{
			url : urlStr,
			method: 'POST',
			async: false,
			timeout: 300000,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
			},
			failure : function(response)
			{
			}
		});

		if (publicJSON.showPDLayers)
		{
			Ext.getCmp('pdGrid').getStore().removeAll();
			Ext.getCmp('pdGrid').getStore().loadRawData(publicJSON.pdLayers);
		}
		else
		{
			Ext.getCmp('pdGrid').getStore().removeAll();
			Ext.get('noPdLayersAlrtDiv').update(noPDLayerFound);
		}
	},
	searchLayer2: function()
	{
		var searchStr = Ext.getCmp('searchBox2').getValue();
		searchStr = encodeURIComponent(searchStr);
		var urlStr = 'ICLayer/data/EgUDLayerJson.jsp?searchStr='+searchStr;
		if (searchStr == "" || searchStr.length == 0)
		{
			Ext.get('My2Trigger_0').setStyle('display','none');
			Ext.get('My2Trigger_1').setStyle('display','block');
		}
		else
		{
			Ext.get('My2Trigger_1').setStyle('display','none');
			Ext.get('My2Trigger_0').setStyle('display','block');
		}

		Ext.Ajax.request(
		{
			url : urlStr,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
			},
			failure : function(response)
			{
			}
		});

		if (publicJSON.showUDLayers)
		{
			Ext.getCmp('udGrid').getStore().removeAll();
			Ext.getCmp('udGrid').getStore().loadRawData(publicJSON.udLayers);
		}
		else
		{
			Ext.getCmp('udGrid').getStore().removeAll();
			Ext.get('noUdLayersAlrtDiv').update(noUDLayerFound);
		}
	},
	showActions: function(view, task, node, rowIndex, e)
	{
		var hideIcon = view.getStore().getAt(rowIndex);
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
			Ext.each(icons, function(icon){
		Ext.get(icon).removeCls('x-hidden');
		});
	},
	hideActions: function(view, task, node, rowIndex, e)
	{
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
		Ext.each(icons, function(icon){
			Ext.get(icon).addCls('x-hidden');
		});
	},
	addNewLayer: function()
	{
		Ext.getCmp('iclayerviewport').removeAll();
		this.getController('AddLayerCtrlr').init();
		Ext.getCmp('iclayerviewport').add(
			{
				xtype: 'newlayer'
			});
	},
	testsAssign:function(grid, rowIndex, colIndex)
	{
		var obj = grid.getStore().getAt(rowIndex);
		var layerName = obj.get('ActualValue');
		
		Ext.getCmp('iclayerviewport').removeAll();
		this.getController('TestsCtrlr').init();
		this.getController('TestsCtrlr').buildMainData(layerName);
		Ext.getCmp('iclayerviewport').add(
			{
				xtype: 'associatetests'
			});
	},
	deleteLayer:function(grid, rowIndex, colIndex)
	{
		var obj = grid.getStore().getAt(rowIndex);
		var layerName = obj.get('ActualValue');
		var me = this;
		Ext.Msg.show({
			title: commTitle,
			msg: delConfMsg,
			buttons: Ext.Msg.YESNO,
			icon: 'iconConfirmation',
			fn: function(response) {
				if(response === 'yes')
				{
					var urlStr = "ICLayer/data/EgDelUDLayerJson.jsp?layer="+encodeURIComponent(layerName);
					var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: updating+'...'});
					tmpMask.show();
					Ext.Ajax.request(
					{
						url : urlStr,
						method: 'POST',
						async: false,
						timeout: 300000,
						success: function(response)
						{
							tmpMask.hide();
							var jsonText = response.responseText;
							resultJSON = Ext.decode(jsonText);
							if(resultJSON.AlertType=='Result')
							{
								Ext.Msg.show({
									title: resultJSON.AlertTitle,
									msg: resultJSON.AlertMsg,
									buttons: Ext.Msg.OK,
									icon: 'iconInformation',
									fn: function(response) {
										if(response == 'ok') {
											me.buildMainData();
											me.afterMainRender();
										}
									}
								});
								
							}
						},
						failure : function(response)
						{
							tmpMask.hide();
						}
					});
				}
			}
		});
	}
});



