Ext.define('ICLayer.controller.TestsCtrlr',{
	extend:'Ext.app.Controller',
	requires:['ICLayer.view.AssociateTests'],
	refs:[
		{selector:'associatetests', ref:'associatetests'}
	],
	init:function(){
		addctrler = this;
		//this.buildMainData()
		this.control({
			'associatetests':
			{
				'afterrender': this.afterMainRender
			},
			'associatetests button[id="back"]':
			{
				'click':this.goBack
			},
			'associatetests button[id="update"]':
			{
				'click':this.updateTests
			}
		});
	},
	buildMainData: function(layerName)
	{
		Ext.Ajax.request(
		{
			url: 'ICLayer/data/EgConfigUDLayerJson.jsp?layer='+encodeURIComponent(layerName),
			method: 'POST',
			async:false,
			timeout: 300000,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},
	afterMainRender: function()
	{
		Ext.getCmp('testFldSet').setTitle(testsFor+ '  <b>' +publicJSON.displayLayerName+'</b>');
		var itemSelObj = Ext.getCmp('testsList');
		var layerName = publicJSON.hiddens.layer;
		var diclaimerObj = Ext.getCmp("disclaimer");
		layerName = layerName.toLowerCase();
		var layerNameLen = layerName.length;
		var layerNameSuffix = layerName.substring((layerNameLen-3),layerNameLen);
		if(layerNameSuffix == "_ex")
		{
			diclaimerObj.show();
		}
		else
		{
			diclaimerObj.hide();
		}
		itemSelObj.fromField.store.removeAll();
		itemSelObj.toField.store.removeAll();

		if (publicJSON.assoTests != null)
		{
			itemSelObj.fromField.store.add(publicJSON.assoTests);
		}
		
		if (publicJSON.disoTests != null)
		{
			itemSelObj.toField.store.add(publicJSON.disoTests);
		}
	},
	goBack: function()
	{
		window.location.href= '/final/admin/EgUDLayer.jsp';
	},
	updateTests: function()
	{
		var itemSelObj = Ext.getCmp('testsList');
		var storeObj = itemSelObj.fromField.store;
		var associatedNow = '';
		
		for (var s=0; s < storeObj.getCount();s++)
		{
			var newVal = storeObj.getAt(s).get('valueField');
			associatedNow += newVal+',';
		}
		var me = Ext.getCmp('hiddenContnr');
		me.removeAll();
		var hiddenParams = publicJSON.hiddens;
		for (var param in hiddenParams) {
				me.add({
					xtype: 'hidden',
					name: param,
					value: hiddenParams[param]
				});
		}
		me.add({
			xtype: 'hidden',
			name: 'fassociate',
			value: associatedNow
		});
		var urlStr = "ICLayer/data/EgconfigudlayerpJson.jsp?sel="+sel;
		var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: updating+'...'});
		tmpMask.show();
		this.getAssociatetests().submit({
			url: urlStr,
			//async:false,
			timeout : 120,
			method: 'POST',
			success: function(form, action)
			{
				tmpMask.hide();
				var jsonText = action.response.responseText;
				var resultJSON = Ext.decode(jsonText);
				var titleMsg = ""; 
				var icoImg = 'iconInformation';
				if(resultJSON.AlertType=='Result' || resultJSON.AlertType=='Error')
				{
					if (resultJSON.AlertType=='Error')
					{
						titleMsg = error+": "+resultJSON.AlertTitle;
						icoImg = 'iconError';
					}
					else
					{
						titleMsg = resultJSON.AlertTitle;
					}
					Ext.Msg.show({
						title: titleMsg,
						msg: resultJSON.AlertMsg,
						buttons: Ext.Msg.OK,
						icon: icoImg,
						fn: function(){
							addctrler.buildMainData(publicJSON.hiddens.layer);
							addctrler.afterMainRender();
						}
					});
				}
			},
			failure: function(form, action)
			{
				 tmpMask.hide();
			}
		});
	}
});



