Ext.define('ICTest.controller.AddCustomTestCtrlr',{
	extend:'Ext.app.Controller',
	views:['AddNewTest'],
	requires:['ICTest.view.AddNewTest'],
	refs:[
		{selector:'addnewtest', ref:'addnewtest'},
		{selector:'defaultthresholds', ref:'defaultthresholds'}
	],
	init:function(){
		customCtrlr = this;
		this.control({
			'addnewtest':
			{
				'afterrender': this.afterMainRender
			},
		});
	},
	afterMainRender: function()
	{
	},
	loadAddMeasureTab: function(urlStr)
	{
		var me = this;
		Ext.Ajax.request(
		{
			url: 'ICTest/data/'+urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});

		var existingMeass = publicJSON.measuresList;
		var cntnrObj = Ext.getCmp('addMeasureCntnr');
		cntnrObj.removeAll();
		if (publicJSON.noMeasuresAdded)
		{
			Ext.getCmp('noMeasureFnd').show();
			Ext.getCmp('generateCntnr').disable();
			Ext.getCmp('tab6Help').disable();
		}
		else
		{

			Ext.getCmp('noMeasureFnd').hide();
			for (var p=0; p<existingMeass.length; p++) {
				var measure = existingMeass[p];
					if(!(measure.measureName == "Installed"))
					{
						cntnrObj.add({
							xtype: 'fieldset',
							title: '<b>'+measure.measureIndex+'. '+measure.measureName+'</b>',
							width: 500,
							items: [
								{
									xtype: 'container',
									layout: {
										type: 'vbox',
										align: 'left',
										pack: 'center'
									},
									defaults: {
										labelSeparator: ' ',
										margin: 5,
										labelWidth: 200 
									},
									items: [
										{
											xtype: 'displayfield',
											fieldLabel: dbColSize,
											value: measure.databaseColumnSize,
											hidden: isConfigTest
										},
										{
											xtype: 'displayfield',
											fieldLabel: unit,
											value: filterDecode(measure.unit),
											hidden: isConfigTest
										},
										{
											xtype: 'displayfield',
											fieldLabel: convFact,
											value: measure.conversionFactor,
											hidden: measure.hideConversionFactor,
											id: 'conFact'+p											
										},
										{
											xtype: 'displayfield',
											fieldLabel: alrmDispStr,
											value: measure.alarmDispString,
											hidden: measure.hideAlarmDispStr,
											id: 'alarmDisp'+p
										}
									]
								},
								{
									xtype: 'container',
									layout: {
										type: 'hbox',
										pack: 'center'
									},
									defaults: {
										width: 80,
									},
									items:[
										{
											xtype: 'button',
											cls : 'button20',
											text: modifyTooltip,
											modifyURL: measure.modifyURL,
											handler: function() {
												me.showModifyMeasure(this.modifyURL);
											},
											margin: '5 0 10 0'
										},
										{
											xtype: 'button',
											cls : 'button20',
											text: deleteTooltip,
											deleteURL: measure.deleteURL,
											measureName: measure.measureName,
											handler: function() {
												me.deleteMeasure(this.deleteURL,this.measureName);
											},
											margin: '5 0 10 20'
										}
									]
								}
							]
						});
						var conFact = Ext.getCmp('conFact'+p);
						var alrmDisp = Ext.getCmp('alarmDisp'+p);
						if (isConfigTest)
						{
							conFact.hide();
							alrmDisp.hide();
						}
					}
			}
		}
		addctrler.tabHelp();
	},
	showAddNewMeasure: function()
	{
		var me = this;
		Ext.create('Ext.window.Window', {
			title: newMeasDetail,
			width: 500,
			padding:'3 10 10 10',
			id:'addMeasureWindow',
			layout:{
				type:'vbox',
				pack:'start',
				align:'center'
			},
			defaults: {
				labelSeparator: '',
				margin: 5,
				width: 400,
				labelWidth: 200
			},
			modal: true,
			resizable: false,
			items:[ 
				{
					xtype: 'textfield',
					cls : 'textbox',
					fieldLabel: measIdx,
					id:'index',
					name:'index',
					margin: '10 5 0 5'
				},
				{
					xtype: 'textfield',
					cls : 'textbox',
					fieldLabel: measName,
					id:'measure',
					name:'measure',
					maxLength: 24,
					enforceMaxLength: true
				},
				{
					xtype: 'scrollcombo',
					cls : 'dropdown',
					id:'dbsize',
					name:'dbsize',
					fieldLabel: dbColSize,
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : []
					}),
					displayField:'displayField',
					valueField:'valueField',
					queryMode : 'local',
					editable: false
				},
				{
					xtype: 'scrollcombo',
					cls : 'dropdown',
					id:'un',
					name:'un',
					//listConfig: {maxHeight: 180},
					fieldLabel: unit,
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : []
					}),
					displayField:'displayField',
					valueField:'valueField',
					queryMode : 'local',
					//editable: false,
					listeners:
					{
						select:{
							fn: function (id){
								me.otherUnit('add');
							}
						}
					}
				},
				{
					xtype: 'textfield',
					cls : 'textbox',
					fieldLabel: other,
					id:'otherunit',
					name:'otherunit',
					hidden: true,
					maxLength: 64,
					enforceMaxLength: true
				},
				{
					xtype: 'scrollcombo',
					cls : 'dropdown',
					id:'cFactor',
					name:'cFactor',
					listConfig: {maxHeight: 150},
					fieldLabel: convFact,
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : []
					}),
					displayField:'displayField',
					valueField:'valueField',
					queryMode : 'local',
					editable: false
				},
				{
					xtype: 'textfield',
					cls : 'textbox',
					fieldLabel: alrmDispStr,
					id:'alarmdescription',
					name:'alarmdescription',
					maxLength: 75,
					enforceMaxLength: true
				},
				{
					xtype: 'button',
					cls : 'button20',
					text: add,
					id:'addMeasureButton',
					width: 80,
					listeners:
					{
						click:{
							fn: function (id){
								me.doAddNewMeasure();
							}
						}
					},
					margin: '5 5 20 5'
				}
			]
		}).show();

		Ext.getCmp('index').setValue(publicJSON.measIndex);
		var dbSizeObj = Ext.getCmp('dbsize');
		var unitObj = Ext.getCmp('un');
		var cFactObj = Ext.getCmp('cFactor');
		var alrmDescObj = Ext.getCmp('alarmdescription');
		if (isConfigTest)
		{
			dbSizeObj.hide();
			unitObj.hide();
			cFactObj.hide();
			alrmDescObj.hide();
		}
		else
		{
			dbSizeObj.show();
			dbSizeObj.getStore().loadRawData(publicJSON.dbColSizeList);
			dbSizeObj.setValue("2");

			unitObj.show();
			unitObj.getStore().loadRawData(publicJSON.unitsList);
			unitObj.setValue("-1");

			cFactObj.show();
			cFactObj.getStore().loadRawData(publicJSON.convFactorList);
			cFactObj.setValue(publicJSON.convFactorSelected);

			alrmDescObj.show();
		}
	},
	otherUnit: function(from)
	{
		var unitObj = Ext.getCmp('un');
		var otherUnitObj = Ext.getCmp('otherunit');
		if (from == 'modify')
		{
			unitObj = Ext.getCmp('s_un');
			otherUnitObj = Ext.getCmp('s_otherunit');
		}

		if(unitObj.getValue() == 'other')
		{
			otherUnitObj.show();
			otherUnitObj.enable();
		}
		else
		{
			otherUnitObj.hide();
			otherUnitObj.disable();
		}
	},
	processMethodChange: function(from)
	{
		var process;
		var factorObj;
		if (from == 'add')
		{
			process = Ext.getCmp('process').getValue();
			factorObj = Ext.getCmp('cFactor');
		}
		else if (from == 'modify')
		{
			process = Ext.getCmp('s_process').getValue();
			factorObj = Ext.getCmp('s_factor');
			factorObj.setValue(publicJSON.convFactorSelected);
		}

		if (process == 'UNALTERED' || process == 'DIFFERENCE')
		{
			factorObj.show();
			factorObj.enable();
		}else
		{
			factorObj.hide();
			factorObj.disable();
		}		
	},
	doAddNewMeasure: function()
	{
		var me = this;
		var test = Ext.getCmp('test').getValue();
		var index = Ext.getCmp('index').getValue();
		var measure = Ext.getCmp('measure').getValue();
		var factor = Ext.getCmp('cFactor').getValue();
		var dbSize = Ext.getCmp('dbsize').getValue();
		var otherUnit = Ext.getCmp('otherunit').getValue();
		var unit = Ext.getCmp('un').getValue();
		var alrmDesc = Ext.getCmp('alarmdescription').getValue();
		var urlStr =  'ICTest/data/EgconfigtestmeasurepJson.jsp?add=add&test='+test+'&measure='+measure+'&factor='+factor;
		urlStr += '&dbsize='+dbSize+'&otherunit='+otherUnit+'&un='+encodeURIComponent(filterEncode(unit))+'&alarmdescription='+encodeURIComponent(alrmDesc)+'&index='+index;
		if (!this.measureValidation(measure,unit,otherUnit,alrmDesc))
		{
			return;
		}
		
		Ext.Ajax.request(
		{
			url: urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});

		if (publicJSON.AlertType == 'Error')
		{
			Ext.Msg.show({
				title: error+': '+publicJSON.AlertTitle,
				msg: publicJSON.AlertMsg,
				buttons: Ext.Msg.OK,
				icon: 'iconError'
			});
		}
		else if (publicJSON.AlertType == 'Result')
		{
			Ext.getCmp('generateCntnr').enable();
			Ext.getCmp('tab6Help').enable();
			Ext.Msg.show({
				title: publicJSON.AlertTitle,
				msg: publicJSON.AlertMsg + '. '+ alertMsg80,
				closable: false,
				buttons: Ext.Msg.YESNO,
				icon: 'iconInformation',
				fn: function(response) {
					if(response == 'yes') {
						Ext.getCmp('addMeasureWindow').close();
						var urlToProcess = publicJSON.forwardURL;
						me.loadAddMeasureTab(urlToProcess);
						me.showAddNewMeasure();
					}
					else if (response == 'no')
					{
						Ext.getCmp('addMeasureWindow').close();
						var urlToProcess = publicJSON.forwardURL;
						me.loadAddMeasureTab(urlToProcess);

						//Ext.getCmp('generateCntnr').enable();
						//Ext.getCmp('tab6Help').enable();
						Ext.getCmp('newtest').setActiveTab(3);
					}
				}
			});
		}
		addctrler.tabHelp();
	},
	measureValidation: function(meas,unit,otherUnit,alarmStr)
	{
		var me=this;
		var measObj = Ext.getCmp('measure');
		var alrmStrObj = Ext.getCmp('alarmdescription');
		var otherUnitObj = Ext.getCmp('otherunit');
		var keyArr = new Array("other","none","null","all");
		var isConfigTest = false;
		var alarmDispStr=true;
		var type= Ext.getCmp('type').getValue();
		if (type != null && type == 'Configuration')
		{
			isConfigTest = true;
		}
		if (!isConfigTest)
		{
			if(!me.checkSpecialChar(alarmStr,"~!@#$%^&*()|:,;'<>"))
			{
				Ext.Msg.show({
					title: newMeasDetail,
					msg: splCharAlert,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				alrmStrObj.focus(true);
				return false;				
			}
			if(isDouble=="false")
			{
				alarmDispStr = validateSingleByte(alarmStr);
			}
		}
		meas = meas.toUpperCase();
		if(meas == "TRGT_HOST" || meas == "PORT_NO"
			|| meas == "SITE_NAME" || meas == "INFO"
			|| meas == "MSMT_HOST" || meas == "MSMT_TIME")   
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg14,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}
		var ch = meas.charAt(0);
		var un=!isConfigTest?unit:"NONE";
		if(!checkblank(meas))
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg15,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			measObj.focus(true);
			return false;
		}
		else if(!checkspace(meas))
		{
			measObj.focus(true);
			return false;
		}
		else if(!checkspecialnomess(meas, "`~!@#$%^&*()+=-/?'\"]{}[\\|;:.,><"))
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg3,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			measObj.focus(true);
			return false;
		}
		else if(ch >= '0' && ch <= '9')
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg16,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			measObj.focus(true);
			return false;
		}
		else if(ch == '_')
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg17,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			measObj.focus(true);
			return false;
		}
		else if(!validateSingleByte(meas))
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg18,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			measObj.focus(true);
			return false;
		}
		else if(un == "-1")
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg19,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}
		else if(!alarmDispStr)
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg20,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			alrmStrObj.focus(true);
			return false;
		}
		else if(un == "other")
		{
			if(!checkblank(otherUnit))
			{
				Ext.Msg.show({
					title: newMeasDetail,
					msg: alertMsg21,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				otherUnitObj.focus(true);
				return false;
			}
			else if(!checkspace(otherUnit))
			{
				otherUnitObj.focus(true);
				return false;
			}
			else if(!checkspecialnomess(otherUnit, "`~!@#^&*()+=-?'\"]{}[\\|;:.,><"))
			{
				Ext.Msg.show({
					title: newMeasDetail,
					msg: alertMsg3,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				otherUnitObj.focus(true);
				return false;
			}
			else if (!checkKeywords(otherUnit,keyArr))
			{
				Ext.Msg.show({
					title: newMeasDetail,
					msg: alertMsg22,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				otherUnitObj.focus(true);
				return false;
			}
		}
		return true;
	},
	deleteMeasure: function(deleteURL, measureName)
	{
		var me = this;
		Ext.Msg.show({
			title: addMeasure,
			msg:alertMsg45+ ' \''+measureName+'\'?',
			buttons: Ext.Msg.OKCANCEL,
			icon: 'iconConfirmation',
			fn: function(response) {
				if(response == 'ok') {
					Ext.Ajax.request(
					{
						url: 'ICTest/data/'+deleteURL,
						method: 'POST',
						async:false,
						success: function( response )
						{
							if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
							{
								var jsonText = response.responseText;
								publicJSON = Ext.decode( jsonText );
							}
						}
					});
					if (publicJSON.AlertType=='Result')
					{
						Ext.Msg.show({
							title: publicJSON.AlertTitle,
							msg:publicJSON.AlertMsg,
							buttons: Ext.Msg.OK,
							icon: 'iconInformation',
							fn: function(response) {
								if(response == 'ok') {
									Ext.getCmp('addMeasureTab').enable();
									var urlToProcess = publicJSON.forwardURL;
									me.loadAddMeasureTab(urlToProcess);
								}
							}
						});
					}
				}
			}
		});
	},
	generateCustomTest: function()
	{
		var me = this;
		var test = Ext.getCmp('test').getValue();
		var pathObj = Ext.getCmp('path')
		var path = pathObj.getValue();
		
		if(!checkblank(path))
		{
			Ext.Msg.show({
				title: generate,
				msg: alertMsg26,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(response) {
					if(response == 'ok') {
						pathObj.focus(true);
					}
				}
			});
			return;
		}
		else if(!checkspace(path))
		{
			pathObj.focus(true);
			return;
		}
		else if(!checkspecialnomess(path, '\*?"<>|')) //These characters only not allowed during folder creation in windows
		{
			Ext.Msg.show({
				title: generate,
				msg: alertMsg3,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(response) {
					if(response == 'ok') {
						pathObj.focus(true);
					}
				}
			});
			return;
		}
		else if(path.indexOf(".class") > -1 && path.indexOf(test)== -1)
		{
			Ext.Msg.show({
				title: generate,
				msg: alertMsg27,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(response) {
					if(response == 'ok') {
						pathObj.focus(true);
					}
				}
			});
			return;
		}
		else if (path.indexOf("_ex.class") != (path.length - "_ex.class".length))
		{
			Ext.Msg.show({
				title: generate,
				msg: alertMsg28,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(response) {
					if(response == 'ok') {
						pathObj.focus(true);
					}
				}
			});
			return;
		}

		var loadLibChecked = Ext.getCmp('loadLib').getValue();
		var libObj = Ext.getCmp('lib');
		var lib = libObj.getValue();
		if (loadLibChecked)
		{
			if(!checkblank(lib))
			{
				Ext.Msg.show({
					title: generate,
					msg: alertMsg29,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							libObj.focus(true);
						}
					}
				});
				return;
			}
			else if(!checkspace(lib))
			{
				libObj.focus(true);
				return;
			}
			else if(!checkspecialnomess(lib, "`!@#$%^&*()+=?'\"]}[{|;><"))
			{
				Ext.Msg.show({
					title: generate,
					msg: alertMsg3,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							libObj.focus(true);
						}
					}
				});
				return;
			}
		}
		
		if (publicJSON.oldClass != "")
		{
			alert(alertMsg30);
		}
		var pathCheck = 'no';
		var libCheck = 'no';
		var ddCheck = 'no';
		if (Ext.getCmp('ddForMeasure').getValue())
		{
			ddCheck = 'yes';
		}
		
		if(Ext.getCmp('loadPath').getValue())
		{
			pathCheck = 'yes';
		}
		if (loadLibChecked)
		{
			libCheck = 'yes';
		}
		
		var urlStr =  'ICTest/data/EgconfigtestmeasurepJson.jsp?add=gen&test='+test+'&path='+path+'&lib='+lib;
		urlStr += '&loadPath='+pathCheck+'&loadLib='+libCheck;
	
		if (isConfigTest)
		{
			var dbSize = Ext.getCmp('dbSizeGen').getValue();
			urlStr += '&dbsize='+dbSize;
			if (Ext.getCmp('isDescriptorBasedTest').getValue())
			{
				urlStr += '&isDescriptorBasedTest=yes';
			}
			else
			{
				urlStr += '&isDescriptorBasedTest=no';
			}
		}
		else
		{
			urlStr += '&ddForMeasure='+ddCheck;
		}

		Ext.Ajax.request(
		{
			url: urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});

		if (publicJSON.AlertType=='Error')
		{
			Ext.Msg.show({
				title: publicJSON.AlertTitle,
				msg: publicJSON.AlertMsg,
				buttons: Ext.Msg.OK,
				icon: 'iconError',
				fn: function(response) {
					if(response == 'ok') {
						Ext.getCmp('addMeasureTab').enable();
						var urlToProcess = publicJSON.forwardURL;
						if (urlToProcess != null && urlToProcess != '')
						{
							me.loadAddMeasureTab(urlToProcess);
						}
					}
				}
			});
		}
		else if (publicJSON.AlertType=='Result')
		{
			Ext.Msg.show({
				title: publicJSON.AlertTitle,
				msg: publicJSON.AlertMsg,
				buttons: Ext.Msg.OK,
				icon: 'iconInformation',
				fn: function(response) {
					if(response == 'ok') {
						window.location.href= '/final/admin/EgUDTest.jsp';
					}
				}
			});
		}
		if (!Ext.isEmpty(publicJSON.forwardURL))
		{
			if (ddCheck == 'yes')
			{
				Ext.getCmp('newtest').child('#tab5DD').tab.show();
				Ext.getCmp('newtest').setActiveTab(4);
			}
			else
			{
				this.getController('ICTest.controller.ThresholdCtrlr').init();
				var genCntnrObj = Ext.getCmp('generateCntnr');
				genCntnrObj.removeAll();
				var urlStr = publicJSON.forwardURL;
				qString = 'ICTest/data/'+urlStr;
				genCntnrObj.add({
					xtype : 'defaultthresholds'
				});
			}
		}
	},
	showModifyMeasure: function(modifyURL)
	{
		var publicJSONTmp;
		Ext.Ajax.request(
		{
			url: 'ICTest/data/'+modifyURL+'&testType=Custom',
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSONTmp = Ext.decode( jsonText );
				}
			}
		});		
		Ext.create('Ext.window.Window', {
			title: modMeas,
		//	height: 300,
			width: 500,
			padding:'3 10 10 10',
			id:'modScriptMeasureWindow',
			modal: true,
			resizable: false,
			items:[ 
				{
					xtype: 'form',
					id: 'measureform',
					name: 'measureform',
					url: 'ICTest/data/EgmodifymeasurespJson.jsp',
				//	height: 300,
					width: 500,
					layout:{
						type:'vbox',
						pack:'start',
						align:'center'
					},
					defaults: {
						labelSeparator: '',
						margin: 5,
						width: 400,
						labelWidth: 200
					},
					items:[
						{
							xtype: 'textfield',
							cls : 'textbox',
							fieldLabel: measName,
							id:'s_measure',
							name:'s_measure',
							maxLength: 24,
							enforceMaxLength: true,
							value: publicJSONTmp.measureName,
							margin: '10 5 0 5'
						},
						{
							xtype: 'scrollcombo',
							cls : 'dropdown',
							id:'s_dbsize',
							name:'s_dbsize',
							fieldLabel: dbColSize,
							store: new Ext.data.Store({
								fields : ['displayField', 'valueField'],
								data : []
							}),
							displayField:'displayField',
							valueField:'valueField',
							queryMode : 'local',
							editable: false,
							hidden: isConfigTest
						},
						{
							xtype: 'scrollcombo',
							cls : 'dropdown',
							id:'s_un',
							name:'s_un',
							fieldLabel: unit,
							store: new Ext.data.Store({
								fields : ['displayField', 'valueField'],
								data : []
							}),
							displayField:'displayField',
							valueField:'valueField',
							queryMode : 'local',
							//editable: false,
							hidden: isConfigTest,
							listeners:
							{
								select:{
									fn: function (id){
										customCtrlr.otherUnit('modify');
									}
								}
							}
						},
						{
							xtype: 'textfield',
							cls : 'textbox',
							fieldLabel: other,
							id:'s_otherunit',
							name:'s_otherunit',
							hidden: true,
							maxLength: 64,
							enforceMaxLength: true,
						},
						{
							xtype: 'scrollcombo',
							cls : 'dropdown',
							id:'s_factor',
							name:'s_factor',
							fieldLabel: convFact,
							store: new Ext.data.Store({
								fields : ['displayField', 'valueField'],
								data : []
							}),
							displayField:'displayField',
							valueField:'valueField',
							queryMode : 'local',
							editable: false,
							hidden: isConfigTest
						},
						{
							xtype: 'textfield',
							cls : 'textbox',
							fieldLabel: alrmDispStr,
							id:'alarmdescription',
							name:'alarmdescription',
							maxLength: 75,
							enforceMaxLength: true,
							value: publicJSONTmp.alarmDispStrValue,
							hidden: isConfigTest
						},
						{
							xtype: 'button',
							cls : 'button20',
							text: modifyTooltip,
							id:'modMeasureButton',
							width: 80,
							margin: '5 5 20 5',
							listeners:
							{
								click:{
									fn: function (id){
										var measure = Ext.getCmp('s_measure').getValue();
										var unit = Ext.getCmp('s_un').getValue();
										var otherUnit = Ext.getCmp('s_otherunit').getValue();
										var alrmDesc = Ext.getCmp('alarmdescription').getValue();
										if (!customCtrlr.measureValidation(measure,unit,otherUnit,alrmDesc))
										{
											return;
										}
										var uploadformObj = Ext.getCmp('measureform').getForm();
										if (uploadformObj.isValid())
										{
											var customform = encodeFieldParams(uploadformObj);
											var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: updating+'...'});
											tmpMask.show();
											uploadformObj.submit({
												method: 'POST',
												params: customform,

												success: function (form, action) {
													tmpMask.hide();
													var jsonText = action.response.responseText;
													var tmpResult = Ext.decode(jsonText);

													if(tmpResult.AlertType == 'Result')
													{
														var test = Ext.getCmp('test').getValue();
														var urlStr = "EgConfigTestMeasureJson.jsp?test=" + test;
														customCtrlr.loadAddMeasureTab(urlStr);
														Ext.Msg.show({
															title: tmpResult.AlertTitle,
															msg: tmpResult.AlertMsg,
															buttons: Ext.Msg.OK,
															icon: 'iconInformation',
															fn: function(response) {
																if(response == 'ok') {
																	Ext.getCmp('newtest').setActiveTab(3);
																}
															}
														});
													}
													else if(tmpResult.AlertType == 'Error')
													{
														Ext.Msg.show({
															title: tmpResult.AlertTitle,
															msg: tmpResult.AlertMsg,
															buttons: Ext.Msg.OK,
															icon: 'iconExclamation',
															fn: function(response) {
																if(response == 'ok') {
																	var test = Ext.getCmp('test').getValue();
																	var urlStr = "EgConfigTestMeasureJson.jsp?test=" + test;
																	customCtrlr.loadAddMeasureTab(urlStr);
																}
															}
														});
													}
												}
											});
										}
										Ext.getCmp('modScriptMeasureWindow').close();
									}
								}
							}
						},
						{
							xtype: 'container',
							id:'hiddenContnr',
							hidden:true
						}
					]
				}
			]
		}).show();


		if (!isConfigTest)
		{
			Ext.getCmp('s_dbsize').getStore().loadRawData(publicJSONTmp.dbColSizeList);
			Ext.getCmp('s_dbsize').setValue(publicJSONTmp.dbColSizeSelected);
			Ext.getCmp('s_un').getStore().loadRawData(publicJSONTmp.unitsList);
			Ext.getCmp('s_un').setValue(publicJSONTmp.unitSelected);
			if (!publicJSONTmp.hideConvFactor)
			{
				var convFactObj = Ext.getCmp('s_factor');
				convFactObj.show();
				convFactObj.getStore().loadRawData(publicJSONTmp.convFactorList);
				convFactObj.setValue(publicJSONTmp.convFactorSelected);
			}
		}
		else
		{
			Ext.getCmp('measureform').setHeight(100);
			Ext.getCmp('modScriptMeasureWindow').setHeight(100);
		}


		var hiddenParams = publicJSONTmp.hiddens;
		var me = Ext.getCmp('hiddenContnr');
		me.removeAll();
		for (var param in hiddenParams) {
				me.add({
					xtype: 'hidden',
					name: param,
					value: hiddenParams[param]
				});
		}
	},
	checkSpecialChar: function(field,s_spl)
	{
		if (typeof(field)=='object')
		{
			obj_val = field.value;
		}
		else
		{
			obj_val = field;
		}
		for(var i=0; i<obj_val.length; i++)
		{
			check_char = s_spl.indexOf(obj_val.charAt(i))
			//Returns value 1 if the special character listed in splChar is found
			if(check_char >= 0)
			{
				//alert(_checkspecial);
				return false;
			}
		}
		return true;
	}
});




