var tempCache;
var selOpt;
Ext.define('ICTest.controller.AddJmxTestCtrlr',{
	extend:'Ext.app.Controller',
	requires:['ICTest.view.JmxMeasurePortal','ICTest.view.AddNewTest'],
	refs:[
		{selector:'jmxmeasureportal', ref:'jmxmeasureportal'},
		{selector:'defaultthresholds', ref:'defaultthresholds'},
		{selector:'addnewtest', ref:'addnewtest'}
	],
	init:function(){
		jmxCtrlr = this;
		this.control({
			'jmxmeasureportal':
			{
				'afterrender': this.afterMainRender
			},
			'jmxmeasureportal combo[id="jmxOpts"]':
			{
				'select':this.jmxOptSelection
			},
			'jmxmeasureportal button[id="startDisc"]':
			{
				'click':this.startMBeanDiscovery
			},
			'jmxmeasureportal button[id="configureJmxMeas"]':
			{
				'click': this.configureJmxMeausre
			},
			'jmxmeasureportal button[id="mbeanUpload"]':
			{
				'click': this.uploadMBean
			},
			'jmxmeasureportal button[id="configureJmxMeas2"]':
			{
				'click': this.configureJmxMeausre2
			},
			'jmxmeasureportal button[id="getDomains"]':
			{
				'click': this.getDomainsFromFile
			},
			'jmxmeasureportal button[id="configureJmxMeas3"]':
			{
				'click': this.configureJmxMeausre3
			},
			'addnewtest button[id="showMeasure"]':
			{
				'click':this.showMeasureValue
			}
		});
	},
	afterMainRender: function()
	{
	},
	loadAddMeasureTab: function(urlStr, reload)
	{
		if (reload == null)
		{
			reload = '0';
		}
		var me = this;
		Ext.getCmp('addNewMeasure').hide();
		Ext.Ajax.request(
		{
			url: 'ICTest/data/'+urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
		if (reload == '1')
		{
			return;
		}
		if (publicJSON.MeasuresExist) //isModifyTest
		{
			var urlStr = 'EgConfigJmxMeasureJson.jsp?test='+publicJSON.hiddens.test;
			Ext.getCmp('showMeasure').hide();
			me.showAddedMeasures(urlStr);
			return;
		}
		var cntnrObj = Ext.getCmp('addMeasureCntnr');
		cntnrObj.removeAll();
		cntnrObj.add({
			xtype : 'jmxmeasureportal'
		});
		
		Ext.getCmp('jmxOpts').getStore().loadRawData(publicJSON.optsList);
		Ext.getCmp('jmxOpts').setValue(publicJSON.optSelected);

		selOpt = Ext.getCmp('jmxOpts').getValue();
		var discObj = Ext.getCmp('mbDiscCntnr');
		var discAnxObj = Ext.getCmp('mbDiscCntnrAnx');
		var fileObj = Ext.getCmp('mbUpldCntnr');
		var fileAnxObj = Ext.getCmp('mbUpldCntnrAnx');
		var exstObj = Ext.getCmp('mbExistCntnr');
		var exstAnxObj = Ext.getCmp('mbExistCntnrAnx');

		if (selOpt == 'disc')
		{
			discObj.show();
			discObj.enable();

			discAnxObj.hide();
			discAnxObj.disable();
			fileObj.hide();
			fileObj.disable();
			fileAnxObj.hide();
			fileAnxObj.disable();
			exstObj.hide();
			exstObj.disable();
			exstAnxObj.hide();
			exstAnxObj.disable();			

			Ext.getCmp('host').setValue(publicJSON.hostName);
			Ext.getCmp('jmxport').setValue(publicJSON.jmxPort);
			Ext.getCmp('jndi').setValue(publicJSON.jndiName);
			Ext.getCmp('user').setValue(publicJSON.userName);
			Ext.getCmp('pass').setValue(publicJSON.password);
		}
		else if (selOpt == 'file')
		{
			fileObj.show();
			fileObj.enable();

			fileAnxObj.hide();
			fileAnxObj.disable();
			discObj.hide();
			discObj.disable();
			discAnxObj.hide();
			discAnxObj.disable();
			exstObj.hide();
			exstObj.disable();
			exstAnxObj.hide();
			exstAnxObj.disable();
		}
		else if (selOpt == 'existingMBean')
		{
			exstObj.show();
			exstObj.enable();

			discObj.hide();
			discObj.disable();
			discAnxObj.hide();
			discAnxObj.disable();
			fileObj.hide();
			fileObj.disable();
			fileAnxObj.hide();
			fileAnxObj.disable();
			exstAnxObj.hide();
			exstAnxObj.disable();

			var urlStr = 'ICTest/data/EgMBeanDiscoveryJson.jsp?test='+test+'&option=existingMBean&filepath=';
			
			Ext.Ajax.request(
			{
				url: urlStr,
				method: 'POST',
				async:false,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						publicJSON = Ext.decode( jsonText );
					}
				}
			});
			Ext.getCmp('filepath2').getStore().loadRawData(publicJSON.mBeanFilesList);
			Ext.getCmp('filepath2').setValue(publicJSON.fileSelected);

			var thirdOptObj = Ext.getCmp('mbExistCntnrAnx');
			if (publicJSON.showDomainsList)
			{
				thirdOptObj.show();
				thirdOptObj.enable();
				Ext.getCmp('domains3').show();
				Ext.getCmp('domainNames3').getStore().loadRawData(publicJSON.domainsList);
				Ext.getCmp('domainNames3').setValue(publicJSON.domainSelected);
				if(publicJSON.MeasuresExist)
				{
					Ext.getCmp('getDomains').disable();
					Ext.getCmp('domainNames3').setReadOnly(true);
				}
			}
			else 
			{
				thirdOptObj.hide();
				thirdOptObj.disable();
				//Ext.getCmp('domains3').hide();
			}
			
		}
		else if (selOpt == 'manual')
		{
			//Ext.getCmp('addNewMeasure').show();
			Ext.getCmp('addMeasure').show();
			discObj.hide();
			discObj.disable();
			discAnxObj.hide();
			discAnxObj.disable();
			fileObj.hide();
			fileObj.disable();
			fileAnxObj.hide();
			fileAnxObj.disable();
			exstObj.hide();
			exstObj.disable();
			exstAnxObj.hide();
			exstAnxObj.disable();
			var isAddNewMeasure='No';
			var fromMbean = 'No';
			me.showAddNewMeasure(isAddNewMeasure,fromMbean);
		}
		tempCache = publicJSON;
	},
	jmxOptSelection: function()
	{
		var me = this;
		var test  = Ext.getCmp('test').getValue();
		selOpt = Ext.getCmp('jmxOpts').getValue();
		var discObj = Ext.getCmp('mbDiscCntnr');
		var discAnxObj = Ext.getCmp('mbDiscCntnrAnx');
		var fileObj = Ext.getCmp('mbUpldCntnr');
		var fileAnxObj = Ext.getCmp('mbUpldCntnrAnx');
		var exstObj = Ext.getCmp('mbExistCntnr');
		var exstAnxObj = Ext.getCmp('mbExistCntnrAnx');
		//Ext.getCmp('addNewMeasure').hide();
		Ext.getCmp('addMeasure').show();
		Ext.getCmp('noMeasureFnd').hide();
		if (selOpt == 'disc')
		{

			discObj.show();
			discObj.enable();

			discAnxObj.hide();
			discAnxObj.disable();
			fileObj.hide();
			fileObj.disable();
			fileAnxObj.hide();
			fileAnxObj.disable();
			exstObj.hide();
			exstObj.disable();
			exstAnxObj.hide();
			exstAnxObj.disable();

			var hostObj = Ext.getCmp('host');
			var jmxportObj = Ext.getCmp('jmxport');
			var jndiObj = Ext.getCmp('jndi');
			var userObj = Ext.getCmp('user');
			var passObj = Ext.getCmp('pass');

			var urlStr = "EgMBeanDiscoveryJson.jsp?test="+test+"&option=disc";
			Ext.Ajax.request(
			{
				url: 'ICTest/data/'+urlStr,
				method: 'POST',
				async:false,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						publicJSON = Ext.decode( jsonText );
					}
				}
			});

			hostObj.setValue(publicJSON.hostName);
			jmxportObj.setValue(publicJSON.jmxPort);
			jndiObj.setValue(publicJSON.jndiName);
			userObj.setValue(publicJSON.userName);
			passObj.setValue(publicJSON.password);
		}
		else if (selOpt == 'file')
		{
			fileObj.show();
			fileObj.enable();

			fileAnxObj.hide();
			fileAnxObj.disable();
			discObj.hide();
			discObj.disable();
			discAnxObj.hide();
			discAnxObj.disable();
			exstObj.hide();
			exstObj.disable();
			exstAnxObj.hide();
			exstAnxObj.disable();
			var urlStr = "EgMBeanDiscoveryJson.jsp?test="+test+"&option=file";
			Ext.Ajax.request(
			{
				url: 'ICTest/data/'+urlStr,
				method: 'POST',
				async:false,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						publicJSON = Ext.decode( jsonText );
					}
				}
			});
		}
		else if (selOpt == 'existingMBean')
		{
			exstObj.show();
			exstObj.enable();

			discObj.hide();
			discObj.disable();
			discAnxObj.hide();
			discAnxObj.disable();
			fileObj.hide();
			fileObj.disable();
			fileAnxObj.hide();
			fileAnxObj.disable();
			exstAnxObj.hide();
			exstAnxObj.disable();

			var urlStr = 'ICTest/data/EgMBeanDiscoveryJson.jsp?test='+test+'&option=existingMBean&filepath=';
			
			Ext.Ajax.request(
			{
				url: urlStr,
				method: 'POST',
				async:false,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						publicJSON = Ext.decode( jsonText );
					}
				}
			});
			Ext.getCmp('filepath2').getStore().loadRawData(publicJSON.mBeanFilesList);
			Ext.getCmp('filepath2').setValue(publicJSON.fileSelected);

			var thirdOptObj = Ext.getCmp('mbExistCntnrAnx');
			if (publicJSON.showDomainsList)
			{
				thirdOptObj.show();
				thirdOptObj.enable();
				Ext.getCmp('domains3').show();
				Ext.getCmp('domainNames3').getStore().loadRawData(publicJSON.domainsList);
				Ext.getCmp('domainNames3').setValue(publicJSON.domainSelected);
				if(publicJSON.MeasuresExist)
				{
					Ext.getCmp('getDomains').disable();
					Ext.getCmp('domainNames3').hide();
					Ext.getCmp('domainNamesDuplicate3').show();
					Ext.getCmp('domainNamesDuplicate3').setValue(publicJSON.domainSelected);
				}
			}
			else 
			{
				thirdOptObj.hide();
				thirdOptObj.disable();
				//Ext.getCmp('domains3').hide();
			}	
		}
		else if (selOpt == 'manual')
		{
			//Ext.getCmp('addNewMeasure').show();
			Ext.getCmp('addMeasure').show();
			discObj.hide();
			discObj.disable();
			discAnxObj.hide();
			discAnxObj.disable();
			fileObj.hide();
			fileObj.disable();
			fileAnxObj.hide();
			fileAnxObj.disable();
			exstObj.hide();
			exstObj.disable();
			exstAnxObj.hide();
			exstAnxObj.disable();
			var isAddNewMeasure='No';
			var fromMbean = 'No';
			me.showAddNewMeasure(isAddNewMeasure,fromMbean);

			Ext.getCmp('jmxOpts').setValue("file");
			var urlStr = "EgMBeanDiscoveryJson.jsp?test="+test;
			me.loadAddMeasureTab(urlStr,"1");
			
			fileObj.show();
			fileObj.enable();

			fileAnxObj.hide();
			fileAnxObj.disable();
			discObj.hide();
			discObj.disable();
			discAnxObj.hide();
			discAnxObj.disable();
			exstObj.hide();
			exstObj.disable();
			exstAnxObj.hide();
			exstAnxObj.disable();
		}
	},
	showMeasureValue: function()
	{
		var me = this;
		if (publicJSON.MeasuresExist)//isModifyTest &&
		{
			var urlStr = 'EgConfigJmxMeasureJson.jsp?test='+publicJSON.hiddens.test;
			me.showAddedMeasures(urlStr);
			return;
		}
	},
	showAddedMeasures: function(urlStr)
	{
		var me = this;
		Ext.Ajax.request(
		{
			url: 'ICTest/data/'+urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});

		var existingMeass = publicJSON.measuresList;
		//var domainName = publicJSON.domainName;
		var cntnrObj = Ext.getCmp('addMeasureCntnr');
		
		cntnrObj.removeAll();
		if (publicJSON.noMeasuresAdded)
		{
			Ext.getCmp('noMeasureFnd').show();
			Ext.getCmp('generateCntnr').disable();
			Ext.getCmp('tab6Help').disable();
			Ext.getCmp('addNewMeasure').show();
			Ext.getCmp('showMeasure').hide();
		}
		else
		{
			Ext.getCmp('addNewMeasure').show();
			Ext.getCmp('noMeasureFnd').hide();
			Ext.getCmp('showMeasure').hide();
			if(existingMeass.length > -1)
			{
				cntnrObj.add({
						xtype: 'displayfield',
						cls: 'textbox',
						fieldLabel: "Domain Name",//domainName,
						readOnly: true,
						id:'objectVal',
						name:'objectVal',
						value: publicJSON.domainName
					});
			}
			for (var p=0; p<existingMeass.length; p++) {
					var measure = existingMeass[p];
					if(!(measure.measureName == "Installed"))
					{
						cntnrObj.add({
						xtype: 'fieldset',
						title: '<b>'+measure.measureIndex+'. '+measure.measureName+'</b>',
						width: 500,
						items: [
							{
								xtype: 'container',
								layout: {
									type: 'vbox',
									align: 'left',
									pack: 'center'
								},
								defaults: {
									labelSeparator: ' ',
									margin: 5,
									labelWidth: 200 
								},
								items: [
									{
										xtype: 'displayfield',
										fieldLabel: dbColSize,
										id : 'dbSize'+p,
										value: measure.databaseColumnSize
									},
									{
										xtype: 'displayfield',
										fieldLabel: unit,
										id : 'unitVal'+p,
										value: filterDecode(measure.unit)
									},
									{
										xtype: 'displayfield',
										fieldLabel: procMthd,
										id : 'processMethodVal'+p,
										value: measure.processMethod
									},
									{
										xtype: 'displayfield',
										fieldLabel: convFact,
										id : 'conFact'+p,
										value: measure.conversionFactor,
										hidden: measure.hideConversionFactor
									},
									{
										xtype: 'displayfield',
										fieldLabel: alrmDispStr,
										id : 'alarmDisp'+p,
										value: measure.alarmDispString,
										hidden: measure.hideAlarmDispStr
									},
									{
										xtype: 'displayfield',
										fieldLabel: mbeanName,
										id : 'mbean'+p,
										value: measure.mbean,
										hidden: !measure.doesMbeanExist
									},
									{
										xtype: 'displayfield',
										fieldLabel: attrName,
										id : 'attributeName'+p,
										value: measure.attributeName,
									}
								]
							},
							{
								xtype: 'container',
								layout: {
									type: 'hbox',
									pack: 'center'
								},
								defaults: {
									width: 80
								},
								items:[
									{
										xtype: 'button',
										cls : 'button20',
										text: modifyTooltip,
										modifyURL: measure.modifyURL,
										handler: function() {
											me.showModifyMeasure(this.modifyURL);
										},
										margin: '5 0 10 0'
									},
									{
										xtype: 'button',
										cls : 'button20',
										text: deleteTooltip,
										deleteURL: measure.deleteURL,
										measureName: measure.measureName,
										handler: function() {
											me.deleteMeasure(this.deleteURL,this.measureName);
										},
										margin: '5 0 10 20'
									}
								]
							}
						]
						//}
					});
					var dbColSize1 = Ext.getCmp('dbSize'+p);
					var unitVal = Ext.getCmp('unitVal'+p);
					var processMethodVal = Ext.getCmp('processMethodVal'+p);
					var conFact = Ext.getCmp('conFact'+p);
					var alrmDisp = Ext.getCmp('alarmDisp'+p);
					var attributeName = Ext.getCmp('attributeName'+p);
					if(isConfigTest)
					{
						dbColSize1.hide();
						unitVal.hide();
						processMethodVal.hide();
						conFact.hide();
						alrmDisp.hide();
						attributeName.show();
					}
				//	else
				//	{
				//		dbColSize1.show();
				//		unitVal.show();
				//		processMethodVal.show();
				//		conFact.show();
				//		alrmDisp.show();
				//		attributeName.show();
				//	}
				}
			}
		}
	},
	otherUnit: function(from)
	{
		var unitObj = Ext.getCmp('un');
		var otherUnitObj = Ext.getCmp('otherunit');
		if (from == 'modify')
		{
			unitObj = Ext.getCmp('s_un');
			otherUnitObj = Ext.getCmp('s_otherunit');
		}

		if(unitObj.getValue() == 'other')
		{
			otherUnitObj.show();
			otherUnitObj.enable();
		}
		else
		{
			otherUnitObj.hide();
			otherUnitObj.disable();
		}
	},
	processMethodChange: function(from)
	{
		var process;
		var factorObj;
		if (from == 'add')
		{
			process = Ext.getCmp('process').getValue();
			factorObj = Ext.getCmp('cFactor');
		}
		else if (from == 'modify')
		{
			process = Ext.getCmp('s_process').getValue();
			Ext.getCmp('s_process').setValue(process);
			factorObj = Ext.getCmp('s_factor');
			factorObj.getStore().loadRawData(publicJSON.convFactorList);
			factorObj.setValue(publicJSON.convFactorSelected);
		}

		if (process == 'UNALTERED' || process == 'DIFFERENCE')
		{
			factorObj.show();
			factorObj.enable();
		}else
		{
			factorObj.hide();
			factorObj.disable();
		}		
	},
	showAddNewMeasure: function(isAddNewMeasure,fromMbean)
	{
		var me = this;
		var testName = Ext.getCmp('test').getValue();
		if(isAddNewMeasure == 'Yes')
		{
			var urlStr =  'ICTest/data/EgMBeanDiscoveryJson.jsp?test='+testName
			Ext.Ajax.request(
			{
				url: urlStr ,
				method: 'POST',
				async:false,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						publicJSON = Ext.decode( jsonText );
					}
				}
			});
			var cntnrObj = Ext.getCmp('addMeasureCntnr');
			cntnrObj.removeAll();
			cntnrObj.add({
				xtype : 'jmxmeasureportal'
			});
			var selectedVal = publicJSON.optSelected;
			Ext.getCmp('jmxOpts').getStore().loadRawData(publicJSON.optsList);
			Ext.getCmp('jmxOpts').setValue(selectedVal);
			var discObj = Ext.getCmp('mbDiscCntnr');
			var fileObj = Ext.getCmp('mbUpldCntnr');
			var exstObj = Ext.getCmp('mbExistCntnr');
			Ext.getCmp('addNewMeasure').hide();
			if (publicJSON.MeasuresExist)
			{
				Ext.getCmp('showMeasure').show();
			}
			else
			{
				Ext.getCmp('showMeasure').hide();
			}
			Ext.getCmp('noMeasureFnd').hide();
			tempCache = publicJSON;
			me.jmxOptSelection();
		}
		else
		{
			if(fromMbean == 'No')
			{
				var urlStr = 'EgConfigJmxMeasureJson.jsp?test='+testName;
				Ext.Ajax.request(
				{
					url: 'ICTest/data/'+urlStr,
					method: 'POST',
					async:false,
					success: function( response )
					{
						if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
						{
							var jsonText = response.responseText;
							publicJSON = Ext.decode( jsonText );
						}
					}
				});
			}
			var win = Ext.WindowManager.getActive();
			if(win != undefined)
			{
				var win2 = Ext.WindowManager.getActive().getId();
				if(win2.startsWith("addJmxMeasureWindow"))
				{
					Ext.getCmp(win2).close();
				}
			}
			Ext.create('Ext.window.Window', {
				title: newMeasDetail,
				padding:'3 10 10 10',
				width: 500,
				id:'addJmxMeasureWindow',
				layout:{
					type:'vbox',
					pack:'start',
					align:'center'
				},
				defaults: {
					labelSeparator: '',
					margin: 5,
					width: 400,
					labelWidth: 200
				},
				modal: true,
				resizable: false,
				doClose: function() {
					me.jmxOptSelection();
					this.destroy();
					//addctrler.loadMeasureTab();
				},
				items:[ 
					{
						xtype: 'textfield',
						cls : 'textbox',
						fieldLabel: measIdx,
						id:'index',
						name:'index',
						margin: '10 5 0 5'
					},
					{
						xtype: 'textfield',
						cls : 'textbox',
						fieldLabel: measName,
						id:'measure',
						name:'measure',
						maxLength: 24,
						enforceMaxLength: true
					},
					{
						xtype: 'scrollcombo',
						cls : 'dropdown',
						id:'dbsize',
						name:'dbsize',
						fieldLabel: dbColSize,
						store: new Ext.data.Store({
							fields : ['displayField', 'valueField'],
							data : []
						}),
						displayField:'displayField',
						valueField:'valueField',
						queryMode : 'local',
						editable: false
					},
					{
						xtype: 'scrollcombo',
						cls : 'dropdown',
						id:'un',
						name:'un',
						fieldLabel: unit,
						store: new Ext.data.Store({
							fields : ['displayField', 'valueField'],
							data : []
						}),
						displayField:'displayField',
						valueField:'valueField',
						queryMode : 'local',
						//editable: false,
						listeners:
						{
							select:{
								fn: function (id){
									me.otherUnit('add');
								}
							}
						}
					},
					{
						xtype: 'textfield',
						cls : 'textbox',
						fieldLabel: other,
						id:'otherunit',
						name:'otherunit',
						hidden: true,
						maxLength: 64,
						enforceMaxLength: true
					},
					{
						xtype: 'scrollcombo',
						cls : 'dropdown',
						id:'process',
						name:'process',
						fieldLabel: procMthd,
						store: new Ext.data.Store({
							fields : ['displayField', 'valueField'],
							data : []
						}),
						displayField:'displayField',
						valueField:'valueField',
						queryMode : 'local',
						editable: false,
						listeners:
						{
							select:{
								fn: function (id){
									me.processMethodChange('add');
								}
							}
						}
					},
					{
						xtype: 'scrollcombo',
						cls : 'dropdown',
						id:'cFactor',
						name:'cFactor',
						fieldLabel: convFact,
						store: new Ext.data.Store({
							fields : ['displayField', 'valueField'],
							data : []
						}),
						displayField:'displayField',
						valueField:'valueField',
						queryMode : 'local',
						editable: false
					},
					{
						xtype: 'textfield',
						cls : 'textbox',
						fieldLabel: alrmDispStr,
						id:'alarmdescription',
						name:'alarmdescription',
						maxLength: 75,
						enforceMaxLength: true
					},
					{
						xtype: 'scrollcombo',
						cls : 'dropdown',
						id:'mBeans',
						name:'mBeans',
						fieldLabel: mBean,
						store: new Ext.data.Store({
							fields : ['displayField', 'valueField'],
							data : []
						}),
						displayField:'displayField',
						valueField:'valueField',
						queryMode : 'local',
						editable: true,
						defaultListConfig: {
							minWidth: 400,
							maxHeight: 300
						},
						listeners:
						{
							select:{
								fn: function (id){
									me.mBeansListChange();
								}
							}
						}
					},
					{
						xtype: 'textfield',
						cls : 'textbox',
						fieldLabel: attrName,
						id:'counter',
						name:'counter',
						maxLength: 100,
						enforceMaxLength: true
					},	
					{
						xtype: 'scrollcombo',
						cls : 'dropdown',
						id:'mBeanArributes',
						name:'mBeanArributes',
						fieldLabel: attrName,
						store: new Ext.data.Store({
							fields : ['displayField', 'valueField'],
							data : []
						}),
						displayField:'displayField',
						valueField:'valueField',
						queryMode : 'local',
						editable: true,
						defaultListConfig: {
							minWidth: 350,
							maxHeight: 300
						},
						hidden: true
					},
					{
						xtype: 'button',
						cls : 'button20',
						text: add,
						id:'addMeasureButton',
						width: 80,
						listeners:
						{
							click:{
								fn: function (id){
									me.doAddNewMeasure();
								}
							}
						},
						margin: '5 5 20 5'
					}
				]
			}).show();
			
			var process = '';
			Ext.getCmp('index').setValue(publicJSON.measIndex);
			if (publicJSON.measNameValue != '')
			{
				Ext.getCmp('measure').setValue(publicJSON.measNameValue);
			}
			var dbSizeObj = Ext.getCmp('dbsize');
			var alrmDescObj = Ext.getCmp('alarmdescription');
			var processObj = Ext.getCmp('process');
			var unitObj = Ext.getCmp('un');
			var otherUnitObj = Ext.getCmp('otherunit');
			var convFactObj = Ext.getCmp('cFactor');
			if (isConfigTest)
			{
				dbSizeObj.hide();
				alrmDescObj.hide();
				processObj.hide();
				unitObj.hide();
				convFactObj.hide();
			}
			else
			{
				dbSizeObj.getStore().loadRawData(publicJSON.dbColSizeList);
				if (publicJSON.dbColSizeSelected != '')
				{
					dbSizeObj.setValue(publicJSON.dbColSizeSelected);
				}
				else
				{
					dbSizeObj.setValue("2");
				}
				Ext.getCmp('un').getStore().loadRawData(publicJSON.unitsList);
				if (publicJSON.unitSelected != undefined && publicJSON.unitSelected != '')
				{
					Ext.getCmp('un').setValue(publicJSON.unitSelected);
					if (publicJSON.unitSelected == "other" && publicJSON.showOtherTextBox == true)
					{
						Ext.getCmp('otherunit').show();
						Ext.getCmp('otherunit').setValue(publicJSON.otherUnitValue);
					}
				}
				else
				{
					Ext.getCmp('un').setValue("-1");
				}
				Ext.getCmp('cFactor').getStore().loadRawData(publicJSON.convFactorList);
				Ext.getCmp('cFactor').setValue(publicJSON.convFactorSelected);
				Ext.getCmp('process').getStore().loadRawData(publicJSON.processMethodList);
				process = publicJSON.selectedProcessMethod;
				Ext.getCmp('process').setValue(process);
				alrmDescObj.setValue(publicJSON.alarmDispStrValue);
			}

			if (process == 'UNALTERED' || process == 'DIFFERENCE')
			{
				convFactObj.show();
				convFactObj.getStore().loadRawData(publicJSON.convFactorList);
				convFactObj.setValue(publicJSON.convFactorSelected);
			}
			else
			{
				convFactObj.hide();
			}
			var mBeansObj = Ext.getCmp('mBeans');
			if (publicJSON.mBeansListShow && selOpt != 'manual')
			{
				mBeansObj.enable();
				mBeansObj.show();
				mBeansObj.getStore().loadRawData(publicJSON.mBeansList);
				mBeansObj.setValue(publicJSON.mBeanSelected);
			}
			else
			{
				mBeansObj.hide();
				mBeansObj.disable();
			}
			var attrInput = publicJSON.attributesInputType;
			var txtObj = Ext.getCmp('counter');
			var combObj = Ext.getCmp('mBeanArributes');
	
			if (attrInput == 'text')
			{
			//	txtObj.enable();
				txtObj.show();
				txtObj.setValue(publicJSON.attributeValue);
	
				combObj.hide();
				//combObj.disable();
			}
			else if (attrInput == 'combo')
			{
				txtObj.hide();
			//	txtObj.disable();
	
			//	combObj.enable();
				combObj.show();
				combObj.getStore().loadRawData(publicJSON.attributesList);
				combObj.setValue(publicJSON.attributeSelected);
			}
		}
	},
	doAddNewMeasure: function()
	{
		var me = this;
		var test = Ext.getCmp('test').getValue();
		var index = Ext.getCmp('index').getValue();
		var measure = Ext.getCmp('measure').getValue();
		var factor = Ext.getCmp('cFactor').getValue();
		var dbSize = Ext.getCmp('dbsize').getValue();
		var otherUnit = Ext.getCmp('otherunit').getValue();
		var unit = Ext.getCmp('un').getValue();
		var alrmDesc = Ext.getCmp('alarmdescription').getValue();
		var process = Ext.getCmp('process').getValue();
		var counter = Ext.getCmp('counter').getValue();
		var attrName =  Ext.getCmp('mBeanArributes').getValue();
		var mbeanSelected = Ext.getCmp('mBeans').getValue();
		var mbeanSelectedDispVal = Ext.getCmp('mBeans').getRawValue();

		if(process == null && isConfigTest)
		{
			process = 'UNALTERED';
			factor = '1';
		}
		if (counter == '' && attrName != null)
		{
			counter = attrName;
		}
		if (process != 'UNALTERED' && process != 'DIFFERENCE')
		{
			factor = 'none';
		}

		var urlStr =  'ICTest/data/EgconfigjmxmeasurepJson.jsp?add=add&test='+test+'&measure='+measure+'&factor='+factor+'&counter='+counter+'&selMbean='+mbeanSelected+'&mbean='+mbeanSelectedDispVal;
		urlStr += '&dbsize='+dbSize+'&otherunit='+otherUnit+'&un='+encodeURIComponent(filterEncode(unit))+'&alarmdescription='+encodeURIComponent(alrmDesc)+'&index='+index+'&process='+process+'&selOpt='+selOpt;

		if (!this.measureValidation(measure,unit,otherUnit,alrmDesc,counter,'',attrName))
		{
			return;
		}
		
		Ext.Ajax.request(
		{
			url: urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});

		if (publicJSON.AlertType == 'Error')
		{
			Ext.Msg.show({
				title: error+': '+publicJSON.AlertTitle,
				msg:publicJSON.AlertMsg,
				buttons: Ext.Msg.OK,
				icon: 'iconError'
			});
		}
		else if (publicJSON.AlertType == 'Result')
		{
			Ext.getCmp('generateCntnr').enable();
			Ext.getCmp('tab6Help').enable();
			Ext.Msg.show({
				title: publicJSON.AlertTitle,
				msg:publicJSON.AlertMsg + ' '+ alertMsg80,
				closable: false,
				buttons: Ext.Msg.YESNO,
				icon: 'iconInformation',
				fn: function(response) {
					if(response == 'yes') {
						Ext.getCmp('addJmxMeasureWindow').destroy();
						var urlToProcess = publicJSON.forwardURL;
						me.loadAddMeasureTab(urlToProcess,'1');
						var isAddNewMeasure = 'No';
						var fromMbean = 'No';
						me.showAddNewMeasure(isAddNewMeasure,fromMbean);
					}
					else if (response == 'no')
					{
						Ext.getCmp('addJmxMeasureWindow').destroy();
						var urlToProcess = publicJSON.forwardURL;
						me.loadAddMeasureTab(urlToProcess);
						
						var urlStr = 'EgConfigJmxMeasureJson.jsp?test='+test;
						me.showAddedMeasures(urlStr);

						//Ext.getCmp('generateCntnr').enable();
						//Ext.getCmp('tab6Help').enable();
						Ext.getCmp('newtest').setActiveTab(3);
					}
				}
			});
		}
	},
	measureValidation: function(meas,unit,otherUnit,alarmStr,counter,mBeans,s_mBeanArributes)
	{
		var me=this;
		var measObj = Ext.getCmp('measure');
		var alrmStrObj = Ext.getCmp('alarmdescription');
		var otherUnitObj = Ext.getCmp('otherunit');
		var counterObj = Ext.getCmp('counter');
		var mBeanArributesObj = Ext.getCmp('s_mBeanArributes');
		var mbeanObj = Ext.getCmp('mBeans');
		var mbeanSelected = "";
		var attrSelected = "";
		if (mbeanObj != undefined)
		{
			mbeanSelected = mbeanObj.getValue();
		}		
		if (mBeanArributesObj != undefined)
		{
			attrSelected = mBeanArributesObj.getValue();
		}		

		var keyArr = new Array("other","none","null","all");
		var isConfigTest = false;
		var alarmDispStr=true;
		var type = Ext.getCmp('type').getValue()
		if (type != null && type == 'Configuration')
		{
			isConfigTest = true;
		}
		if (!isConfigTest)
		{
			if(!me.checkSpecialChar(alarmStr,"~!@#$%^&*()|:,;'<>"))
			{
				Ext.Msg.show({
					title: newMeasDetail,
					msg: splCharAlert,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				alrmStrObj.focus(true);
				return false;				
			}
			if(isDouble=="false")
			{
				alarmDispStr = validateSingleByte(alarmStr);
			}
		}
		meas = meas.toUpperCase();
		if(meas == "TRGT_HOST" || meas == "PORT_NO"
			|| meas == "SITE_NAME" || meas == "INFO"
			|| meas == "MSMT_HOST" || meas == "MSMT_TIME")   
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg14,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}
		var ch = meas.charAt(0);
		var un=!isConfigTest?unit:"NONE";
		if(!checkblank(meas))
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg15,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			measObj.focus(true);
			return false;
		}
		else if(!checkspace(meas))
		{
			measObj.focus(true);
			return false;
		}
		else if(!checkspecialnomess(meas, "`~!@#$%^&*()+=-/?'\"]{}[\\|;:.,><"))
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg3,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			measObj.focus(true);
			return false;
		}
		else if(ch >= '0' && ch <= '9')
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg16,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			measObj.focus(true);
			return false;
		}
		else if(ch == '_')
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg17,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			measObj.focus(true);
			return false;
		}
		else if(!validateSingleByte(meas))
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg18,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			measObj.focus(true);
			return false;
		}
		else if(un == "-1")
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg19,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}
		else if(!alarmDispStr)
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg20,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			alrmStrObj.focus(true);
			return false;
		}
		else if(un == "other")
		{
			if(!checkblank(otherUnit))
			{
				Ext.Msg.show({
					title: newMeasDetail,
					msg: alertMsg21,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return false;
			}
			else if(!checkspace(otherUnit))
			{
				otherUnitObj.focus(true);
				return false;
			}
			else if(!checkspecialnomess(otherUnit, "`~!@#^&*()+=-?'\"]{}[\\|;:.,><"))
			{
				Ext.Msg.show({
					title: newMeasDetail,
					msg: alertMsg3,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				otherUnitObj.focus(true);
				return false;
			}
			else if (!checkKeywords(otherUnit,keyArr))
			{
				Ext.Msg.show({
					title: newMeasDetail,
					msg: alertMsg22,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				otherUnitObj.focus(true);
				return false;
			}
		}

		if(mbeanSelected != "")
		{
			if(mbeanSelected == "-1")
			{
				Ext.Msg.show({
					title: newMeasDetail,
					msg: "Please select mbean name",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				mbeanObj.focus(true);
				return false;
			}
		}
		if(s_mBeanArributes != "")
		{
			if(s_mBeanArributes == "-1")
			{
				Ext.Msg.show({
					title: newMeasDetail,
					msg: "Please select attribute name",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				mBeanArributesObj.focus(true);
				return false;
			}
		}
		
		if(!checkblank(counter))
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg62,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			counterObj.focus(true);
			return false;
		}
		else if(counter == "-1")
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg62,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}
		else if(!validateSingleByte(counter))
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg42,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			counterObj.focus(true);
			return false;
		}		

		return true;
	},
	showModifyMeasure: function(modifyURL)
	{
		var win = Ext.WindowManager.getActive();
		if (win) {
			win.close();
		}
		var domain = Ext.getCmp("objectVal").getValue();
		var me = this;
		var publicJSONTmp;
		Ext.Ajax.request(
		{
			url: 'ICTest/data/'+modifyURL+'&testType=JMX&domain='+domain,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSONTmp = Ext.decode( jsonText );
				}
			}
		});

		Ext.create('Ext.window.Window', {
			title: modMeas,
			padding:'3 10 10 10',
		//	height: 350,
			width: 500,
			id:'modJmxMeasureWindow',
			modal: true,
			resizable: false,
			items:[ 
				{
					xtype: 'form',
					id: 'measureform',
					name: 'measureform',
					url: 'ICTest/data/EgmodifymeasurespJson.jsp',
				//	height: 350,
					width: 500,
					layout:{
						type:'vbox',
						pack:'start',
						align:'center'
					},
					defaults: {
						labelSeparator: '',
						margin: 5,
						width: 400,
						labelWidth: 200
					},
					items:[
						{
							xtype: 'textfield',
							id:'s_index',
							name:'s_index',
							margin: '10 5 0 5',
							hidden:true
						},
						{
							xtype: 'textfield',
							cls : 'button20',
							fieldLabel: measName,
							id:'s_measure',
							name:'s_measure',
							maxLength: 24,
							enforceMaxLength: true,
							value: publicJSONTmp.measureName,
							margin: '10 5 0 5'
						},
						{
							xtype: 'scrollcombo',
							cls : 'dropdown',
							id:'s_dbsize',
							name:'s_dbsize',
							fieldLabel: dbColSize,
							store: new Ext.data.Store({
								fields : ['displayField', 'valueField'],
								data : []
							}),
							displayField:'displayField',
							valueField:'valueField',
							queryMode : 'local',
							editable: false,
							hidden: isConfigTest//new feed
						},
						{
							xtype: 'scrollcombo',
							cls : 'dropdown',
							id:'s_un',
							name:'s_un',
							fieldLabel: unit,
							store: new Ext.data.Store({
								fields : ['displayField', 'valueField'],
								data : []
							}),
							displayField:'displayField',
							valueField:'valueField',
							queryMode : 'local',
							//editable: false,
							hidden: isConfigTest,//new feed
							listeners:
							{
								select:{
									fn: function (id){
										jmxCtrlr.otherUnit('modify');
									}
								}
							}
						},
						{
							xtype: 'textfield',
							cls : 'textbox',
							fieldLabel: other,
							id:'s_otherunit',
							name:'s_otherunit',
							hidden: true,
							maxLength: 64,
							enforceMaxLength: true
						},
						{
							xtype: 'scrollcombo',
							cls : 'dropdown',
							id:'s_process',
							name:'s_process',
							fieldLabel: procMthd,
							store: new Ext.data.Store({
								fields : ['displayField', 'valueField'],
								data : []
							}),
							displayField:'displayField',
							valueField:'valueField',
							queryMode : 'local',
							editable: false,
							hidden: isConfigTest,//new feed
							listeners:
							{
								select:{
									fn: function (id){
										jmxCtrlr.processMethodChange('modify');
									}
								}
							}
						},
						{
							xtype: 'scrollcombo',
							cls : 'dropdown',
							id:'s_factor',
							name:'s_factor',
							fieldLabel: convFact,
							store: new Ext.data.Store({
								fields : ['displayField', 'valueField'],
								data : []
							}),
							displayField:'displayField',
							valueField:'valueField',
							queryMode : 'local',
							editable: false,
							hidden: isConfigTest//new feed
						},
						{
							xtype: 'textfield',
							cls : 'textbox',
							fieldLabel: alrmDispStr,
							id:'s_alarmdescription',
							name:'s_alarmdescription',
							maxLength: 75,
							enforceMaxLength: true,
							value: publicJSONTmp.alarmDispStrValue,
							hidden: isConfigTest//new feed
						},
						{
							xtype: 'scrollcombo',
							cls : 'dropdown',
							id:'s_mBeans',
							name:'s_mBeans',
							fieldLabel: mBean,
							store: new Ext.data.Store({
								fields : ['displayField', 'valueField'],
								data : []
							}),
							displayField:'displayField',
							valueField:'valueField',
							queryMode : 'local',
							value: publicJSONTmp.mbeanForMeasure,
							editable: true,
							defaultListConfig: {
								minWidth: 400,
								maxHeight: 300
							},
							listeners:
							{
								select:{
									fn: function (id){
										jmxCtrlr.mBeansListChangeModify();
										//jmxCtrlr.mbeanListChange(publicJSONTmp);
									}
								}
							}
						},
						{
							xtype: 'textfield',
							cls : 'textbox',
							fieldLabel: attrName,
							id:'s_counter',
							name:'s_counter',
							maxLength: 100,
							enforceMaxLength: true,
							value: publicJSONTmp.attributeValue
						},
						{
							xtype: 'scrollcombo',
							cls : 'dropdown',
							id:'s_mBeanArributes',
							name:'s_mBeanArributes',
							fieldLabel: attrName,
							store: new Ext.data.Store({
								fields : ['displayField', 'valueField'],
								data : []
							}),
							displayField:'displayField',
							valueField:'valueField',
							queryMode : 'local',
							editable: true,
							defaultListConfig: {
								minWidth: 350,
								maxHeight: 300
							},
							hidden: true
						},
						{
							xtype: 'button',
							cls : 'button20',
							text: modifyTooltip,
							id:'modMeasureButton',
							width: 80,
							margin: '5 5 20 5',
							listeners:
							{
								click:{
									fn: function (id){
										var measure = Ext.getCmp('s_measure').getValue();
										var otherUnit = Ext.getCmp('s_otherunit').getValue();
										var unit = Ext.getCmp('s_un').getValue();
										var alrmDesc = Ext.getCmp('s_alarmdescription').getValue();
										var counter = Ext.getCmp('s_counter').getValue();
										var mBeanArributes = Ext.getCmp('s_mBeanArributes').getValue();
										if (!jmxCtrlr.measureValidation(measure,unit,otherUnit,alrmDesc,counter,s_mBeans,mBeanArributes))
										{
											return;
										}
										var uploadformObj = Ext.getCmp('measureform').getForm();
										if (uploadformObj.isValid())
										{
											var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: updating+'...'});
											var jmxform = encodeFieldParams(uploadformObj);
											tmpMask.show();
											uploadformObj.submit({
												method: 'POST',
												params : jmxform,
												success: function (form, action) {
													tmpMask.hide();
													var jsonText = action.response.responseText;
													var tmpResult = Ext.decode(jsonText);

													if(tmpResult.AlertType == 'Result')
													{
														var test = Ext.getCmp('test').getValue();
														var urlStr = "EgConfigJmxMeasureJson.jsp?test=" + test;
														jmxCtrlr.showAddedMeasures(urlStr);
														Ext.Msg.show({
															title: tmpResult.AlertTitle,
															msg: tmpResult.AlertMsg,
															buttons: Ext.Msg.OK,
															icon: 'iconInformation',
															fn: function(response) {
																if(response == 'ok') {
																	Ext.getCmp('newtest').setActiveTab(3);
																}
															}
														});
													}
													else if(tmpResult.AlertType == 'Error')
													{
														Ext.Msg.show({
															title: tmpResult.AlertTitle,
															msg: tmpResult.AlertMsg,
															buttons: Ext.Msg.OK,
															icon: 'iconError',
															fn: function(response) {
																if(response == 'ok') {
																	var test = Ext.getCmp('test').getValue();
																	var urlStr = "EgConfigJmxMeasureJson.jsp?test=" + test;
																	jmxCtrlr.showAddedMeasures(urlStr);
																}
															}
														});
													}
												}
											});
										}
										Ext.getCmp('modJmxMeasureWindow').close();
									}
								}
							}
						},
						{
							xtype: 'container',
							id:'hiddenContnr',
							hidden:true
						}
					]
				}
			]
		}).show();
		
		if (!isConfigTest)//new feed
		{
			Ext.getCmp('s_dbsize').getStore().loadRawData(publicJSONTmp.dbColSizeList);
			Ext.getCmp('s_dbsize').setValue(publicJSONTmp.dbColSizeSelected);
			Ext.getCmp('s_un').getStore().loadRawData(publicJSONTmp.unitsList);
			Ext.getCmp('s_un').setValue(publicJSONTmp.unitSelected);
			Ext.getCmp('s_process').getStore().loadRawData(publicJSONTmp.processMethodList);
			Ext.getCmp('s_process').setValue(publicJSONTmp.selectedProcessMethod);
			
			var mBeansObj = Ext.getCmp('s_mBeans');
			if(publicJSONTmp.mBeansListShow && publicJSONTmp.doesMbeanExist && (publicJSON.mBeanSelected == "-1" || publicJSON.mBeanSelected == "undefined"))
			{
				mBeansObj.enable();
				mBeansObj.show();
				mBeansObj.getStore().loadRawData(publicJSON.mBeansList);
				mBeansObj.setRawValue(publicJSONTmp.previousMBeanSelected);
			}
			else if (publicJSONTmp.mBeansListShow && publicJSONTmp.doesMbeanExist)
			{
				mBeansObj.enable();
				mBeansObj.show();
				mBeansObj.getStore().loadRawData(publicJSONTmp.mBeansList);
				mBeansObj.setValue(publicJSONTmp.mBeanSelected);
			}
			else
			{
				mBeansObj.hide();
				mBeansObj.disable();
			}
			var attrInput = publicJSONTmp.attributesInputType;
			var txtObj = Ext.getCmp('s_counter');
			var combObj = Ext.getCmp('s_mBeanArributes');
			if (attrInput == 'text')
			{
				txtObj.show();
				txtObj.setValue(publicJSONTmp.attributeValue);
				combObj.hide();
			}
			else if (attrInput == 'combo')
			{
				txtObj.hide();
				combObj.show();
				combObj.getStore().loadRawData(publicJSONTmp.attributesList);
				combObj.setValue(publicJSONTmp.attributeSelected);
			}
			var convFactObj = Ext.getCmp('s_factor');
			if (!publicJSONTmp.hideConvFactor)
			{
				convFactObj.show();
				convFactObj.getStore().loadRawData(publicJSONTmp.convFactorList);
				convFactObj.setValue(publicJSONTmp.convFactorSelected);
			}
			else{
				convFactObj.hide();
			}
		}
		else
		{
			Ext.getCmp('measureform').setHeight(100);
			Ext.getCmp('modJmxMeasureWindow').setHeight(150);
		}

		var hiddenParams = publicJSONTmp.hiddens;
		var me = Ext.getCmp('hiddenContnr');
		me.removeAll();
		for (var param in hiddenParams) {
				me.add({
					xtype: 'hidden',
					name: param,
					value: hiddenParams[param]
				});
		}
	},
	deleteMeasure: function(deleteURL, measureName)
	{
		var me = this;
		Ext.Msg.show({
			title: addMeasure,
			msg: alertMsg45+ ' \''+measureName+'\'?',
			buttons: Ext.Msg.OKCANCEL,
			icon: 'iconConfirmation',
			fn: function(response) {
				if(response == 'ok') {
					Ext.Ajax.request(
					{
						url: 'ICTest/data/'+deleteURL,
						method: 'POST',
						async:false,
						success: function( response )
						{
							if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
							{
								var jsonText = response.responseText;
								publicJSON = Ext.decode( jsonText );
							}
						}
					});
					if (publicJSON.AlertType=='Result')
					{
						Ext.Msg.show({
							title: publicJSON.AlertTitle,
							msg:publicJSON.AlertMsg,
							buttons: Ext.Msg.OK,
							icon: 'iconInformation',
							fn: function(response) {
								if(response == 'ok') {
									Ext.getCmp('addMeasureTab').enable();
									var urlToProcess = publicJSON.forwardURL;
									me.showAddedMeasures(urlToProcess);
								}
							}
						});
					}
				}
			}
		});
	},
	generateJmxTest: function()
	{
		var test = Ext.getCmp('test').getValue();
		var objObj = Ext.getCmp('object');
		var incObj = Ext.getCmp('instances');
		var excObj = Ext.getCmp('instances_neg');

		var obj = objObj.getValue();
		var incl = incObj.getValue();
		var excl = excObj.getValue();

		if(!checkblank(obj))
		{
			Ext.Msg.show({
				title: generate,
				msg: alertMsg63,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(response) {
					if(response == 'ok') {
						objObj.focus(true);
					}
				}
			});
			return;
		}
		else if(!validateSingleByte(obj))
		{
			Ext.Msg.show({
				title: generate,
				msg: alertMsg64,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(response) {
					if(response == 'ok') {
						objObj.focus(true);
					}
				}
			});
			return;
		}
		else if(!validateSingleByte(incl))
		{
			Ext.Msg.show({
				title: generate,
				msg: alertMsg65,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(response) {
					if(response == 'ok') {
						incObj.focus(true);
					}
				}
			});
			return;
		}
		else if(!validateSingleByte(excl))
		{
			Ext.Msg.show({
				title: generate,
				msg: alertMsg66,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(response) {
					if(response == 'ok') {
						excObj.focus(true);
					}
				}
			});
			return;
		}
		if (publicJSON.existingJmxObj != '')
		{
			//alert(alertMsg30);
		}
			
		var urlStr =  'ICTest/data/EgconfigjmxmeasurepJson.jsp?add=gen&test='+test+'&object='+obj+'&instances='+incl+'&instances_neg='+excl;

		if (isConfigTest)
		{
			var dbSize = Ext.getCmp('dbSizeGen').getValue();
			var descVal = Ext.getCmp('isDescriptorBasedTestJmx').getValue();
			urlStr += '&dbsize='+dbSize+'&descVal='+descVal;
		}

		Ext.Ajax.request(
		{
			url: urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});

		if (publicJSON.AlertType=='Error')
		{
			Ext.Msg.show({
				title: publicJSON.AlertTitle,
				msg:publicJSON.AlertMsg,
				buttons: Ext.Msg.OK,
				icon: 'iconError'
			});
		}
		else if (publicJSON.AlertType=='Result')
		{
			Ext.Msg.show({
				title: publicJSON.AlertTitle,
				msg:publicJSON.AlertMsg,
				buttons: Ext.Msg.OK,
				icon: 'iconInformation',
				fn: function(response) {
					if(response == 'ok') {
						window.location.href= '/final/admin/EgUDTest.jsp';
					}
				}
			});
		}


		if (!Ext.isEmpty(publicJSON.forwardURL))
		{
			this.getController('ICTest.controller.ThresholdCtrlr').init();
			var genCntnrObj = Ext.getCmp('generateCntnr');
			genCntnrObj.removeAll();
			var urlStr = publicJSON.forwardURL;
			qString = 'ICTest/data/'+urlStr;
			genCntnrObj.add({
				xtype : 'defaultthresholds'
			});
		}
	},
	startMBeanDiscovery: function()
	{
		var hostObj = Ext.getCmp('host');
		var jmxPortObj = Ext.getCmp('jmxport');
		var jndiObj = Ext.getCmp('jndi');
		var userObj = Ext.getCmp('user');
		var passObj = Ext.getCmp('pass');
		var host = hostObj.getValue();
		var jmxPort = jmxPortObj.getValue();
		var jndi = jndiObj.getValue();
		var user = userObj.getValue();
		var pass = passObj.getValue();
		 
		if(!checkblank(host))
		{
			Ext.Msg.show({
				title: mbDisc,
				msg: alertMsg67,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(response) {
					if(response == 'ok') {
						hostObj.focus(true);
					}
				}
			});
			return;
		}
		else if(!checkblank(jmxPort))
		{
			Ext.Msg.show({
				title: mbDisc,
				msg: alertMsg68,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(response) {
					if(response == 'ok') {
						jmxPortObj.focus(true);
					}
				}
			});
			return;
		}
		else if(!checkblank(jndi))
		{
			Ext.Msg.show({
				title: mbDisc,
				msg: alertMsg69,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(response) {
					if(response == 'ok') {
						jndiObj.focus(true);
					}
				}
			});
			return;
		}
		else if(!checkblank(user))
		{
			Ext.Msg.show({
				title: mbDisc,
				msg: alertMsg70,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(response) {
					if(response == 'ok') {
						userObj.focus(true);
					}
				}
			});
			return;
		}
		else if(!checkblank(pass))
		{
			Ext.Msg.show({
				title: mbDisc,
				msg: alertMsg71,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(response) {
					if(response == 'ok') {
						passObj.focus(true);
					}
				}
			});
			return;
		}
		var test = Ext.getCmp('test').getValue();
		var urlStr = "ICTest/data/EgMBeanDiscoveryJson.jsp?test="+test+"&host="+host+"&jmxport="+jmxPort+"&jndi="+jndi+"&user="+encodeURIComponent(user)+"&pass="+encodeURIComponent(pass)+"&error=true";
		var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: updating+'...'});
		tmpMask.show();
		Ext.Ajax.request(
		{
			url: urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				tmpMask.hide();
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			},
			failure: function( response )
			{
				tmpMask.hide();
			}
		});

		var domainsObj = Ext.getCmp('mbDiscCntnrAnx');
		if (publicJSON.showDomainsList)
		{
			domainsObj.show();
			domainsObj.enable();
			var domainsListObj = Ext.getCmp('domainNames');
			domainsListObj.getStore().loadRawData(publicJSON.domainsList);
			domainsListObj.setValue(publicJSON.domainSelected);
		}
		else
		{
			domainsObj.hide();
			Ext.Msg.show({
				title: mbDisc,
				msg: alertMsg81,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
		}

	},
	configureJmxMeausre: function()
	{
		var test = Ext.getCmp('test').getValue();
		var domainObj = Ext.getCmp('domainNames');
		var domain = domainObj.getValue();
		if(domain == "-1")
		{
			Ext.Msg.show({
				title: mbDisc,
				msg: alertMsg72,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(response) {
					if(response == 'ok') {
						domainObj.focus(true);
					}
				}
			});
			return;
		}
		
		var urlStr="ICTest/data/EgConfigJmxMeasureJson.jsp?test="+test+"&domain="+domain;
		Ext.Ajax.request(
		{
			url: urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
		var isAddNewMeasure = 'No';
		var fromMbean = 'No';
		this.showAddNewMeasure(isAddNewMeasure,fromMbean);
	},
	configureJmxMeausre2: function()
	{
		var test = publicJSON.hiddens.test;
		var domainObj = Ext.getCmp('domainNames2');
		var domain = domainObj.getValue();
		if(domain == "-1")
		{
			Ext.Msg.show({
				title: mbDisc,
				msg: alertMsg72,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(response) {
					if(response == 'ok') {
						domainObj.focus(true);
					}
				}
			});
			return;
		}
		
		var urlStr="ICTest/data/EgConfigJmxMeasureJson.jsp?test="+test+"&domain="+domain;
		Ext.Ajax.request(
		{
			url: urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
		var isAddNewMeasure = 'No';
		var fromMbean = 'No';

		this.showAddNewMeasure(isAddNewMeasure,fromMbean);
	},
	configureJmxMeausre3: function()
	{
		var win = Ext.WindowManager.getActive();
		if (win) {
			win.close();
		}
		var test = publicJSON.hiddens.test;
		var domainObj = Ext.getCmp('domainNames3');
		var domain = domainObj.getValue();
		if(domain == "-1")
		{
			Ext.Msg.show({
				title: mbDisc,
				msg: alertMsg72,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(response) {
					if(response == 'ok') {
						domainObj.focus(true);
					}
				}
			});
			return;
		}
		
		var urlStr="ICTest/data/EgConfigJmxMeasureJson.jsp?test="+test+"&domain="+domain;
		Ext.Ajax.request(
		{
			url: urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
		var isAddNewMeasure = 'No';
		var fromMbean = 'No';

		this.showAddNewMeasure(isAddNewMeasure,fromMbean);
	},
	mBeansListChange: function()
	{
		var test = publicJSON.hiddens.test
		var index = Ext.getCmp('index').getValue();
		var measure = Ext.getCmp('measure').getValue();
		var factor = Ext.getCmp('cFactor').getValue();
		var dbSize = Ext.getCmp('dbsize').getValue();
		var otherUnit = Ext.getCmp('otherunit').getValue();
		var unit = Ext.getCmp('un').getValue();
		var alrmDesc = Ext.getCmp('alarmdescription').getValue();
		var process = Ext.getCmp('process').getValue();
		var counter = Ext.getCmp('counter').getValue();
		var mBean = Ext.getCmp('mBeans').getValue();
		var domain = publicJSON.domainName;
		if (domain == null || domainName == 'undefined')
		{
			domain = publicJSON.hiddens.domain;
		}

		for(var x=0;x<counter.length;x++)
		{
			if(counter.charAt(x) == ' ')
				counter = counter.replace(' ','*');
			else if(counter.charAt(x) == '%')
				counter = counter.replace('%','|');
			else
				continue;
		}

		var urlStr = "ICTest/data/EgConfigJmxMeasureJson.jsp?test="+test+"&unit="+encodeURI(unit)+"&measure="+measure+"&process="+process+"&index="+index+'&otherunit='+otherUnit;
		urlStr += "&factor="+encodeURI(factor)+"&mbean="+encodeURI(mBean)+"&domain="+encodeURI(domain)+"&dbsize="+dbSize+"&counter="+encodeURI(counter)+"&alarmDisplay="+encodeURIComponent(alrmDesc);
		Ext.Ajax.request(
		{
			url: urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
		Ext.getCmp('addJmxMeasureWindow').destroy();
		var isAddNewMeasure = 'No';
		var fromMbean = 'Yes';
		this.showAddNewMeasure(isAddNewMeasure,fromMbean);
	},
	mBeansListChangeModify: function()
	{
		var test = publicJSON.hiddens.test
		var index = Ext.getCmp('s_index').getValue();
		var measure = Ext.getCmp('s_measure').getValue();
		var factor = Ext.getCmp('s_factor').getValue();
		var dbSize = Ext.getCmp('s_dbsize').getValue();
		var otherUnit = Ext.getCmp('s_otherunit').getValue();
		var unit = Ext.getCmp('s_un').getValue();
		var alrmDesc = Ext.getCmp('s_alarmdescription').getValue();
		var process = Ext.getCmp('s_process').getValue();
		var counter = Ext.getCmp('s_counter').getValue();
		var mBean = Ext.getCmp('s_mBeans').getValue();
		var mBeanSel = Ext.getCmp('s_mBeans').getRawValue();
		var domain = publicJSON.domainName;
		if (domain == null || domainName == 'undefined')
		{
			domain = publicJSON.hiddens.domain;
		}
		

		for(var x=0;x<counter.length;x++)
		{
			if(counter.charAt(x) == ' ')
				counter = counter.replace(' ','*');
			else if(counter.charAt(x) == '%')
				counter = counter.replace('%','|');
			else
				continue;
		}
		var org_mbean = measure+"$"+mBeanSel;
		var org_counter = measure+":"+counter;
		var org_process = measure+":"+process;
		var org_factor = measure+":"+factor;
		//var org_mbean = measure+":"+mBean;
		var urlStr = "ICTest/data/EgConfigJmxMeasureJson.jsp?test="+test+"&unit="+encodeURI(unit)+"&measure="+measure+"&process="+process+"&index="+index+'&otherunit='+otherUnit;
		urlStr += "&factor="+encodeURI(factor)+"&mbean="+encodeURI(mBean)+"&domain="+encodeURI(domain)+"&dbsize="+dbSize+"&counter="+encodeURI(counter)+"&alarmDisplay="+encodeURIComponent(alrmDesc)+"&fromPage=Modify&mbeanDispVal="+mBeanSel;

		Ext.Ajax.request(
		{
			url: urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
					var existingMeass = publicJSON.measuresList;
					for (var p=0; p<existingMeass.length; p++) {
						var measureVal = existingMeass[p];
						if(measureVal.measureName == measure)
						{
							var modifyurl = measureVal.modifyURL;
							jmxCtrlr.showModifyMeasure(modifyurl);
						}
					}
				}
			}
		});
	},
	
	uploadMBean: function()
	{
		var me = this;
		//alert('Upload MBean..!');
		var test = Ext.getCmp('test').getValue();
		var urlStr = "/final/admin/Misc/data/EgFileUpload.jsp?title=Uploading eGurkha Files&dispCaption=Fiels&requestFrom=EgMBeanDiscovery.jsp";
		urlStr += "&uploadFor=save&&uploadDir=&mgrLog=true&showDir=true&test="+test+"&fileExt=";
		var selFile = '';
		Ext.Ajax.request(
		{
			url: urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});

		Ext.widget('window', {
			title: fileUpload,
			width: 350,
			height: 150,
			id: 'fileUploadWin',
			name: 'fileUploadWin',
			resizable: 'false',
			items: [
				{
					xtype: 'form',
					id: 'uploadform',
					name: 'uploadform',
					url: '/final/admin/Misc/data/EgFileUpload.jsp?fileUpload=yes&mgrLog=startDiscovery',
					height: 150,
					items: [
						{
							xtype: 'fileuploadfield',
							cls: 'fileupload',
							id: 'file',
							name: 'file',
							labelSeparator: '',
							emptyText: noFileSel,
							fieldLabel: file2Upload,
							labelAlign: 'top',
							width: 290,
							buttonText: 'Browse',
							margin: '15 0 0 15',
						},
						{
							xtype: 'button',
							text: upload,
							id: 'uploadMbean',
							name: 'uploadMbean',
							action: 'upload',
							cls: 'button20',
							align: 'center',
							margin: '15 0 0 140',
							handler: function (button, e)
							{
								selFile = Ext.getCmp('uploadform').getForm().findField('file').getValue();
								var validate = true;
								var n = selFile.lastIndexOf("fakepath");
								if(n > 0)
								{
									selFile = selFile.substring(n+9);

								}
								var list = publicJSON.uploadedFilesString;
								if(!publicJSON.isDouble && !validateSingleByte(selFile))
								{
									Ext.Msg.show({
										title: fileUpload,
										msg: alertMsg23,
										buttons: Ext.Msg.OK,
										icon: 'iconExclamation'
									});
									Ext.getCmp("file").focus(true);
									validate = false;
								}
								else if(selFile=="")
								{
									Ext.Msg.show({
										title: fileUpload,
										msg: alertMsg24,
										buttons: Ext.Msg.OK,
										icon: 'iconExclamation'
									});
									Ext.getCmp("file").focus(true);
									validate = false;
								}
								else if(list.match(selFile) == selFile)
								{
									Ext.Msg.show({
										title: fileUpload,
										msg: alertMsg73,
										buttons: Ext.Msg.OKCANCEL,
										icon: 'iconExclamation',
										fn: function(response) {
											if(response == 'cancel') {
												validate = false;
											}
										}
									});
								}
								if (!validate)
								{
									return false;
								}
								else
								{
									//urlStr = "/final/admin/EgFileUpload.jsp?fileUpload=yes&mgrLog=startDiscovery&test="+test+"&mbeanFile="+selFile;
									var instDir = publicJSON.installDir;
									var count = instDir.indexOf(":");
									if(count > 0)
									{
										var tmp1 = instDir.substring(0,count);
										var tmp2 = instDir.substring(count+2);
										instDir = tmp1+":/"+tmp2;
									}
									var currentPath = instDir+"/tmp/"+selFile;
									var uploadformObj = Ext.getCmp('uploadform').getForm();
									if (uploadformObj.isValid())
									{
										uploadformObj.submit({
											method: 'POST',
											headers: {'Content-Type': 'multipart/form-data'},
											success: function (form, action) {
												var jsonText = action.response.responseText;
												var tmpResult = Ext.decode(jsonText);
												
												if (!Ext.isEmpty(tmpResult.uploadStatus) && tmpResult.uploadStatus)
												{
													Ext.getCmp('fileUploadWin').close();
													Ext.getCmp('filepath').setValue(currentPath);
													var url = "ICTest/data/EgMBeanDiscoveryJson.jsp?test="+test+"&option=file&filepath="+currentPath;
													me.loadMBeanFile(url);
												}
											},
											failure: function (form, action) {
												Ext.Msg.alert(fileUpload, 'File upload failure');
											}
										});
									}
								}
							}
						}
					],
					listeners: {
						afterrender: function () {
							var formObj = Ext.getCmp('uploadform');
							formObj.add({
								xtype: 'hidden',
								name: 'test',
								value: test
							});
							formObj.add({
								xtype: 'hidden',
								name: 'mbeanFile',
								value: selFile
							});
						}
					}
				}
			]
		}).show()
	},
	loadMBeanFile: function(urlStr)
	{
		Ext.Ajax.request(
		{
			url: urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});

		var domainsObj = Ext.getCmp('mbUpldCntnrAnx');
		if(!publicJSON.SelectedDomainExists)
		{
			Ext.Msg.alert("Alert","Please Select a MBean file with valid Domain");
			domainsObj.hide();
		}
		else if(publicJSON.showDomainsList)
		{
			domainsObj.show();
			domainsObj.enable();
			var domainListObj = Ext.getCmp('domainNames2');
			domainListObj.show();
			domainListObj.enable();
			domainListObj.getStore().loadRawData(publicJSON.domainsList);
			domainListObj.setValue(publicJSON.domainSelected);
		}
		else
		{
			domainsObj.hide();
		}
	},
	getDomainsFromFile: function()
	{
		var test = Ext.getCmp('test').getValue();
		var path = Ext.getCmp('filepath2').getValue();
		var urlStr = "ICTest/data/EgMBeanDiscoveryJson.jsp?test="+test+"&filepath="+path+"&option=existingMBean";

		Ext.Ajax.request(
		{
			url: urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
		
		var thirdOptObj = Ext.getCmp('mbExistCntnrAnx');
		if (publicJSON.showDomainsList)
		{
			thirdOptObj.show();
			thirdOptObj.enable();
			Ext.getCmp('domains3').show();
			Ext.getCmp('domainNames3').getStore().loadRawData(publicJSON.domainsList);
			Ext.getCmp('domainNames3').setValue(publicJSON.domainSelected);
		}
		else 
		{
			thirdOptObj.hide();
			thirdOptObj.disable();
			//Ext.getCmp('domains3').hide();
		}
	},
	checkSpecialChar: function(field,s_spl)
	{
		if (typeof(field)=='object')
		{
			obj_val = field.value;
		}
		else
		{
			obj_val = field;
		}
		for(var i=0; i<obj_val.length; i++)
		{
			check_char = s_spl.indexOf(obj_val.charAt(i))
			//Returns value 1 if the special character listed in splChar is found
			if(check_char >= 0)
			{
				//alert(_checkspecial);
				return false;
			}
		}
		return true;
	}
});




