Ext.define('ICTest.controller.AddPerfmonTestCtrlr',{
	extend:'Ext.app.Controller',
	views:['AddNewTest'],
	requires:['ICTest.view.AddNewTest'],
	refs:[
		{selector:'addnewtest', ref:'addnewtest'},
		{selector:'defaultthresholds', ref:'defaultthresholds'},
	],
	init:function(){
		perfmonCtrlr = this;
		this.control({
			'addnewtest':
			{
				'afterrender': this.afterMainRender
			}
		});
	},
	afterMainRender: function()
	{
	},
	loadAddMeasureTab: function(urlStr)
	{
		var me = this;
		Ext.Ajax.request(
		{
			url: 'ICTest/data/'+urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});

		var existingMeass = publicJSON.measuresList;
		var cntnrObj = Ext.getCmp('addMeasureCntnr');
		cntnrObj.removeAll();
		if (publicJSON.noMeasuresAdded)
		{
			Ext.getCmp('noMeasureFnd').show();
			Ext.getCmp('generateCntnr').disable();
			Ext.getCmp('tab6Help').disable();
		}
		else
		{
			Ext.getCmp('noMeasureFnd').hide();
			for (var p=0; p<existingMeass.length; p++) {
					var measure = existingMeass[p];
					if(!(measure.measureName == "Installed"))
					{
						cntnrObj.add({
						xtype: 'fieldset',
						title: '<b>'+measure.measureIndex+'. '+measure.measureName+'</b>',
						width: 500,
						items: [
							{
								xtype: 'container',
								layout: {
									type: 'vbox',
									align: 'left',
									pack: 'center'
								},
								defaults: {
									labelSeparator: ' ',
									margin: 5,
									labelWidth: 200 
								},
								items: [
									{
										xtype: 'displayfield',
										fieldLabel: dbColSize,
										id : 'dbSize'+p,
										value: measure.databaseColumnSize,
										hidden: measure.hideDatabaseColumnSize,
									},
									{
										xtype: 'displayfield',
										id : 'unitVal'+p,
										fieldLabel: unit,
										value: filterDecode(measure.unit)
									},
									{
										xtype: 'displayfield',
										fieldLabel: procMthd,
										id : 'processMethodVal'+p,
										value: measure.processMethod
									},
									{
										xtype: 'displayfield',
										fieldLabel: convFact,
										id : 'conFact'+p,
										value: measure.conversionFactor,
										hidden: measure.hideConversionFactor
									},
									{
										xtype: 'displayfield',
										fieldLabel: alrmDispStr,
										id : 'alarmDisp'+p,
										value: measure.alarmDispString,
										hidden: measure.hideAlarmDispStr
									},
									{
										xtype: 'displayfield',
										fieldLabel: counterName,
										id : 'contVal'+p,
										value: measure.counterName,
									}
								]
							},
							{
								xtype: 'container',
								layout: {
									type: 'hbox',
									pack: 'center'
								},
								defaults: {
									width: 80
								},
								items:[
									{
										xtype: 'button',
										cls : 'button20',
										text: modifyTooltip,
										modifyURL: measure.modifyURL,
										handler: function() {
											me.showModifyMeasure(this.modifyURL);
										},
										margin: '5 0 10 0'
									},
									{
										xtype: 'button',
										cls : 'button20',
										text: deleteTooltip,
										deleteURL: measure.deleteURL,
										measureName: measure.measureName,
										handler: function() {
											me.deleteMeasure(this.deleteURL, this.measureName);
										},
										margin: '5 0 10 20'
									}
								]
							}
						]
					});
					var dbColSize1 = Ext.getCmp('dbSize'+p);
					var unitVal = Ext.getCmp('unitVal'+p);
					var processMethodVal = Ext.getCmp('processMethodVal'+p);
					var conFact = Ext.getCmp('conFact'+p);
					var alrmDisp = Ext.getCmp('alarmDisp'+p);
					var contVal = Ext.getCmp('contVal'+p);
					if(isConfigTest)
					{
						dbColSize1.hide();
						unitVal.hide();
						processMethodVal.hide();
						conFact.hide();
						alrmDisp.hide();
						contVal.show();
					}
				//	else
				//	{
				//		dbColSize1.show();
				//		unitVal.show();
				//		processMethodVal.show();
				//		conFact.show();
				//		alrmDisp.show();
				//		contVal.show();
				//	}
				}
			}
		}
	},
	showAddNewMeasure: function()
	{
		var me = this;
		Ext.create('Ext.window.Window', {
			padding:'3 10 10 10',
			title: newMeasDetail,
			width: 500,
			id:'addPerfmonMeasureWindow',
			layout:{
				type:'vbox',
				pack:'start',
				align:'center'
			},
			defaults: {
				labelSeparator: '',
				margin: 5,
				width: 400,
				labelWidth: 200
			},
			modal: true,
			resizable: false,
			items:[ 
				{
					xtype: 'textfield',
					cls : 'textbox',
					fieldLabel: measIdx,
					id:'index',
					name:'index',
					margin: '10 5 0 5'
				},
				{
					xtype: 'textfield',
					cls : 'textbox',
					fieldLabel: measName,
					id:'measure',
					name:'measure',
					maxLength: 24,
					enforceMaxLength: true
				},
				{
					xtype: 'scrollcombo',
					cls : 'dropdown',
					id:'dbsize',
					name:'dbsize',
					fieldLabel: dbColSize,
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : []
					}),
					displayField:'displayField',
					valueField:'valueField',
					queryMode : 'local',
					editable: false
				},
				{
					xtype: 'scrollcombo',
					cls : 'dropdown',
					id:'un',
					name:'un',
					fieldLabel: unit,
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : []
					}),
					displayField:'displayField',
					valueField:'valueField',
					queryMode : 'local',
					//editable: false,
					listeners:
					{
						select:{
							fn: function (id){
								me.otherUnit('add');
							}
						}
					}
				},
				{
					xtype: 'textfield',
					cls : 'textbox',
					fieldLabel: other,
					id:'otherunit',
					name:'otherunit',
					hidden: true,
					maxLength: 64,
					enforceMaxLength: true
				},
				{
					xtype: 'scrollcombo',
					cls : 'dropdown',
					id:'process',
					name:'process',
					fieldLabel: procMthd,
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : []
					}),
					displayField:'displayField',
					valueField:'valueField',
					queryMode : 'local',
					editable: false,
					listeners:
					{
						select:{
							fn: function (id){
								me.processMethodChange('add');
							}
						}
					}
				},
				{
					xtype: 'scrollcombo',
					cls : 'dropdown',
					id:'cFactor',
					name:'cFactor',
					fieldLabel: convFact,
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : []
					}),
					displayField:'displayField',
					valueField:'valueField',
					queryMode : 'local',
					editable: false
				},
				{
					xtype: 'textfield',
					cls : 'textbox',
					fieldLabel: alrmDispStr,
					id:'alarmdescription',
					name:'alarmdescription',
					maxLength: 75,
					enforceMaxLength: true
				},
				{
					xtype: 'textfield',
					cls : 'textbox',
					fieldLabel: counterName,
					id:'counter',
					name:'counter',
					maxLength: 100,
					enforceMaxLength: true
				},
				{
					xtype: 'button',
					cls :'button20',
					text: add,
					id:'addMeasureButton',
					width: 80,
					listeners:
					{
						click:{
							fn: function (id){
								me.doAddNewMeasure();
							}
						}
					},
					margin: '5 5 20 5'
				}
			]
		}).show();

		var process = '';
		Ext.getCmp('index').setValue(publicJSON.measIndex);
		var dbSizeObj = Ext.getCmp('dbsize');
		var alrmDescObj = Ext.getCmp('alarmdescription');
		var unitObj = Ext.getCmp('un');
		var processObj = Ext.getCmp('process');
		var convFactObj = Ext.getCmp('cFactor');
		if (isConfigTest)
		{
			dbSizeObj.hide();
			alrmDescObj.hide();
			unitObj.hide();
			processObj.hide();
		}
		else
		{
			dbSizeObj.show();
			dbSizeObj.getStore().loadRawData(publicJSON.dbColSizeList);
			dbSizeObj.setValue("2");
			alrmDescObj.show();
			Ext.getCmp('process').getStore().loadRawData(publicJSON.processMethodList);
			process = publicJSON.selectedProcessMethod;
			Ext.getCmp('process').setValue(process);
			Ext.getCmp('un').getStore().loadRawData(publicJSON.unitsList);
			Ext.getCmp('un').setValue("-1");
		}
		if (process == 'UNALTERED' || process == 'DIFFERENCE')
		{
			convFactObj.show();
			convFactObj.getStore().loadRawData(publicJSON.convFactorList);
			convFactObj.setValue(publicJSON.convFactorSelected);
		}
		else
		{
			convFactObj.hide();
		}
	},
	otherUnit: function(from)
	{
		var unitObj = Ext.getCmp('un');
		var otherUnitObj = Ext.getCmp('otherunit');
		if (from == 'modify')
		{
			unitObj = Ext.getCmp('s_un');
			otherUnitObj = Ext.getCmp('s_otherunit');
		}

		if(unitObj.getValue() == 'other')
		{
			otherUnitObj.show();
			otherUnitObj.enable();
		}
		else
		{
			otherUnitObj.hide();
			otherUnitObj.disable();
		}
	},
	processMethodChange: function(from)
	{
		var process;
		var factorObj;
		if (from == 'add')
		{
			process = Ext.getCmp('process').getValue();
			factorObj = Ext.getCmp('cFactor');
		}
		else if (from == 'modify')
		{
			process = Ext.getCmp('s_process').getValue();
			factorObj = Ext.getCmp('s_factor');
			factorObj.getStore().loadRawData(publicJSON.convFactorList);
			factorObj.setValue(publicJSON.convFactorSelected);
		}

		if (process == 'UNALTERED' || process == 'DIFFERENCE')
		{
			factorObj.show();
			factorObj.enable();
		}else
		{
			factorObj.hide();
			factorObj.disable();
		}
	},
	doAddNewMeasure: function()
	{
		var me = this;
		var test = Ext.getCmp('test').getValue();
		var index = Ext.getCmp('index').getValue();
		var measure = Ext.getCmp('measure').getValue();
		var factor = Ext.getCmp('cFactor').getValue();
		var dbSize = Ext.getCmp('dbsize').getValue();
		var otherUnit = Ext.getCmp('otherunit').getValue();
		var unit = Ext.getCmp('un').getValue();
		var alrmDesc = Ext.getCmp('alarmdescription').getValue();
		var process = Ext.getCmp('process').getValue();
		var counter = Ext.getCmp('counter').getValue();
		if(process == null && isConfigTest)
		{
			process = 'UNALTERED';
			factor = '1';
		}
		if (process != 'UNALTERED' && process != 'DIFFERENCE')
		{
			factor = 'none';
		}
		var urlStr =  'ICTest/data/EgconfigperfmonmeasurepJson.jsp?add=add&test='+test+'&measure='+measure+'&factor='+factor+'&counter='+encodeURIComponent(counter);
		urlStr += '&dbsize='+dbSize+'&otherunit='+otherUnit+'&un='+encodeURIComponent(filterEncode(unit))+'&alarmdescription='+encodeURIComponent(alrmDesc)+'&index='+index+'&process='+process;

		if (!this.measureValidation(measure,unit,otherUnit,alrmDesc,counter))
		{
			return;
		}
		
		Ext.Ajax.request(
		{
			url: urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});

		if (publicJSON.AlertType == 'Error')
		{
			Ext.Msg.show({
				title: error+': '+publicJSON.AlertTitle,
				msg: publicJSON.AlertMsg,
				buttons: Ext.Msg.OK,
				icon: 'iconError'
			});
		}
		else if (publicJSON.AlertType == 'Result')
		{
			Ext.getCmp('generateCntnr').enable();
			Ext.getCmp('tab6Help').enable();
			Ext.Msg.show({
				title: publicJSON.AlertTitle,
				msg: publicJSON.AlertMsg + ' '+ alertMsg80,
				closable: false,
				buttons: Ext.Msg.YESNO,
				icon: 'iconInformation',
				fn: function(response) {
					if(response == 'yes') {
						Ext.getCmp('addPerfmonMeasureWindow').close();
						var urlToProcess = publicJSON.forwardURL;
						me.loadAddMeasureTab(urlToProcess);
						me.showAddNewMeasure();
					}
					else if (response == 'no')
					{
						Ext.getCmp('addPerfmonMeasureWindow').close();
						var urlToProcess = publicJSON.forwardURL;
						me.loadAddMeasureTab(urlToProcess);

						//Ext.getCmp('generateCntnr').enable();
						//Ext.getCmp('tab6Help').enable();
						Ext.getCmp('newtest').setActiveTab(3);
					}
				}
			});
		}
	},
	measureValidation: function(meas,unit,otherUnit,alarmStr,counter)
	{
		var me=this;
		var measObj = Ext.getCmp('measure');
		var alrmStrObj = Ext.getCmp('alarmdescription');
		var otherUnitObj = Ext.getCmp('otherunit');
		var counterObj = Ext.getCmp('counter');

		var keyArr = new Array("other","none","null","all");
		var isConfigTest = false;
		var alarmDispStr=true;
		var type = Ext.getCmp('type').getValue()
		if (type != null && type == 'Configuration')
		{
			isConfigTest = true;
		}
		if (!isConfigTest)
		{
			if(!me.checkSpecialChar(alarmStr,"~!@#$%^&*()|:,;'<>"))
			{
				Ext.Msg.show({
					title: newMeasDetail,
					msg: splCharAlert,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				alrmStrObj.focus(true);
				return false;				
			}
			if(isDouble=="false")
			{
				alarmDispStr = validateSingleByte(alarmStr);
			}
		}
		meas = meas.toUpperCase();
		if(meas == "TRGT_HOST" || meas == "PORT_NO"
			|| meas == "SITE_NAME" || meas == "INFO"
			|| meas == "MSMT_HOST" || meas == "MSMT_TIME")   
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg14,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}
		var ch = meas.charAt(0);
		var un=!isConfigTest?unit:"NONE";
		if(!checkblank(meas))
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg15,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			measObj.focus(true);
			return false;
		}
		else if(!checkspace(meas))
		{
			measObj.focus(true);
			return false;
		}
		else if(!checkspecialnomess(meas, "`~!@#$%^&*()+=-/?'\"]{}[\\|;:.,><"))
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg3,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			measObj.focus(true);
			return false;
		}
		else if(ch >= '0' && ch <= '9')
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg16,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			measObj.focus(true);
			return false;
		}
		else if(ch == '_')
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg17,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			measObj.focus(true);
			return false;
		}
		else if(!validateSingleByte(meas))
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg18,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			measObj.focus(true);
			return false;
		}
		else if(un == "-1")
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg19,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}
		else if(!alarmDispStr)
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg20,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			alrmStrObj.focus(true);
			return false;
		}
		else if(un == "other")
		{
			if(!checkblank(otherUnit))
			{
				Ext.Msg.show({
					title: newMeasDetail,
					msg: alertMsg21,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return false;
			}
			else if(!checkspace(otherUnit))
			{
				otherUnitObj.focus(true);
				return false;
			}
			else if(!checkspecialnomess(otherUnit, "`~!@#^&*()+=-?'\"]{}[\\|;:.,><"))
			{
				Ext.Msg.show({
					title: newMeasDetail,
					msg: alertMsg3,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				otherUnitObj.focus(true);
				return false;
			}
			else if (!checkKeywords(otherUnit,keyArr))
			{
				Ext.Msg.show({
					title: newMeasDetail,
					msg: alertMsg22,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				otherUnitObj.focus(true);
				return false;
			}
		}
		else if(!checkblank(counter))
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg41,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			counterObj.focus(true);
			return false;
		}
		else if(!validateSingleByte(counter))
		{
			Ext.Msg.show({
				title: newMeasDetail,
				msg: alertMsg42,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			counterObj.focus(true);
			return false;
		}

		return true;
	},
	deleteMeasure: function(deleteURL, measureName)
	{
		var me = this;
		Ext.Msg.show({
			title: addMeasure,
			msg: alertMsg45+ ' \''+measureName+'\'?',
			buttons: Ext.Msg.OKCANCEL,
			icon: 'iconConfirmation',
			fn: function(response) {
				if(response == 'ok') {
					Ext.Ajax.request(
					{
						url: 'ICTest/data/'+deleteURL,
						method: 'POST',
						async:false,
						success: function( response )
						{
							if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
							{
								var jsonText = response.responseText;
								publicJSON = Ext.decode( jsonText );
							}
						}
					});
					if (publicJSON.AlertType=='Result')
					{
						Ext.Msg.show({
							title: publicJSON.AlertTitle,
							msg:publicJSON.AlertMsg,
							buttons: Ext.Msg.OK,
							icon: 'iconInformation',
							fn: function(response) {
								if(response == 'ok') {
									Ext.getCmp('addMeasureTab').enable();
									var urlToProcess = publicJSON.forwardURL;
									me.loadAddMeasureTab(urlToProcess);
								}
							}
						});
					}
				}
			}
		});
	},
	generatePerfmonTest: function()
	{
		var objObj = Ext.getCmp('object');
		var object = objObj.getValue();
		var instObj = Ext.getCmp('instances');
		var instances = instObj.getValue();
		var instExObj = Ext.getCmp('instances_neg');
		var instEx = instExObj.getValue();

		if(!checkblank(object))
		{
			Ext.Msg.show({
				title: generate,
				msg: alertMsg75,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(response) {
					if(response == 'ok') {
						objObj.focus(true);
					}
				}
			});
			return;
		}
		else if(!validateSingleByte(object))
		{
			Ext.Msg.show({
				title: generate,
				msg: alertMsg76,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(response) {
					if(response == 'ok') {
						objObj.focus(true);
					}
				}
			});
			return;
		}
		else if(!validateSingleByte(instances))
		{
			Ext.Msg.show({
				title: generate,
				msg: alertMsg43,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(response) {
					if(response == 'ok') {
						instObj.focus(true);
					}
				}
			});
			return;
		}
		else if(!validateSingleByte(instEx))
		{
			Ext.Msg.show({
				title: generate,
				msg: alertMsg44,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(response) {
					if(response == 'ok') {
						instExObj.focus(true);
					}
				}
			});
			return;
		}
	
		var test = Ext.getCmp('test').getValue();
		var urlStr =  'ICTest/data/EgconfigperfmonmeasurepJson.jsp?add=gen&test='+test+'&object='+object+'&instances='+instances+'&instances_neg='+instEx;
	
		if (isConfigTest)
		{
			var dbSize = Ext.getCmp('dbSizeGen').getValue();
			var desvVal = Ext.getCmp('isDescriptorBasedTestPerfmon').getValue();
			urlStr += '&dbsize='+dbSize+'&descVal='+desvVal;
		}

		Ext.Ajax.request(
		{
			url: urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});

		if(publicJSON.objectError)
		{
			Ext.Msg.show({
				title: publicJSON.AlertTitle,
				msg: alertMsg83,
				buttons: Ext.Msg.OK,
				icon: 'iconError',
				fn: function(response) {
					if(response == 'ok') {
						objObj.focus(true);
					}
				}
			});
		}
		else if(publicJSON.NonDescriptorObjError)
		{
			Ext.Msg.show({
				title: publicJSON.AlertTitle,
				msg: alertMsg84,
				buttons: Ext.Msg.OK,
				icon: 'iconError',
				fn: function(response) {
					if(response == 'ok') {
						objObj.focus(true);
					}
				}
			});
		}
		else
		{
			if (publicJSON.oldObjectName != "")
			{
				Ext.Msg.show({
					title: generate,
					msg: alertMsg30,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(response) {
						if(response == 'ok') {
							if (publicJSON.AlertType=='Error')
							{
								Ext.Msg.show({
									title: publicJSON.AlertTitle,
									msg: publicJSON.AlertMsg,
									buttons: Ext.Msg.OK,
									icon: 'iconError'
								});
							}
							else if (publicJSON.AlertType=='Result')
							{
								Ext.Msg.show({
									title: publicJSON.AlertTitle,
									msg:publicJSON.AlertMsg,
									buttons: Ext.Msg.OK,
									icon: 'iconInformation',
									fn: function(response) {
										if(response == 'ok') {
											window.location.href= '/final/admin/EgUDTest.jsp';
										}
									}
								});
							}
						}
					}
				});
			}
		}

		if (!Ext.isEmpty(publicJSON.forwardURL))
		{
			this.getController('ICTest.controller.ThresholdCtrlr').init();
			var genCntnrObj = Ext.getCmp('generateCntnr');
			genCntnrObj.removeAll();
			var urlStr = publicJSON.forwardURL;
			qString = 'ICTest/data/'+urlStr;
			genCntnrObj.add({
				xtype : 'defaultthresholds'
			});
		}

	},
	showModifyMeasure: function(modifyURL)
	{
		var publicJSONTmp;
		Ext.Ajax.request(
		{
			url: 'ICTest/data/'+modifyURL+'&testType=Perfmon',
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSONTmp = Ext.decode( jsonText );
				}
			}
		});
		Ext.create('Ext.window.Window', {
			padding:'3 10 10 10',
			title: modMeas,
		//	height: 325,
			width: 500,
			id:'modScriptMeasureWindow',
			modal: true,
			resizable: false,
			items:[ 
				{
					xtype: 'form',
					id: 'measureform',
					name: 'measureform',
					url: 'ICTest/data/EgmodifymeasurespJson.jsp',
				//	height: 325,
					width: 500,
					layout:{
						type:'vbox',
						pack:'start',
						align:'center'
					},
					defaults: {
						labelSeparator: '',
						margin: 5,
						width: 400,
						labelWidth: 200
					},
					items:[
						{
							xtype: 'textfield',
							cls : 'textbox',
							fieldLabel: measName,
							id:'s_measure',
							name:'s_measure',
							maxLength: 24,
							enforceMaxLength: true,
							value: publicJSONTmp.measureName,
							margin: '10 5 0 5'
						},
						{
							xtype: 'scrollcombo',
							cls : 'dropdown',
							id:'s_dbsize',
							name:'s_dbsize',
							fieldLabel: dbColSize,
							store: new Ext.data.Store({
								fields : ['displayField', 'valueField'],
								data : []
							}),
							displayField:'displayField',
							valueField:'valueField',
							queryMode : 'local',
							editable: false,
							hidden: isConfigTest//new feed
						},
						{
							xtype: 'scrollcombo',
							cls : 'dropdown',
							id:'s_un',
							name:'s_un',
							fieldLabel: unit,
							store: new Ext.data.Store({
								fields : ['displayField', 'valueField'],
								data : []
							}),
							displayField:'displayField',
							valueField:'valueField',
							queryMode : 'local',
							//editable: false,
							hidden: isConfigTest,//new feed
							listeners:
							{
								select:{
									fn: function (id){
										perfmonCtrlr.otherUnit('modify');
									}
								}
							}
						},
						{
							xtype: 'textfield',
							cls : 'textbox',
							fieldLabel: other,
							id:'s_otherunit',
							name:'s_otherunit',
							hidden: true,
							maxLength: 64,
							enforceMaxLength: true
						},
						{
							xtype: 'scrollcombo',
							cls : 'dropdown',
							id:'s_process',
							name:'s_process',
							fieldLabel: procMthd,
							store: new Ext.data.Store({
								fields : ['displayField', 'valueField'],
								data : []
							}),
							displayField:'displayField',
							valueField:'valueField',
							queryMode : 'local',
							editable: false,
							hidden: isConfigTest,//new feed
							listeners:
							{
								select:{
									fn: function (id){
										perfmonCtrlr.processMethodChange('modify');
									}
								}
							}
						},
						{
							xtype: 'scrollcombo',
							cls : 'dropdown',
							id:'s_factor',
							name:'s_factor',
							fieldLabel: convFact,
							store: new Ext.data.Store({
								fields : ['displayField', 'valueField'],
								data : []
							}),
							displayField:'displayField',
							valueField:'valueField',
							queryMode : 'local',
							editable: false,
							hidden: isConfigTest//new feed
						},
						{
							xtype: 'textfield',
							cls : 'textbox',
							fieldLabel: alrmDispStr,
							id:'alarmdescription',
							name:'alarmdescription',
							maxLength: 75,
							enforceMaxLength: true,
							value: publicJSONTmp.alarmDispStrValue,
							hidden: isConfigTest//new feed
						},
						{
							xtype: 'textfield',
							cls : 'textbox',
							fieldLabel: counterName,
							id:'s_counter',
							name:'s_counter',
							maxLength: 100,
							enforceMaxLength: true,
							value: publicJSONTmp.counterValue
						},
						{
							xtype: 'button',
							cls : 'button20',
							text: modifyTooltip,
							id:'modMeasureButton',
							width: 80,
							margin: '5 5 20 5',
							listeners:
							{
								click:{
									fn: function (id){
										var measure = Ext.getCmp('s_measure').getValue();
										var unit = Ext.getCmp('s_un').getValue();
										var otherUnit = Ext.getCmp('s_otherunit').getValue();
										var alrmDesc = Ext.getCmp('alarmdescription').getValue();
										var counter = Ext.getCmp('s_counter').getValue();
										if (!perfmonCtrlr.measureValidation(measure,unit,otherUnit,alrmDesc,counter))
										{
											return;
										}	
										var uploadformObj = Ext.getCmp('measureform').getForm();
										if (uploadformObj.isValid())
										{
											var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: updating+'...'});
											var perfmform = encodeFieldParams(uploadformObj);

											tmpMask.show();
											uploadformObj.submit({
												method : 'POST',
												params : perfmform,
												success: function (form, action) {
													tmpMask.hide();
													var jsonText = action.response.responseText;
													var tmpResult = Ext.decode(jsonText);

													if(tmpResult.AlertType == 'Result')
													{
														var test = Ext.getCmp('test').getValue();
														var urlStr = "EgConfigPerfmonMeasureJson.jsp?test=" + test;
														perfmonCtrlr.loadAddMeasureTab(urlStr);
														Ext.Msg.show({
															title: tmpResult.AlertTitle,
															msg: tmpResult.AlertMsg,
															buttons: Ext.Msg.OK,
															icon: 'iconInformation',
															fn: function(response) {
																if(response == 'ok') {
																	Ext.getCmp('newtest').setActiveTab(3);
																}
															}
														});
													}
													else if(tmpResult.AlertType == 'Error')
													{
														Ext.Msg.show({
															title: tmpResult.AlertTitle,
															msg: tmpResult.AlertMsg,
															buttons: Ext.Msg.OK,
															icon: 'iconError',
															fn: function(response) {
																if(response == 'ok') {
																	var test = Ext.getCmp('test').getValue();
																	var urlStr = "EgConfigPerfmonMeasureJson.jsp?test=" + test;
																	perfmonCtrlr.loadAddMeasureTab(urlStr);
																}
															}
														});
													}
												}
											});
										}
										Ext.getCmp('modScriptMeasureWindow').close();
									}
								}
							}
						},
						{
							xtype: 'container',
							id:'hiddenContnr',
							hidden:true
						}
					]
				}
			]
		}).show();
		
		if(!isConfigTest)//new feed
		{
			Ext.getCmp('s_dbsize').getStore().loadRawData(publicJSONTmp.dbColSizeList);
			Ext.getCmp('s_dbsize').setValue(publicJSONTmp.dbColSizeSelected);
			Ext.getCmp('s_un').getStore().loadRawData(publicJSONTmp.unitsList);
			Ext.getCmp('s_un').setValue(publicJSONTmp.unitSelected);
			Ext.getCmp('s_process').getStore().loadRawData(publicJSONTmp.processMethodList);
			Ext.getCmp('s_process').setValue(publicJSONTmp.selectedProcessMethod);
			var convFactObj = Ext.getCmp('s_factor');
			if (!publicJSONTmp.hideConvFactor)
			{				
				convFactObj.show();
				convFactObj.getStore().loadRawData(publicJSONTmp.convFactorList);
				convFactObj.setValue(publicJSONTmp.convFactorSelected);
			}
			else{
				convFactObj.hide();
			}
		}
		else
		{
			Ext.getCmp('measureform').setHeight(100);
			Ext.getCmp('modScriptMeasureWindow').setHeight(150);
		}
		var hiddenParams = publicJSONTmp.hiddens;
		var me = Ext.getCmp('hiddenContnr');
		me.removeAll();
		for (var param in hiddenParams) {
				me.add({
					xtype: 'hidden',
					name: param,
					value: hiddenParams[param]
				});
		}
	},
	checkSpecialChar: function(field,s_spl)
	{
		if (typeof(field)=='object')
		{
			obj_val = field.value;
		}
		else
		{
			obj_val = field;
		}
		for(var i=0; i<obj_val.length; i++)
		{
			check_char = s_spl.indexOf(obj_val.charAt(i))
			//Returns value 1 if the special character listed in splChar is found
			if(check_char >= 0)
			{
				//alert(_checkspecial);
				return false;
			}
		}
		return true;
	}
});



