var isConfigSupported = "";
Ext.define('ICTest.controller.AddTestCtrlr',{
	extend:'Ext.app.Controller',
	views:['AddNewTest','AddHelp'],
	requires:['ICTest.view.AddNewTest'],
	refs:[
		{selector:'addnewtest', ref:'addnewtest'},
		{selector:'customgenerate', ref:'customgenerate'},
		{selector:'scriptgenerate', ref:'scriptgenerate'},
		{selector:'sqlgenerate', ref:'sqlgenerate'},
		{selector:'perfmongenerate', ref:'perfmongenerate'},
		{selector:'snmpgenerate', ref:'snmpgenerate'},
		{selector:'jmxgenerate', ref:'jmxgenerate'},
		{selector:'addhelp', ref:'addhelp'},
		{selector:'defaultthresholds', ref:'defaultthresholds'},
		{selector:'addhelp #formContainer', ref:'testHelpApp'}
	],
	init:function(){
		addctrler = this;
		this.buildMainData();
		isConfigSupported = publicJSON.isConfigSupported;
		this.control({
			'addnewtest':
			{
				'afterrender': this.afterMainRender
			},
			'addnewtest button[id="add"]':
			{
				'click':this.addTest
			},
			'addnewtest radiogroup[id="duplicatetest"]':
			{
				'change': this.duplicateSelection
			},
			'addnewtest button[id="backButton"]':
			{
				'click':this.goBack
			},
			'addnewtest combo[id="testType"]':
			{
				'select':this.testTypeSelection
			},
			'addnewtest combo[id="type"]':
			{
				'select':this.typeSelection
			},
			'addnewtest combo[id="nonDupTest"]':
			{
				'select':this.duplicateComboChange
			},
			'addnewtest button[id="addNewParam"]':
			{
				'click':this.showAddNewParam
			},
			'addnewtest button[id="addNewMeasure"]':
			{
				'click':this.showAddMeasure
			},
			'addnewtest button[id="configureMetricsBtn"]':
			{
				'click':this.showConfigMetricsPopup
			},
			'addnewtest button[id="chooseClass"]':
			{
				'click':this.showClassFileUpload
			},
			'addnewtest button[id="chooselLib"]':
			{
				'click':this.showLibFileUpload
			},
			'addnewtest button[id="generate"]':
			{
				'click':this.generateTest
			},
			'addnewtest button[id="ddChooseClass"]':
			{
				'click':this.showDDClassFileUpload
			},
			'addnewtest button[id="ddChooselLib"]':
			{
				'click':this.showDDLibFileUpload
			},
			'addnewtest button[id="ddGenerate"]':
			{
				'click':this.generateDDTest
			},
			'addnewtest button[id="addNewDDMeasure"]':
			{
				'click':this.showAddNewDDMeasure
			},
			'addnewtest button[id="chooseScript"]':
			{
				'click':this.showScriptFileUpload
			},
//			'addnewtest radiogroup[id="elements"]':
//			{
//				'change': snmpCtrlr.elementsSelection
//			},
			'addnewtest combo[id="tempgroup"]':
			{
				'select':this.loadHelpTemplate
			}
		});
	},
	buildMainData: function()
	{
		Ext.Ajax.request(
		{
			url: 'ICTest/data/EgAddUDTestJson.jsp',
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},
	tabchange : function(tabPanel)
	{
		var selectedTab = tabPanel.getActiveTab().id;
		var testType = Ext.getCmp('testType').getValue();
		if (testType == 'Script/Batch File')
		{
			testType = 'ScriptBatchFile';
		}
		else if (testType.toLowerCase() == 'sql query')
		{
			testType = 'SqlQuery';
		}
		Ext.Ajax.request({
			url: 'ICTest/data/ictesthelpJson.jsp?selectTab='+selectedTab+'&testType='+testType,
			method: 'POST',
			async: false
		});
	},
	tabHelp : function()
	{
		var selectedConTab = Ext.getCmp('newtest').getActiveTab().id;
		var testType = Ext.getCmp('testType').getValue();
		if (testType == 'Script/Batch File')
		{
			testType = 'ScriptBatchFile';
		}
		else if (testType.toLowerCase() == 'sql query')
		{
			testType = 'SqlQuery';
		}
		Ext.Ajax.request({
			url: 'ICTest/data/ictesthelpJson.jsp?selectTab='+selectedConTab+'&testType='+testType,
			method: 'POST',
			async: false
		});
	},
	afterMainRender: function()
	{
		var me = this;
		//isConfigSupported = publicJSON.isConfigSupported;
		var testTypeObj = Ext.getCmp('testType');
		testTypeObj.getStore().loadRawData(publicJSON.testTypes);
		testTypeObj.setValue(publicJSON.testTypeSelected);
		var typeObj = Ext.getCmp('type');
		typeObj.hide();
		if(isConfigSupported)
		{
			typeObj.show();
			typeObj.getStore().loadRawData(publicJSON.types)
			typeObj.setValue(publicJSON.typeSelected);
		}
		Ext.getCmp('test').setValue('_ex');

		var dupTestObj = Ext.getCmp("duplicatetest");
		if(publicJSON.showDuplicate)
		{
			dupTestObj.show();
			dupTestObj.enable();
		}
		else
		{
			dupTestObj.hide();
			dupTestObj.disable();
		}
		me.tabHelp();
	//	if (ddEnabled == 'true')
	//	{
	//		Ext.getCmp('newtest').child('#tab5DD').tab.show();
	//	}
		
	},
	goBack: function()
	{
		window.location.href= '/final/admin/EgUDTest.jsp';
	},
	duplicateSelection: function()
	{
		var selVal = Ext.getCmp('duplicatetest').getValue().duprb;
		var dupList = Ext.getCmp('nonDupTest')
		var elmtsCntnrObj = Ext.getCmp('elmtsCntnr');
		var labelObj = Ext.getCmp('testTypeLabel');
		var testName = Ext.getCmp('test').getValue();
		var typeObj = Ext.getCmp('type').getValue();
		/*var typeObj = '';
		if(isConfigSupported)
		{
			typeObj = Ext.getCmp('type').getValue();
		}
		else{
			typeObj = 'Performance';
		}*/
		
		if (testName.indexOf("_ex") > -1 && (typeObj == undefined || typeObj == null || typeObj == "Performance"))
		{
			typeObj = "Performance";
		}
		else if (testName.indexOf("_cf_ex") == -1 || typeObj == "Configuration")
		{
			typeObj = "Configuration";
		}
		Ext.Ajax.request(
		{
			url: 'ICTest/data/EgAddUDTestJson.jsp?testtype='+typeObj,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});

		if (selVal=='Yes')
		{
			dupList.show();
			dupList.enable();
			dupList.getStore().removeAll();
			dupList.getStore().loadRawData(publicJSON.dupTestList);
			dupList.setValue(publicJSON.selectedDupeTest);
			elmtsCntnrObj.hide();
			elmtsCntnrObj.disable();
			labelObj.hide();
		}
		else
		{
			dupList.hide();
			dupList.disable();
			labelObj.hide();
			elmtsCntnrObj.show();
			elmtsCntnrObj.enable();
		}
	},
	duplicateComboChange: function()
	{
		var test = Ext.getCmp('test').getValue();
		var dupBaseTest = Ext.getCmp('nonDupTest').getValue();
		var urlStr = 'EgAddUDTestJson.jsp?test='+test+'&duplicateTest=true&testToBeDuplicated='+dupBaseTest;
		Ext.Ajax.request(
		{
			url: 'ICTest/data/'+urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
		Ext.getCmp('test').setValue(test);
		if (publicJSON.testTypeAsLabel)
		{
			var labelObj = Ext.getCmp('testTypeLabel');
			labelObj.show();
			labelObj.setValue(publicJSON.testType);
		}
	},
	testTypeSelection: function()
	{
		var testType = Ext.getCmp('testType').getValue();
		var osTypeObj = Ext.getCmp('ostype');
		var dbTypeObj = Ext.getCmp('dbType');
		if (testType == 'Script/Batch File')
		{
			osTypeObj.show();
			osTypeObj.enable();
			dbTypeObj.hide();
			dbTypeObj.disable();
			Ext.getCmp('newtest').getTabBar().items.items[2].hide();
		}
		else if (testType.toLowerCase() == 'sql query')
		{
			dbTypeObj.show();
			dbTypeObj.enable();
			osTypeObj.hide();
			osTypeObj.disable();
			
			this.buildMainData();
			dbTypeObj.getStore().loadRawData(publicJSON.dbTypes);
			dbTypeObj.setValue(publicJSON.dbTypeSelected);
			Ext.getCmp('newtest').getTabBar().items.items[2].hide();
		}
		else if(testType == 'REST')
		{
			Ext.getCmp('newtest').getTabBar().items.items[2].show();
		}
		else
		{
			dbTypeObj.hide();
			dbTypeObj.disable();
			osTypeObj.hide();
			osTypeObj.disable();
			Ext.getCmp('newtest').getTabBar().items.items[2].hide();
		}
	},
	typeSelection : function()
	{
		var typeVal = Ext.getCmp('type').getValue();
		var isDuplicate = Ext.getCmp('duplicatetest').getValue().duprb;
		var dupList = Ext.getCmp('nonDupTest')

		if(isDuplicate == 'Yes')
		{
			Ext.Ajax.request(
			{
				url: 'ICTest/data/EgAddUDTestJson.jsp?testtype='+typeVal,
				method: 'POST',
				async:false,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						rootJson = Ext.decode( jsonText );
					}
				}
			});
			dupList.getStore().loadRawData(rootJson.dupTestList);
			dupList.setValue(rootJson.selectedDupeTest);
		}
		if(typeVal == "Performance")
		{
			Ext.getCmp('test').setValue('_ex');
			Ext.getCmp('test').focus(false, 200);
		}
		else if(typeVal == "Configuration")
		{
			Ext.getCmp('test').setValue('_cf_ex');
			Ext.getCmp('test').focus(false, 200);
		}
	},
	addTest: function()
	{
		isModifyTest = false;
		if (testTabLoad)
		{
			this.testModifyAlone();
			return;
		}
		//isModifyTest = false;
		var me = this;
		if (this.validate() == false)
		{
			return;
		}

		var isDuplicate = Ext.getCmp('duplicatetest').getValue().duprb;
		if (isDuplicate == 'Yes')
		{
			this.doDuplicate();
			return;
		}
		/*var type = '';
		if(isConfigSupported)
		{
			type = Ext.getCmp('type').getValue();
		}
		else{
			type = 'Performance';
		}*/
		
		var test = Ext.getCmp('test').getValue();
		var type = Ext.getCmp('type').getValue();
		var testType = Ext.getCmp('testType').getValue();
		var port = Ext.getCmp('port').getValue().portrb;
		var execution = Ext.getCmp('execution').getValue().exerb;
		
		if (test.indexOf("_ex") > -1 && (type == undefined || type == null || type == "Performance"))
		{
			type = "Performance";
		}
		else if (test.indexOf("_cf_ex") == -1 && type == "Configuration")
		{
			type = "Configuration";
		}

		var urlStr = "EgaddudtestpJson.jsp?add=test&test="+test+"&typeVal="+type+"&testtype="+testType+"&port="+port+"&type="+execution;
		if (testType.toLowerCase() == 'sql query')
		{
			var dbType = Ext.getCmp('dbType').getValue();
			urlStr += "&dbType=" + dbType;
		}
		else if (testType == 'Script/Batch File')
		{
			var osType =  Ext.getCmp('ostype').getValue().ostyperb;
			urlStr += "&os="+ osType;
		}
		if (test.indexOf('_cf_ex') > -1 )
		{
			isConfigTest = true;
		}
		
		Ext.Ajax.request(
		{
			url: 'ICTest/data/'+urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});

		if (publicJSON.AlertType == 'Error')
		{
			Ext.Msg.show({
					title: error+': '+publicJSON.AlertTitle,
					msg:publicJSON.AlertMsg,
					buttons: Ext.Msg.OK,
					icon: 'iconError'
				});
		}
		else if (publicJSON.AlertType == 'Result')
		{
			Ext.Msg.show({
				title: publicJSON.AlertTitle,
				msg:publicJSON.AlertMsg,
				closable: false,
				buttons: Ext.Msg.OK,
				icon: 'iconInformation',
				width: 300,
				fn: function(response) {
						if(response == 'ok') {
							
							
							Ext.getCmp('addMeasureTab').enable();
							if(testType!=null && testType == 'REST')
							{
								Ext.getCmp('newtest').getTabBar().items.items[2].enable();
								Ext.getCmp('datasetTab').enable();
								Ext.getCmp('newtest').getTabBar().items.items[1].hide();
								Ext.getCmp('newtest').getTabBar().items.items[4].hide();
								Ext.getCmp('newtest').setActiveTab(2);
								isRESTTestType=true;
							}
							else
							{
								Ext.getCmp('addParamTab').enable();
								Ext.getCmp('newtest').setActiveTab(1);
								Ext.getCmp('addMeasureTab').enable();
								Ext.getCmp('newtest').getTabBar().items.items[2].disable();
								Ext.getCmp('datasetTab').disable();
								var urlToProcess = publicJSON.forwardURL;
								me.loadAddParamTab(urlToProcess);
							}
							
						}
					}
			});
		}
		me.tabHelp();
	},
	doDuplicate:function()
	{
		var testName = Ext.getCmp('test').getValue();
		var typeVal = Ext.getCmp('type').getValue();
		
		if (testName.indexOf("_ex") > -1 && (typeVal == undefined || typeVal == null || typeVal == "Performance"))
		{
			typeVal = "Performance";
		}
		else if (testName.indexOf("_cf_ex") == -1 && typeVal == "Configuration")
		{
			typeVal = "Configuration";
		}
		//var typeVal = "";
		/*if(isConfigSupported)
		{
			typeVal = Ext.getCmp('type').getValue();
		}
		else
		{
			typeVal = "Performance";
		}*/
		var testType = Ext.getCmp('testTypeLabel').getValue();
		var baseTest = Ext.getCmp('nonDupTest').getValue();
		var urlStr = "EgDuplicateTestJson.jsp?testName="+baseTest+"&testType="+testType+"&duplicate="+testName+"&typeVal="+typeVal;
		Ext.Ajax.request(
		{
			url: 'ICTest/data/'+urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
		if (publicJSON.AlertType == 'Error')
		{
			Ext.Msg.show({
					title: error+': '+publicJSON.AlertTitle,
					msg:publicJSON.AlertMsg,
					buttons: Ext.Msg.OK,
					icon: 'iconError'
				});
		}else if (publicJSON.AlertType == 'Result')
		{
			Ext.Msg.show({
					title:publicJSON.AlertTitle,
					msg:publicJSON.AlertMsg,
					buttons: Ext.Msg.OK,
					icon: 'iconInformation',
					fn: function(response) {
							if(response == 'ok') {
								window.location.href= '/final/admin/EgUDTest.jsp';
							}
						}
				});
		}
	},
	validate:function()
	{
		var testObj = Ext.getCmp('test');
		var typeObj = Ext.getCmp('type');
		var test = testObj.getValue();
		var type = typeObj.getValue();
		var ch = ch = test.charAt(0);
		if(ch >= '0' && ch <= '9')
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: alertMsg1,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			testObj.focus(true);
			return false;
		}
		else if(!checkblank(test))
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: alertMsg2,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			testObj.focus(true);
			return false;
		}
		else if(checkspaceExtjs(test) != '0')
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: _checkblank,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			testObj.focus(true);
			return false;
		}
		else if(!checkspecialnomess(test,"`~!@#$%^&*()+=-/?'\"]{}[\\|;:.,><"))
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: alertMsg3,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			testObj.focus(true);
			return false;
		}
		else if(!checkForNameWithEx(test))
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: alertMsg2,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			testObj.focus(true);
			return false;
		}
		else if(test.indexOf("_cf_ex") > -1 && (type == undefined || type == null || type == "Performance"))
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: "Performance test name should end with _ex.",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			testObj.focus(true);
			return false;
		}
		else if(test.indexOf("_cf_ex") == -1 && type == "Configuration")
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: "Configuration test name should end with _cf_ex.",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			testObj.focus(true);
			return false;
		}
		else if(test.indexOf("_cf_ex")>-1 && isConfigSupported=='false')
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: alertMsg4,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			testObj.focus(true);
			return false;
		}
		else if(!validateSingleByte(test))
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: alertMsg5,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			testObj.focus(true);
			return false;
		}

		var isDuplicate = Ext.getCmp('duplicatetest').getValue().duprb;
		if (isDuplicate == 'Yes')
		{
			var strLayer = Ext.getCmp('nonDupTest').getValue();
			if (strLayer == "-1")
			{
				Ext.Msg.show({
					title: pageTitle1,
					msg: alertMsg6,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});

				return false;
			}
		}
		return true;
	},
	loadAddParamTab:function(urlStr)
	{
		var me = this;
		Ext.getCmp('addParam').show();
		Ext.Ajax.request(
		{
			url: 'ICTest/data/'+urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});

		var cntnrObj = Ext.getCmp('addParamCntnr');
		cntnrObj.removeAll();
		var existingParams = publicJSON.paramList;
		if (existingParams.length == 0)
		{
			Ext.getCmp('noParamsFnd').show();
		}
		else
		{
			Ext.getCmp('noParamsFnd').hide();
			for (var p=0; p<existingParams.length; p++) {
					var param = existingParams[p];
					if(param.paramName == "password")
					{
							cntnrObj.add({
							xtype: 'fieldset',
							title: '<b>'+param.paramName+'</b>',
							layout: {
								type: 'vbox',
								align: 'left'
							},
							width: 650,
							//height: 70,
							items: [
								{
									xtype:"displayfield",
									fieldLabel: defVal,
									inputType:"password",
									labelSeparator: '',
									value: param.paramValue,
									flex: 1,
									renderer: function(value, metaData, record, row, col, store, gridView)
									{
										var a="&#8226;";
										for(var k=1; k<value.length; k++)
										{
											a = a+"&#8226;";
										}
										return "<h1>"+a+"</h1>";
									}
								},
								{
									xtype:'container',
									layour:{
										type: 'hbox',
										pack: 'left'
									},
									margin: '10 0 10 0',
									items : [
										{
											xtype: 'button',
											cls : 'button20',
											text: modifyTooltip,
											modifyURL: param.modifyURL,
											width: 80,
											handler: function() {
												me.showModifyParam(this.modifyURL);
											},
											//columnWidth: 0.25,
											//margin: '0 0 0 20'
										},
										{
											xtype: 'button',
											cls : 'button20',
											text: deleteTooltip,
											hidden: param.hideDelete,
											deleteURL: param.deleteURL,
											paramName : param.paramName,
											width: 80,
											handler: function() {
												me.deleteParam(this.deleteURL, this.paramName);
											},
											//columnWidth: 0.25,
											margin: '0 0 0 20'
										}
									]
								}
							]
						});
					}
					else
					{
						cntnrObj.add({
						xtype: 'fieldset',
						title: '<b>'+param.paramName+'</b>',
						//layout: 'column',
						layout: {
								type: 'vbox',
								align: 'left'
							},
						width: 650,
						items: [
							{
								xtype: 'displayfield',
								fieldLabel: defVal,
								labelSeparator: '',
								value: param.paramValue,
								flex: 1,
							},
							{
								xtype:'container',
								layour:{
									type: 'hbox',
									pack: 'left'
								},
								margin: '10 0 10 0',
								items : [
									{
										xtype: 'button',
										cls : 'button20',
										text: modifyTooltip,
										modifyURL: param.modifyURL,
										width: 80,
										handler: function() {
											me.showModifyParam(this.modifyURL);
										},
										//columnWidth: 0.25,
										//margin: '0 0 0 20'
									},
									{
										xtype: 'button',
										cls : 'button20',
										text: deleteTooltip,
										hidden: param.hideDelete,
										deleteURL: param.deleteURL,
										paramName : param.paramName,
										width: 80,
										handler: function() {
											me.deleteParam(this.deleteURL, this.paramName);
										},
										//columnWidth: 0.25,
										margin: '0 0 0 20'
									}
								]
							}
						]
					});
					}
			}
		}
		//cntnrObj.doLayout();

		if (publicJSON.showNewTetsParams)
		{
			Ext.getCmp('addParam').show();
		}
		else
		{
			Ext.getCmp('addParam').hide();
		}
		me.tabHelp();
	},
	showAddNewParam: function()
	{
		var me = this;
		Ext.create('Ext.window.Window', {
			title: newParam,
			padding:'3 10 10 10',
			height: 175,
			width: 350,
			id:'addParamWindow',
			layout:{
				type:'vbox',
				pack:'center',
				align:'center'
			},
			modal: true,
			resizable: false,
			items:[ 
				{
					xtype: 'textfield',
					fieldLabel: param,
					//labelAlign: 'top',
					labelSeparator: ' ',
					cls : 'textbox',
					id:'param',
					name:'param',
					width: 300,
					margin: '10 0 0 0'
				},
				{
					xtype: 'textfield',
					fieldLabel: defVal,
					cls : 'textbox',
					//labelAlign: 'top',
					labelSeparator: ' ',
					id:'value',
					name:'value',
					value:'unconfigured',
					width: 300,
					margin: '10 0 0 0'
				},
				{
					xtype: 'button',
					text: add,
					cls : 'button20',
					id:'addParamButton',
					width: 80,
					listeners:
					{
						click:{
							fn: function (id){
								me.doAddNewParam();
							}
						}
					},
					margin: '20 0 20 0'
				}
			]
		}).show();
	},
	doAddNewParam:function()
	{
		var me = this;
		jmxCtrlr = this.getController('ICTest.controller.AddJmxTestCtrlr');
		var param = Ext.getCmp('param').getValue();
		var value = Ext.getCmp('value').getValue();
		var test = Ext.getCmp('test').getValue();
		var testType = Ext.getCmp('testType').getValue();
		var port = Ext.getCmp('port').getValue().portrb;
		var execution = Ext.getCmp('execution').getValue().exerb;

		if (!this.paramValidation(param,value,testType))
		{
			return;
		}

		var urlStr = "EgaddudtestpJson.jsp?param="+encodeURIComponent(param)+"&value="+encodeURIComponent(value)+"&add=param&test="+test+"&testtype="+testType+"&port="+port+"&type="+execution;
		 if (testType.toLowerCase() == 'sql query')
		{
			var dbType = Ext.getCmp('dbType').getValue();
			urlStr += "&dbType=" + dbType;
		}
		else if (testType == 'Script/Batch File')
		{
			var osType =  Ext.getCmp('ostype').getValue().ostyperb;
			urlStr += "&os="+ osType;
		}

		var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: updating+'...'});
		tmpMask.show();
	
		Ext.Ajax.request(
		{
			url: 'ICTest/data/'+urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				tmpMask.hide();
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );

					if (publicJSON.AlertType == 'Error')
					{
						Ext.Msg.show({
							title: error+': '+publicJSON.AlertTitle,
							msg:publicJSON.AlertMsg,
							buttons: Ext.Msg.OK,
							icon: 'iconError'
						});
					}
					else if (publicJSON.AlertType == 'Result')
					{
						Ext.Msg.show({
							title: publicJSON.AlertTitle,
							msg:publicJSON.AlertMsg + ' '+ 'Would you like to add more parameters for this test?',
							buttons: Ext.Msg.YESNO,
							icon: 'iconInformation',
							fn: function(response) {
								if(response == 'yes') {
									Ext.getCmp('addParamWindow').close();
									Ext.getCmp('addParamTab').enable();
									var urlToProcess = publicJSON.forwardURL;
									me.loadAddParamTab(urlToProcess);
								}
								else if (response == 'no')
								{
									Ext.getCmp('addParamWindow').destroy();
									var urlToProcess = publicJSON.forwardURL;
									me.loadAddParamTab(urlToProcess);
									jmxCtrlr.loadAddMeasureTab(urlToProcess);
									var urlStr = 'EgConfigJmxMeasureJson.jsp?test='+test;
									//jmxCtrlr.showAddedMeasures(urlStr);
									Ext.getCmp('newtest').setActiveTab(2);
								}
							}
						});
					}
					/*else if (publicJSON.AlertType == 'Result')
					{
						Ext.Msg.show({
							title: publicJSON.AlertTitle,
							msg:publicJSON.AlertMsg,
							buttons: Ext.Msg.OK,
							icon: 'iconInformation',
							fn: function(response) {
								if(response == 'ok') {
									Ext.getCmp('addParamWindow').close();
									Ext.getCmp('addParamTab').enable();
									var urlToProcess = publicJSON.forwardURL;
									//alert(urlToProcess);
									me.loadAddParamTab(urlToProcess);
								}
							}
						});
					}*/
				}
			},
			failure: function( response )
			{
				tmpMask.hide();
			}
		});
		me.tabHelp();
	},
	paramValidation: function(param,value,testType)
	{
		var default_Value=true;
		if(isDouble == 'false')
		{
			default_Value = validateSingleByte(value);
		}
		var allowToUpdate = icTestParamValidation(param,value,testType);
		var paramObj = Ext.getCmp('param');
		var valueObj = Ext.getCmp('value');
		if(!checkblank(param))
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: alertMsg7,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			paramObj.focus(true);
			return false;
		}
		else if(!checkspecialnomess(param, "`~!@#$%^&*()+=-/?'\"]{}[\\|;:.,><"))
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: alertMsg3,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			paramObj.focus(true);
			return false;
		}
		else if(!checkblank(value))
		{
			//alert(alertMsg8);
			valueObj.focus(true);
			return false;
		}
		else if(!checkspace(value))
		{
			valueObj.focus(true);
			return false;
		}
		else if(param == "host")
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: alertMsg9,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			paramObj.focus(true);
			return false;
		}
		else if(param == "info")
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: alertMsg10,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			paramObj.focus(true);
			return false;
		}
		else if (param ==  "scriptfile")
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: alertMsg56,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			paramObj.focus(true);
			return false;
		}
		else if(param == "port")
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: alertMsg11,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			paramObj.focus(true);
			return false;
		}
		else if(!validateSingleByte(param))
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: alertMsg12,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			paramObj.focus(true);
			return false;
		}
		else if(!default_Value)
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: alertMsg13,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			valueObj.focus(true);
			return false;
		}
		else if (!allowToUpdate)
		{
			if (testType != "Snmp" && testType != "Custom" && (param.toLowerCase() == "snmpport" || param.toLowerCase() == "snmpversion" || param.toLowerCase() == "snmpcommunity"))
			{
				Ext.Msg.show({
					title: pageTitle1,
					msg: _snmpParams,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});

				paramObj.focus(true);
				return false;
			}
			else
			{
				paramObj.focus(true);
				return false;
			}
		}
		return true;
	},
	loadMeasureTab: function()
	{
		var test = Ext.getCmp('test').getValue();
		var testType = Ext.getCmp('testType').getValue();
		if(testType == "Jmx")
		{
			testType = "JMX";
		}
		var me = this;

		if (testType == 'Custom')
		{
			var urlStr = 'EgConfigTestMeasureJson.jsp?test='+test+"&unit=";
			customCtrlr = this.getController('ICTest.controller.AddCustomTestCtrlr');
			customCtrlr.loadAddMeasureTab(urlStr);
		}
		else if (testType == 'Script/Batch File')
		{
			var urlStr = 'EgConfigScriptMeasureJson.jsp?test='+test;
			scriptCtrlr = this.getController('ICTest.controller.AddScriptTestCtrlr');
			scriptCtrlr.loadAddMeasureTab(urlStr);
		}
		else if (testType.toLowerCase() == 'sql query')
		{
			var urlStr = 'EgConfigSqlMeasureJson.jsp?test='+test;
			sqlCtrlr = this.getController('ICTest.controller.AddSqlTestCtrlr');
			sqlCtrlr.loadAddMeasureTab(urlStr);
		}
		else if (testType == 'Perfmon')
		{
			var urlStr = 'EgConfigPerfmonMeasureJson.jsp?test='+test;
			perfmonCtrlr = this.getController('ICTest.controller.AddPerfmonTestCtrlr');
			perfmonCtrlr.loadAddMeasureTab(urlStr);
		}
		else if (testType == 'Snmp')
		{
			var urlStr = 'EgConfigSnmpMeasureJson.jsp?test='+test;
			snmpCtrlr = this.getController('ICTest.controller.AddSnmpTestCtrlr');
			snmpCtrlr.init();
			snmpCtrlr.loadAddMeasureTab(urlStr);
		}
		else if (testType ==  'JMX')
		{
			var utlStr = 'EgMBeanDiscoveryJson.jsp?test='+test;
			jmxCtrlr = this.getController('ICTest.controller.AddJmxTestCtrlr');
			jmxCtrlr.init();
			jmxCtrlr.loadAddMeasureTab(utlStr);
		//	Ext.getCmp('addNewMeasure').hide();
		}
		else if (testType ==  'REST')
		{
			if(Ext.isEmpty(datasetCtrlr))
			{
				datasetCtrlr= this.getController('ICTest.controller.DatasetController');
				datasetCtrlr.init();
			}
			var urlStr = "EgConfigRESTMeasureJson.jsp?test=" + test;
			datasetCtrlr.loadAddMeasureTab(urlStr);
		}
	},
	showConfigMetricsPopup : function(btnObj)
	{
		if(Ext.isEmpty(datasetCtrlr))
		{
			datasetCtrlr= this.getController('ICTest.controller.DatasetController');
		}
		var test = Ext.getCmp('test').getValue();
		var urlStr = "EgConfigRESTMeasureJson.jsp?test=" + test;
		datasetCtrlr.loadAddMeasureTab(urlStr);
		datasetCtrlr.addRESTDataFields(publicJSON['restDSNName'],btnObj); 
	},
	showAddMeasure: function()
	{
		var testType = Ext.getCmp('testType').getValue();
		if(testType == "Jmx")
		{
			testType = "JMX";
		}
		if (testType == 'Custom')
		{
			customCtrlr = this.getController('ICTest.controller.AddCustomTestCtrlr');
			customCtrlr.showAddNewMeasure();
		}
		else if (testType == 'Script/Batch File')
		{
			scriptCtrlr = this.getController('ICTest.controller.AddScriptTestCtrlr');
			scriptCtrlr.showAddNewMeasure();
		}
		else if (testType.toLowerCase() == 'sql query')
		{
			sqlCtrlr = this.getController('ICTest.controller.AddSqlTestCtrlr');
			sqlCtrlr.showAddNewMeasure();
		}
		else if (testType == 'Perfmon')
		{
			perfmonCtrlr = this.getController('ICTest.controller.AddPerfmonTestCtrlr');
			perfmonCtrlr.showAddNewMeasure();
		}
		else if (testType == 'Snmp')
		{
			snmpCtrlr = this.getController('ICTest.controller.AddSnmpTestCtrlr');
			snmpCtrlr.showAddNewMeasure();
		}
		else if (testType == 'JMX')
		{
			jmxCtrlr = this.getController('ICTest.controller.AddJmxTestCtrlr');
			jmxCtrlr.showAddNewMeasure();
		}
		else if (testType == 'REST')
		{
			if(Ext.isEmpty(datasetCtrlr))
			{
				datasetCtrlr= this.getController('ICTest.controller.DatasetController');
			}
			datasetCtrlr.showAddNewMeasure();
		}
	},
	showClassFileUpload: function()
	{
		addctrler.showFileUpload("loadClass");
	},
	showLibFileUpload: function()
	{
		addctrler.showFileUpload("loadLib");
	},
	showScriptFileUpload: function()
	{
		addctrler.showFileUpload("loadScript")
	},
	showDDClassFileUpload: function()
	{
		addctrler.showFileUpload("loadDDClass");
	},
	showDDLibFileUpload: function()
	{
		addctrler.showFileUpload("loadDDLib");
	},
	showFileUpload: function(uploadType)
	{
		var me = this;
		var test = Ext.getCmp('test').getValue();
		Ext.widget('window', {
			title: fileUpload,
			width: 350,
			height: 150,
			id: 'file',
			name: 'file',
			resizable: 'false',
			padding:'0 10 10 10',
			items: [{
				xtype: 'form',
				id: 'uploadform',
				name: 'uploadform',
				url: '../servlet/com.eg.EgUploadServlet',
				height: 150,
				items: [{
					xtype: 'fileuploadfield',
					cls: 'fileupload',
					id: 'file1',
					name: 'file1',
					labelSeparator: '',
					emptyText: noFileSel,
					fieldLabel: file2Upload,
					labelAlign: 'top',
					width: 290,
					buttonText: 'Browse',
					margin: '15 0 0 15',
				},
				{
					xtype: 'button',
					text: upload,
					id: 'upload',
					name: 'upload',
					action: 'upload',
					cls: 'button20',
					align: 'center',
					margin: '15 0 0 140',
					handler: function (button, e)
					{
						var selFile = Ext.getCmp('uploadform').getForm().findField('file1').getValue();
						var validate = true;
						if(!validateSingleByte(selFile))
						{
							Ext.Msg.show({
								title:fileUpload,
								msg:alertMsg23,
								buttons: Ext.Msg.OK,
								icon : 'iconExclamation'
							});
							Ext.getCmp("file1").focus(true);
							validate = false;
						}
						else if(selFile=="")
						{
							Ext.Msg.show({
								title:fileUpload,
								msg:alertMsg24,
								buttons: Ext.Msg.OK,
								icon : 'iconExclamation'
							});
							Ext.getCmp("file1").focus(true);
							validate = false;
						}
						else if(uploadType=="loadClass")
						{
							if(selFile.indexOf(".class")==-1)
							{
								Ext.Msg.show({
									title:fileUpload,
									msg:alertMsg25,
									buttons: Ext.Msg.OK,
									icon : 'iconExclamation'
								});
								Ext.getCmp("file1").focus(true);
								validate = false;
							}
						}
						if (!validate)
						{
							return false;
						}
						else
						{
							var uploadformObj = Ext.getCmp('uploadform').getForm();
							if (uploadformObj.isValid())
							{
								uploadformObj.submit({
									method: 'POST',
									success: function (form, action) {
										var jsonText = action.response.responseText;
										var tmpResult = Ext.decode(jsonText);
										if (!Ext.isEmpty(tmpResult.uploadStatus) && tmpResult.uploadStatus == 'true')
										{
											if (uploadType == 'loadClass')
											{
												Ext.getCmp('path').setValue(tmpResult.classPath);
											}
											else if(uploadType == 'loadLib')
											{
												var libObj = Ext.getCmp('lib');
												var tmpVal = libObj.getValue();
												if (tmpVal != null && tmpVal != "")
												{
													tmpVal = tmpVal +","+tmpResult.libPath;
												}
												else
												{
													tmpVal = tmpResult.libPath;
												}
												libObj.setValue(tmpVal);
											}
											else if (uploadType == 'loadDDClass')
											{
												Ext.getCmp('ddPath').setValue(tmpResult.classPath);
											}
											else if(uploadType == 'loadDDLib')
											{
												var libObj = Ext.getCmp('ddLib');
												var tmpVal = libObj.getValue();
												if (tmpVal != null && tmpVal != "")
												{
													tmpVal = tmpVal +","+tmpResult.libPath;
												}
												else
												{
													tmpVal = tmpResult.libPath;
												}
												libObj.setValue(tmpVal);
											}
											else if (uploadType == 'loadScript')
											{
												Ext.getCmp('scriptPath').setValue(tmpResult.scriptPath);
											}
											button.up('.window').close();
										}
									},
									failure: function (form, action) {
										Ext.Msg.alert(fileUpload, 'File upload failure');
									}
								});
							}
							else
							{}
						}
					}
				}],
				listeners: {
					afterrender: function () {
						var tmpUploadType = uploadType
						if (uploadType == 'loadDDClass')
						{
							tmpUploadType = 'loadClass';
						}
						else if (uploadType == 'loadDDLib')
						{
							tmpUploadType = 'loadLib';
						}
						me.uploadWindowData(test,tmpUploadType);
					},
				}
			}]
		}).show()
	},
	uploadWindowData:function(test, uploadType)
	{
		var formObj = Ext.getCmp('uploadform');
		formObj.add({
			xtype: 'hidden',
			name: 'test',
			value: test
		});
		if (uploadType == 'loadScript')
		{
			formObj.add({
				xtype: 'hidden',
				name: 'uploadScript',
				value: 'true'
			});
		}
		else
		{
			formObj.add({
				xtype: 'hidden',
				name: 'uploadType',
				value: uploadType
			});
		}
	},
	generateTest: function()
	{
		var testType = Ext.getCmp('testType').getValue();
		if(testType == "Jmx")
		{
			testType = "JMX";
		}

		if (testType == 'Custom')
		{
			customCtrlr = this.getController('ICTest.controller.AddCustomTestCtrlr');
			customCtrlr.init();
			customCtrlr.generateCustomTest();
		}
		else if (testType == 'Script/Batch File')
		{
			scriptCtrlr = this.getController('ICTest.controller.AddScriptTestCtrlr');
			scriptCtrlr.init();
			scriptCtrlr.generateScriptTest();
		}
		else if (testType.toLowerCase() == 'sql query')
		{
			sqlCtrlr = this.getController('ICTest.controller.AddSqlTestCtrlr');
			sqlCtrlr.generateSqlTest();
		}
		else if (testType == 'Perfmon')
		{
			perfmonCtrlr = this.getController('ICTest.controller.AddPerfmonTestCtrlr');
			perfmonCtrlr.generatePerfmonTest();
		}
		else if (testType == 'Snmp')
		{
			snmpCtrlr = this.getController('ICTest.controller.AddSnmpTestCtrlr');
			snmpCtrlr.generateSnmpTest();
		}
		else if (testType == 'JMX')
		{
			jmxCtrlr = this.getController('ICTest.controller.AddJmxTestCtrlr');
			jmxCtrlr.generateJmxTest();
		}
		else if (testType == 'REST')
		{
			if(Ext.isEmpty(datasetCtrlr))
			{
				datasetCtrlr = this.getController('ICTest.controller.DatasetController');
			}
			datasetCtrlr.generateRESTTest();
		}
	},
	generateDDTest: function()
	{
		var test = Ext.getCmp('test').getValue();
		var ddPathObj = Ext.getCmp('ddPath')
		var ddPath = ddPathObj.getValue();
		
		if (ddPath.indexOf(test+'_DD.class') == -1)
		{
			Ext.Msg.show({
				title: generate,
				msg: alertMsg31,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			ddPathObj.focus(true);
			return;			
		}

		var ddLib = Ext.getCmp('ddLib').getValue();
		var libCheck = Ext.getCmp('ddLoadLib').getValue();
		var ddLibChk = "no";
		if (libCheck)
		{
			ddLibChk = "yes";
		}
		var urlStr =  'ICTest/data/EgdiagnosisformatpJson.jsp?action=generate&test='+test+'&path='+ddPath+'&lib='+ddLib+'&loadLib='+ddLibChk;
		Ext.Ajax.request(
		{
			url: urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});

		if (publicJSON.AlertType=='Error')
		{
			Ext.Msg.show({
				title: publicJSON.AlertTitle,
				msg:publicJSON.AlertMsg,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
		}

		if (!Ext.isEmpty(publicJSON.forwardURL))
		{
			this.getController('ICTest.controller.ThresholdCtrlr').init();
			var genCntnrObj = Ext.getCmp('ddgenerateCntnr');
			genCntnrObj.removeAll();
			var urlStr = publicJSON.forwardURL;
			qString = 'ICTest/data/'+urlStr;
			genCntnrObj.add({
				xtype : 'defaultthresholds'
			});
		}
	},
	loadDDMeasureTab: function()
	{
		var test = Ext.getCmp('test').getValue();
		var urlStr = 'EgDiagnosisFormatJson.jsp?test='+test;
		this.loadAddDDMeasureTab(urlStr);
	},
	loadAddDDMeasureTab: function(urlStr)
	{
		var me = this;
		Ext.Ajax.request(
		{
			url: 'ICTest/data/'+urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});

		var existingMeass = publicJSON.measuresList;
		var cntnrObj = Ext.getCmp('addDDMeasureCntnr');
		cntnrObj.removeAll();
		if (publicJSON.noMeasuresFnd)
		{
			Ext.getCmp('noDDMeasureFnd').show();
		}
		else
		{
			Ext.getCmp('noDDMeasureFnd').hide();
			for (var p=0; p<existingMeass.length; p++) 
			{
					var measure = existingMeass[p];
					if(param.paramName == "password")
					{
							cntnrObj.add({
							xtype: 'fieldset',
							title: '<b>'+param.paramName+'</b>',
							layout: {
								type: 'vbox',
								align: 'left'
							},
							width: 650,
							//height: 70,
							items: [
								{
									xtype:"displayfield",
									fieldLabel: defVal,
									inputType:"password",
									labelSeparator: '',
									value: param.paramValue,
									flex: 1,
									renderer: function(value, metaData, record, row, col, store, gridView)
									{
										var a="&#8226;";
										for(var k=1; k<value.length; k++)
										{
											a = a+"&#8226;";
										}
										return "<h1>"+a+"</h1>";
									}
								},
								{
									xtype:'container',
									layour:{
										type: 'hbox',
										pack: 'left'
									},
									margin: '10 0 10 0',
									items : [
										{
											xtype: 'button',
											cls : 'button20',
											text: modifyTooltip,
											modifyURL: param.modifyURL,
											width: 80,
											handler: function() {
												me.showModifyParam(this.modifyURL);
											},
											//columnWidth: 0.25,
											//margin: '0 0 0 20'
										},
										{
											xtype: 'button',
											cls : 'button20',
											text: deleteTooltip,
											hidden: param.hideDelete,
											deleteURL: param.deleteURL,
											paramName : param.paramName,
											width: 80,
											handler: function() {
												me.deleteParam(this.deleteURL, this.paramName);
											},
											//columnWidth: 0.25,
											margin: '0 0 0 20'
										}
									]
								}
							]
						});
					}
					else
					{
						cntnrObj.add({
						xtype: 'fieldset',
						title: '<b>'+measure.measure+'</b>',
						width: 500,
						height: 150,
						items: [
							{
								xtype: 'container',
								layout: {
									type: 'vbox',
									align: 'left',
									pack: 'center'
								},
								defaults: {
									labelSeparator: ' ',
									margin: 5,
									labelWidth: 200 
								},
								items: [
									{
										xtype: 'displayfield',
										fieldLabel: column,
										value: measure.column
									},
									{
										xtype: 'displayfield',
										fieldLabel: desc,
										value: measure.description
									}
								]
							},
							{
								xtype: 'container',
								layout: {
									type: 'hbox',
									align: 'center',
									pack: 'center'
								},
								defaults: {
									width: 70,
									margin: 10
								},
								items:[
									{
										xtype: 'button',
										cls : 'button20',
										text: modifyTooltip,
										modifyInfo: measure.modifyInfo,
										handler: function() {
											me.showModifyDDMeasure(this.modifyInfo);
										}
									},
									{
										xtype: 'button',
										cls : 'button20',
										text: deleteTooltip,
										deleteURL: measure.deleteURL,
										handler: function() {
											me.deleteDDMeasure(this.deleteURL);
										}
									}
								]
							}
						]
						});
					}
			}
			var ddClassPath = publicJSON.hiddens.classPath;
			if (ddClassPath != null && ddClassPath != "")
			{
				Ext.getCmp('ddPath').setValue(ddClassPath);
			}
			var libPath = publicJSON.hiddens.libraryPath;
			var libCheck = publicJSON.loadLibChecked;
			if (libPath != null && libPath != "")
			{
				Ext.getCmp('ddLib').setValue(libPath);
			}
			if (libCheck)
			{
				Ext.getCmp('ddLoadLib').setValue(true);
			}			
		}
	},
	loadDDTab: function()
	{
		isDDLoaded = true;
		var test = Ext.getCmp('test').getValue();
		var urlStr = 'EgDiagnosisFormatJson.jsp?test='+test;
		this.loadAddDDMeasureTab(urlStr);
	},
	showAddNewDDMeasure: function()
	{		
		var me = this;
		Ext.create('Ext.window.Window', {
			title: meas4DD,
			padding:'3 10 10 10',
			height: 400,
			width: 400,
			id:'addDDMeasureWindow',
			layout:{
				type:'vbox',
				pack:'start',
				align:'center'
			},
			defaults:{
				margin: 10
			},
			items:[ 
				{
					xtype: 'scrollcombo',
					cls : 'dropdown',
					id:'ddMeasure',
					name:'ddMeasure',
					fieldLabel: meas4Test,
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : []
					}),
					displayField:'displayField',
					valueField:'valueField',
					queryMode : 'local',
					labelAlign: 'top',
					labelSeparator: ' ',
					width: 300,
					editable: false
				},
				{
					xtype: 'textareafield',
					cls : 'text-area',
					grow: true,
					labelAlign: 'top',
					labelSeparator: ' ',
					width: 300,
					height: 100,
					name: 'ddColTitles',
					id: 'ddColTitles',
					fieldLabel: colHeads
				},
				{
					xtype: 'textareafield',
					cls : 'text-area',
					grow: true,
					labelAlign: 'top',
					labelSeparator: ' ',
					width: 300,
					height: 100,
					name: 'ddDesc',
					id: 'ddDesc',
					fieldLabel: descDD
				},
				{
					xtype: 'button',
					cls : 'button20',
					text: add,
					id:'addMeasureButton',
					width: 80,
					listeners:
					{
						click:{
							fn: function (id){
								addctrler.doAddNewDDMeasure();
							}
						}
					}
				}
			]
		}).show();

		var measComboObj = Ext.getCmp('ddMeasure');
		measComboObj.getStore().loadRawData(publicJSON.measures);
		measComboObj.setValue(publicJSON.selectedMeasure);

		Ext.getCmp('ddColTitles').setValue(publicJSON.columnValue);
		Ext.getCmp('ddDesc').setValue(publicJSON.descriptionValue);
	},
	deleteDDMeasure: function(deleteURL)
	{
		var me = this;
		Ext.Msg.show({
			title: tab5DD,
			msg:alertMsg37,
			buttons: Ext.Msg.OKCANCEL,
			icon:'iconConfirmation',
			fn: function(response) {
				if(response == 'ok') {
					Ext.Ajax.request(
					{
						url: 'ICTest/data/'+deleteURL,
						method: 'POST',
						async:false,
						success: function( response )
						{
							if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
							{
								var jsonText = response.responseText;
								publicJSON = Ext.decode( jsonText );
							}
						}
					});
					if (publicJSON.AlertType=='Result')
					{
						Ext.Msg.show({
							title: publicJSON.AlertTitle,
							msg:publicJSON.AlertMsg,
							buttons: Ext.Msg.OK,
							icon:'iconInformation',
							fn: function(response) {
								if(response == 'ok') {
									Ext.getCmp('addDDMeasureTab').enable();
									var urlToProcess = publicJSON.forwardURL;
									me.loadAddDDMeasureTab(urlToProcess);
								}
							}
						});
					}
				}
			}
		});	
	},
	showModifyDDMeasure: function(modifyInfo)
	{
		//test#measure#column#description
		var data = modifyInfo.split('#^#');
		var urlStr = 'EgDiagnosisFormatJson.jsp?test='+data[0]+'&measure='+data[1]+'&column='+data[2]+'&desc='+data[3];
		
		Ext.Ajax.request(
		{
			url: 'ICTest/data/'+urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});

		
		this.showAddNewDDMeasure();
		
	},
	doAddNewDDMeasure: function()
	{
		var me = this;
		var test = publicJSON.hiddens.test;
		var measure = Ext.getCmp('ddMeasure').getValue();
		var colHead = Ext.getCmp('ddColTitles').getValue();
		var desc = Ext.getCmp('ddDesc').getValue();
		var urlStr = 'ICTest/data/EgdiagnosisformatpJson.jsp?action=add&ddColTitles='+encodeURIComponent(colHead)+'&ddDesc='+desc+'&measure='+measure+'&test='+test;
		
		if (!this.ddMeasureValidation(measure,colHead,desc))
		{
			return;
		}

		Ext.Ajax.request(
		{
			url: urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});

		if (publicJSON.AlertType == 'Error')
		{
			Ext.Msg.show({
				title: error+': '+publicJSON.AlertTitle,
				msg:publicJSON.AlertMsg,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
		}

		if (publicJSON.forwardPage)
		{
			Ext.getCmp('addDDMeasureWindow').close();
			Ext.getCmp('addDDMeasureTab').enable();
			var urlToProcess = publicJSON.forwardURL;
			me.loadAddDDMeasureTab(urlToProcess);
			Ext.getCmp('ddGenerateTab').enable();
		}
	
	},
	ddMeasureValidation:function(measure,colHead,desc)
	{
		var measObj = Ext.getCmp('ddMeasure');
		var colObj = Ext.getCmp('ddColTitles');
		var descObj = Ext.getCmp('ddDesc');
		if (measure == -1)
		{
			Ext.Msg.show({
				title: generate,
				msg: alertMsg32,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			measObj.focus(true);
			return false;
		}
		else if (colHead == "")
		{
			Ext.Msg.show({
					title: generate,
					msg: alertMsg33,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
			colObj.focus(true);
			return false;
		}
		else if (colHead.indexOf(" ") > 0)
		{
			Ext.Msg.show({
					title: generate,
					msg: alertMsg34,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
			colObj.focus(true);
			return false;
		}
		else if (desc == "")
		{
			Ext.Msg.show({
					title: generate,
					msg: alertMsg35,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
			descObj.focus(true);
			return false;
		}
		else if(desc.indexOf(",")>-1)
		{
			Ext.Msg.show({
					title: generate,
					msg: alertMsg356,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
			descObj.focus(true);
			return false;
		}
		return true;
	},
	loadGenerateTab:function()
	{
		var test = Ext.getCmp('test').getValue();
		var testType = Ext.getCmp('testType').getValue();
		var genCntnrObj = Ext.getCmp('generateCntnr');
		var me = this;
		genCntnrObj.removeAll();
		if(testType == "Jmx")
		{
			testType = "JMX";
		}

		if (testType == 'Custom')
		{
			var urlStr = 'EgConfigTestMeasureJson.jsp?test='+test;
			this.postURL(urlStr);
			genCntnrObj.add({
				xtype : 'customgenerate'
			});
			if (isConfigTest)
			{
				var infoOptObj = Ext.getCmp('isDescriptorBasedTest');
				infoOptObj.show();
				if(publicJSON.descriptorBasedTestCheck == 'checked')
				{
					infoOptObj.setValue(true);
				}
			}
			else
			{
				if (ddEnabled == 'true')
				{
					Ext.getCmp('ddForMeasure').show();
					if (publicJSON.ddForMeasureCheck == 'checked')
					{
						Ext.getCmp('ddForMeasure').setValue(true);
						Ext.getCmp('newtest').child('#tab5DD').tab.show();
					}
				}
			}
			Ext.getCmp('path').setValue(publicJSON.path);
			Ext.getCmp('lib').setValue(publicJSON.libFile);
			if(publicJSON.loadLibChecked)
			{
				Ext.getCmp('loadLib').setValue(true);
			}

			if (isConfigTest)
			{
				var dbSizeObj = Ext.getCmp('dbSizeGen');
				dbSizeObj.show();
				dbSizeObj.getStore().loadRawData(publicJSON.dbColSizeList);
				dbSizeObj.setValue(publicJSON.dbColSizeSelected);
			}
			else
			{
				var descCheckObj = Ext.getCmp('descCheckBox');
				descCheckObj.hide();
			}
		}
		else if (testType  == 'Script/Batch File')
		{
			var urlStr = 'EgConfigScriptMeasureJson.jsp?test='+test;
			this.postURL(urlStr);
			genCntnrObj.add({
				xtype : 'scriptgenerate'
			});
			Ext.getCmp('scriptPath').setValue(publicJSON.path);

			if (isConfigTest)
			{
				var dbSizeObj = Ext.getCmp('dbSizeGen');
				var descBasedObj = Ext.getCmp('isDescriptorBasedTestScript');
				dbSizeObj.show();
				descBasedObj.show();
				dbSizeObj.getStore().loadRawData(publicJSON.dbColSizeList);
				dbSizeObj.setValue(publicJSON.dbColSizeSelected);
				if(publicJSON.descriptorBasedTestCheck == 'checked')
				{
					descBasedObj.setValue(true);
				}
			}
			else
			{
				var descCheckObj = Ext.getCmp('descCheckBox');
				descCheckObj.hide();
			}
		}
		else if (testType.toLowerCase() == 'sql query')
		{
			var urlStr = 'EgConfigSqlMeasureJson.jsp?test='+test;
			this.postURL(urlStr);
			genCntnrObj.add({
				xtype : 'sqlgenerate'
			});
			Ext.getCmp('query').setValue(publicJSON.query);

			if (isConfigTest)
			{
				var dbSizeObj = Ext.getCmp('dbSizeGen');
				var descBasedObj = Ext.getCmp('isDescriptorBasedTestSql');
				dbSizeObj.show();
				descBasedObj.show();
				dbSizeObj.getStore().loadRawData(publicJSON.dbColSizeList);
				dbSizeObj.setValue(publicJSON.dbColSizeSelected);
				if(publicJSON.descriptorBasedTestCheck == 'checked')
				{
					descBasedObj.setValue(true);
				}
			}
			else
			{
				var descCheckObj = Ext.getCmp('descCheckBox');
				descCheckObj.hide();
			}
		}
		else if (testType == 'Perfmon')
		{
			var urlStr = 'EgConfigPerfmonMeasureJson.jsp?test='+test;
			this.postURL(urlStr);
			genCntnrObj.add({
				xtype : 'perfmongenerate'
			});
			Ext.getCmp('object').setValue(publicJSON.objectName);
			Ext.getCmp('instances').setValue(publicJSON.instancesIncluded);
			Ext.getCmp('instances_neg').setValue(publicJSON.instancesExcluded);

			if (isConfigTest)
			{
				var dbSizeObj = Ext.getCmp('dbSizeGen');
				var descBasedObj = Ext.getCmp('isDescriptorBasedTestPerfmon');
				dbSizeObj.show();
				descBasedObj.show();
				dbSizeObj.getStore().loadRawData(publicJSON.dbColSizeList);
				dbSizeObj.setValue(publicJSON.dbColSizeSelected);
				if(publicJSON.descriptorBasedTestCheck == 'checked')
				{
					descBasedObj.setValue(true);
				}
			}
			else
			{
				var descCheckObj = Ext.getCmp('descCheckBox');
				descCheckObj.hide();
			}
		}
		else if (testType == 'Snmp')
		{
			var urlStr = 'EgConfigSnmpMeasureJson.jsp?test='+test;
			this.postURL(urlStr);
			genCntnrObj.add({
				xtype : 'snmpgenerate'
			});
			
			this.getController('ICTest.controller.AddSnmpTestCtrlr').init();
			Ext.getCmp('elements').getStore().loadRawData(publicJSON.elemntCategoery);
			var textCntnrObj = Ext.getCmp('multiGroup');
			if (publicJSON.multipleChecked)
			{
				Ext.getCmp('elements').setValue('Multiple Elements');
				textCntnrObj.show();
				textCntnrObj.enable();
				Ext.getCmp('elementOid').setValue(publicJSON.elementID);
				Ext.getCmp('validOid').setValue(publicJSON.elementStatus);
				Ext.getCmp('validValue').setValue(publicJSON.elementValidStatus);
				Ext.getCmp('rediscPeriod').setValue(publicJSON.rediscoveryPeriod);

				snmpElmtID = publicJSON.elementID;
				snmpElmtStatus = publicJSON.elementStatus;
			}
			else
			{
				textCntnrObj.hide();
				textCntnrObj.disable();
				Ext.getCmp('elements').setValue('Single Element');
				var descCheckObj = Ext.getCmp('descCheckBox');
				descCheckObj.hide();
			}

			if (isConfigTest)
			{
				var dbSizeObj = Ext.getCmp('dbSizeGen');
				var descBasedObj = Ext.getCmp('isDescriptorBasedTestSnmp');
				var descCheckObj = Ext.getCmp('descCheckBox');
				dbSizeObj.show();
				dbSizeObj.getStore().loadRawData(publicJSON.dbColSizeList);
				dbSizeObj.setValue(publicJSON.dbColSizeSelected);
				if(publicJSON.descriptorBasedTestCheck == 'checked' || publicJSON.multipleChecked)
				{
					descBasedObj.show();
					descCheckObj.show();
					descBasedObj.setValue(true);
				}
				descBasedObj.setReadOnly(true);
			}
			else
			{
				var descCheckObj = Ext.getCmp('descCheckBox');
				descCheckObj.hide();
			}
		}
		else if (testType == 'JMX')
		{
			var urlStr = 'EgConfigJmxMeasureJson.jsp?test='+test;
			this.postURL(urlStr);
			genCntnrObj.add({
				xtype : 'jmxgenerate'
			});
			Ext.getCmp('object').setValue(publicJSON.domainName);
			Ext.getCmp('object').setReadOnly(true);
			Ext.getCmp('instances').setValue(publicJSON.mBeansIncluded);
			Ext.getCmp('instances_neg').setValue(publicJSON.mBeansExcluded);

			if (isConfigTest)
			{
				var dbSizeObj = Ext.getCmp('dbSizeGen');
				var descBasedObj = Ext.getCmp('isDescriptorBasedTestJmx');
				dbSizeObj.show();
				descBasedObj.show();
				dbSizeObj.getStore().loadRawData(publicJSON.dbColSizeList);
				dbSizeObj.setValue(publicJSON.dbColSizeSelected);
				descBasedObj.setValue(true);
				if(publicJSON.descriptorBasedTestCheck == 'checked')
				{
					descBasedObj.setValue(true);
				}
				descBasedObj.setReadOnly(true);
			}
			else
			{
				var descCheckObj = Ext.getCmp('descCheckBox');
				descCheckObj.hide();
			}
		}
		else if (testType == 'REST')
		{
			var urlStr = 'EgConfigRESTMeasureJson.jsp?test='+test;
			this.postURL(urlStr);
			genCntnrObj.add({
				xtype : 'restgenerate'
			});
			if(Ext.isEmpty(datasetCtrlr))
			{
				this.getController('ICTest.controller.DatasetController').init();
			}
			
			if(publicJSON!=null && publicJSON.hasOwnProperty('descriptorNode'))
			{
				if(!Ext.isEmpty(publicJSON['descriptorNode']))
				{
					Ext.getCmp('DescriptorRequired').setValue(true);
					Ext.getCmp('descriptorDataRestFld').setValue(publicJSON['descriptorNode']);
					if(publicJSON!=null && publicJSON.hasOwnProperty('descriptorParentNode'))
					{
						if(!Ext.isEmpty(publicJSON['descriptorParentNode']))
						{
							Ext.getCmp('descriptorDataRestFld').dataFieldParentNode=publicJSON['descriptorParentNode'];
						}
					}
				}
			}
			else
			{
				Ext.getCmp('DescriptorRequired').setValue(false);
			}
		}
		me.tabHelp();
	},
	postURL:function(urlStr)
	{
		Ext.Ajax.request(
			{
				url: 'ICTest/data/'+urlStr,
				method: 'POST',
				async:false,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						publicJSON = Ext.decode( jsonText );
					}
				}
			});
	},
	helpOptionChange: function(opt)
	{
		if(opt == 'usetemplate')
		{
			Ext.getCmp('addUseTmpl').show();
			Ext.getCmp('addUseTmpl').enable();
			Ext.getCmp('uploadHelpPage').hide();
			Ext.getCmp('uploadHelpPage').disable();
		}
		else if (opt == 'upload')
		{
			Ext.getCmp('uploadHelpPage').show();
			Ext.getCmp('uploadHelpPage').enable();
			Ext.getCmp('addUseTmpl').hide();
			Ext.getCmp('addUseTmpl').disable();
		}
	},
	loadHelpTab: function()
	{
		this.loadAddHelpTab();
	},
	loadAddHelpTab: function()
	{
		var addModify = 'add';
		var test = Ext.getCmp('test').getValue();
		var dir;
		var help1;
		var help2;

		if (publicJSON.hiddens != null)
		{			
			test = publicJSON.hiddens.test;
			dir = publicJSON.hiddens.dir;
			help1 = publicJSON.hiddens.help1;
			help2 = publicJSON.hiddens.help2;
		}		
				
		if (help1 == null || help1 ==  'undefined')
		{	
			help1 = "";
		}
		if (help2 == null || help2 ==  'undefined')
		{	
			help2 = "";
		}
		if (dir == null || dir ==  'undefined')
		{	
			dir = "";
		}
		
		var urlStr = 'ICTest/data/EgTemplateUpload.jsp?test='+test+'&addormodify='+addModify+'&helpf1='+help1+'&help2='+help2+'&dir='+dir;
		Ext.Ajax.request(
		{
			url: urlStr,
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
					var comboObj = Ext.getCmp('tempgroup');
					comboObj.setFieldLabel(avlTemplete);
					comboObj.getStore().loadRawData(publicJSON.optList);
					comboObj.setValue(publicJSON.optSelected);
					var textArObj = Ext.getCmp('filetest');
					textArObj.setFieldLabel(templCont);
					textArObj.setValue(publicJSON.textAreaValue);
				}
			}
		});
	},
	loadModifyHelpTab: function()
	{
		var test = publicJSON.hiddens.test;
		var addModify = 'modify';
		var dir = publicJSON.hiddens.dir;
		var help1 = publicJSON.hiddens.help1;
		var help2 = publicJSON.hiddens.help2;
		if (help1 == null || help1 ==  'undefined')
		{	
			help1 = "";
		}
		if (help2 == null || help2 ==  'undefined')
		{	
			help2 = "";
		}
		if (dir == null || dir ==  'undefined')
		{	
			dir = "";
		}
		var urlStr = 'ICTest/data/EgTemplateUpload.jsp?test='+test+'&addormodify='+addModify+'&helpf1='+help1+'&helpf2='+help2+'&dir='+dir;
		Ext.Ajax.request(
		{
			url: urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});

		var mainContainerObj = Ext.getCmp('addHelpCntnr');
		mainContainerObj.removeAll();
		mainContainerObj = Ext.getCmp('modifyHelpTab');
		mainContainerObj.removeAll();
		mainContainerObj.add({
			xtype : 'addhelp'
		});

		
		//optList
		var comboObj = Ext.getCmp('tempgroup');
		comboObj.setFieldLabel(avlHelpPages);
		comboObj.getStore().loadRawData(publicJSON.optList);
		comboObj.setValue(publicJSON.optSelected);
		var textArObj = Ext.getCmp('filetest');
		textArObj.setFieldLabel(hlpPageCont);
		textArObj.setValue(publicJSON.textAreaValue);
		var buttonObj = Ext.getCmp('createHelp');
		buttonObj.setText(modifyHlp);
		this.helpOptionChange('usetemplate');

	},
	updateTestTemplates : function()
	{
		var me = this;
		var helpFile1 = me.getTestHelpApp().getComponent("adHlp");
		var helpFile2 = me.getTestHelpApp().getComponent("monHlp");
		if (me.isFileSelected())
		{
			me.uploadHelp();
		}
		else if (!me.isFileSelected() && Ext.isEmpty(Ext.getCmp('filetest').getValue()))
		{
			Ext.Msg.show({
				title: useTemplete,
				msg: alertMsg77,
				buttons: Ext.Msg.OK,
				fn: function(response) {
					if(response == 'ok') {
						return;
					}
				}
			});
		}
		else
		{
			me.createHelp();
		}
	},
	filterFormFields : function(state)
	{
		if (state == "usetemplate")
		{
			Ext.getCmp('templateCt').enable();
			Ext.getCmp('formContainer').disable();
		}
		else
		{
			Ext.getCmp('templateCt').disable();
			Ext.getCmp('formContainer').enable();
		}
	},
	elableAllFiedls : function()
	{
		Ext.getCmp('templateCt').enable();
		Ext.getCmp('formContainer').enable();
	},
	isFileSelected : function()
	{
		var me = this;
		var helpFile1 = me.getTestHelpApp().getComponent("adHlp").getValue();
		var helpFile2 = me.getTestHelpApp().getComponent("monHlp").getValue();
		if (Ext.isEmpty(helpFile1) && Ext.isEmpty(helpFile2))
		{
			return false;
		}
		return true;
	},
	createHelp: function()
	{
		var me = this;
		var helpContent = Ext.getCmp('filetest').getValue();
		if (helpContent.trim() == '')
		{
			Ext.Msg.show({
					title: useTemplete,
					msg: alertMsg77,
					buttons: Ext.Msg.OK,
					fn: function(response) {
						if(response == 'ok') {
							return;
						}
					}
				});
		}
		else
		{
			var uploadObj = Ext.getCmp('helpuploadform');
			uploadObj.add({
				xtype: 'hidden',
				name: 'tempup',
				value: 'tempupload'
			});
			me.loadHiddenParams();
			var uploadformObj = uploadObj.getForm();
			if (uploadformObj.isValid())
			{
				me.filterFormFields("usetemplate");
				var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: updating+'...'});
				tmpMask.show();
				uploadformObj.submit({
					method: 'POST',
					params : {
						uploadType: "loadHelp"
					},
					headers: {'Content-Type':'multipart/form-data'},
					success: function (form, action) {
						tmpMask.hide();
						var jsonText = action.response.responseText;
						var tmpResult = Ext.decode(jsonText);

						if(tmpResult.uploadStatus == 'true')
						{
							Ext.Msg.show({
								title: createHlp,
								msg: alertMsg58,
								buttons: Ext.Msg.OK,
								icon:'iconInformation',
								fn: function(response) {
									if(response == 'ok') {
										window.location.href= '/final/admin/EgUDTest.jsp';
									}
								}
							});
						}
						me.elableAllFiedls();
					}
				});
			}
		}
	},
	loadHiddenParams : function()
	{
		var hiddenParamsContainer = Ext.getCmp('hiddenContainer');
		hiddenParamsContainer.removeAll();
		var hiddenParams = publicJSON.hiddens;
		for (var param in hiddenParams) {
			hiddenParamsContainer.add({
				xtype: 'hidden',
				name: param,
				value: hiddenParams[param]
			});
		}
	},
	uploadHelp: function()
	{
		var me = this;
		var helpFile1 = Ext.getCmp('adHlp').getValue();
		var helpFile2 = Ext.getCmp('monHlp').getValue();
		var exten_st="";
		var exten_id = helpFile1.lastIndexOf(".");
		if(exten_id > 0)
			exten_st = helpFile1.substring(exten_id);
		exten_st= exten_st.toLowerCase();
		var exten_h2="";
		var exten_h2id = helpFile2.lastIndexOf(".");
		if(exten_h2id > 0)
			exten_h2 = helpFile2.substring(exten_h2id);
		exten_h2= exten_h2.toLowerCase();
		
		if(helpFile1=="" && helpFile2=="")
		{
			Ext.Msg.show({
				title: createHlp,
				msg: alertMsg59,
				buttons: Ext.Msg.OK,
				icon : 'iconExclamation'
			});
			return;
		}
		else if( helpFile1!="" && exten_st != ".html")
		{
			Ext.Msg.show({
				title: createHlp,
				msg: alertMsg60,
				buttons: Ext.Msg.OK,
				icon : 'iconExclamation'
			});
			return;
		}
		if( helpFile2!="" && exten_h2 != ".html")
		{
			Ext.Msg.show({
				title: createHlp,
				msg: alertMsg61,
				buttons: Ext.Msg.OK,
				icon : 'iconExclamation'
			});
			return;
		}

		var uploadformObj = Ext.getCmp('helpuploadform').getForm();
		me.loadHiddenParams();
		var hiddensObj = Ext.getCmp('hiddenContainer')
		hiddensObj.add({
			xtype: 'hidden',
			name: 'helpf1',
			value: helpFile1
		});
		hiddensObj.add({
			xtype: 'hidden',
			name: 'helpf2',
			value: helpFile2
		});
		if (uploadformObj.isValid())
		{
			me.filterFormFields("file");
			var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: updating+'...'});
			tmpMask.show();
			uploadformObj.submit({
				method: 'POST',
				params : {
					uploadType: "loadHelp"
				},
				headers: {'Content-Type':'multipart/form-data'},
				success: function (form, action) {
					tmpMask.hide();
					var jsonText = action.response.responseText;
					var tmpResult = Ext.decode(jsonText);
					if(tmpResult.uploadStatus == 'true')
					{
						Ext.Msg.show({
							title: createHlp,
							msg: alertMsg58,
							buttons: Ext.Msg.OK,
							icon : 'iconInformation'
						});
					}
					me.elableAllFiedls();
				}
			});
		}
		
	},
	loadHelpTemplate: function()
	{
		var selValue = Ext.getCmp('tempgroup').getValue();
		if(selValue=="-1")
		{
			Ext.getCmp('filetest').setValue("");
		}
		else if (selValue == 'Admin Not Available')
		{
			Ext.Msg.show({
				title: useTemplete,
				msg:alertMsg78 + ' \'Admin\'',
				buttons: Ext.Msg.OK,
				icon : 'iconInformation',
				fn: function(response) {
					if(response == 'ok') {
						return;
					}
				}
			});
			Ext.getCmp('tempgroup').setValue("-1");
			Ext.getCmp('filetest').setValue("");
		}
		else if (selValue == 'Monitor Not Available')
		{
			Ext.Msg.show({
				title: useTemplete,
				msg:alertMsg78 + ' \'Monitor\'',
				buttons: Ext.Msg.OK,
				icon : 'iconInformation',
				fn: function(response) {
					if(response == 'ok') {
						return;
					}
				}
			});
			Ext.getCmp('tempgroup').setValue("-1");
			Ext.getCmp('filetest').setValue("");
		}
		else
		{
			var test = Ext.getCmp('test').getValue();
			var path = publicJSON.hiddens.dir + selValue;
			var urlStr = 'ICTest/data/EgTemplateUpload.jsp?path='+path+'&test='+test+'&dir='+publicJSON.hiddens.dir;
			urlStr += '&tempName='+selValue+'&addormodify='+publicJSON.hiddens.addormodify;
			Ext.Ajax.request(
			{
				url: urlStr,
				method: 'POST',
				async:false,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						publicJSON = Ext.decode( jsonText );
					}
				}
			});
			Ext.getCmp('tempgroup').getStore().loadRawData(publicJSON.optList);
			Ext.getCmp('filetest').setValue(publicJSON.textAreaValue);
			if (selValue.indexOf("_ex_") != -1)
			{
				Ext.getCmp('filetest').setFieldLabel(publicJSON.htmlViewContent1);
			}
			else
			{
				Ext.getCmp('filetest').setFieldLabel(publicJSON.htmlViewContent0);
			}
		}
	},
//	showMetaHelp: function()
//	{
//		var localDataBag = '';
//		Ext.Ajax.request(
//		{
//			url: '/final/eghelp/EgHelp.jsp',
//			method: 'POST',
//			async:false,
//			success: function( response )
//			{
//				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
//				{
//					var jsonText = response.responseText;
//					localDataBag = Ext.decode( jsonText );
//				}
//			}
//		});
//
//		Ext.create('Ext.window.Window', {
//			title: 'Help',
//			//height: 500,
//			//width: 800,
//			id:'metaHelpWin',
//			layout:{
//				type:'vbox',
//				pack:'center',
//				align:'center'
//			},
//			items:[ 
//				{
//					xtype: 'component',
//					id: 'iframeHelp',
//					width: 800,
//					height: 500,
//					html: '<iframe width=100% height=100% src=\"'+localDataBag.PAGE_URL+'\"></iframe>'
//				}
//			]
//		}).show();
//	},
	loadTestTab: function()
	{
		isConfigSupported = publicJSON.isConfigSupported;
		var testObj = Ext.getCmp('test');
		var test = testObj.getValue();
		var typeValObj = Ext.getCmp('type');
		var testType;
		var typeValue;
		if (test != null && test != '' && test != '_ex' && test != '_cf_ex')
		{
			testTabLoad = true;
			testObj.setReadOnly(true);
			var testTypeObj = Ext.getCmp('testType')
			testType =	testTypeObj.getValue();
			testTypeObj.setReadOnly(true);
			typeValObj.setReadOnly(true);
			Ext.getCmp('add').setText(modifyTooltip);
			if (!isConfigSupported)
			{
				typeValObj.hide();
			}
			if (test.indexOf('_cf_ex') > -1)
			{
				isConfigTest = true;
			}
			else
			{
				isConfigTest = false;
			}

			var execution = Ext.getCmp('execution').getValue().exerb;
			var port = Ext.getCmp('port').getValue().portrb;
			var os = '';
			var dbType = '';
			if(testType == "Script/Batch File")
			{
				os = Ext.getCmp('ostype').getValue().ostyperb;
			}
			if (testType.toLowerCase() == 'sql query')
			{
				dbType = Ext.getCmp('dbType').getValue();
			}

			tmpTest=test;
			tmpTestType=testType;
			tmpOs=os;
			tmpExecu=execution;
			tmpPort=port;
			tmpDbType=dbType;
		}
	},
	testModifyAlone: function()
	{
		var test = Ext.getCmp('test').getValue();
		var testType = Ext.getCmp('testType').getValue();
		Ext.getCmp('duplicatetest').hide();
		Ext.getCmp('nonDupTest').hide();
		var execution = Ext.getCmp('execution').getValue().exerb;
		var port = Ext.getCmp('port').getValue().portrb;
		var os = '';
		var dbType = '';
		if(testType == "Script/Batch File")
		{
			os = Ext.getCmp('ostype').getValue().ostyperb;
		}
		else if (testType.toLowerCase() == 'sql query')
		{
			dbType = Ext.getCmp('dbType').getValue();
		}

		var urlStr = "EgconfigtestparampJson.jsp?index=test&test=" + test + "&testtype=" + testType + "&type=" + execution + "&port=" + port + "&os=" + os + "&dbtype=" + dbType + "&mod=modify_test"+"&$_type="+tmpExecu+"&$_port="+tmpPort+"&$_os="+tmpOs+"&$_dbtype="+tmpDbType;

		Ext.Ajax.request(
		{
			url: 'ICTest/data/'+urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});

		if (publicJSON.AlertType == 'Error')
		{
			Ext.Msg.show({
					title: error+': '+publicJSON.AlertTitle,
					msg:publicJSON.AlertMsg,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
		}
		else if (publicJSON.AlertType == 'Result')
		{
			Ext.Msg.show({
				title: publicJSON.AlertTitle,
				msg:publicJSON.AlertMsg + ' '+ 'Would you like to add more parameters for this test?',
				buttons: Ext.Msg.YESNO,
				icon: 'iconInformation',
				fn: function(response) {
					if(response == 'yes') {
						//Ext.getCmp('modParamWindow').close();
						Ext.getCmp('addParamTab').enable();
						Ext.getCmp('newtest').setActiveTab(1);
						Ext.getCmp('addMeasureTab').enable();
						var urlToProcess = publicJSON.forwardURL;
						me.loadAddParamTab(urlToProcess);
					}
					else if (response == 'no')
					{
						//Ext.getCmp('modParamWindow').destroy();
						var urlToProcess = publicJSON.forwardURL;
						me.loadAddParamTab(urlToProcess);
						jmxCtrlr.loadAddMeasureTab(urlToProcess);
						var urlStr = 'EgConfigJmxMeasureJson.jsp?test='+test;
						//jmxCtrlr.showAddedMeasures(urlStr);
						Ext.getCmp('newtest').setActiveTab(2);
					}
				}
			});
		}
		/*else if (publicJSON.AlertType == 'Result')
		{
			Ext.Msg.show({
				title: publicJSON.AlertTitle,
				msg:publicJSON.AlertMsg,
				buttons: Ext.Msg.OK,
				icon: 'iconInformation',
				fn: function(response) {
						if(response == 'ok') {
						//	me.buildMainData(test, testType);
						//	me.afterMainRender();
						}
					}
			});
		}*/
	},
	showModifyParam: function(urlStr)
	{
		var me = this;
		Ext.Ajax.request(
		{
			url: 'ICTest/data/'+urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
		var I = Ext.WindowManager.getActive();
		if (I) {
			I.close();
		}
		var paramModifyWin;
		if(publicJSON.paramName == 'password')
		{
			paramModifyWin =Ext.create('Ext.window.Window', {
				title: modParam,
				padding:'3 10 10 10',
				height: 200,
				width: 350,
				id:'modParamWindow',
				layout:{
					type:'vbox',
					pack:'start',
					align:'center'
				},
				defaults:{
					margin: 10
				},
				items:[ 
					{
						xtype: 'textfield',
						cls :'textbox',
						fieldLabel: param,
						labelAlign: 'top',
						labelSeparator: ' ',
						id:'modParam',
						name:'modParam',
						value: publicJSON.paramName,
						width: 250
					},
					{
						xtype: 'textfield',
						cls :'textbox',
						fieldLabel: defVal,
						labelAlign: 'top',
						labelSeparator: ' ',
						inputType:"password",
						id:'modValue',
						name:'modValue',
						value: publicJSON.paramValue,
						width: 250
					},
					{
						xtype: 'button',
						cls :'button20',
						text: modifyTooltip,
						id:'modParamButton',
						width: 80,
						listeners:
						{
							click:{
								fn: function (id){
									me.doModifyParam();
								}
							}
						}
					}
				]
			});
		}
		else
		{
			paramModifyWin =Ext.create('Ext.window.Window', {
				title: modParam,
				padding:'3 10 10 10',
				height: 200,
				width: 350,
				id:'modParamWindow',
				layout:{
					type:'vbox',
					pack:'start',
					align:'center'
				},
				defaults:{
					margin: 10
				},
				items:[ 
					{
						xtype: 'textfield',
						cls :'textbox',
						fieldLabel: param,
						labelAlign: 'top',
						labelSeparator: ' ',
						id:'modParam',
						name:'modParam',
						value: publicJSON.paramName,
						width: 250
					},
					{
						xtype: 'textfield',
						cls :'textbox',
						fieldLabel: defVal,
						labelAlign: 'top',
						labelSeparator: ' ',
						id:'modValue',
						name:'modValue',
						value: publicJSON.paramValue,
						width: 250
					},
					{
						xtype: 'button',
						cls :'button20',
						text: modifyTooltip,
						id:'modParamButton',
						width: 80,
						listeners:
						{
							click:{
								fn: function (id){
									me.doModifyParam();
								}
							}
						}
					}
				]
			});
		}
		paramModifyWin.show();

		if (publicJSON.isSnmpParam || publicJSON.isJmxParam)
		{
			Ext.getCmp('modParam').setReadOnly(true);
		}
		else
		{
			Ext.getCmp('modParam').setReadOnly(false);
		}
	},
	doModifyParam: function()
	{
		jmxCtrlr = this.getController('ICTest.controller.AddJmxTestCtrlr');
		Ext.getCmp('addParam').show();
		var me = this;
		var os = '';
		var dbType = '';

		var test = Ext.getCmp('test').getValue();
		var testType = Ext.getCmp('testType').getValue();
		var paramName = Ext.getCmp('modParam').getValue();
		var paramVal = Ext.getCmp('modValue').getValue();

		if(testType == "Script/Batch File")
		{
			os = Ext.getCmp('ostype').getValue().ostyperb;
		}
		else if (testType.toLowerCase() == 'sql query')
		{
			dbType = Ext.getCmp('dbType').getValue();
		}

		if (!this.paramValidation(paramName,paramVal,testType))
		{
			return;
		}
		var urlStr = 'EgconfigtestparampJson.jsp?index=paramTab&mod=modify_params&one='+encodeURIComponent(paramName)+'&two='+encodeURIComponent(paramVal)+'&test='+test;
		urlStr += '&org_param='+encodeURIComponent(publicJSON.hiddens.org_param)+'&os='+os+'&dbtype='+dbType+'&testtype='+testType;

		var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: updating+'...'});
		tmpMask.show();

		Ext.Ajax.request(
		{
			url: 'ICTest/data/'+urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				tmpMask.hide();
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );

					if (publicJSON.AlertType == 'Error')
					{
						Ext.Msg.show({
							title: error+': '+publicJSON.AlertTitle,
							msg:publicJSON.AlertMsg,
							buttons: Ext.Msg.OK,
							icon: 'iconError'
						});
					}
					else if (publicJSON.AlertType == 'Result')
					{
						Ext.Msg.show({
							title: publicJSON.AlertTitle,
							msg:publicJSON.AlertMsg + ' '+ 'Would you like to add more parameters for this test?',
							buttons: Ext.Msg.YESNO,
							icon: 'iconInformation',
							fn: function(response) {
								if(response == 'yes') {
									Ext.getCmp('modParamWindow').close();
									Ext.getCmp('addParamTab').enable();
									var urlToProcess = publicJSON.forwardURL;
									me.loadAddParamTab(urlToProcess);
								}
								else if (response == 'no')
								{
									Ext.getCmp('modParamWindow').destroy();
									var urlToProcess = publicJSON.forwardURL;
									jmxCtrlr.loadAddMeasureTab(urlToProcess);
									var urlStr = 'EgConfigJmxMeasureJson.jsp?test='+test;
									//jmxCtrlr.showAddedMeasures(urlStr);
									Ext.getCmp('newtest').setActiveTab(2);
								}
							}
						});
					}
				}
			},
			failure: function( response )
			{
				tmpMask.hide();
			}
		});
	},
	showAddMeasure: function()
	{
		var testType = Ext.getCmp('testType').getValue();
		if(testType == "Jmx")
		{
			testType = "JMX";
		}
		if (testType == 'Custom')
		{
			customCtrlr = this.getController('ICTest.controller.AddCustomTestCtrlr');
			customCtrlr.showAddNewMeasure();
		}
		else if (testType == 'Script/Batch File')
		{
			scriptCtrlr = this.getController('ICTest.controller.AddScriptTestCtrlr');
			scriptCtrlr.showAddNewMeasure();
		}
		else if (testType.toLowerCase() == 'sql query')
		{
			sqlCtrlr = this.getController('ICTest.controller.AddSqlTestCtrlr');
			sqlCtrlr.showAddNewMeasure();
		}
		else if (testType == 'Perfmon')
		{
			perfmonCtrlr = this.getController('ICTest.controller.AddPerfmonTestCtrlr');
			perfmonCtrlr.showAddNewMeasure();
		}
		else if (testType == 'Snmp')
		{
			snmpCtrlr = this.getController('ICTest.controller.AddSnmpTestCtrlr');
			snmpCtrlr.showAddNewMeasure();
		}
		else if (testType == 'JMX')
		{
			jmxCtrlr = this.getController('ICTest.controller.AddJmxTestCtrlr');
			var isAddNewMeasure = 'Yes';
			var fromMbean = 'No';
			jmxCtrlr.showAddNewMeasure(isAddNewMeasure,fromMbean);
		}
		else if (testType == 'REST')
		{
			if(Ext.isEmpty(datasetCtrlr))
			{
				datasetCtrlr= this.getController('ICTest.controller.DatasetController');
			}
			datasetCtrlr.showAddNewMeasure();
		}
	},
	deleteParam: function(url2Del, paramName)
	{
		var me = this;
		Ext.getCmp('addParam').show();
		Ext.Msg.show({
			title:delParam,
			msg:alertMsg57 + ' \''+paramName+'\'?',
			buttons: Ext.Msg.OKCANCEL,
			icon: 'iconConfirmation',
			fn: function(response) {
				if(response == 'ok') {
					Ext.Ajax.request(
					{
						url: 'ICTest/data/'+url2Del+'&index=paramTab',
						method: 'POST',
						async:false,
						success: function( response )
						{
							if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
							{
								var jsonText = response.responseText;
								publicJSON = Ext.decode( jsonText );
							}
						}
					});

					if (publicJSON.AlertType == 'Result')
					{
						Ext.Msg.show({
							title: publicJSON.AlertTitle,
							msg:publicJSON.AlertMsg,
							buttons: Ext.Msg.OK,
							icon: 'iconInformation',
							fn: function(response) {
								if(response == 'ok') {
									Ext.getCmp('addParamTab').enable();
									var urlToProcess = publicJSON.forwardURL;
									me.loadAddParamTab(urlToProcess);
								}
							}
						});
					}
				}
			}
		});
	}
});


