var isConfigSupported =  "";
Ext.define('ICTest.controller.Main',{
	extend:'Ext.app.Controller',
	views:['Tests'],
	requires:['ICTest.view.Tests'],
	refs:[
		{selector:'tests', ref:'tests'}
	],
	init:function(){
		ctrler = this;
		this.buildMainData();
		isConfigSupported = publicJSON.isConfigSupported;
		this.control({
			'tests':
			{
				'afterrender': this.afterMainRender
			},
			'tests trigger[id="searchBox"]':
			{
				'change': this.searchTest
			},
			'tests [id="udGrid"]':
			{
				//'itemmouseenter': this.showActions,
				//'itemmouseleave': this.hideActions
			},
			'tests button[id="addTestButton"]':
			{
				'click':this.addNewTest
			}
		});
	},
	buildMainData: function()
	{
		Ext.Ajax.request(
		{
			url: 'ICTest/data/EgUDTestJson.jsp',
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},
	afterMainRender: function()
	{
		if (publicJSON.noUDTestsFound)
		{
			Ext.getCmp('udGrid').getStore().removeAll();
			Ext.getCmp('searchBox').disable();
		}
		else
		{
			Ext.getCmp('searchBox').enable();
			//isConfigSupported =  publicJSON.isConfigSupported;
			if(isConfigSupported)
			{
				var gridObj = Ext.getCmp('udGrid');
				gridObj.getStore().removeAll();
				gridObj.getStore().loadRawData(publicJSON.testsList);
			}
			else
			{
				var performanceTestGrid = {
					xtype: 'customgrid',
					cls:'gridSkin',
					frame:false,
					border:true,
					padding:0,
					scroll:true,
					id:'udGrid1',
					title: udTests,
					store: new Ext.data.Store({
						fields: ['test','type','testType','jspPage'],
						data : []
					}),
					autoScroll: true,
					columns: {
						defaults: {
							sortable: true,
							hideable: false,
							menuDisabled: true,
							draggable: false,
							resizable: false
						},
						items: [
							{
								text: test,
								dataIndex: 'test',
								flex:1
							},
							{
								text: 'Type',
								dataIndex: 'type',
								hidden: true,
								flex:1
							},
							{
								text: 'Category',
								dataIndex: 'testType',
								flex: 1
							},
							{
								text: '',
								dataIndex: 'jspPage',
								hidden: true
							},
							{
								xtype: 'actioncolumn',
								//cls: 'tasks-icon-column-header tasks-edit-column-header',
								width: 36,
								//icon: '../../../../admin/extjs/resources/images/edit_task.png',
								iconCls: 'iconModify',
								//tooltip: modifyTooltip,
								sortable: false,
								renderer: function(value, metaData, record, row, col, store, gridView)
								{
									metaData.tdAttr = "data-qtip='"+modifyTooltip+"' data-qclass='yellowTip'";
								},
								handler: function(grid, rowIndex, colIndex) {
									ctrler.modifyTest(grid, rowIndex, colIndex);
								}
							},
							{
								xtype: 'actioncolumn',
								//cls: 'tasks-icon-column-header tasks-delete-column-header',
								width: 36,
								//icon: '../../../../admin/extjs/resources/images/delete.png',
								iconCls: 'iconDelete',
								//tooltip: deleteTooltip,
								sortable: false,
								renderer: function(value, metaData, record, row, col, store, gridView)
								{
									metaData.tdAttr = "data-qtip='"+deleteTooltip+"' data-qclass='yellowTip'";
								},
								handler: function(grid, rowIndex, colIndex) {
									ctrler.deleteTest(grid, rowIndex, colIndex);
								}
							}
						]
					},
					margin: 10,
					flex: 1,
					emptyText:  '<table border="0" width="100%" height="400px"><tr><td align="center" valign="middle"><div class="iconInformation"></div><div class="commonErrorMsgText" id="noUdTestsAlrtDiv">'+noTestsFnd+'</div></td></tr></table>',
					viewConfig: {
						deferEmptyText: false
					},
					tools: [
						/*{
							xtype:'tbfill',
						},*/
						{
							xtype: 'trigger',
							cls:'whitedropdown_search',
							trigger1Cls: 'x-form-clear-trigger',
							trigger2Cls: 'x-form-search-trigger',
							emptyText: 'Search',
							id:'searchBox',
							padding:0,
							margin:'0 5 0 0',
							onTrigger1Click: function() {
								this.reset();
							},
							onTrigger2Click: function() {
								ctrler.searchTest();
							},
							getTriggerMarkup: function() {
								var me = this,
								i = 0,
								hideTrigger = (me.readOnly || me.hideTrigger),
								triggerCls,
								triggerBaseCls = me.triggerBaseCls,
								triggerConfigs = [],
								unselectableCls = Ext.dom.Element.unselectableCls,
								style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
								cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;
								// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
								// single triggerCls config. Should rethink this, perhaps something more structured like a list of
								// trigger config objects that hold cls, handler, etc.
								// triggerCls is a synonym for trigger1Cls, so copy it.
								if (!me.trigger1Cls) {
									me.trigger1Cls = me.triggerCls;
								}
								// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
								for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
									if (i == 0)
									{
										triggerConfigs.push({
											tag: 'td',
											role: 'presentation',
											valign: 'top',
											cls: cls,
											id : 'MyTrigger_'+i,
											style: style + "display:none;",
											cn: {
												cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
												role: 'presentation'
											}
										});
									}
									else
									{
										triggerConfigs.push({
											tag: 'td',
											role: 'presentation',
											valign: 'top',
											cls: cls,
											id : 'MyTrigger_'+i,
											style: style,
											cn: {
												cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
												role: 'presentation'
											}
										});
									}
								}
								triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
								return Ext.DomHelper.markup(triggerConfigs);
							}
						},
						{
							xtype: 'toolbar',
							ui: 'footer',
							padding:0,
							margin:0,
							items: [
								{
									xtype: 'button',
									cls:'button20',
									padding:0,
									margin:0,
									id: 'addTestButton',
									text: addTest
								}
							]
						}
					]
				}
				var contObj = Ext.getCmp('testCnt');
				contObj.removeAll();
				contObj.add(performanceTestGrid);
				contObj.show();
				var gridObj = Ext.getCmp('udGrid1');
				gridObj.getStore().removeAll();
				gridObj.getStore().loadRawData(publicJSON.testsList);
			}
		}
	},
	searchTest: function()
	{
		var searchStr = Ext.getCmp('searchBox').getValue();
		searchStr = encodeURIComponent(searchStr);
		var urlStr = 'ICTest/data/EgUDTestJson.jsp?searchStr='+searchStr;
		if (searchStr == "" || searchStr.length == 0)
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');
		}
		Ext.Ajax.request(
		{
			url : urlStr,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
			},
			failure : function(response)
			{
			}
		});
		if(isConfigSupported)
		{
			if (publicJSON.noSrchItemFound)
			{
				Ext.getCmp('udGrid').getStore().removeAll();
				Ext.get('noUdTestsAlrtDiv').update(noSrcTestFnd+'.');
			}
			else
			{
				var gridObj = Ext.getCmp('udGrid');
				gridObj.getStore().removeAll();
				gridObj.getStore().loadRawData(publicJSON.testsList);
			}
		}
		else
		{
			if (publicJSON.noSrchItemFound)
			{
				Ext.getCmp('udGrid1').getStore().removeAll();
				Ext.get('noUdTestsAlrtDiv').update(noSrcTestFnd+'.');
			}
			else
			{
				var gridObj = Ext.getCmp('udGrid1');
				gridObj.getStore().removeAll();
				gridObj.getStore().loadRawData(publicJSON.testsList);
			}
		}
	},
	showActions: function(view, task, node, rowIndex, e)
	{
		var hideIcon = view.getStore().getAt(rowIndex);
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
			Ext.each(icons, function(icon){
		Ext.get(icon).removeCls('x-hidden');
		});
	},
	hideActions: function(view, task, node, rowIndex, e)
	{
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
		Ext.each(icons, function(icon){
			Ext.get(icon).addCls('x-hidden');
		});
	},
	addNewTest: function()
	{
		Ext.getCmp('ictestviewport').removeAll();
		this.getController('AddTestCtrlr').init();
		this.getController('DatasetController').init();
		Ext.getCmp('ictestviewport').add(
			{
				xtype: 'addnewtest'
			});
		if(!isConfigSupported)
		{
			Ext.getCmp('type').hide();
		}
	},
//	testsAssign:function(grid, rowIndex, colIndex)
//	{
//		var obj = grid.getStore().getAt(rowIndex);
//		var layerName = obj.get('ActualValue');
//		
//		Ext.getCmp('iclayerviewport').removeAll();
//		this.getController('TestsCtrlr').init();
//		this.getController('TestsCtrlr').buildMainData(layerName);
//		Ext.getCmp('iclayerviewport').add(
//			{
//				xtype: 'associatetests'
//			});
//	},
	deleteTest:function(grid, rowIndex, colIndex)
	{
		var obj = grid.getStore().getAt(rowIndex);
		var testName = obj.get('test');
		Ext.Msg.show({
			title: pageTitle1,
			msg: confrmMsg+' \''+testName+'\'?',
			buttons: Ext.Msg.YESNO,
			icon: 'iconConfirmation',
			fn: function(response) {
				if(response === 'yes')
				{
					var urlStr = "ICTest/data/EgDelUDTestJson.jsp?test="+testName;
					var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: updating+'...'});
					tmpMask.show();
					Ext.Ajax.request(
					{
						url : urlStr,
						method: 'POST',
						async: false,
						success: function(response)
						{
							tmpMask.hide();
							var jsonText = response.responseText;
							resultJSON = Ext.decode(jsonText);
							if (resultJSON.AlertType=='Result')
							{
								Ext.Msg.show({
									title: resultJSON.AlertTitle,
									msg: resultJSON.AlertMsg,
									buttons: Ext.Msg.OK,
									icon: 'iconInformation',
									width: 300,
									fn:function(response){
										ctrler.buildMainData();
										ctrler.afterMainRender();
									}
								});
							}
							else if(resultJSON.AlertType=='Error')
							{
								Ext.Msg.show({
									title: error+": "+resultJSON.AlertTitle,
									msg: resultJSON.AlertMsg,
									buttons: Ext.Msg.OK,
									icon: 'iconError',
									fn: function(response){
										ctrler.buildMainData();
										ctrler.afterMainRender();
									}
								});
							}
						},
						failure : function(response)
						{
							tmpMask.hide();
						}
					});
				}
			}
		});
	},
	modifyTest: function(grid, rowIndex, colIndex)
	{
		var obj = grid.getStore().getAt(rowIndex);
		var type = obj.get('type');
		var test = obj.get('test');
		var testType = obj.get('testType');
		addctrler = this.getController('ICTest.controller.AddTestCtrlr');
		Ext.getCmp('ictestviewport').removeAll();
		this.getController('ModifyTestCtrlr').init(test, testType);
		Ext.getCmp('ictestviewport').add({
			xtype: 'addnewtest'
		});
		isModifyTest = true;
		if (test.indexOf('_cf_ex') > -1)
		{
			isConfigTest = true;
		}
		else
		{
			isConfigTest = false;
		}
	}
});



