Ext.define('ICTest.controller.ModifyTestCtrlr',{
	extend:'Ext.app.Controller',
	views:['AddNewTest'],
	requires:['ICTest.view.AddNewTest'],
	refs:[
		{selector:'addnewtest', ref:'addnewtest'}
	],
	init:function(test, testType){
		modifyCtrler = this;
		snmpCtrlr = this.getController('ICTest.controller.AddSnmpTestCtrlr');
		this.getController('DatasetController').init();
		this.buildMainData(test, testType,'test');
		this.control({
			'addnewtest':
			{
				'afterrender': this.afterMainRender
			},
			'addnewtest button[id="backButton"]':
			{
				'click':this.goBack
			},
			'addnewtest button[id="add"]':
			{
				'click':this.modifyTest
			},
			'addnewtest button[id="addNewParam"]':
			{
				'click':this.showAddNewParam
			},
			'addnewtest button[id="addNewMeasure"]':
			{
				'click':this.showAddMeasure
			},
			'addnewtest combo[id="tempgroup"]':
			{
				'select':addctrler.loadHelpTemplate
			},
			'addnewtest button[id="chooseClass"]':
			{
				'click':addctrler.showClassFileUpload
			},
			'addnewtest button[id="chooselLib"]':
			{
				'click':addctrler.showLibFileUpload
			},
			'addnewtest button[id="generate"]':
			{
				'click':addctrler.generateTest
			},
			'addnewtest button[id="configureMetricsBtn"]':
			{
				'click':this.showConfigMetricsPopup
			},
			'addnewtest button[id="ddChooseClass"]':
			{
				'click':addctrler.showDDClassFileUpload
			},
			'addnewtest button[id="ddChooselLib"]':
			{
				'click':addctrler.showDDLibFileUpload
			},
			'addnewtest button[id="ddGenerate"]':
			{
				'click':addctrler.generateDDTest
			},
			'addnewtest button[id="addNewDDMeasure"]':
			{
				'click':addctrler.showAddNewDDMeasure
			},
			'addnewtest button[id="chooseScript"]':
			{
				'click':addctrler.showScriptFileUpload
			},
			'addnewtest radiogroup[id="elements"]':
			{
				'change': snmpCtrlr.elementsSelection
			}
		});
	},
	showConfigMetricsPopup : function(btnObj)
	{
		if(Ext.isEmpty(datasetCtrlr))
		{
			datasetCtrlr= this.getController('ICTest.controller.DatasetController');
		}
		var test = Ext.getCmp('test').getValue();
		var urlStr = "EgConfigRESTMeasureJson.jsp?test=" + test;
		datasetCtrlr.loadAddMeasureTab(urlStr);
		datasetCtrlr.addRESTDataFields(publicJSON['restDSNName'],btnObj); 
	},
	buildMainData: function(test, testType,index)
	{
		Ext.Ajax.request(
		{
			url: 'ICTest/data/EgConfigTestParamJson.jsp?test='+test+'&testtype='+testType+'&index='+index,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},
	afterMainRender: function()
	{
		// Tab - Test
		var me = this;
		
		Ext.getCmp('addParamTab').enable();
		Ext.getCmp('addMeasureTab').enable();
		
		if (publicJSON.showGenerateTab)
		{
			Ext.getCmp('generateCntnr').enable();
			Ext.getCmp('ddGenerateTab').enable();
			Ext.getCmp('tab6Help').enable();
			if (publicJSON.ddEnabled)
			{
				Ext.getCmp('newtest').child('#tab5DD').tab.show();
			}
		}
		else
		{
			Ext.getCmp('generateCntnr').disable();
			Ext.getCmp('ddGenerateTab').disable();
			Ext.getCmp('tab6Help').disable();
		}
		
		var testObj = Ext.getCmp('test');
		testObj.setValue(publicJSON.test);
		testObj.setReadOnly(true);
		var testType = publicJSON.testType;
		var testTypeObj = Ext.getCmp('testType');
		testTypeObj.setValue(testType);
		testTypeObj.setReadOnly(true);
		var typeValue = publicJSON.typeValue;

		var typeValObj = Ext.getCmp('type');
		typeValObj.setRawValue(typeValue);
		if (publicJSON.internalChecked)
		{
			Ext.getCmp('execIn').setValue(true);
		}
		else if (publicJSON.externalChecked)
		{
			Ext.getCmp('execEx').setValue(true);
		}
		
		if (publicJSON.portBasedYes)
		{
			Ext.getCmp('portYes').setValue(true);
		}
		else 
		{
			Ext.getCmp('portNo').setValue(true);
		}

		if (testType == "Script/Batch File")
		{
			Ext.getCmp('ostype').show();
			if (publicJSON.unixChecked)
			{
				Ext.getCmp('osUnix').setValue(true);
			} 
			else if (publicJSON.winChecked)
			{
				Ext.getCmp('osWin').setValue(true);
			}
		}
		else
		{
			Ext.getCmp('ostype').hide();
		}
		var dbTypeObj = Ext.getCmp('dbType');
		if (testType.toLowerCase() == 'sql query')
		{
			dbTypeObj.show();
			dbTypeObj.getStore().loadRawData(publicJSON.dbTypes);
			dbTypeObj.setValue(publicJSON.dbTypeSelected);
		}
		else
		{
			dbTypeObj.hide();
		}

		if(testType == 'REST')
		{
			Ext.getCmp('datasetTab').enable();
			Ext.getCmp('newtest').getTabBar().items.items[2].enable();
			Ext.getCmp('newtest').getTabBar().items.items[2].show();
		}
		else
		{
			Ext.getCmp('datasetTab').disable();
			Ext.getCmp('newtest').getTabBar().items.items[2].disable();
			Ext.getCmp('newtest').getTabBar().items.items[2].hide();
		}

		Ext.getCmp('add').setText(modifyTooltip);

		//Tab - Parameter
		var cntnrObj = Ext.getCmp('addParamCntnr');
		cntnrObj.removeAll();
		var existingParams = publicJSON.paramList;
		if (existingParams.length == 0)
		{
			Ext.getCmp('noParamsFnd').show();
		}
		else
		{
			Ext.getCmp('noParamsFnd').hide();
			for (var p=0; p<existingParams.length; p++) {
					var param = existingParams[p];
					if(param.paramName == "password")
					{
							cntnrObj.add({
							xtype: 'fieldset',
							title: '<b>'+param.paramName+'</b>',
							layout: {
								type: 'vbox',
								align: 'left'
							},
							width: 650,
							//height: 70,
							items: [
								{
									xtype:"displayfield",
									fieldLabel: defVal,
									inputType:"password",
									labelSeparator: '',
									value: param.paramValue,
									flex: 1,
									renderer: function(value, metaData, record, row, col, store, gridView)
									{
										var a="&#8226;";
										for(var k=1; k<value.length; k++)
										{
											a = a+"&#8226;";
										}
										return "<h1>"+a+"</h1>";
									}
								},
								{
									xtype:'container',
									layour:{
										type: 'hbox',
										pack: 'left'
									},
									margin: '10 0 10 0',
									items : [
										{
											xtype: 'button',
											cls : 'button20',
											text: modifyTooltip,
											modifyURL: param.modifyURL,
											width: 80,
											handler: function() {
												me.showModifyParam(this.modifyURL);
											},
										},
										{
											xtype: 'button',
											cls : 'button20',
											text: deleteTooltip,
											hidden: param.hideDelete,
											deleteURL: param.deleteURL,
											paramName : param.paramName,
											width: 80,
											handler: function() {
												me.deleteParam(this.deleteURL, this.paramName);
											},
											margin: '0 0 0 20'
										}
									]
								}
							]
						});
					}
					else
					{
						cntnrObj.add({
						xtype: 'fieldset',
						title: '<b>'+param.paramName+'</b>',
						layout: {
							type: 'vbox',
							align: 'left'
						},				
						width: 650,
						height: 100,
						items: [
							{
								xtype: 'container',
								layout:{
									type: 'hbox',
									pack: 'start'
								},
								items:[
									{
										xtype: 'displayfield',
										fieldLabel: defVal,
										labelSeparator: '',
										value: param.paramValue,
										//flex: 1,
										margin: '0 0 0 10'
									}
								]
							},
							{
								xtype:'container',
								layour:{
									type: 'hbox',
									pack: 'center'
								},
								margin: 10,
								items:[
									{
										xtype: 'button',
										cls : 'button20',
										text: modifyTooltip,
										modifyURL: param.modifyURL,
										width: 80,
										handler: function() {
											me.showModifyParam(this.modifyURL);
										},
										//columnWidth: 0.25
									},
									{
										xtype: 'button',
										cls : 'button20',
										text: deleteTooltip,
										hidden: param.hideDelete,
										deleteURL: param.deleteURL,
										paramName: param.paramName,
										width: 80,
										handler: function() {
											me.deleteParam(this.deleteURL,this.paramName);
										},
										//columnWidth: 0.25,
										margin: '0 0 0 20'
									}
								]
							}
						]
					});
				}
			}
		}
		if(testType == 'REST')
		{
			Ext.getCmp('newtest').getTabBar().items.items[1].hide();
			Ext.getCmp('newtest').getTabBar().items.items[4].hide();
			isRESTTestType=true;
		}
		else
		{
			if (publicJSON.showAddNewParam)
			{
				Ext.getCmp('addParam').show();
			}
			else
			{
				Ext.getCmp('addParam').hide();
			}
		}
	},
	goBack: function()
	{
		window.location.href= '/final/admin/EgUDTest.jsp';
	},
	modifyTest: function()
	{
		var me = this;
		var test = publicJSON.test;
		var testType = publicJSON.testType;
		if (test == null || test == undefined)
		{
			test = Ext.getCmp('test').getValue();
			testType = Ext.getCmp('testType').getValue();
		}
		var execution = Ext.getCmp('execution').getValue().exerb;
		var port = Ext.getCmp('port').getValue().portrb;
		var os = '';
		var dbType = '';
		if(testType == "Script/Batch File")
		{
			os = Ext.getCmp('ostype').getValue().ostyperb;
		}
		else if (testType.toLowerCase() == 'sql query')
		{
			dbType = Ext.getCmp('dbType').getValue();
		}

		var $Type = publicJSON.$execution;
		var $port = publicJSON.$port;
		var $os = publicJSON.$os;
		var $dbType = publicJSON.$dbType;

		var urlStr = "EgconfigtestparampJson.jsp?index=test&test=" + test + "&testtype=" + testType + "&type=" + execution + "&port=" + port + "&os=" + os + "&dbtype=" + dbType + "&mod=modify_test"+"&$_type="+$Type+"&$_port="+$port+"&$_os="+$os+"&$_dbtype="+$dbType;

		Ext.Ajax.request(
		{
			url: 'ICTest/data/'+urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});

		if (publicJSON.AlertType == 'Error')
		{
			Ext.Msg.show({
					title: error+': '+publicJSON.AlertTitle,
					msg:publicJSON.AlertMsg,
					buttons: Ext.Msg.OK,
					icon: 'iconError'
				});
		}
		else if (publicJSON.AlertType == 'Result')
		{
			Ext.Msg.show({
				title: publicJSON.AlertTitle,
				msg:publicJSON.AlertMsg,
				closable: false,
				icon: 'iconInformation',
				buttons: Ext.Msg.OK,
				fn: function(response) {
						if(response == 'ok') {
							me.buildMainData(test, testType,'test');
							me.afterMainRender();
						}
					}
			});
		}
	},
	showAddNewParam: function()
	{
		var me = this;
		Ext.create('Ext.window.Window', {
			padding:'3 10 10 10',
			title: newParam,
			height: 175,
			width: 350,
			id:'addParamWindow',
			layout:{
				type:'vbox',
				pack:'start',
				align:'center'
			},
			modal: true,
			resizable: false,
			items:[ 
				{
					xtype: 'textfield',
					cls : 'textbox',
					fieldLabel: param,
					//labelAlign: 'top',
					labelSeparator: ' ',
					id:'param',
					name:'param',
					width: 300,
					margin: '10 0 0 0'
				},
				{
					xtype: 'textfield',
					cls : 'textbox',
					fieldLabel: defVal,
					//labelAlign: 'top',
					labelSeparator: ' ',
					id:'value',
					name:'value',
					value:'unconfigured',
					width: 300,
					margin: '10 0 0 0'
				},
				{
					xtype: 'button',
					cls :'button20',
					text: add,
					id:'addParamButton',
					width: 80,
					listeners:
					{
						click:{
							fn: function (id){
								me.doAddNewParam();
							}
						}
					},
					margin: '20 0 20 0'
				}
			]
		}).show();
	},
	doAddNewParam:function()
	{
		var me = this;
		jmxCtrlr = this.getController('ICTest.controller.AddJmxTestCtrlr');
		var param = Ext.getCmp('param').getValue();
		var value = Ext.getCmp('value').getValue();
		var test = Ext.getCmp('test').getValue();
		var testType = Ext.getCmp('testType').getValue();
		var os = '';
		var dbType = '';
		if(testType == "Script/Batch File")
		{
			os = Ext.getCmp('ostype').getValue().ostyperb;
		}
		else if (testType.toLowerCase() == 'sql query')
		{
			dbType = Ext.getCmp('dbType').getValue();
		}

		if (!this.paramValidation(param,value,testType))
		{
			return;
		}

		var urlStr = "EgconfigtestparampJson.jsp?index=paramTab&param="+param+"&value="+value+"&mod=param&test="+test+'&os='+os+'&dbtype='+dbType+'&testtype='+testType;

		var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: updating+'...'});
		tmpMask.show();
	
		Ext.Ajax.request(
		{
			url: 'ICTest/data/'+urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				tmpMask.hide();
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );

					if (publicJSON.AlertType == 'Error')
					{
						Ext.Msg.show({
							title: error+': '+publicJSON.AlertTitle,
							msg:publicJSON.AlertMsg,
							buttons: Ext.Msg.OK,
							icon: 'iconError'
						});
					}
					else if (publicJSON.AlertType == 'Result')
					{
						Ext.Msg.show({
							title: publicJSON.AlertTitle,
							msg:publicJSON.AlertMsg + '.'+ addParamAlert,
							buttons: Ext.Msg.YESNO,
							icon: 'iconInformation',
							fn: function(response) {
								if(response == 'yes') {
									Ext.getCmp('addParamWindow').close();
									Ext.getCmp('addParamTab').enable();
									var urlToProcess = publicJSON.forwardURL;
									//alert(urlToProcess);
									me.loadAddParamTab(urlToProcess);
								}
								else if (response == 'no')
								{
									Ext.getCmp('addParamWindow').destroy();
									var urlToProcess = publicJSON.forwardURL;
									me.loadAddParamTab(urlToProcess);
									jmxCtrlr.loadAddMeasureTab(urlToProcess);
									
									var urlStr = 'EgConfigJmxMeasureJson.jsp?test='+test;
									jmxCtrlr.showAddedMeasures(urlStr);
									
									//Ext.getCmp('generateCntnr').enable();
									//Ext.getCmp('tab6Help').enable();
									Ext.getCmp('newtest').setActiveTab(2);
								}
							}
						});
					}


					/*Ext.Msg.show({
				title: publicJSON.AlertTitle,
				msg:publicJSON.AlertMsg + ' '+ alertMsg80,
				closable: false,
				buttons: Ext.Msg.YESNO,
				icon: 'iconInformation',
				fn: function(response) {
					if(response == 'yes') {
						Ext.getCmp('addJmxMeasureWindow').destroy();
						var urlToProcess = publicJSON.forwardURL;
						me.loadAddMeasureTab(urlToProcess,'1');
						var isAddNewMeasure = 'No';
						var fromMbean = 'No';
						me.showAddNewMeasure(isAddNewMeasure,fromMbean);
					}
					else if (response == 'no')
					{
						Ext.getCmp('addJmxMeasureWindow').destroy();
						var urlToProcess = publicJSON.forwardURL;
						me.loadAddMeasureTab(urlToProcess);
						
						var urlStr = 'EgConfigJmxMeasureJson.jsp?test='+test;
						me.showAddedMeasures(urlStr);

						//Ext.getCmp('generateCntnr').enable();
						//Ext.getCmp('tab6Help').enable();
						Ext.getCmp('newtest').setActiveTab(3);
					}
				}
			});*/


				}
			},
			failure: function( response )
			{
				tmpMask.hide();
			}
		});
	},
	paramValidation: function(param,value,testType)
	{
		var default_Value=true;
		if(isDouble == 'false')
		{
			default_Value = validateSingleByte(value);
		}
		var paramObj = Ext.getCmp('param');
		var valueObj = Ext.getCmp('value');
		//If Modify action
		if (paramObj == null || paramObj == undefined)
		{
			paramObj = Ext.getCmp('modParam');
			valueObj = Ext.getCmp('modValue');
		}
		//var allowToUpdate = icTestParamValidation(param,value,testType);
		var allowToUpdate = icTestParamValidationExtJS(param,value,testType);
		if(allowToUpdate == "1")
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: _checkempty,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(btn) {
					if (btn == 'ok'){
						valueObj.focus(true);
					}
				}
			});
			return false;
		}
		else if(allowToUpdate == "2")
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: _tcKeyword,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(btn) {
					if (btn == 'ok'){
						valueObj.focus(true);
					}
				}
			});
			return false;
		}
		else if(allowToUpdate == "3")
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: _checkspecial,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(btn) {
					if (btn == 'ok'){
						valueObj.focus(true);
					}
				}
			});
			return false;
		}
		else if(allowToUpdate == "5")
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: _checkdots,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(btn) {
					if (btn == 'ok'){
						valueObj.focus(true);
					}
				}
			});
			return false;
		}
		else if(allowToUpdate == "6")
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: _checkSpaces,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(btn) {
					if (btn == 'ok'){
						valueObj.focus(true);
					}
				}
			});
			return false;
		}
		else if(allowToUpdate == "7")
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: _snmpcomma,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(btn) {
					if (btn == 'ok'){
						valueObj.focus(true);
					}
				}
			});
			return false;
		}
		else if(allowToUpdate == "8")
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: _checkfordecimal,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(btn) {
					if (btn == 'ok'){
						valueObj.focus(true);
					}
				}
			});
			return false;
		}
		else if(allowToUpdate == "9")
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: _checkforobjectname,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(btn) {
					if (btn == 'ok'){
						valueObj.focus(true);
					}
				}
			});
			return false;
		}
		else if(allowToUpdate == "11")
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: _checkInt,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(btn) {
					if (btn == 'ok'){
						valueObj.focus(true);
					}
				}
			});
			return false;
		}
		else if(allowToUpdate == "12")
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: _valInt,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(btn) {
					if (btn == 'ok'){
						valueObj.focus(true);
					}
				}
			});
			return false;
		}
		else if(allowToUpdate == "13")
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: _checkport,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(btn) {
					if (btn == 'ok'){
						valueObj.focus(true);
					}
				}
			});
			return false;
		}
		else if(allowToUpdate == "14")
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: _validatePort,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(btn) {
					if (btn == 'ok'){
						valueObj.focus(true);
					}
				}
			});
			return false;
		}
		else if(allowToUpdate == "16")
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: _alphabetsOnly,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(btn) {
					if (btn == 'ok'){
						valueObj.focus(true);
					}
				}
			});
			return false;
		}
		else if(allowToUpdate == "17")
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: _validDDPattern,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(btn) {
					if (btn == 'ok'){
						valueObj.focus(true);
					}
				}
			});
			return false;
		}
		else if(allowToUpdate == "19")
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: _checkmail,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(btn) {
					if (btn == 'ok'){
						valueObj.focus(true);
					}
				}
			});
			return false;
		}
		else if(allowToUpdate == "19")
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: _checkmail,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(btn) {
					if (btn == 'ok'){
						valueObj.focus(true);
					}
				}
			});
			return false;
		}
		else if(allowToUpdate == "20")
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: _invalidUrl,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(btn) {
					if (btn == 'ok'){
						valueObj.focus(true);
					}
				}
			});
			return false;
		}
		else if(allowToUpdate == "21")
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: _invalidWebsite,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(btn) {
					if (btn == 'ok'){
						valueObj.focus(true);
					}
				}
			});
			return false;
		}
		else if(allowToUpdate == "22")
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: _invalidVersion,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(btn) {
					if (btn == 'ok'){
						valueObj.focus(true);
					}
				}
			});
			return false;
		}
		else if(allowToUpdate == "23")
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: _contentvalidation,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(btn) {
					if (btn == 'ok'){
						valueObj.focus(true);
					}
				}
			});
			return false;
		}
		else if(allowToUpdate == "24")
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: _checkcomma,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(btn) {
					if (btn == 'ok'){
						valueObj.focus(true);
					}
				}
			});
			return false;
		}
		else if(allowToUpdate == "25")
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: _checkMethod,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(btn) {
					if (btn == 'ok'){
						valueObj.focus(true);
					}
				}
			});
			return false;
		}
		else if(allowToUpdate == "26")
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: _valMethod,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(btn) {
					if (btn == 'ok'){
						valueObj.focus(true);
					}
				}
			});
			return false;
		}
		else if(allowToUpdate == "27")
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: _validProtocol,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(btn) {
					if (btn == 'ok'){
						valueObj.focus(true);
					}
				}
			});
			return false;
		}
		
		if(!checkblank(param))
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: alertMsg7,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(btn) {
					if (btn == 'ok'){
						paramObj.focus(true);
					}
				}
			});
			return false;
		}
		else if(!checkspecialnomess(param, "`~!@#$%^&*()+=-/?'\"]{}[\\|;:.,><"))
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: alertMsg3,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(btn) {
					if (btn == 'ok'){
						paramObj.focus(true);
					}
				}
			});
			return false;
		}
		/*else if(!checkblank(value))
		{
			//alert(alertMsg8);
			valueObj.focus(true);
			return false;
		}
		else if(!checkspace(value))
		{
			valueObj.focus(true);
			return false;
		}*/
		else if(checkspaceExtjs(value) == "17")
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: _checkblank,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(btn) {
					if (btn == 'ok'){
						valueObj.focus(true);
					}
				}
			});
			return false;
		}
		else if(param == "host")
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: alertMsg9,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(btn) {
					if (btn == 'ok'){
						paramObj.focus(true);
					}
				}
			});
			return false;
		}
		else if(param == "info")
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: alertMsg10,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(btn) {
					if (btn == 'ok'){
						paramObj.focus(true);
					}
				}
			});
			return false;
		}
		else if (param ==  "scriptfile")
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: alertMsg56,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(btn) {
					if (btn == 'ok'){
						paramObj.focus(true);
					}
				}
			});
			return false;
		}
		else if(param == "port")
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: alertMsg11,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(btn) {
					if (btn == 'ok'){
						paramObj.focus(true);
					}
				}
			});
			return false;
		}
		else if(!validateSingleByte(param))
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: alertMsg12,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(btn) {
					if (btn == 'ok'){
						paramObj.focus(true);
					}
				}
			});
			return false;
		}
		else if(!default_Value)
		{
			Ext.Msg.show({
				title: pageTitle1,
				msg: alertMsg13,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function(btn) {
					if (btn == 'ok'){
						valueObj.focus(true);
					}
				}
			});
			return false;
		}
		else
		{
			if (testType != "Snmp" && testType != "Custom" && (param.toLowerCase() == "snmpport" || param.toLowerCase() == "snmpversion" || param.toLowerCase() == "snmpcommunity"))
			{
				Ext.Msg.show({
					title: pageTitle1,
					msg: _snmpParams,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function(btn) {
						if (btn == 'ok'){
							paramObj.focus(true);
						}
					}
				});
				return false;
			}
			else
			{
				return true;
			}
		}

		return true;
	},
	loadAddParamTab:function(urlStr)
	{
		var me = this;
		Ext.Ajax.request(
		{
			url: 'ICTest/data/'+urlStr+'&index=paramTab',
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});

		var cntnrObj = Ext.getCmp('addParamCntnr');
		cntnrObj.removeAll();
		var existingParams = publicJSON.paramList;
		if (existingParams.length == 0)
		{
			Ext.getCmp('noParamsFnd').show();
		}
		else
		{
			Ext.getCmp('noParamsFnd').hide();
			for (var p=0; p<existingParams.length; p++) {
					var param = existingParams[p];
					if(param.paramName == "password")
					{
							cntnrObj.add({
							xtype: 'fieldset',
							title: '<b>'+param.paramName+'</b>',
							layout: {
								type: 'vbox',
								align: 'left'
							},
							width: 650,
							//height: 70,
							items: [
								{
									xtype:"displayfield",
									fieldLabel: defVal,
									inputType:"password",
									labelSeparator: '',
									value: param.paramValue,
									flex: 1,
									renderer: function(value, metaData, record, row, col, store, gridView)
									{
										var a="&#8226;";
										for(var k=1; k<value.length; k++)
										{
											a = a+"&#8226;";
										}
										return "<h1>"+a+"</h1>";
									}
								},
								{
									xtype:'container',
									layour:{
										type: 'hbox',
										pack: 'left'
									},
									margin: '10 0 10 0',
									items : [
										{
											xtype: 'button',
											cls : 'button20',
											text: modifyTooltip,
											modifyURL: param.modifyURL,
											width: 80,
											handler: function() {
												me.showModifyParam(this.modifyURL);
											},
											//columnWidth: 0.25,
											//margin: '0 0 0 20'
										},
										{
											xtype: 'button',
											cls : 'button20',
											text: deleteTooltip,
											hidden: param.hideDelete,
											deleteURL: param.deleteURL,
											paramName : param.paramName,
											width: 80,
											handler: function() {
												me.deleteParam(this.deleteURL, this.paramName);
											},
											//columnWidth: 0.25,
											margin: '0 0 0 20'
										}
									]
								}
							]
						});
					}
					else
					{
						cntnrObj.add({
						xtype: 'fieldset',
						title: '<b>'+param.paramName+'</b>',
						layout: {
							type: 'vbox',
							align: 'left'
						},
						width: 650,
						//height: 70,
						items: [
							{
								xtype: 'displayfield',
								fieldLabel: defVal,
								labelSeparator: '',
								value: param.paramValue,
								flex: 1,
							},
							{
								xtype:'container',
								layour:{
									type: 'hbox',
									pack: 'left'
								},
								margin: '10 0 10 0',
								items : [
									{
										xtype: 'button',
										cls : 'button20',
										text: modifyTooltip,
										modifyURL: param.modifyURL,
										width: 80,
										handler: function() {
											me.showModifyParam(this.modifyURL);
										},
										//columnWidth: 0.25,
										//margin: '0 0 0 20'
									},
									{
										xtype: 'button',
										cls : 'button20',
										text: deleteTooltip,
										hidden: param.hideDelete,
										deleteURL: param.deleteURL,
										paramName : param.paramName,
										width: 80,
										handler: function() {
											me.deleteParam(this.deleteURL, this.paramName);
										},
										//columnWidth: 0.25,
										margin: '0 0 0 20'
									}
								]
							}
						]
					});
				}
			}
		}
		if (publicJSON.showAddNewParam)
		{
			Ext.getCmp('addParam').show();
		}
		else
		{
			Ext.getCmp('addParam').hide();
		}
	},
	showModifyParam: function(urlStr)
	{
		var me = this;
		Ext.Ajax.request(
		{
			url: 'ICTest/data/'+urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
		var I = Ext.WindowManager.getActive();
		if (I) {
			I.close();
		}
		var paramModifyWin;
		if(publicJSON.paramName == 'password')
		{
			paramModifyWin =Ext.create('Ext.window.Window', {
				title: modParam,
				padding:'3 10 10 10',
				height: 200,
				width: 350,
				id:'modParamWindow',
				layout:{
					type:'vbox',
					pack:'start',
					align:'center'
				},
				defaults:{
					margin: 10
				},
				items:[ 
					{
						xtype: 'textfield',
						cls :'textbox',
						fieldLabel: param,
						labelAlign: 'top',
						labelSeparator: ' ',
						id:'modParam',
						name:'modParam',
						value: publicJSON.paramName,
						width: 250
					},
					{
						xtype: 'textfield',
						cls :'textbox',
						fieldLabel: defVal,
						labelAlign: 'top',
						labelSeparator: ' ',
						inputType:"password",
						id:'modValue',
						name:'modValue',
						value: publicJSON.paramValue,
						width: 250
					},
					{
						xtype: 'button',
						cls :'button20',
						text: modifyTooltip,
						id:'modParamButton',
						width: 80,
						listeners:
						{
							click:{
								fn: function (id){
									me.doModifyParam();
								}
							}
						}
					}
				]
			});
		}
		else
		{
			paramModifyWin =Ext.create('Ext.window.Window', {
				title: modParam,
				padding:'3 10 10 10',
				height: 200,
				width: 350,
				id:'modParamWindow',
				layout:{
					type:'vbox',
					pack:'start',
					align:'center'
				},
				defaults:{
					margin: 10
				},
				items:[ 
					{
						xtype: 'textfield',
						cls :'textbox',
						fieldLabel: param,
						labelAlign: 'top',
						labelSeparator: ' ',
						id:'modParam',
						name:'modParam',
						value: publicJSON.paramName,
						width: 250
					},
					{
						xtype: 'textfield',
						cls :'textbox',
						fieldLabel: defVal,
						labelAlign: 'top',
						labelSeparator: ' ',
						id:'modValue',
						name:'modValue',
						value: publicJSON.paramValue,
						width: 250
					},
					{
						xtype: 'button',
						cls :'button20',
						text: modifyTooltip,
						id:'modParamButton',
						width: 80,
						listeners:
						{
							click:{
								fn: function (id){
									me.doModifyParam();
								}
							}
						}
					}
				]
			});
		}
		paramModifyWin.show();

		if (publicJSON.isSnmpParam || publicJSON.isJmxParam)
		{
			Ext.getCmp('modParam').setReadOnly(true);
		}
		else
		{
			Ext.getCmp('modParam').setReadOnly(false);
		}
	},
	doModifyParam: function()
	{
		var me = this;
		jmxCtrlr = this.getController('ICTest.controller.AddJmxTestCtrlr');
		var os = '';
		var dbType = '';

		var test = Ext.getCmp('test').getValue();
		var testType = Ext.getCmp('testType').getValue();
		var paramName = Ext.getCmp('modParam').getValue();
		var paramVal = Ext.getCmp('modValue').getValue();

		if(testType == "Script/Batch File")
		{
			os = Ext.getCmp('ostype').getValue().ostyperb;
		}
		else if (testType.toLowerCase() == 'sql query')
		{
			dbType = Ext.getCmp('dbType').getValue();
		}

		if (!this.paramValidation(paramName,paramVal,testType))
		{
			return;
		}
		var urlStr = 'EgconfigtestparampJson.jsp?index=paramTab&mod=modify_params&one='+encodeURIComponent(paramName)+'&two='+encodeURIComponent(paramVal)+'&test='+test;
		urlStr += '&org_param='+encodeURIComponent(publicJSON.hiddens.org_param)+'&os='+os+'&dbtype='+dbType+'&testtype='+testType;

		var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: updating+'...'});
		tmpMask.show();

		Ext.Ajax.request(
		{
			url: 'ICTest/data/'+urlStr,
			method: 'POST',
			async:false,
			success: function( response )
			{
				tmpMask.hide();
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );

					if (publicJSON.AlertType == 'Error')
					{
						Ext.Msg.show({
							title: error+': '+publicJSON.AlertTitle,
							msg:publicJSON.AlertMsg,
							buttons: Ext.Msg.OK,
							icon: 'iconError'
						});
					}
					else if (publicJSON.AlertType == 'Result')
					{
						Ext.Msg.show({
							title: publicJSON.AlertTitle,
							msg:publicJSON.AlertMsg + '.'+ modifyParamAlert,
							buttons: Ext.Msg.YESNO,
							icon: 'iconInformation',
							fn: function(response) {
								if(response == 'yes') {
									Ext.getCmp('modParamWindow').close();
									Ext.getCmp('addParamTab').enable();
									var urlToProcess = publicJSON.forwardURL;
									me.loadAddParamTab(urlToProcess);
								}
								else if (response == 'no')
								{
									Ext.getCmp('modParamWindow').close();
									var urlToProcess = publicJSON.forwardURL;
									me.loadAddParamTab(urlToProcess);
									jmxCtrlr.loadAddMeasureTab(urlToProcess);
									
									var urlStr = 'EgConfigJmxMeasureJson.jsp?test='+test;
									//jmxCtrlr.showAddedMeasures(urlStr);
									Ext.getCmp('newtest').setActiveTab(2);
								}
							}
						});
					}
				}
			},
			failure: function( response )
			{
				tmpMask.hide();
			}
		});
	},
	showAddMeasure: function()
	{
		var testType = Ext.getCmp('testType').getValue();
		if (testType == 'Custom')
		{
			customCtrlr = this.getController('ICTest.controller.AddCustomTestCtrlr');
			customCtrlr.showAddNewMeasure();
		}
		else if (testType == 'Script/Batch File')
		{
			scriptCtrlr = this.getController('ICTest.controller.AddScriptTestCtrlr');
			scriptCtrlr.showAddNewMeasure();
		}
		else if (testType.toLowerCase() == 'sql query')
		{
			sqlCtrlr = this.getController('ICTest.controller.AddSqlTestCtrlr');
			sqlCtrlr.showAddNewMeasure();
		}
		else if (testType == 'Perfmon')
		{
			perfmonCtrlr = this.getController('ICTest.controller.AddPerfmonTestCtrlr');
			perfmonCtrlr.showAddNewMeasure();
		}
		else if (testType == 'Snmp')
		{
			snmpCtrlr = this.getController('ICTest.controller.AddSnmpTestCtrlr');
			snmpCtrlr.showAddNewMeasure();
		}
		else if (testType == 'JMX')
		{
			jmxCtrlr = this.getController('ICTest.controller.AddJmxTestCtrlr');
			var isAddNewMeasure = 'Yes';
			var fromMbean = 'No';
			jmxCtrlr.showAddNewMeasure(isAddNewMeasure,fromMbean);
		}
		else if (testType == 'REST')
		{
			if(Ext.isEmpty(datasetCtrlr))
			{
				datasetCtrlr= this.getController('ICTest.controller.DatasetController');
			}
			datasetCtrlr.showAddNewMeasure();
		}
	},
	deleteParam: function(url2Del, paramName)
	{
		Ext.Msg.show({
			title:delParam,
			msg:alertMsg57 + ' \''+paramName+'\'?',
			buttons: Ext.Msg.OKCANCEL,
			icon: 'iconConfirmation',
			fn: function(response) {
				if(response == 'ok') {
					Ext.Ajax.request(
					{
						url: 'ICTest/data/'+url2Del+'&index=paramTab',
						method: 'POST',
						async:false,
						success: function( response )
						{
							if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
							{
								var jsonText = response.responseText;
								publicJSON = Ext.decode( jsonText );
							}
						}
					});

					if (publicJSON.AlertType == 'Result')
					{
						Ext.Msg.show({
							title: publicJSON.AlertTitle,
							msg:publicJSON.AlertMsg,
							buttons: Ext.Msg.OK,
							icon: 'iconInformation',
							fn: function(response) {
								if(response == 'ok') {
									Ext.getCmp('addParamTab').enable();
									var urlToProcess = publicJSON.forwardURL;
									modifyCtrler.loadAddParamTab(urlToProcess);
								}
							}
						});
					}
				}
			}
		});
	}
});



