Ext.define('ICTest.controller.ThresholdCtrlr',{
	extend:'Ext.app.Controller',
	refs:[
		{selector:'defaultthresholds', ref:'defaultthresholds'},
		{selector:'configurethresholds', ref:'configurethresholds'}
	],
	init:function(){
		me = this,
		this.control({
			'defaultthresholds':
			{
				'afterrender': this.gotoDefaultThresholdPage
			},
			'defaultthresholds [id="measureGrid"]':
			{
				itemmouseenter: this.showModifyTool,
				itemmouseleave: this.hideModifyTool
			},
			'defaultthresholds [id="noMeasureGrid"]':
			{
				'cellclick': this.noThreshMeasureModify,
			},
			'defaultthresholds button[id="fromDefaultBackBtn"]':
			{
				'click': this.goback,
			},
			'defaultthresholds button[id="submitBtn"]':
			{
				'click': this.submitData,
			},
			'configurethresholds':
			{
				'afterrender': this.configureMainRender,
			},
			'configurethresholds button[id="updateBtn"]':
			{
				'click': this.applyThresholdsData
			},
			'configurethresholds button[id="configureBackBtn"]':
			{
				'click': this.configureThresholdsPageBack,
			},
			'configurethresholds slider[id="relMinCritical"]':
			{
				'drag': this.minRelCriticalSlider,
				'change': this.minRelCriticalSlider,
			},
			'configurethresholds slider[id="relMinMajor"]':
			{
				'drag': this.minRelMajorSlider,
				'change': this.minRelMajorSlider,
			},
			'configurethresholds slider[id="relMinMinor"]':
			{
				'drag': this.minRelMinorSlider,
				'change': this.minRelMinorSlider,
			},
			'configurethresholds slider[id="relMaxCritical"]':
			{
				'drag': this.maxRelCriticalSlider,
				'change': this.maxRelCriticalSlider,
			},
			'configurethresholds slider[id="relMaxMajor"]':
			{
				'drag': this.maxRelMajorSlider,
				'change': this.maxRelMajorSlider,
			},
			'configurethresholds slider[id="relMaxMinor"]':
			{
				'drag': this.maxRelMinorSlider,
				'change': this.maxRelMinorSlider,
			},
			'configurethresholds checkbox[id="minStaticCheck"]':
			{
				'change': this.minStaticCheckChange,
			},
			'configurethresholds checkbox[id="minAutoCheck"]':
			{
				'change': this.minAutoCheckChange,
			},
			'configurethresholds checkbox[id="maxStaticCheck"]':
			{
				'change': this.maxStaticCheckChange,
			},
			'configurethresholds checkbox[id="maxAutoCheck"]':
			{
				'change': this.maxAutoCheckChange,
			},
			'configurethresholds combo[id="alarmPolicyCombo"]':
			{
				'select': this.alarmPolicyChange,
			}
		});
	},
	configureThresholdsPageBack: function()
	{
		var homepage;
		if (isDDLoaded)
		{
			homepage = Ext.getCmp('ddgenerateCntnr');
		}
		else
		{
			if(isRESTTestType)
			{
				homepage = Ext.getCmp('restDataConfigurationWindow');
			}
			else
			{
				homepage = Ext.getCmp('generateCntnr');
			}
		}
		myMask = new Ext.LoadMask(homepage, {msg: updating+"..."});
		myMask.show();
		homepage.removeAll();
		homepage.add({ xtype : 'defaultthresholds' });
		myMask.hide();
	},
	alarmPolicyChange: function()
	{
		var alarmPolicy = Ext.getCmp('alarmPolicyCombo').getValue();
		var tmpDescription = publicJson['alarmPolicyDescriptionObj'][alarmPolicy]
		Ext.getCmp('alarmDispField').el.update(tmpDescription);
	},
	gotoDefaultThresholdPage: function()
	{
		Ext.Ajax.request({
			url:qString,
			method: 'POST',
			scope: this,
			success: function(response)
			{
				if(response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					publicJson = Ext.decode(jsonText);
					var measureThreshValArr = publicJson['measureValArr'];
					var noMeasureThreshValArr = publicJson['noMeasureValArr'];
					var hostTestMsg = publicJson['hosttest_title'];
					var descConfigBtn = publicJson['desc_configure'];
					var fieldSetTitle = publicJson['tableTitle'];
					if (fieldSetTitle != null && !Ext.isEmpty(fieldSetTitle))
					{
						Ext.getCmp('fieldTitleId').setTitle(fieldSetTitle);
					}

					if (hostTestMsg != null && hostTestMsg != 'undefined')
					{
						Ext.getCmp('hostTestMsgContainer').show();
						Ext.getCmp('hostMsgLabel').update(hostTestMsg);
					}
					else
					{
						Ext.getCmp('hostTestMsgContainer').hide();
					}

					if(measureThreshValArr != null &&  !Ext.isEmpty(measureThreshValArr))
					{
						Ext.getCmp('measureGrid').getStore().suspendEvents();
						Ext.getCmp('measureGrid').getStore().removeAll();
						Ext.getCmp('measureGrid').getStore().loadRawData(measureThreshValArr);
						Ext.getCmp('measureGrid').getStore().resumeEvents();
						Ext.getCmp('measureGrid').getView().refresh();
						Ext.getCmp('measureGrid').show();

					}else
					{
						Ext.getCmp('measureGrid').hide();
					}

					if(noMeasureThreshValArr != null && !Ext.isEmpty(noMeasureThreshValArr))
					{
						Ext.getCmp('noMeasureGrid').getStore().suspendEvents();
						Ext.getCmp('noMeasureGrid').getStore().removeAll();
						Ext.getCmp('noMeasureGrid').getStore().loadRawData(noMeasureThreshValArr);
						Ext.getCmp('noMeasureGrid').getStore().resumeEvents();
						Ext.getCmp('noMeasureGrid').getView().refresh();
						Ext.getCmp('noMeasureGrid').show();
					}
					else
					{
						Ext.getCmp('noMeasureGrid').hide();
					}
				}
				//myMask.hide();
			}
		});
	},
	configureMainRender: function()
	{
		Ext.Ajax.request({
			url:'ICTest/data/EgConfigureThresholdsJson.jsp?'+hiddenFieldsVal,
			method:'POST',
			scope:this,
			success:function(response)
			{
				var jsonText = response.responseText;
				publicJson = Ext.decode(jsonText);
				var testDescription = publicJson['screenLabels']['test_description'];
				var descComp = Ext.getCmp('testDescriptionId');
				var alarmPolicyCombo = publicJson['alarmPolicyArr'];
				var minThreshObj = publicJson['minThreshObj'];
				var maxThreshObj = publicJson['maxThreshObj'];
				var selectAlarm = publicJson['selectedAlarmType'];
				var selectedAlarmDescription = publicJson['selectedAlarmDescription'];
				var isNegativeValuesAllowed = publicJson['isNegativeValuesAllowed'];
				var isGlobalThresholds = publicJson['isGlobalThresholds'];
				if(isGlobalThresholds)
				{
					Ext.getCmp('minAutoCheck').hide();
					Ext.getCmp('minAutoFieldContainer').hide();
					Ext.getCmp('maxAutoCheck').hide();
					Ext.getCmp('maxAutoFieldContainer').hide();
				}

				var minStaticOption = minThreshObj.minStaticOption;
				var minStaticBlock = minThreshObj.minStaticBlock;
				if(minStaticOption != null && !Ext.isEmpty(minStaticOption) && minStaticOption == 'selected')
				{
					var absMinCritical = minThreshObj.absMinCritical;
					var absMinMajor = minThreshObj.absMinMajor;
					var absMinMinor = minThreshObj.absMinMinor;
					Ext.getCmp('minStaticCheck').setValue(false);
					Ext.getCmp('absMinCritical').setValue(absMinCritical);
					Ext.getCmp('absMinMajor').setValue(absMinMajor);
					Ext.getCmp('absMinMinor').setValue(absMinMinor);
					
				}
				if (!isGlobalThresholds)
				{
					if (!isNegativeValuesAllowed)
					{
						var minAutomaticOption = minThreshObj.minAutomaticOption;
						var minAutomaticBlock = minThreshObj.minAutomaticBlock;
						if (minAutomaticOption != null && !Ext.isEmpty(minAutomaticOption) && minAutomaticOption == 'selected')
						{
							var relMinCritical = minThreshObj.relMinCritical;
							var relMinMajor = minThreshObj.relMinMajor;
							var relMinMinor = minThreshObj.relMinMinor;
							Ext.getCmp('minAutoCheck').show();
							Ext.getCmp('minAutoFieldContainer').show();
							Ext.getCmp('minAutoCheck').setValue(false);
							Ext.getCmp('relMinCritical').setValue(relMinCritical);
							Ext.getCmp('relMinCriticalText').setValue(relMinCritical);
							Ext.getCmp('relMinMajor').setValue(relMinMajor);
							Ext.getCmp('relMinMajorText').setValue(relMinMajor);
							Ext.getCmp('relMinMinor').setValue(relMinMinor);
							Ext.getCmp('relMinMinorText').setValue(relMinMinor);
						}
					}
				}

				var maxStaticOption = maxThreshObj.maxStaticOption;
				var maxStaticBlock = maxThreshObj.maxStaticBlock;
				if (maxStaticOption != null && !Ext.isEmpty(maxStaticOption) && maxStaticOption == 'selected')
				{
					var absMaxCritical = maxThreshObj.absMaxCritical;
					var absMaxMajor = maxThreshObj.absMaxMajor;
					var absMaxMinor = maxThreshObj.absMaxMinor;
					Ext.getCmp('maxStaticCheck').setValue(false);
					Ext.getCmp('absMaxCritical').setValue(absMaxCritical);
					Ext.getCmp('absMaxMajor').setValue(absMaxMajor);
					Ext.getCmp('absMaxMinor').setValue(absMaxMinor);
					
				}

				if (!isGlobalThresholds)
				{
					if (!isNegativeValuesAllowed)
					{
						var maxAutomaticOption = maxThreshObj.maxAutomaticOption;
						var maxAutomaticBlock = maxThreshObj.maxAutomaticBlock;
						if (maxAutomaticOption != null && !Ext.isEmpty(maxAutomaticOption) && maxAutomaticOption == 'selected')
						{
							var relMaxCritical = maxThreshObj.relMaxCritical;
							var relMaxMajor = maxThreshObj.relMaxMajor;
							var relMaxMinor = maxThreshObj.relMaxMinor;
							Ext.getCmp('maxAutoCheck').show();
							Ext.getCmp('maxAutoFieldContainer').show();
							Ext.getCmp('maxAutoCheck').setValue(false);
							Ext.getCmp('relMaxCritical').setValue(relMaxCritical);
							Ext.getCmp('relMaxCriticalText').setValue(relMaxCritical);
							Ext.getCmp('relMaxMajor').setValue(relMaxMajor);
							Ext.getCmp('relMaxMajorText').setValue(relMaxMajor);
							Ext.getCmp('relMaxMinor').setValue(relMaxMinor);
							Ext.getCmp('relMaxMinorText').setValue(relMaxMinor);
						}
					}
				}
				var isHostTest = publicJson['isHostTest'];
				descComp.update('<center>'+testDescription+'</center>');

				if(alarmPolicyCombo != null && !Ext.isEmpty(alarmPolicyCombo))
				{
					Ext.getCmp('alarmDispField').el.animate({opacity: 1});
					Ext.getCmp('alarmPolicyCombo').getStore().removeAll();
					Ext.getCmp('alarmPolicyCombo').getStore().suspendEvents();
					Ext.getCmp('alarmPolicyCombo').getStore().loadRawData(alarmPolicyCombo);
					Ext.getCmp('alarmPolicyCombo').getStore().resumeEvents();

					if (selectAlarm != null && !Ext.isEmpty(selectAlarm))
					{
						Ext.getCmp('alarmPolicyCombo').setValue(selectAlarm);
					}
					else
					{
						//selectAlarm = alarmPolicyCombo[0].valueField;
						Ext.getCmp('alarmPolicyCombo').setValue(alarmPolicyCombo[0].valueField);
					}
					if (selectedAlarmDescription != null && !Ext.isEmpty(selectedAlarmDescription))
					{
						//Ext.getCmp('alarmDispField').el.update(selectedAlarmDescription);
						Ext.getCmp('alarmDispField').setValue(selectedAlarmDescription);
					}
					else
					{
						var tmpDescription = publicJson['alarmPolicyDescriptionObj'][alarmPolicyCombo[0].valueField]
						//Ext.getCmp('alarmDispField').el.update(tmpDescription);
						Ext.getCmp('alarmDispField').setValue(tmpDescription);
					}
				}
			}
		});
	},
	submitData: function()
	{
		Ext.Msg.show({
			title: pageTitle1,
			msg: alertMsg79,
			buttons: Ext.Msg.YESNO,
			icon: 'iconConfirmation',
			fn: function(response) {
				if(response == 'yes') {
					//Ext.getCmp('newtest').child('#helpTab').tab.show();
					if(isRESTTestType)
					{
						var restDashMainPnl = Ext.getCmp('restDataConfigurationWindow');
						Ext.getCmp('newtest').setActiveTab(6);
						if(!Ext.isEmpty(restDashMainPnl))
						{
							restDashMainPnl.close();
						}
					}
					else
					{
						Ext.getCmp('newtest').setActiveTab(5);
					}
				}
				else 
				{
					window.location.href = '/final/admin/EgUDTest.jsp';
				}
			}
		});
	},
	applyThresholdsData: function()
	{
		var flag = true;
		var v_testname = publicJson['hiddenObj']['testName'];
		if (v_testname == "null")
		{
			flag = false;
			return false;
		}

		var v_measure =  publicJson['hiddenObj']['measure'];
		if (v_measure == "null")
		{
			flag = false;
			return false;
		}

		var v_policy = "mix";
		var minThreshold = "-1";
		var maxThreshold = "-1";
		var v_alarmPolicy = Ext.getCmp('alarmPolicyCombo').getValue();
		var lastItem = "HML";

		var abs_MinCritical = "-";
		var abs_MinMajor = "-";
		var abs_MinMinor = "-";
		var abs_MinOpt = Ext.getCmp('minStaticCheck').getValue();
		var isNegativeValuesAllowed = publicJson['isNegativeValuesAllowed'];
		if (!abs_MinOpt)
		{
			abs_MinCritical = Ext.getCmp('absMinCritical').getValue();
			abs_MinMajor =  Ext.getCmp('absMinMajor').getValue();
			abs_MinMinor =  Ext.getCmp('absMinMinor').getValue();

			// Negative value check...
			if (!isNegativeValuesAllowed)
			{
				//Invalid threshold entry check...
				if (!checkValidValue(abs_MinCritical))
				{
					Ext.Msg.show({
						title: pageTitle4,
						msg: staticMinCriticalErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function(){
							Ext.getCmp('absMinCritical').focus();
						}

					});
					flag = false;
					return false;
				}
				else if(abs_MinCritical != "-") 
				{
					if(!checkNonNegativeFormat(abs_MinCritical))
					{
						Ext.Msg.show({
							title: pageTitle4,
							msg: staticMinCriticalErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMinCritical').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MinMajor))
				{
					Ext.Msg.show({
						title: pageTitle4,
						msg: staticMinMajorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMajor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MinMajor != "-")
				{
					if(!checkNonNegativeFormat(abs_MinMajor))
					{
						Ext.Msg.show({
							title: pageTitle4,
							msg: staticMinMajorErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMinMajor').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MinMinor))
				{
					Ext.Msg.show({
						title: pageTitle4,
						msg: staticMinMinorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMinor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MinMinor != "-")
				{
					if(!checkNonNegativeFormat(abs_MinMinor))
					{
						Ext.Msg.show({
							title: pageTitle4,
							msg: staticMinMinorErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMinMinor').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				var ret = checkNegativeValue(abs_MinCritical);
				if (ret)
				{
					Ext.Msg.show({
						title: pageTitle4,
						msg: errMsg5+" \'"+v_measure+"\' "+errMsg6,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinCritical').focus();
						}
					});
					flag = false;
					return false;
				}

				ret = checkNegativeValue(abs_MinMajor);
				if (ret)
				{
					Ext.Msg.show({
						title: pageTitle4,
						msg: errMsg5+" \'"+v_measure+"\' "+errMsg6,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMajor').focus();
						}
					});
					flag = false;
					return false;
				}

				ret = checkNegativeValue(abs_MinMinor);
				if (ret)
				{
					Ext.Msg.show({
						title: pageTitle4,
						msg: errMsg5+" \'"+v_measure+"\' "+errMsg6,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMinor').focus();
						}
					});
					flag = false;
					return false;
				}
			}
			else
			{
				//Invalid threshold entry check...
				if (!checkValidValue(abs_MinCritical))
				{
					Ext.Msg.show({
						title: pageTitle4,
						msg: staticMinCriticalErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinCritical').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MinCritical != "-") 
				{
					if(!checkNegativeFormat(abs_MinCritical))
					{
						Ext.Msg.show({
							title: pageTitle4,
							msg: staticMinCriticalErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMinCritical').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MinMajor))
				{
					Ext.Msg.show({
						title: pageTitle4,
						msg: staticMinMajorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMajor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MinMajor != "-")
				{
					if(!checkNegativeFormat(abs_MinMajor))
					{
						Ext.Msg.show({
							title: pageTitle4,
							msg: staticMinMajorErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMinMajor').focus();
							}
						});
						flag = false;
						return false;
					}
				}
				if (!checkValidValue(abs_MinMinor))
				{
					Ext.Msg.show({
						title: pageTitle4,
						msg: staticMinMinorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMinor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MinMinor != "-")
				{
					if(!checkNegativeFormat(abs_MinMinor))
					{
						Ext.Msg.show({
							title: pageTitle4,
							msg: staticMinMinorErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMinMinor').focus();
							}
						});
						flag = false;
						return false;
					}
				}
			}

			//check ascending order...
			if (abs_MinCritical != "-" && abs_MinMajor != "-")
			{
				if (parseFloat(abs_MinCritical) >= parseFloat(abs_MinMajor))
				{
					Ext.Msg.show({
						title: pageTitle4,
						msg: errMsg7,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinCritical').focus();
						}
					});
					flag = false;
					return false;
				}
			}
			if (abs_MinMajor != "-" && abs_MinMinor != "-")
			{
				if (parseFloat(abs_MinMajor) >= parseFloat(abs_MinMinor))
				{
					Ext.Msg.show({
						title: pageTitle4,
						msg: errMsg7,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMajor').focus();
						}
					});
					flag = false;
					return false;
				}
			}
			if (abs_MinCritical != "-" && abs_MinMinor != "-")
			{
				if (parseFloat(abs_MinCritical) >= parseFloat(abs_MinMinor))
				{
					Ext.Msg.show({
						title: pageTitle4,
						msg: errMsg7,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinCritical').focus();
						}
					});
					flag = false;
					return false;
				}
			}
		}

		var rel_MinCritical = "-";
		var rel_MinMajor = "-";
		var rel_MinMinor = "-";
		var minAutoCheck = Ext.getCmp('minAutoCheck').getValue();
		if (!minAutoCheck)
		{
			var v_amount_A = Ext.getCmp('relMinCriticalText').getValue();
			if (v_amount_A != 0)
			{
				if (v_amount_A == 100)
				{
					rel_MinCritical = "sqc";
				}
				else
				{
					rel_MinCritical = (v_amount_A/100) + "*sqc";
				}
			}

			var v_amount_B = Ext.getCmp('relMinMajorText').getValue();
			if (v_amount_B != 0)
			{
				if (v_amount_B == 100)
				{
					rel_MinMajor = "sqc";
				}
				else
				{
					rel_MinMajor = (v_amount_B/100) + "*sqc";
				}
			}

			var v_amount_C = Ext.getCmp('relMinMinorText').getValue();
			if (v_amount_C != 0)
			{
				if (v_amount_C == 100)
				{
					rel_MinMinor = "sqc";
				}
				else
				{
					rel_MinMinor = (v_amount_C/100) + "*sqc";
				}
			}

			//check ascending order...
			var relCri,relMaj,relMin;
			relCri = rel_MinCritical;
			relMaj = rel_MinMajor;
			relMin = rel_MinMinor;
			relCri = relCri.replace(/(\*sqc)/gi,"");
			relCri = relCri.replace(/sqc/g,"1");
			relMaj = relMaj.replace(/(\*sqc)/gi,"");
			relMaj = relMaj.replace(/sqc/g,"1");
			relMin = relMin.replace(/(\*sqc)/gi,"");
			relMin = relMin.replace(/sqc/g,"1");

			if (relCri != "-" && relMaj != "-")
			{
				if (parseFloat(relCri) >= parseFloat(relMaj))
				{
					Ext.Msg.show({
						title: pageTitle4,
						msg: errMsg8,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					flag = false;
					return false;
				}
			}
			if (relMaj != "-" && relMin != "-")
			{
				if (parseFloat(relMaj) >= parseFloat(relMin))
				{
					Ext.Msg.show({
						title: pageTitle4,
						msg: errMsg8,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					flag = false;
					return false;
				}
			}
			if (relCri != "-" && relMin != "-")
			{
				if (parseFloat(relCri) >= parseFloat(relMin))
				{
					Ext.Msg.show({
						title: pageTitle4,
						msg: errMsg8,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					flag = false;
					return false;
				}
			}
		}

		if(abs_MinCritical.indexOf(".") != -1 )
		{
			var abs_MinCriticalDecimal = abs_MinCritical.substring(abs_MinCritical.indexOf(".")+1);
			if (abs_MinCriticalDecimal == "0000" || 
				abs_MinCriticalDecimal == "000" || 
				abs_MinCriticalDecimal == "00" || 
				abs_MinCriticalDecimal == "0" )
			{
				abs_MinCritical = abs_MinCritical.substring(0,abs_MinCritical.indexOf("."));
			}
			else if(abs_MinCriticalDecimal.length > 1)
			{
				if ((abs_MinCriticalDecimal.charAt(3) == "0" && abs_MinCriticalDecimal.charAt(2) == "0") || 
					(abs_MinCriticalDecimal.charAt(3) == "0"))
				{
					abs_MinCritical = abs_MinCritical.substring(0,abs_MinCritical.lastIndexOf("0"));
				}
			}
		}
		if(abs_MinMajor.indexOf(".") != -1 )
		{
			var abs_MinMajorDecimal = abs_MinMajor.substring(abs_MinMajor.indexOf(".")+1);
			if (abs_MinMajorDecimal == "0000" || 
				abs_MinMajorDecimal == "000" || 
				abs_MinMajorDecimal == "00" || 
				abs_MinMajorDecimal == "0")
			{
				abs_MinMajor = abs_MinMajor.substring(0,abs_MinMajor.indexOf("."));
			}
			else if(abs_MinMajorDecimal.length > 1)
			{
				if ((abs_MinMajorDecimal.charAt(3) == "0" && abs_MinMajorDecimal.charAt(2) == "0") ||
					(abs_MinMajorDecimal.charAt(3) == "0"))
				{
					abs_MinMajor = abs_MinMajor.substring(0,abs_MinMajor.lastIndexOf("0"));
				}
			}
		}
		if(abs_MinMinor.indexOf(".") != -1 )
		{
			var abs_MinMinorDecimal = abs_MinMinor.substring(abs_MinMinor.indexOf(".")+1);
			if (abs_MinMinorDecimal == "0000" || 
				abs_MinMinorDecimal == "000" || 
				abs_MinMinorDecimal == "00" || 
				abs_MinMinorDecimal == "0")
			{
				abs_MinMinor = abs_MinMinor.substring(0,abs_MinMinor.indexOf("."));
			}
			else if(abs_MinMinorDecimal.length > 1)
			{
				if ((abs_MinMinorDecimal.charAt(3) == "0" && abs_MinMinorDecimal.charAt(2) == "0") || 
					(abs_MinMinorDecimal.charAt(3) == "0"))
				{
					abs_MinMinor = abs_MinMinor.substring(0,abs_MinMinor.lastIndexOf("0"));
				}
			}
		}

		var minCritical = "-";
		if (abs_MinCritical != "-" && rel_MinCritical != "-")
		{
			if(abs_MinCritical > -1 || abs_MinCritical < 0)
			{
				if(abs_MinCritical.indexOf(".") == 0)
				{
					abs_MinCritical = "0"+abs_MinCritical;
				}
				abs_MinCritical = parseFloat(abs_MinCritical);
				minCritical = abs_MinCritical.toString() + "&" + rel_MinCritical;
			}
			else
			{
				minCritical = rel_MinCritical;
			}
		}
		else if (abs_MinCritical != "-" && rel_MinCritical == "-")
		{
			if(abs_MinCritical > -1 || abs_MinCritical < 0)
			{
				if(abs_MinCritical.indexOf(".") == 0)
				{
					abs_MinCritical = "0"+abs_MinCritical;
				}
				abs_MinCritical = parseFloat(abs_MinCritical);
				minCritical = abs_MinCritical.toString();
			}
			else
			{
				minCritical = "-";
			}
		}
		else if (abs_MinCritical == "-" && rel_MinCritical != "-")
		{
			minCritical = rel_MinCritical;
		}

		var minMajor = "-";
		if (abs_MinMajor != "-" && rel_MinMajor != "-")
		{
			if(abs_MinMajor > -1 || abs_MinMajor < 0)
			{
				if(abs_MinMajor.indexOf(".") == 0)
				{
					abs_MinMajor = "0"+abs_MinMajor;
				}
				abs_MinMajor = parseFloat(abs_MinMajor);
				minMajor = abs_MinMajor.toString() + "&" + rel_MinMajor;
			}
			else
			{
				minMajor = rel_MinMajor;
			}
		}
		else if (abs_MinMajor != "-" && rel_MinMajor == "-")
		{
			if(abs_MinMajor > -1 || abs_MinMajor < 0)
			{
				if(abs_MinMajor.indexOf(".") == 0)
				{
					abs_MinMajor = "0"+abs_MinMajor;
				}
				abs_MinMajor = parseFloat(abs_MinMajor);
				minMajor = abs_MinMajor.toString();
			}
			else
			{
				minMajor = "-";
			}
		}
		else if (abs_MinMajor == "-" && rel_MinMajor != "-")
		{
			minMajor = rel_MinMajor;
		}

		var minMinor = "-";
		if (abs_MinMinor != "-" && rel_MinMinor != "-")
		{
			if(abs_MinMinor > -1 || abs_MinMinor < 0)
			{
				if(abs_MinMinor.indexOf(".") == 0)
				{
					abs_MinMinor = "0"+abs_MinMinor;
				}
				abs_MinMinor = parseFloat(abs_MinMinor);
				minMinor = abs_MinMinor.toString() + "&" + rel_MinMinor;
			}
			else
			{
				minMinor = rel_MinMinor;
			}
		}
		else if (abs_MinMinor != "-" && rel_MinMinor == "-")
		{
			if(abs_MinMinor > -1 || abs_MinMinor < 0)
			{
				if(abs_MinMinor.indexOf(".") == 0)
				{
					abs_MinMinor = "0"+abs_MinMinor;
				}
				abs_MinMinor = parseFloat(abs_MinMinor);
				minMinor = abs_MinMinor.toString();
			}
			else
			{
				minMinor = "-";
			}
		}
		else if (abs_MinMinor == "-" && rel_MinMinor != "-")
		{
			minMinor = rel_MinMinor;
		}

		if (minCritical != "-" || minMajor != "-" || minMinor != "-")
		{
			minThreshold = minCritical + "/" + minMajor + "/" + minMinor
		}

		var abs_MaxCritical = "-";
		var abs_MaxMajor = "-";
		var abs_MaxMinor = "-";
		var abs_MaxOpt = Ext.getCmp('maxStaticCheck').getValue();
		if (!abs_MaxOpt)
		{
			abs_MaxCritical = Ext.getCmp('absMaxCritical').getValue();
			abs_MaxMajor =  Ext.getCmp('absMaxMajor').getValue();
			abs_MaxMinor =  Ext.getCmp('absMaxMinor').getValue();

			// Negative value check...
			if (!isNegativeValuesAllowed)
			{
				//Invalid threshold entry check...
				if (!checkValidValue(abs_MaxCritical))
				{
					Ext.Msg.show({
						title: pageTitle4,
						msg: staticMaxCriticalErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxCritical').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MaxCritical != "-")
				{
					if(!checkNonNegativeFormat(abs_MaxCritical))
					{
						Ext.Msg.show({
							title: pageTitle4,
							msg: staticMaxCriticalErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMaxCritical').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MaxMajor))
				{
					Ext.Msg.show({
						title: pageTitle4,
						msg: staticMaxMajorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMajor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MaxMajor != "-")
				{
					if(!checkNonNegativeFormat(abs_MaxMajor))
					{
						Ext.Msg.show({
							title: pageTitle4,
							msg: staticMaxMajorErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMaxMajor').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MaxMinor))
				{
					Ext.Msg.show({
						title: pageTitle4,
						msg: staticMaxMinorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMinor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MaxMinor != "-")
				{
					if(!checkNonNegativeFormat(abs_MaxMinor))
					{
						Ext.Msg.show({
							title: pageTitle4,
							msg: staticMaxMinorErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMaxMinor').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				var ret = checkNegativeValue(abs_MaxCritical);
				if (ret)
				{
					Ext.Msg.show({
						title: pageTitle4,
						msg: errMsg11+" \'"+v_measure+"\' "+errMsg6,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxCritical').focus();
						}
					});
					flag = false;
					return false;
				}

				ret = checkNegativeValue(abs_MaxMajor);
				if (ret)
				{
					Ext.Msg.show({
						title: pageTitle4,
						msg: errMsg11+" \'"+v_measure+"\' "+errMsg6,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMajor').focus();
						}
					});
					flag = false;
					return false;
				}

				ret = checkNegativeValue(abs_MaxMinor);
				if (ret)
				{
					Ext.Msg.show({
						title: pageTitle4,
						msg: errMsg11+" \'"+v_measure+"\' "+errMsg6,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMinor').focus();
						}
					});
					flag = false;
					return false;
				}
			}
			else
			{
				if (!checkValidValue(abs_MaxCritical))
				{
					Ext.Msg.show({
						title: pageTitle4,
						msg: staticMaxCriticalErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxCritical').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MaxCritical != "-")
				{
					if(!checkNegativeFormat(abs_MaxCritical))
					{
						Ext.Msg.show({
							title: pageTitle4,
							msg: staticMaxCriticalErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMaxCritical').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MaxMajor))
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: staticMaxMajorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMajor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MaxMajor != "-")
				{
					if(!checkNegativeFormat(abs_MaxMajor))
					{
						Ext.Msg.show({
							title: pageTitle1,
							msg: staticMaxMajorErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMaxMajor').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MaxMinor))
				{
					Ext.Msg.show({
						title: pageTitle4,
						msg: staticMaxMinorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMinor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MaxMinor != "-")
				{
					if(!checkNegativeFormat(abs_MaxMinor))
					{
						Ext.Msg.show({
							title: pageTitle4,
							msg: staticMaxMinorErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMaxMinor').focus();
							}
						});
						flag = false;
						return false;
					}
				}
			}
			//check descending order...
			if (abs_MaxCritical != "-" && abs_MaxMajor != "-")
			{
				if (parseFloat(abs_MaxCritical) <= parseFloat(abs_MaxMajor))
				{
					Ext.Msg.show({
						title: pageTitle4,
						msg: errMsg9,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxCritical').focus();
						}
					});
					flag = false;
					return false;
				}
			}
			if (abs_MaxMajor != "-" && abs_MaxMinor != "-")
			{
				if (parseFloat(abs_MaxMajor) <= parseFloat(abs_MaxMinor))
				{
					Ext.Msg.show({
						title: pageTitle4,
						msg: errMsg9,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMajor').focus();
						}
					});
					flag = false;
					return false;
				}
			}
			if (abs_MaxCritical != "-" && abs_MaxMinor != "-")
			{
				if (parseFloat(abs_MaxCritical) <= parseFloat(abs_MaxMinor))
				{
					Ext.Msg.show({
						title: pageTitle4,
						msg: errMsg9,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxCritical').focus();
						}
					});
					flag = false;
					return false;
				}
			}
		}

		var rel_MaxCritical = "-";
		var rel_MaxMajor = "-";
		var rel_MaxMinor = "-";
		var maxAutoCheck = Ext.getCmp('maxAutoCheck').getValue();
		if (!maxAutoCheck)
		{
			var v_amount_D = Ext.getCmp('relMaxCriticalText').getValue();
			if (v_amount_D != 0)
			{
				if (v_amount_D == 100)
				{
					rel_MaxCritical = "sqc";
				}
				else
				{
					rel_MaxCritical = (v_amount_D/100) + "*sqc";
				}
			}

			var v_amount_E =  Ext.getCmp('relMaxMajorText').getValue();
			if (v_amount_E != 0)
			{
				if (v_amount_E == 100)
				{
					rel_MaxMajor = "sqc";
				}
				else
				{
					rel_MaxMajor = (v_amount_E/100) + "*sqc";
				}
			}

			var v_amount_F = Ext.getCmp('relMaxMinorText').getValue();
			if (v_amount_F != 0)
			{
				if (v_amount_F == 100)
				{
					rel_MaxMinor = "sqc";
				}
				else
				{
					rel_MaxMinor = (v_amount_F/100) + "*sqc";
				}
			}

			//check descending order...
			var relCri,relMaj,relMin;
			relCri = rel_MaxCritical;
			relMaj = rel_MaxMajor;
			relMin = rel_MaxMinor;
			relCri = relCri.replace(/(\*sqc)/gi,"");
			relCri = relCri.replace(/sqc/g,"1");
			relMaj = relMaj.replace(/(\*sqc)/gi,"");
			relMaj = relMaj.replace(/sqc/g,"1");
			relMin = relMin.replace(/(\*sqc)/gi,"");
			relMin = relMin.replace(/sqc/g,"1");

			if (relCri != "-" && relMaj != "-")
			{
				if (parseFloat(relCri) <= parseFloat(relMaj))
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: errMsg10,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					flag = false;
					return false;
				}
			}
			if (relMaj != "-" && relMin != "-")
			{
				if (parseFloat(relMaj) <= parseFloat(relMin))
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: errMsg10,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					flag = false;
					return false;
				}
			}
			if (relCri != "-" && relMin != "-")
			{
				if (parseFloat(relCri) <= parseFloat(relMin))
				{
					Ext.Msg.show({
						title: pageTitle1,
						msg: errMsg10,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					flag = false;
					return false;
				}
			}
		}

		if(abs_MaxCritical.indexOf(".") != -1 )
		{
			var abs_MaxCriticalDecimal = abs_MaxCritical.substring(abs_MaxCritical.indexOf(".")+1);
			if (abs_MaxCriticalDecimal == "0000" || 
				abs_MaxCriticalDecimal == "000" || 
				abs_MaxCriticalDecimal == "00" || 
				abs_MaxCriticalDecimal == "0")
			{
				abs_MaxCritical = abs_MaxCritical.substring(0,abs_MaxCritical.indexOf("."));
			}
			else if(abs_MaxCriticalDecimal.length > 1)
			{
				if ((abs_MaxCriticalDecimal.charAt(3) == "0" && abs_MaxCriticalDecimal.charAt(2) == "0") ||
					(abs_MaxCriticalDecimal.charAt(3) == "0"))
				{
					abs_MaxCritical = abs_MaxCritical.substring(0,abs_MaxCritical.lastIndexOf("0"));
				}
			}
		}
		if(abs_MaxMajor.indexOf(".") != -1 )
		{
			var abs_MaxMajorDecimal = abs_MaxMajor.substring(abs_MaxMajor.indexOf(".")+1);
			if (abs_MaxMajorDecimal == "0000" || 
				abs_MaxMajorDecimal == "000" ||
				abs_MaxMajorDecimal == "00" ||
				abs_MaxMajorDecimal == "0")
			{
				abs_MaxMajor = abs_MaxMajor.substring(0,abs_MaxMajor.indexOf("."));
			}
			else if(abs_MaxMajorDecimal.length > 1)
			{
				if ((abs_MaxMajorDecimal.charAt(3) == "0" && abs_MaxMajorDecimal.charAt(2) == "0") ||
					(abs_MaxMajorDecimal.charAt(3) == "0"))
				{
					abs_MaxMajor = abs_MaxMajor.substring(0,abs_MaxMajor.lastIndexOf("0"));
				}
			}
		}
		if(abs_MaxMinor.indexOf(".") != -1 )
		{
			var abs_MaxMinorDecimal = abs_MaxMinor.substring(abs_MaxMinor.indexOf(".")+1);
			if (abs_MaxMinorDecimal == "0000" || 
				abs_MaxMinorDecimal == "000" ||
				abs_MaxMinorDecimal == "00" ||
				abs_MaxMinorDecimal == "0")
			{
				abs_MaxMinor = abs_MaxMinor.substring(0,abs_MaxMinor.indexOf("."));
			}
			else if(abs_MaxMinorDecimal.length > 1)
			{
				if ((abs_MaxMinorDecimal.charAt(3) == "0" && abs_MaxMinorDecimal.charAt(2) == "0") ||
					(abs_MaxMinorDecimal.charAt(3) == "0"))
				{
					abs_MaxMinor = abs_MaxMinor.substring(0,abs_MaxMinor.lastIndexOf("0"));
				}
			}
		}

		var maxCritical = "-";
		if (abs_MaxCritical != "-" && rel_MaxCritical != "-")
		{
			if(abs_MaxCritical > -1 || abs_MaxCritical < 0)
			{
				if(abs_MaxCritical.indexOf(".") == 0)
				{
					abs_MaxCritical = "0"+abs_MaxCritical;
				}
				abs_MaxCritical = parseFloat(abs_MaxCritical);
				maxCritical = abs_MaxCritical.toString() + "&" + rel_MaxCritical;
			}
			else
			{
				maxCritical = rel_MaxCritical;
			}
		}
		else if (abs_MaxCritical != "-" && rel_MaxCritical == "-")
		{
			if(abs_MaxCritical > -1 || abs_MaxCritical < 0)
			{
				if(abs_MaxCritical.indexOf(".") == 0)
				{
					abs_MaxCritical = "0"+abs_MaxCritical;
				}
				abs_MaxCritical = parseFloat(abs_MaxCritical);
				maxCritical = abs_MaxCritical.toString();
			}
			else
			{
				maxCritical = "-";
			}
		}
		else if (abs_MaxCritical == "-" && rel_MaxCritical != "-")
		{
			maxCritical = rel_MaxCritical;
		}

		var maxMajor = "-";
		if (abs_MaxMajor != "-" && rel_MaxMajor != "-")
		{
			if(abs_MaxMajor > -1 || abs_MaxMajor < 0)
			{
				if(abs_MaxMajor.indexOf(".") == 0)
				{
					abs_MaxMajor = "0"+abs_MaxMajor;
				}
				abs_MaxMajor = parseFloat(abs_MaxMajor);
				maxMajor = abs_MaxMajor.toString() + "&" + rel_MaxMajor;
			}
			else
			{
				maxMajor = rel_MaxMajor;
			}
		}
		else if (abs_MaxMajor != "-" && rel_MaxMajor == "-")
		{
			if(abs_MaxMajor > -1 || + abs_MaxMajor < 0)
			{
				if(abs_MaxMajor.indexOf(".") == 0)
				{
					abs_MaxMajor = "0"+abs_MaxMajor;
				}
				abs_MaxMajor = parseFloat(abs_MaxMajor);
				maxMajor = abs_MaxMajor.toString();
			}
			else
			{
				maxMajor = "-";
			}
		}
		else if (abs_MaxMajor == "-" && rel_MaxMajor != "-")
		{
			maxMajor = rel_MaxMajor;
		}

		var maxMinor = "-";
		if (abs_MaxMinor != "-" && rel_MaxMinor != "-")
		{
			if(abs_MaxMinor > -1 || abs_MaxMinor < 0)
			{
				if(abs_MaxMinor.indexOf(".") == 0)
				{
					abs_MaxMinor = "0"+abs_MaxMinor;
				}
				abs_MaxMinor = parseFloat(abs_MaxMinor);
				maxMinor = abs_MaxMinor.toString() + "&" + rel_MaxMinor;
			}
			else
			{
				maxMinor = rel_MaxMinor;
			}
		}
		else if (abs_MaxMinor != "-" && rel_MaxMinor == "-")
		{
			if(abs_MaxMinor > -1  || abs_MaxMinor < 0)
			{
				if(abs_MaxMinor.indexOf(".") == 0)
				{
					abs_MaxMinor = "0"+abs_MaxMinor;
				}
				abs_MaxMinor = parseFloat(abs_MaxMinor);
				maxMinor = abs_MaxMinor.toString();
			}
			else
			{
				maxMinor = "-";
			}
		}
		else if (abs_MaxMinor == "-" && rel_MaxMinor != "-")
		{
			maxMinor = rel_MaxMinor;
		}

		if (maxCritical != "-" || maxMajor != "-" || maxMinor != "-")
		{
			maxThreshold = maxCritical + "/" + maxMajor + "/" + maxMinor
		}

		if (flag)
		{
			var v_threshold = v_measure + ":" + v_policy + ":" + minThreshold + ":" + maxThreshold + ":" + v_alarmPolicy + ":" + lastItem;
			//this.updateThresholds(v_testname,v_threshold);
			var homepage;
			if (isDDLoaded)
			{
				homepage = Ext.getCmp('ddgenerateCntnr');
			}
			else
			{
				if(isRESTTestType)
				{
					homepage = Ext.getCmp('restDataConfigurationWindow');
				}
				else
				{
					homepage = Ext.getCmp('generateCntnr');
				}
			}
			myMask = new Ext.LoadMask(homepage, {msg: updating+"..."});
			homepage.removeAll();
			myMask.show();

			var urlVal = '';
			var params = "&testName="+v_testname+"&threshold="+escape(v_threshold)+"&operation=updateThresholds";
			urlVal = 'ICTest/data/EgApplyThresholdsJson.jsp?'+params;

			Ext.Ajax.request({
				url:urlVal,
				method:'POST',
				timeout: 60000000,
				//async:false,
				scope:this,
				success:function(response)
				{
					if (response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						var jsonText = Ext.decode(response.responseText);
						if (jsonText.successUpdate != null && !Ext.isEmpty(jsonText.successUpdate) && jsonText.successUpdate == 'true')
						{
							Ext.Msg.show({
								title: pageTitle3,
								msg: successMsg1,
								buttons: Ext.Msg.OK,
								icon: 'iconInformation',
								fn: function(response) {
									if(response == 'ok') {
										homepage.add({ xtype : 'defaultthresholds' });
										myMask.hide();
									}
								}
							});
						}
					}
				},
				failure: function(response)
				{

					Ext.Msg.show({
						title: pageName,
						msg: 'Updating problem in server side...',
						icon: 'iconExclamation',
						buttons: Ext.Msg.OK
					});
				}
			});
		}
	},
	//updateThresholds: function (v_test,v_threshValue)
	//{
		//var homepage;
		//if (isDDLoaded)
		//{
			//homepage = Ext.getCmp('ddgenerateCntnr');
		//}
		//else
		//{
			//homepage = Ext.getCmp('generateCntnr');
		//}
		//myMask = new Ext.LoadMask(homepage, {msg: updating+"..."});
		//homepage.removeAll();
		//myMask.show();

		//var urlVal = '';
		//var params = "&testName="+v_test+"&threshold="+escape(v_threshValue)+"&operation=updateThresholds";
		//urlVal = 'ICTest/data/EgApplyThresholdsJson.jsp?'+params;

		//Ext.Ajax.request({
			//url:urlVal,
			//method:'POST',
			//timeout: 600000,
			////async:false,
			//scope:this,
			//success:function(response)
			//{
				//if (response.status == 200 && !Ext.isEmpty(response.responseText))
				//{
					//var jsonText = Ext.decode(response.responseText);
					//if (jsonText.successUpdate != null && !Ext.isEmpty(jsonText.successUpdate) && jsonText.successUpdate == 'true')
					//{
						//Ext.Msg.show({
							//title: pageTitle3,
							//msg: successMsg1,
							//buttons: Ext.Msg.OK,
							//icon: 'iconInformation',
							//fn: function(response) {
								//if(response == 'ok') {
									//homepage.add({ xtype : 'defaultthresholds' });
									//myMask.hide();
								//}
							//}
						//});
					//}
				//}
			//},
			//failure: function(response)
			//{
				//Ext.Msg.alert(pageTitle3,'Thresholds value update failed');
				//return false;
			//}
		//});
	//},
	maxStaticFieldChange: function(field){
	var maxStaticCheck = Ext.getCmp('maxStaticCheck').getValue();
	copyField = Ext.getCmp(field.id);

	if (maxStaticCheck) {
		copyField.reset();
	} else {
		copyField.clearInvalid();
	}
	},
	maxAutoFieldChange: function(field){
		var maxAutoCheck = Ext.getCmp('maxAutoCheck').getValue();
		copyField = Ext.getCmp(field.id);
		if (maxAutoCheck) {
			copyField.reset();
		} else {
			copyField.clearInvalid();
		}
	},
	minStaticFieldChange: function(field){
	var minStaticCheck = Ext.getCmp('minStaticCheck').getValue();
		copyField = Ext.getCmp(field.id);

	if (minStaticCheck) {
		copyField.reset();
	} else {
		copyField.clearInvalid();
	}
},
	minAutoFieldChange: function(field){
		var minAutoCheck = Ext.getCmp('minAutoCheck').getValue();
			copyField = Ext.getCmp(field.id);
		if (minAutoCheck) {
			copyField.reset();
		} else {
			copyField.clearInvalid();
		}
	},
	maxStaticCheckChange: function(box, checked)
	{
		var fieldset = box.ownerCt;
		Ext.Array.forEach(fieldset.query('textfield'), this.maxStaticFieldChange, this);
		Ext.Array.forEach(fieldset.query('textfield'), function(field) {
			field.setDisabled(checked);
			if (!Ext.isIE6) {
				field.el.animate({opacity: checked ? 0.3 : 1});
			}
		});
	},
	maxAutoCheckChange: function(box, checked)
	{
		var fieldset = box.ownerCt;
		Ext.Array.forEach(fieldset.query('slider'), this.maxAutoFieldChange, this);
		Ext.Array.forEach(fieldset.query('slider'), function(field) {
			field.setDisabled(checked);
			if (!Ext.isIE6) {
				field.el.animate({opacity: checked ? 0.3 : 1});
			}
		});
		Ext.Array.forEach(fieldset.query('displayfield'), this.minAutoFieldChange, this);
		Ext.Array.forEach(fieldset.query('displayfield'), function(field) {
			if (field.id == 'maxThreshDisplayField')
			{
			}
			else
			{
				field.setDisabled(checked);
				if (!Ext.isIE6) {
					field.el.animate({opacity: checked ? 0.3 : 1});
				}
			}
		});
	},
	minStaticCheckChange: function(box, checked)
	{
		var fieldset = box.ownerCt;
		Ext.Array.forEach(fieldset.query('textfield'), this.minStaticFieldChange, this);
		Ext.Array.forEach(fieldset.query('textfield'), function(field) {
			field.setDisabled(checked);
			if (!Ext.isIE6) {
				field.el.animate({opacity: checked ? 0.3 : 1});
			}
		});
	},
	minAutoCheckChange: function(box, checked)
	{
		var fieldset = box.ownerCt;
		Ext.Array.forEach(fieldset.query('slider'), this.minAutoFieldChange, this);
		Ext.Array.forEach(fieldset.query('slider'), function(field) {
		field.setDisabled(checked);
			if (!Ext.isIE6) {
				field.el.animate({opacity: checked ? 0.3 : 1});
			}
		});
		Ext.Array.forEach(fieldset.query('displayfield'), this.minAutoFieldChange, this);
		Ext.Array.forEach(fieldset.query('displayfield'), function(field) {
			if (field.id == 'minThreshDisplayField')
			{
			}
			else
			{

				field.setDisabled(checked);
				if (!Ext.isIE6) {
					field.el.animate({opacity: checked ? 0.3 : 1});
				}
			}
		});
	},
	getHiddenFields : function(measureActualVal)
	{
		var hiddenFields = publicJson['hiddenDataObj'][measureActualVal.trim()];
		var hiddenQstr = '';
		for (key in hiddenFields)
		{
			hiddenQstr += key+'='+encodeURIComponent(hiddenFields[key])+"&";
		}
		return hiddenQstr;
	},
	maxRelCriticalSlider: function()
	{
		Ext.getCmp('relMaxCriticalText').setValue(Ext.getCmp('relMaxCritical').getValue());
	},
	maxRelMajorSlider: function()
	{
		Ext.getCmp('relMaxMajorText').setValue(Ext.getCmp('relMaxMajor').getValue());
	},
	maxRelMinorSlider: function()
	{
		Ext.getCmp('relMaxMinorText').setValue(Ext.getCmp('relMaxMinor').getValue());
	},
	minRelCriticalSlider: function()
	{
		Ext.getCmp('relMinCriticalText').setValue(Ext.getCmp('relMinCritical').getValue());
	},
	minRelMajorSlider: function()
	{
		Ext.getCmp('relMinMajorText').setValue(Ext.getCmp('relMinMajor').getValue());
	},
	minRelMinorSlider: function()
	{
		Ext.getCmp('relMinMinorText').setValue(Ext.getCmp('relMinMinor').getValue());
	},
	noThreshMeasureModify: function( grid, td, cellIndex, record, tr, rowIndex, e, eOpts )
	{
		var pos = grid.getSelectionModel().getCurrentPosition();
		record = grid.store.getAt(pos.row);
		colname = grid.getHeaderCt().getHeaderAtIndex(cellIndex).dataIndex;
		cellvalue = record.data[colname];
		actualMeasName = publicJson['measureDataObj'][cellvalue];
		if (actualMeasName != null && actualMeasName != 'undefined' && actualMeasName != '')
		{
			hiddenFieldsVal = this.getHiddenFields(actualMeasName);
			var homepage;
			if (isDDLoaded)
			{
				homepage = Ext.getCmp('ddgenerateCntnr');
			}
			else
			{
				if(isRESTTestType)
				{
					homepage = Ext.getCmp('restDataConfigurationWindow');
				}
				else
				{
					homepage = Ext.getCmp('generateCntnr');
				}
			}
			homepage.removeAll();
			homepage.add({ xtype : 'configurethresholds' });
		}
	},
	handleEditIconClick: function(view, rowIndex, colIndex, column, e)
	{
		this.showEditWindow(view.getRecord(view.findTargetByEvent(e)));
	},
	showEditWindow: function(task)
	{
		var measureName = task.get('Measure');
		var thresholds = task.get('Thresholds');
		var alarmPol = task.get('AlarmPolicy');
		if(measureName.lastIndexOf(' ') != -1)
		{
			measureName = measureName.substring(0,measureName.lastIndexOf(' '));
		}
		var measureActualObj = publicJson.measureDataObj;
		hiddenFieldsVal = this.getHiddenFields(measureActualObj[measureName.trim()]);
		var me = this;
		var homepage;
		if (isDDLoaded)
		{
			homepage = Ext.getCmp('ddgenerateCntnr');
		}
		else
		{
			if(isRESTTestType)
			{
				homepage = Ext.getCmp('restDataConfigurationWindow');
			}
			else
			{
				homepage = Ext.getCmp('generateCntnr');
			}
		}
		homepage.removeAll();
		homepage.add({ xtype : 'configurethresholds' });
	},
	showModifyTool: function(view, record, item, index, e)
	{
		var icons = Ext.DomQuery.select('.x-action-col-icon', item);
		Ext.each(icons, function(icon){
			//Ext.get(icon).removeCls('x-hidden');
		 });
	},
	hideModifyTool: function( view, record, item, index, e, eOpts )
	{
		var icons = Ext.DomQuery.select('.x-action-col-icon', item);
		Ext.each(icons, function(icon){
			//Ext.get(icon).addCls('x-hidden');
		});
	}
});

function checkValidValue(val)
{
	var regExp = /^(\-)$|^(\-|\-?(([0-9]+\.|\.)?[0-9]+))$/i;
	var ret = regExp.test(val);
	return ret;
}

function checkNegativeValue(val)
{
	if (val == "-")
	{
		val = "0";
	}
	var regExp = /^\-([0-9]+\.|\.)?[0-9]+/;
	var ret = regExp.test(val);
	return ret;
}

function checkNegativeFormat(val)
{
	var regExp= /^(\-{0,1})[0-9]{1,10}(\.[0-9]{1,4})?$/;
	var ret = regExp.test(val);
	return ret;
}

function checkNonNegativeFormat(val)
{
	var regExp= /^[0-9]{0,10}(\.[0-9]{1,4})?$/;
	var ret = regExp.test(val);
	return ret;
}



