
Ext.define('ICTest.view.AddNewTest', {
	extend: 'Ext.form.Panel',
	alias: 'widget.addnewtest',
	title: pageTitle2,
	extend: 'utilities.innerScrollContainer',
	margin : '8 8 0 8',
	frame:true,
	paading:0,
	bodyPadding:0,
	cls:'outerpanel',

	requires: [
		'utilities.ScrollCombo',
		'utilities.adminMsg',
		'utilities.ScrollTabPanel',
		'ICTest.view.AddHelp'
	],

	layout: {
		type: 'vbox',
		align: 'stretch'
	},

	tools: [
		{
			xtype : 'button',
			text : back,
			cls:'backbutton',
			iconCls:'iconBack',
			id : 'backButton'
		}
	],

	dockedItems: [{
		xtype: 'toolbar',
		cls:'adminHeadInfoText',
		dock: 'top',
		height: 25,
		border:true,
		padding: 3,
		margin : 0,
		layout:{pack:'center'},
		items: [
			{
				xtype: 'component',
				html: '<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp'+pageDesc2+'.</center>',
			}
		]
	}],

	items: [
		{
			xtype: 'scrolltabPanel',
			cls: 'tablayout tabpanel',
			//style:{'border': '0px none ! important'},
			bodyCls:'scrollTabPanel-body',
			id:'newtest',
			tabPosition: 'top',
			flex: 1,
			margin: '8',
			listeners: {
				'tabchange': function(tabPanel, newCard, oldCard, eOpts ) {
					addctrler.tabchange(tabPanel);
				}
			},
			defaults: {
				autoScroll: true
			},
			items: [
				{
					title: tab1Test,
					itemId:'addtest',
					id:'addtest',
					margin: 20,
					listeners: {
							activate: function(){
							addctrler.loadTestTab();
						}
					},
					items: [
						{
							xtype: 'container',
							layout: {
								type: 'vbox',
								align: 'center',
								pack: 'center'
							},
							defaults: {
								labelSeparator: '',
								margin: 5,
								width: 500,
								labelWidth: 250
							},
							items: [
								{
									xtype: 'scrollcombo',
									id: 'type',
									name: 'Type',
									fieldLabel : typeName,
									store: new Ext.data.Store({
										fields:['displayField','valueField'],
										data:[]
									}),
									displayField:'displayField',
									valueField:'valueField',
									queryMode : 'local',
									editable : false,
									forceSelection: false
								},
								{
									xtype: 'textfield',
									fieldLabel: testName,
									cls:'textbox',
									id:'test',
									name:'test',
									maxLength: 19,
									enforceMaxLength: true,
									listeners:{
										afterrender : function(fld){
											fld.focus(false,200);
										}
									}
								},
								{
									xtype: 'radiogroup',
									fieldLabel: duplicate,
									id:'duplicatetest',
									name:'duplicatetest',
									columns: 2,
									vertical: false,
									hidden:true,
									items: [
										{ boxLabel: yes, name: 'duprb', inputValue: 'Yes',cls:'radiobt' },
										{ boxLabel: no, name: 'duprb', inputValue: 'No', checked: true,cls:'radiobt'}
									]
								},
								{
									xtype: 'scrollcombo',
									id:'nonDupTest',
									name:'nonDupTest',
									hidden:true,
									fieldLabel: testToDuplicate,
									store: new Ext.data.Store({
										fields : ['displayField', 'valueField'],
										data : []
									}),
									displayField:'displayField',
									valueField:'valueField',
									queryMode : 'local',
									editable: false
								},
								{
									xtype: 'textfield',
									cls:'textbox',
									fieldLabel: testType,
									id:'testTypeLabel',
									hidden:true,
									value:'',
									readOnly: true
								}
							]
						},
						{
							xtype: 'container',
							id:'elmtsCntnr',
							layout: {
								type: 'vbox',
								align: 'center',
								pack: 'center'
							},
							defaults: {
								labelSeparator: '',
								margin: 5,
								width: 500,
								labelWidth: 250
							},
							items: [
								{
									xtype: 'scrollcombo',
									id:'testType',
									name:'testType',
									fieldLabel: category,
									store: new Ext.data.Store({
										fields : ['displayField', 'valueField'],
										data : []
									}),
									displayField:'displayField',
									valueField:'valueField',
									queryMode : 'local',
									editable: false,
									forceSelection: false
								},
								{
									xtype: 'radiogroup',
									fieldLabel: execution,
									id:'execution',
									name:'execution',
									columns: 2,
									vertical: false,
									items: [
										{ boxLabel: internal, name: 'exerb', id: 'execIn', inputValue: 'Internal', checked: true ,cls:'radiobt'},
										{ boxLabel: external, name: 'exerb', id: 'execEx', inputValue: 'External',cls:'radiobt'}
									]
								},
								{
									xtype: 'radiogroup',
									fieldLabel: port,
									id:'port',
									name:'port',
									columns: 2,
									vertical: false,
									items: [
										{ boxLabel: yes, name: 'portrb', id: 'portYes', inputValue: 'Yes', checked: true,cls:'radiobt'  },
										{ boxLabel: no, name: 'portrb', id: 'portNo', inputValue: 'No',cls:'radiobt' }
									]
								},
								{
									xtype: 'radiogroup',
									fieldLabel: ostype,
									id:'ostype',
									name:'ostype',
									columns: 2,
									vertical: false,
									hidden:true,
									items: [
										{ boxLabel: unix, name: 'ostyperb', id: 'osUnix', inputValue: 'Unix', checked: true,cls:'radiobt' },
										{ boxLabel: windows, name: 'ostyperb', id: 'osWin', inputValue: 'Windows',cls:'radiobt' }
									]
								},
								{
									xtype: 'scrollcombo',
									id:'dbType',
									name:'dbType',
									hidden:true,
									fieldLabel: dbType,
									store: new Ext.data.Store({
										fields : ['displayField', 'valueField'],
										data : []
									}),
									displayField:'displayField',
									valueField:'valueField',
									queryMode : 'local',
									editable: false
								}
							]
						},
						{
							xtype: 'container',
							layout: {
								type: 'hbox',
								pack: 'center'
							},
							margin: 20,
							items: [
								{
									xtype: 'button',
									cls:'button20',
									text: add,
									id:'add',
									width: 80
								}
							]
						}
					]
				},
				{
					title: tab2Param,
					id:'addParamTab',
					disabled: true,
					dockedItems: [
						{
							dock: 'top',
							layout:{
								type: 'hbox',
								pack: 'end'
							},
							id: 'addParam',
							border: false,
							padding: 5,
							items: [
								{
									xtype: 'button',
									cls: 'button20',
									id: 'addNewParam',
									text: addParam
								}
							]
						}
					],
					items: [
						{
							xtype: 'container',
							id:'addParamCntnr',
							layout: {
								type: 'vbox',
								align: 'center',
								pack: 'center'
							},
							margin: 20,
							flex: 1
						},
						{
							xtype: 'container',
							id:'noParamsFnd',
							layout: {
								type: 'hbox',
								pack: 'center'
							},
							margin: 15,
							//hidden: true,
							items: [
								{
									xtype: 'label',
									html: '<table><tr><td align="center" height="280"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+noParamFnd+'.</td></tr></table></td></tr></table>',
								}
							]
						}
					]
				},
				{
					title: 'API',
					id : 'datasetTab',
					disabled: true,
					hidden : true,
					listeners: {
							activate: function(){
							datasetCtrlr.loadDatasetTab();
						}
					},
					items : [
					/*	{
							xtype: 'scrollcombo',
							id: 'Dataset_type',
							name: 'Dataset_type',
							fieldLabel : 'Dataset Type',
							store: new Ext.data.Store({
								fields:['displayField','valueField'],
								data:[]
							}),
							displayField:'displayField',
							valueField:'valueField',
							queryMode : 'local',
							editable : false,
							forceSelection: false
						},*/
						{
							xtype : 'panel',
							id : 'datasetconfiguration',
							items :[
							{
								xtype : 'container',
								html : '<div><a href="javascript:void(0);" onclick="javascript:configureDataSet();">click here to configure dataset</a></div>'
							}
							]
						}
					]
				},
				{
					title: tab3Measure,
					id:'addMeasureTab',
					disabled: true,
					listeners: {
							activate: function(){
							addctrler.loadMeasureTab();
						}
					},
					dockedItems: [
						{
							dock: 'top',
							layout:{
								type: 'hbox',
								pack: 'end'
							},
							id: 'addMeasure',
							border: false,
							padding: 5,
							/*listeners:{
								'close':function(win){
										addctrler.loadMeasureTab(); 
									}
								},*/
							items: [
								{
									xtype: 'button',
									cls:'button20',
									id: 'addNewMeasure',
									text: addMeasure,
									
								},
								{
									xtype: 'button',
									cls:'button20',
									id: 'showMeasure',
									text:showMeasure,
									hidden: true
								},
								{
									xtype: 'button',
									cls:'button20',
									margin: '5 5 0 0',
									id: 'configureMetricsBtn',
									text: configureMetrics,
									hidden: true
								}
							]
						}
					],
					items: [
						{
							xtype: 'container',
							id:'addMeasureCntnr',
							layout: {
								type: 'vbox',
								align: 'center',
								pack: 'center'
							},
							margin: 20,
						},
						{
							xtype: 'container',
							id:'noMeasureFnd',
							layout: {
								type: 'hbox',
								pack: 'center'
							},
							margin: 15,
							hidden: true,
							items: [
								{
									xtype: 'label',
									html: '<table><tr><td align="center" height="280"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+noMeasureFnd+'.</td></tr></table></td></tr></table>',
								}
							]
						}
						
					]
				},
				{
					title: tab4Generate,
					id:'generateCntnr',
					disabled: true,
					listeners: {
							activate: function(){
							addctrler.loadGenerateTab();
						}
					}
				},
				{
					title: tab5DD,
					id:'ddgenerateCntnr',	
					itemId: 'tab5DD',
					hidden: true,
					listeners: {
							activate: function(){
							addctrler.loadDDTab();
						}
					},
					layout: {
						type: 'vbox',
						align: 'stretch'
					},
					items: [
						{
							
							xtype: 'scrolltabPanel',
							cls: 'tablayout tabpanel',
							plain: true,
							id:'addDD',
							tabPosition: 'top',
							flex: 1,
							margin: '5 5 5 5',
							items: [
								{
									title: tab3Measure,
									id:'addDDMeasureTab',
									autoScroll: true,
									//disabled: true,
									listeners: {
											activate: function(){
											//addctrler.loadDDMeasureTab();
										}
									},
									items: [
										{
											xtype: 'toolbar',
											ui:'footer',
											dock: 'top',
											id:'addDDMeasure',
											items: [
												{
													xtype: 'tbfill'
												},
												{
													xtype: 'button',
													cls:'button20',
													id: 'addNewDDMeasure',
													text: addMeasure,
													margin: '5 15 5 5'
												}
											]
										},
										{
											xtype: 'container',
											id:'addDDMeasureCntnr',
											layout: {
												type: 'vbox',
												align: 'center',
												pack: 'center'
											},
											margin: 20,
										},
										{
											xtype: 'container',
											id:'noDDMeasureFnd',
											layout: {
												type: 'hbox',
												pack: 'center',
												align: 'center'
											},
											margin: 15,
											hidden: true,
											items: [
												{
													xtype: 'label',
													html: '<table><tr><td align="center" height="280"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+noMeasureFnd+'.</td></tr></table></td></tr></table>',
												}
											]
										}
									]
								},
								{
									title: tab4Generate,
									id:'ddGenerateTab',
									disabled: true,
									layout: {
										type: 'vbox',
										pack: 'start',
										align: 'center'
									},
									items: [
										{
											xtype: 'fieldset',
											title: '<b>'+browseFile+'</b>',
											margin: 20,
											layout: {
												type: 'vbox',
												pack: 'center',
												align: 'left'
											},
											items: [
												{
													xtype:'container',
													layout: {
														type: 'hbox',
														pack: 'start'
													},
													margin: 10,
													items:[
														{
															xtype: 'textfield',
															cls : 'textbox',
															fieldLabel: classFile,
															labelSeparator: ' ',
															id:'ddPath',
															name:'ddPath',
															width: 450,
															labelWidth: 100
														},
														{
															xtype: 'button',
															cls : 'textbox',
															cls:'button20',
															text: choose,
															id:'ddChooseClass',
															name:'ddChooseClass',
															width: 80,
															margin: '0 0 0 20'
														}
													]
												},
												{
													xtype:'container',
													layout: {
														type: 'hbox',
														pack: 'start'
													},
													margin: 10,
													items:[
														{
															xtype: 'textfield',
															cls : 'textbox',
															fieldLabel: libFile,
															labelSeparator: ' ',
															id:'ddLib',
															name:'ddLib',
															width: 450,
															labelWidth: 100
														},
														{
															xtype: 'button',
															cls:'button20',
															text: choose,
															id:'ddChooselLib',
															name:'ddChooseLib',
															width: 80,
															margin: '0 0 0 20'
														},
														{
															xtype: 'checkbox',
															cls:'checkbt',
															boxLabel: loadLib,
															id:'ddLoadLib',
															name:'ddLoadLib',
															labelAlign: 'left',
															margin: '0 0 0 20',
															width: 150
														}
													]
												},
												{
													xtype: 'label',
													text: '( '+fileReqToExecute+' )',
													margin: '0 10 10 10'
												}
											]
										},
										{
											xtype:'container',
											layout: {
												type: 'hbox',
												pack: 'center'
											},
											items: [
												{
													xtype: 'button',
													cls:'button20',
													text: generate,
													id:'ddGenerate',
													name:'ddGenerate',
													width: 80
												}
											]
										}
									]
								}
							]
						}
					]
				},
				{
					title: tab6Help,
					autoScroll : true,
					scroll : true,
					id: 'tab6Help',
					itemId: 'helpTab',
					disabled: true,
					listeners: {
							activate: function(){
							addctrler.loadHelpTab();
						}
					},
					dockedItems :[
						{
							dock: 'bottom',
							layout : {
								type : 'hbox',
								pack : 'center'
							},
							padding: '10 0 10 0',
							items: [
								{
									xtype: 'button',
									cls : 'button20',
									text: btnText2,
									id:'createHelp',
									width: 80,
									listeners: {
										click: {
											fn: function (id) {
												addctrler.updateTestTemplates();
											}
										}
									}
								}
							]
						}
					],
					items: [
						{
							xtype : 'addhelp'
						}
					]
				}
			]
		}
	]
});



