Ext.define('ICTest.view.DefaultThresholds', {
	extend: 'Ext.container.Container',
	alias: 'widget.defaultthresholds',

	items: [
		{
			xtype: 'container',
			id: 'resultContainer',
			margin:10,
			flex:1,
			layout: {
				type: 'vbox',
				pack: 'center',
				align: 'stretch'
			},
			items:[
				{
					xtype: 'fieldset',
					id: 'fieldTitleId',
					style: {
						'box-shadow':'none'
					},
					title: '',
					margin: 10,
					flex:1,
					//width: 965,
					layout: {
						type: 'vbox',
						pack: 'center',
						align: 'stretch'
					},
					items: [
						{
							xtype: 'container',
							id: 'hostTestMsgContainer',
							margin: 15,
								flex:1,
							hidden: true,
							layout: {
								type: 'vbox',
								//pack: 'center',
								align: 'stretch'
							},
							items: [
								{
									xtype: 'label',
									id: 'hostMsgLabel',
									html: '',
								}
							]
						},
						{
							xtype: 'grid',
							cls:'gridSkin',
							id: 'measureGrid',
							margin: '10 0 10 0',
							flex:1,
							title: titleGrid1,
							store:new Ext.data.Store(
							{
								fields: ['Measure','Threshold','AlarmPolicy'],
								data: []
							}),
							autoScroll: true,
							hideHeaders: true,
							columns: {
								defaults: {
									sortable: false,
									hideable: false,
									menuDisabled: true,
									draggable: false,
									resizable: false
								},
								items: [
									{
										text: measureText,
										dataIndex: 'Measure',
										
									},
									{
										text: thresholdText,
										dataIndex: 'Threshold',
										flex:1,
										//width: 550,
										renderer : function(value, metaData, record, row, col, store, gridView) {
											metaData.tdCls ="threshold_tdcls";
											//value = "Min|-|2|-#Max|99|90|80" - For reference
											var measures = value.split("#");
											var measuresLen = measures.length;
											var result = "";
											if (measuresLen == 1)
											{
												var vals = measures[0].split("|");
												result = '<table border="0"cellspacing="0" cellpadding="0" class="font_normal11 threshold_table"><tr><td width="70" height="20" class="font_bold11" valign="top">'+vals[0]+'</td><td width="160" height="20" valign="top">'+vals[1]+'</td><td width="160" height="20" valign="top">'+vals[2]+'</td><td width="160" height="20" valign="top">'+vals[3]+'</td></tr></table>'
											}
											else
											{
												var val0 = measures[0].split("|");
												var val1 = measures[1].split("|");
												result = '<table border="0" style="width:550px;padding:0px;" cellspacing="0" cellpadding="0" class="font_normal11 threshold_table"><tr><td style="width:70px !important;padding:0px;" height="20" class="font_bold11" valign="top">'+val0[0]+'</td><td style="width:160px !important;padding:0px;" height="20" valign="top">'+val0[1]+'</td><td style="width:160px !important;padding:0px;" height="20" valign="top">'+val0[2]+'</td><td style="width:160px !important;padding:0px;" height="20" valign="top">'+val0[3]+'</td></tr><tr><td style="width:70px !important;padding:0px;" height="20" class="font_bold11" valign="top">'+val1[0]+'</td><td style="width:160px !important;padding:0px;" height="20" valign="top">'+val1[1]+'</td><td style="width:160px !important;padding:0px;" height="20" valign="top">'+val1[2]+'</td><td style="width:160px !important;padding:0px;" height="20" valign="top">'+val1[3]+'</td></tr></table>'
											}
											return result;
										}
									},
									{
										text: alarmPolText,
										dataIndex: 'AlarmPolicy',
										width: 114
									},
									{
										xtype: 'actioncolumn',
										//cls: 'tasks-icon-column-header tasks-edit-column-header',
										width: 36,
										//icon: '../../../../resources/images/edit_task.png',
										iconCls: 'iconModify',
										//tooltip: 'Modify',
										sortable: false,
										handler: function(view, rowIndex, colIndex, column, e) {
											me.handleEditIconClick(view, rowIndex, colIndex, column, e);
										},
										renderer: function(value, metaData, record, row, col, store, gridView)
										{
											metaData.tdAttr = "data-qtip='Modify' data-qclass='yellowTip'";
										}
									}
								]
							},
							hidden: true,
							dockedItems: [
								{
									xtype: 'toolbar',
									dock: 'top',
									height: 25,
									padding: 0,
									items: [
										{
											xtype: 'label',
											text: measureText,
											width: 245,
											height: 25,
											cls:'gridlabelheader'
										},
										{
											xtype: 'label',
											text: maxminText,
											width: 70,
											height: 25,
											cls:'gridlabelheader',
											margin: '0 0 0 -2'
										},
										{
											xtype: 'label',
											text: criticalText,
											width: 160,
											height: 25,
											cls:'gridlabelheader'
										},
										{
											xtype: 'label',
											text: majorText,
											width: 160,
											height: 25,
											cls:'gridlabelheader',
											margin: '0 0 0 -2'
										},
										{
											xtype: 'label',
											text: minorText,
											width: 160,
											height: 25,
											cls:'gridlabelheader'
										},
										{
											xtype: 'label',
											text: alarmPolText,
											width: 114,
											height: 25,
											cls:'gridlabelheader',
											margin: '0 0 0 -2'
										},
										{
											xtype: 'label',
											text: '',
											width: 36,
											cls:'gridlabelheader',
											height: 25
										}
									]
								}
							]
						},
						{
							xtype: 'grid',
							cls : 'gridSkin cellmodel_single',
							id: 'noMeasureGrid',
							flex:1,
							title: titleGrid2,
							store:new Ext.data.Store({
								fields: ['Measure1','Measure2','Measure3'],
								data: []
							}),
							//width: 840,
								flex:1,
							autoScroll: true,
							hideHeaders: true,
							hidden: true,
							selModel: {
								selType: 'cellmodel',
								mode: 'SINGLE'
							},
							columns: {
								defaults: {
									sortable: false,
									hideable: false,
									menuDisabled: true,
									draggable: false,
									resizable: false
								},
								items: [
									{
										text: '',
										dataIndex: 'Measure1',
										id:'measOne',
										flex: 1,
										renderer:function( val )
										{
											if (val != null || val != '')
												val = '<div style="cursor:pointer;">'+val+'</div>';
											return val;
										}
									},
									{
										text: '',
										dataIndex: 'Measure2',
										id: 'measTwo',
										flex: 1,
										renderer:function( val )
										{
											if (val != null || val != '')
												val = '<div style="cursor:pointer;">'+val+'</div>';
											return val;
										}
									},
									{
										text: '',
										dataIndex: 'Measure3',
										id: 'measThree',
										flex: 1,
										renderer:function( val )
										{
											if (val != null || val != '')
												val = '<div style="cursor:pointer;">'+val+'</div>';
											return val;
										}
									}
								]
							}
						},
						{
							xtype: 'container',
							id: 'buttonContainer',
							frame: true,
							layout: {
								type: 'hbox',
								pack: 'center'
							},
							margin: '20 0 20 0',
							items: [
								{
									xtype: 'button',
									cls : 'button20',
									id: 'submitBtn',
									text: btnText,
									width: 80
								}
							]
						}
					]
				}
			]
		}
	]
});



