Ext.define('ICTest.view.RESTGenerate', {
	extend: 'Ext.container.Container',
	alias: 'widget.restgenerate',
	layout: {
		type: 'vbox',
		//pack: 'center',
		align: 'stretch'
	},
	margin: 10,
	selectedMetrics : '',
	descriptorFields : '',
	dataFieldParentNode : '',
	multipleNodes : false,
	initComponent : function()
	{
		var meRESTGenCont=this;
		var selectedMetrics=this.selectedMetrics;
		var descriptorFields=this.descriptorFields;
		var dataFieldParentNode=this.dataFieldParentNode;
		var descriptorDataFldsArr=[];
		if(!Ext.isEmpty(descriptorFields))
		{
			for(var inf in descriptorFields)
			{
				var optObj={};
				var dispInf=descriptorFields[inf];
				if(dispInf!=null && dispInf.indexOf("|^|")>0)
					dispInf=dispInf.substring(0,dispInf.indexOf("|^|"));

				optObj['displayField']=dispInf;
				optObj['valueField']=descriptorFields[inf];
				descriptorDataFldsArr.push(optObj);
			}
		}
		
		var metricsContArr=[];
		if(!Ext.isEmpty(selectedMetrics))
		{
			
			var metricDataStr=[];
			for(var met in selectedMetrics)
			{
				var metric=selectedMetrics[met];
				if(metric!=null && metric.indexOf("|^|")>0)
					metric=metric.substring(0,metric.indexOf("|^|"));

				var columnObj={};
				columnObj['COLUMNS']=metric;
				var jk=1;
				metricDataStr.push(columnObj);
			}
		}
		var itmsArr=[];
		itmsArr.push({
					xtype : 'container',
					layout: {
						type: 'vbox',
						align: 'stretch',
						pack: 'left'
					},
					defaults: {
						labelSeparator: '',
						margin: 0
					},
					items : [
					{
						xtype : 'panel',
						cls: 'measureHead datapanel',
						scroll: true,
						//flex:1,
//						margin:10,
						border: true,
						//margin: '0 50 0 50',
						title : '<span>'+screenLabelsObj['measuresLbl']+'</span>',
						height : '200',
						scroll : true,
						autoScroll : true,
						items : [
									{
										xtype: 'dataview',
										margin: '0 0 0 0',
										padding: 0,
										flex:1,
										layout: {
											type: 'vbox',
											align: 'stretch'
										},
										store : Ext.data.Store({
											fields : [ 'COLUMNS'],
											data :metricDataStr
										}), 
										itemSelector: 'div.thumb-wrap',
										tpl: new Ext.XTemplate(
										'<div class="newTable x-table-outer-border lastBorderLess">',
											'<table border="0" style="width:100%; border:none" >',
												'{[this.getRows(values)]}',
												// '<tr><td>df</td></tr>',
											'</table>',
										'</div>',
										{
										getRows: function (values) {
											var ret = '',
												rowsArr = [];
											var remainder = (values.length%3);
											Ext.each(values, function (item, i) {
												if(i== 0){
												ret += '<tr>';    
												}
												else if(i%3 == 0){
														
												ret += '</tr>'; 
												ret += '<tr>';
												}
												
												ret += '<td >' + item.COLUMNS + '</td>'
												
											});
											if(remainder == 1){
												ret += '<td colspan="1"> </td><td  colspan="1" > </td>'
												}
												else if(remainder == 2){
												ret += '<td  colspan="1"> </td>'
												}
											ret += '</tr>';
											return ret;
										}

									}
									)
							
								}]
					}
					]
		});
		if(!meRESTGenCont.multipleNodes &&!Ext.isEmpty(descriptorDataFldsArr))
		{
			itmsArr.push(
				{
					xtype: 'container',
					layout: {
						type: 'hbox',
						align: 'stretch'
					},
					padding: '20 0 15 0',
					cls: 'apiConfBottombtn',
					items: [
						{
							xtype: 'switchfield',
							labelWidth: 200,
							height: 34,
							width: 240,
							margin: '0 15 0 0',
							cls:'apiConfbtn',
							labelCls: 'DSswitchfieldCls',
							labelStyle : 'margin: 8px 0 0 0; display:block;',
							fieldLabel: '<span class="newFont_normal12" style="line-height:1;">'+infoBasedTest+'</span>',
							checked: false,
							id: 'DescriptorRequired',
							name: 'DescriptorRequired',
							inputValue: 'Yes',
							uncheckedValue: 'No',

						},
						/*{
							xtype:'container',
							id: 'descriptorRestFieldCont',
							hidden: true,
							margin: '0 0 5 30',
							defaults: {
								labelSeparator: '',
								margin: 0,
								width: 310,
								labelWidth: 163
							}
						},*/
							{
								xtype: 'scrollcombo',
								id: 'descriptorDataRestFld',
								name: 'descriptorDataRestFld',
								margin: '0 0 5 30',
								fieldLabel : 'Descriptor',
								labelWidth: 72,
								width:310,
								hidden: true,
								store: new Ext.data.Store({
									fields:['displayField','valueField'],
									data:descriptorDataFldsArr
								}),
								value : descriptorDataFldsArr[0].valueField,
								displayField:'displayField',
								valueField:'valueField',
								queryMode : 'local',
								editable : false,
								forceSelection: false
							},
							
						{
							xtype: 'button',
							cls : 'buttonNew apiConfbtn',
							text: generate,
							id:'generate',
							name:'generate',
							height: 25,
							margin:'2 0 6 10',
							width: 84,
							
						
						},
						
					]
				}
				
			);
		}
		else
		{
			itmsArr.push(
				
				{
					xtype: 'container',
					layout: {
						type: 'hbox',
						align: 'stretch'
					},
					cls: 'apiConfBottombtn',
					items: [{
						xtype: 'button',
						cls : 'buttonNew apiConfbtn',
						text: generate,
						id:'generate',
						height: 25,
						name:'generate',
						margin:'20 0 18 0',
						width: 84,
						
					
					}
					]
				}
				
			);
		}		
		this.items=itmsArr;
		this.callParent(this);
	},
	listeners : {
		
		'boxready' : function()
		{
			var restDataLoadingMaskObj=Ext.getCmp('restDataLoadingMask');
			if(!Ext.isEmpty(restDataLoadingMaskObj))
			{
				restDataLoadingMaskObj.hide();
			}
		}
	}
});



