var cellEditing = Ext.create('Ext.grid.plugin.CellEditing', {
        clicksToEdit: 1
    });

Ext.define('ICTest.view.RESTParamsGrid',{
	extend:'Ext.grid.Panel',
	requires:['Ext.selection.CellModel','Ext.selection.CheckboxModel'],
	alias:'widget.RESTParamsGrid',
	id : 'RESTParamsGrid',
	name : 'RESTParamsGrid',
	layout:{type:'vbox',align:'stretch'},
	ui:'newGridPanel mydashboard_grid  RestColumnGrid paramGrid',
	margin:'10 20 20 20',
	flex:1,
	autoScroll:true,
	width : 550,
	viewConfig: {
		deferEmptyText: false
		
	},
			emptyText : '<table width="100%" height="10px" style="margin:0% auto"><tr><td align="center" valign="middle"><div class="iconExclamation"></div><div style="margin:6px auto">'+screenLabelsObj['No_Params_Available']+'</div></td></tr></table>',
	initComponent : function()
	{
		this.selModel =  new Ext.selection.CheckboxModel({
				checkOnly: true,
				headerWidth:33,
				injectCheckbox: 0
			});
		this.getStore();
		this.columns = [
			{
				 text: screenLabelsObj['Header_name'],
				 dataIndex: 'key',
				 width:150,
				 editor: {
				    allowBlank: false
				}				
			},
			{
				 text: screenLabelsObj['Header_value'],
				 dataIndex: 'value',
				 flex: 1,
				 editor: {
				    allowBlank: false
				}
			
			},
			{
			header: '<div class="iconDeleteAll" style="margin:0px auto 0px auto" data-qclass="yellowTip" data-qtip="'+toolDeleteAll+'"></div>',
            xtype: 'actioncolumn',
			enableColumnHide:false,
			menuDisabled:true,
			renderer: function(value, metaData) {
								metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+toolDelete+'"';
								return value;
							},
            width:55,
            sortable: false,
			tdCls: 'restGridColumnCenter',
            items: [{
                iconCls: 'iconDelete',
                handler: function(grid, rowIndex, colIndex) {
					var rec = grid.getStore().getAt(rowIndex);
                    grid.store.remove(rec); 
                }
            }],
			listeners:{
				'headerclick':function( ct, column, e, t, eOpts ){
					var thisGrid = this.up('grid'),
					thisGridStore = thisGrid.getStore(),
					thisGridSelections = thisGrid.getSelectionModel(),
					noOfrecords = thisGridStore.getCount();
					if ( noOfrecords > 0 )
								{
									var selection = thisGridSelections.getSelection();
									if(selection.length==0)
									{
										 Ext.Msg.show({
											title: icTestAlertHeaderMsg,
											msg: screenLabelsObj['deleteParamAlert'],
											buttons: Ext.MessageBox.OK,
											icon: Ext.MessageBox.WARNING
										});
										return;
									}
									Ext.Msg.show({
										title:icTestAlertHeaderMsg,
										msg: screenLabelsObj['deleteSelectedParams'],
										buttons: Ext.Msg.YESNO,
										icon: Ext.Msg.QUESTION,
										fn:function(buttonId)
										{
											if(buttonId =="yes")
											{

													var chkTotal = (thisGrid.selModel.selected.getCount() === thisGrid.getStore().getCount());
													if(chkTotal){
													thisGridStore.remove(selection);
													}else{
													for (var i=0; i< selection.length ; i++ )
													{
														thisGridStore.remove(selection[i]);
													}
													}
													thisGrid.selModel.toggleUiHeader();
												
											
											}
										}
									});
								}
								else
								{
									 Ext.Msg.show({
										title: icTestAlertHeaderMsg,
										msg: screenLabelsObj['No_Params_Available'],
										buttons: Ext.MessageBox.OK,
										icon: Ext.MessageBox.WARNING
									});
									return;
								}
					


				}
			}
        }
			];
				this.callParent();
	},
		plugins: [cellEditing],
		store:Ext.create('Ext.data.ArrayStore',{
		fields: [
            {name: 'key', type : 'string'},
            {name: 'value', type: 'string'}
           
         ],
		data:[
			// {key: 'one', value: 'Hello1'},
			// {key: 'two', value: 'Hello2'}
		 ],
			 selModel: {
         selType: 'cellmodel'
    },
			 storeId:'Grid1'
	}),
			
})
